// Code generated by github.com/whyrusleeping/cbor-gen. DO NOT EDIT.

package atproto

import (
	"fmt"
	"io"
	"math"
	"sort"

	util "github.com/bluesky-social/indigo/lex/util"
	cid "github.com/ipfs/go-cid"
	cbg "github.com/whyrusleeping/cbor-gen"
	xerrors "golang.org/x/xerrors"
)

var _ = xerrors.Errorf
var _ = cid.Undef
var _ = math.E
var _ = sort.Sort

func (t *RepoStrongRef) MarshalCBOR(w io.Writer) error {
	if t == nil {
		_, err := w.Write(cbg.CborNull)
		return err
	}

	cw := cbg.NewCborWriter(w)
	fieldCount := 3

	if t.LexiconTypeID == "" {
		fieldCount--
	}

	if _, err := cw.Write(cbg.CborEncodeMajorType(cbg.MajMap, uint64(fieldCount))); err != nil {
		return err
	}

	// t.Cid (string) (string)
	if len("cid") > 1000000 {
		return xerrors.Errorf("Value in field \"cid\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("cid"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("cid")); err != nil {
		return err
	}

	if len(t.Cid) > 1000000 {
		return xerrors.Errorf("Value in field t.Cid was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(t.Cid))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string(t.Cid)); err != nil {
		return err
	}

	// t.Uri (string) (string)
	if len("uri") > 1000000 {
		return xerrors.Errorf("Value in field \"uri\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("uri"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("uri")); err != nil {
		return err
	}

	if len(t.Uri) > 1000000 {
		return xerrors.Errorf("Value in field t.Uri was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(t.Uri))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string(t.Uri)); err != nil {
		return err
	}

	// t.LexiconTypeID (string) (string)
	if t.LexiconTypeID != "" {

		if len("$type") > 1000000 {
			return xerrors.Errorf("Value in field \"$type\" was too long")
		}

		if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("$type"))); err != nil {
			return err
		}
		if _, err := cw.WriteString(string("$type")); err != nil {
			return err
		}

		if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("com.atproto.repo.strongRef"))); err != nil {
			return err
		}
		if _, err := cw.WriteString(string("com.atproto.repo.strongRef")); err != nil {
			return err
		}
	}
	return nil
}

func (t *RepoStrongRef) UnmarshalCBOR(r io.Reader) (err error) {
	*t = RepoStrongRef{}

	cr := cbg.NewCborReader(r)

	maj, extra, err := cr.ReadHeader()
	if err != nil {
		return err
	}
	defer func() {
		if err == io.EOF {
			err = io.ErrUnexpectedEOF
		}
	}()

	if maj != cbg.MajMap {
		return fmt.Errorf("cbor input should be of type map")
	}

	if extra > cbg.MaxLength {
		return fmt.Errorf("RepoStrongRef: map struct too large (%d)", extra)
	}

	var name string
	n := extra

	for i := uint64(0); i < n; i++ {

		{
			sval, err := cbg.ReadStringWithMax(cr, 1000000)
			if err != nil {
				return err
			}

			name = string(sval)
		}

		switch name {
		// t.Cid (string) (string)
		case "cid":

			{
				sval, err := cbg.ReadStringWithMax(cr, 1000000)
				if err != nil {
					return err
				}

				t.Cid = string(sval)
			}
			// t.Uri (string) (string)
		case "uri":

			{
				sval, err := cbg.ReadStringWithMax(cr, 1000000)
				if err != nil {
					return err
				}

				t.Uri = string(sval)
			}
			// t.LexiconTypeID (string) (string)
		case "$type":

			{
				sval, err := cbg.ReadStringWithMax(cr, 1000000)
				if err != nil {
					return err
				}

				t.LexiconTypeID = string(sval)
			}

		default:
			// Field doesn't exist on this type, so ignore it
			cbg.ScanForLinks(r, func(cid.Cid) {})
		}
	}

	return nil
}
func (t *SyncSubscribeRepos_Commit) MarshalCBOR(w io.Writer) error {
	if t == nil {
		_, err := w.Write(cbg.CborNull)
		return err
	}

	cw := cbg.NewCborWriter(w)
	fieldCount := 12

	if t.Blocks == nil {
		fieldCount--
	}

	if _, err := cw.Write(cbg.CborEncodeMajorType(cbg.MajMap, uint64(fieldCount))); err != nil {
		return err
	}

	// t.Ops ([]*atproto.SyncSubscribeRepos_RepoOp) (slice)
	if len("ops") > 1000000 {
		return xerrors.Errorf("Value in field \"ops\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("ops"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("ops")); err != nil {
		return err
	}

	if len(t.Ops) > 8192 {
		return xerrors.Errorf("Slice value in field t.Ops was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajArray, uint64(len(t.Ops))); err != nil {
		return err
	}
	for _, v := range t.Ops {
		if err := v.MarshalCBOR(cw); err != nil {
			return err
		}

	}

	// t.Rev (string) (string)
	if len("rev") > 1000000 {
		return xerrors.Errorf("Value in field \"rev\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("rev"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("rev")); err != nil {
		return err
	}

	if len(t.Rev) > 1000000 {
		return xerrors.Errorf("Value in field t.Rev was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(t.Rev))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string(t.Rev)); err != nil {
		return err
	}

	// t.Seq (int64) (int64)
	if len("seq") > 1000000 {
		return xerrors.Errorf("Value in field \"seq\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("seq"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("seq")); err != nil {
		return err
	}

	if t.Seq >= 0 {
		if err := cw.WriteMajorTypeHeader(cbg.MajUnsignedInt, uint64(t.Seq)); err != nil {
			return err
		}
	} else {
		if err := cw.WriteMajorTypeHeader(cbg.MajNegativeInt, uint64(-t.Seq-1)); err != nil {
			return err
		}
	}

	// t.Prev (util.LexLink) (struct)
	if len("prev") > 1000000 {
		return xerrors.Errorf("Value in field \"prev\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("prev"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("prev")); err != nil {
		return err
	}

	if err := t.Prev.MarshalCBOR(cw); err != nil {
		return err
	}

	// t.Repo (string) (string)
	if len("repo") > 1000000 {
		return xerrors.Errorf("Value in field \"repo\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("repo"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("repo")); err != nil {
		return err
	}

	if len(t.Repo) > 1000000 {
		return xerrors.Errorf("Value in field t.Repo was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(t.Repo))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string(t.Repo)); err != nil {
		return err
	}

	// t.Time (string) (string)
	if len("time") > 1000000 {
		return xerrors.Errorf("Value in field \"time\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("time"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("time")); err != nil {
		return err
	}

	if len(t.Time) > 1000000 {
		return xerrors.Errorf("Value in field t.Time was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(t.Time))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string(t.Time)); err != nil {
		return err
	}

	// t.Blobs ([]util.LexLink) (slice)
	if len("blobs") > 1000000 {
		return xerrors.Errorf("Value in field \"blobs\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("blobs"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("blobs")); err != nil {
		return err
	}

	if len(t.Blobs) > 8192 {
		return xerrors.Errorf("Slice value in field t.Blobs was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajArray, uint64(len(t.Blobs))); err != nil {
		return err
	}
	for _, v := range t.Blobs {
		if err := v.MarshalCBOR(cw); err != nil {
			return err
		}

	}

	// t.Since (string) (string)
	if len("since") > 1000000 {
		return xerrors.Errorf("Value in field \"since\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("since"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("since")); err != nil {
		return err
	}

	if t.Since == nil {
		if _, err := cw.Write(cbg.CborNull); err != nil {
			return err
		}
	} else {
		if len(*t.Since) > 1000000 {
			return xerrors.Errorf("Value in field t.Since was too long")
		}

		if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(*t.Since))); err != nil {
			return err
		}
		if _, err := cw.WriteString(string(*t.Since)); err != nil {
			return err
		}
	}

	// t.Blocks (util.LexBytes) (slice)
	if t.Blocks != nil {

		if len("blocks") > 1000000 {
			return xerrors.Errorf("Value in field \"blocks\" was too long")
		}

		if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("blocks"))); err != nil {
			return err
		}
		if _, err := cw.WriteString(string("blocks")); err != nil {
			return err
		}

		if len(t.Blocks) > 2097152 {
			return xerrors.Errorf("Byte array in field t.Blocks was too long")
		}

		if err := cw.WriteMajorTypeHeader(cbg.MajByteString, uint64(len(t.Blocks))); err != nil {
			return err
		}

		if _, err := cw.Write(t.Blocks); err != nil {
			return err
		}

	}

	// t.Commit (util.LexLink) (struct)
	if len("commit") > 1000000 {
		return xerrors.Errorf("Value in field \"commit\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("commit"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("commit")); err != nil {
		return err
	}

	if err := t.Commit.MarshalCBOR(cw); err != nil {
		return err
	}

	// t.Rebase (bool) (bool)
	if len("rebase") > 1000000 {
		return xerrors.Errorf("Value in field \"rebase\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("rebase"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("rebase")); err != nil {
		return err
	}

	if err := cbg.WriteBool(w, t.Rebase); err != nil {
		return err
	}

	// t.TooBig (bool) (bool)
	if len("tooBig") > 1000000 {
		return xerrors.Errorf("Value in field \"tooBig\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("tooBig"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("tooBig")); err != nil {
		return err
	}

	if err := cbg.WriteBool(w, t.TooBig); err != nil {
		return err
	}
	return nil
}

func (t *SyncSubscribeRepos_Commit) UnmarshalCBOR(r io.Reader) (err error) {
	*t = SyncSubscribeRepos_Commit{}

	cr := cbg.NewCborReader(r)

	maj, extra, err := cr.ReadHeader()
	if err != nil {
		return err
	}
	defer func() {
		if err == io.EOF {
			err = io.ErrUnexpectedEOF
		}
	}()

	if maj != cbg.MajMap {
		return fmt.Errorf("cbor input should be of type map")
	}

	if extra > cbg.MaxLength {
		return fmt.Errorf("SyncSubscribeRepos_Commit: map struct too large (%d)", extra)
	}

	var name string
	n := extra

	for i := uint64(0); i < n; i++ {

		{
			sval, err := cbg.ReadStringWithMax(cr, 1000000)
			if err != nil {
				return err
			}

			name = string(sval)
		}

		switch name {
		// t.Ops ([]*atproto.SyncSubscribeRepos_RepoOp) (slice)
		case "ops":

			maj, extra, err = cr.ReadHeader()
			if err != nil {
				return err
			}

			if extra > 8192 {
				return fmt.Errorf("t.Ops: array too large (%d)", extra)
			}

			if maj != cbg.MajArray {
				return fmt.Errorf("expected cbor array")
			}

			if extra > 0 {
				t.Ops = make([]*SyncSubscribeRepos_RepoOp, extra)
			}

			for i := 0; i < int(extra); i++ {
				{
					var maj byte
					var extra uint64
					var err error
					_ = maj
					_ = extra
					_ = err

					{

						b, err := cr.ReadByte()
						if err != nil {
							return err
						}
						if b != cbg.CborNull[0] {
							if err := cr.UnreadByte(); err != nil {
								return err
							}
							t.Ops[i] = new(SyncSubscribeRepos_RepoOp)
							if err := t.Ops[i].UnmarshalCBOR(cr); err != nil {
								return xerrors.Errorf("unmarshaling t.Ops[i] pointer: %w", err)
							}
						}

					}

				}
			}
			// t.Rev (string) (string)
		case "rev":

			{
				sval, err := cbg.ReadStringWithMax(cr, 1000000)
				if err != nil {
					return err
				}

				t.Rev = string(sval)
			}
			// t.Seq (int64) (int64)
		case "seq":
			{
				maj, extra, err := cr.ReadHeader()
				if err != nil {
					return err
				}
				var extraI int64
				switch maj {
				case cbg.MajUnsignedInt:
					extraI = int64(extra)
					if extraI < 0 {
						return fmt.Errorf("int64 positive overflow")
					}
				case cbg.MajNegativeInt:
					extraI = int64(extra)
					if extraI < 0 {
						return fmt.Errorf("int64 negative overflow")
					}
					extraI = -1 - extraI
				default:
					return fmt.Errorf("wrong type for int64 field: %d", maj)
				}

				t.Seq = int64(extraI)
			}
			// t.Prev (util.LexLink) (struct)
		case "prev":

			{

				b, err := cr.ReadByte()
				if err != nil {
					return err
				}
				if b != cbg.CborNull[0] {
					if err := cr.UnreadByte(); err != nil {
						return err
					}
					t.Prev = new(util.LexLink)
					if err := t.Prev.UnmarshalCBOR(cr); err != nil {
						return xerrors.Errorf("unmarshaling t.Prev pointer: %w", err)
					}
				}

			}
			// t.Repo (string) (string)
		case "repo":

			{
				sval, err := cbg.ReadStringWithMax(cr, 1000000)
				if err != nil {
					return err
				}

				t.Repo = string(sval)
			}
			// t.Time (string) (string)
		case "time":

			{
				sval, err := cbg.ReadStringWithMax(cr, 1000000)
				if err != nil {
					return err
				}

				t.Time = string(sval)
			}
			// t.Blobs ([]util.LexLink) (slice)
		case "blobs":

			maj, extra, err = cr.ReadHeader()
			if err != nil {
				return err
			}

			if extra > 8192 {
				return fmt.Errorf("t.Blobs: array too large (%d)", extra)
			}

			if maj != cbg.MajArray {
				return fmt.Errorf("expected cbor array")
			}

			if extra > 0 {
				t.Blobs = make([]util.LexLink, extra)
			}

			for i := 0; i < int(extra); i++ {
				{
					var maj byte
					var extra uint64
					var err error
					_ = maj
					_ = extra
					_ = err

					{

						if err := t.Blobs[i].UnmarshalCBOR(cr); err != nil {
							return xerrors.Errorf("unmarshaling t.Blobs[i]: %w", err)
						}

					}

				}
			}
			// t.Since (string) (string)
		case "since":

			{
				b, err := cr.ReadByte()
				if err != nil {
					return err
				}
				if b != cbg.CborNull[0] {
					if err := cr.UnreadByte(); err != nil {
						return err
					}

					sval, err := cbg.ReadStringWithMax(cr, 1000000)
					if err != nil {
						return err
					}

					t.Since = (*string)(&sval)
				}
			}
			// t.Blocks (util.LexBytes) (slice)
		case "blocks":

			maj, extra, err = cr.ReadHeader()
			if err != nil {
				return err
			}

			if extra > 2097152 {
				return fmt.Errorf("t.Blocks: byte array too large (%d)", extra)
			}
			if maj != cbg.MajByteString {
				return fmt.Errorf("expected byte array")
			}

			if extra > 0 {
				t.Blocks = make([]uint8, extra)
			}

			if _, err := io.ReadFull(cr, t.Blocks); err != nil {
				return err
			}

			// t.Commit (util.LexLink) (struct)
		case "commit":

			{

				if err := t.Commit.UnmarshalCBOR(cr); err != nil {
					return xerrors.Errorf("unmarshaling t.Commit: %w", err)
				}

			}
			// t.Rebase (bool) (bool)
		case "rebase":

			maj, extra, err = cr.ReadHeader()
			if err != nil {
				return err
			}
			if maj != cbg.MajOther {
				return fmt.Errorf("booleans must be major type 7")
			}
			switch extra {
			case 20:
				t.Rebase = false
			case 21:
				t.Rebase = true
			default:
				return fmt.Errorf("booleans are either major type 7, value 20 or 21 (got %d)", extra)
			}
			// t.TooBig (bool) (bool)
		case "tooBig":

			maj, extra, err = cr.ReadHeader()
			if err != nil {
				return err
			}
			if maj != cbg.MajOther {
				return fmt.Errorf("booleans must be major type 7")
			}
			switch extra {
			case 20:
				t.TooBig = false
			case 21:
				t.TooBig = true
			default:
				return fmt.Errorf("booleans are either major type 7, value 20 or 21 (got %d)", extra)
			}

		default:
			// Field doesn't exist on this type, so ignore it
			cbg.ScanForLinks(r, func(cid.Cid) {})
		}
	}

	return nil
}
func (t *SyncSubscribeRepos_Handle) MarshalCBOR(w io.Writer) error {
	if t == nil {
		_, err := w.Write(cbg.CborNull)
		return err
	}

	cw := cbg.NewCborWriter(w)

	if _, err := cw.Write([]byte{164}); err != nil {
		return err
	}

	// t.Did (string) (string)
	if len("did") > 1000000 {
		return xerrors.Errorf("Value in field \"did\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("did"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("did")); err != nil {
		return err
	}

	if len(t.Did) > 1000000 {
		return xerrors.Errorf("Value in field t.Did was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(t.Did))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string(t.Did)); err != nil {
		return err
	}

	// t.Seq (int64) (int64)
	if len("seq") > 1000000 {
		return xerrors.Errorf("Value in field \"seq\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("seq"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("seq")); err != nil {
		return err
	}

	if t.Seq >= 0 {
		if err := cw.WriteMajorTypeHeader(cbg.MajUnsignedInt, uint64(t.Seq)); err != nil {
			return err
		}
	} else {
		if err := cw.WriteMajorTypeHeader(cbg.MajNegativeInt, uint64(-t.Seq-1)); err != nil {
			return err
		}
	}

	// t.Time (string) (string)
	if len("time") > 1000000 {
		return xerrors.Errorf("Value in field \"time\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("time"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("time")); err != nil {
		return err
	}

	if len(t.Time) > 1000000 {
		return xerrors.Errorf("Value in field t.Time was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(t.Time))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string(t.Time)); err != nil {
		return err
	}

	// t.Handle (string) (string)
	if len("handle") > 1000000 {
		return xerrors.Errorf("Value in field \"handle\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("handle"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("handle")); err != nil {
		return err
	}

	if len(t.Handle) > 1000000 {
		return xerrors.Errorf("Value in field t.Handle was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(t.Handle))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string(t.Handle)); err != nil {
		return err
	}
	return nil
}

func (t *SyncSubscribeRepos_Handle) UnmarshalCBOR(r io.Reader) (err error) {
	*t = SyncSubscribeRepos_Handle{}

	cr := cbg.NewCborReader(r)

	maj, extra, err := cr.ReadHeader()
	if err != nil {
		return err
	}
	defer func() {
		if err == io.EOF {
			err = io.ErrUnexpectedEOF
		}
	}()

	if maj != cbg.MajMap {
		return fmt.Errorf("cbor input should be of type map")
	}

	if extra > cbg.MaxLength {
		return fmt.Errorf("SyncSubscribeRepos_Handle: map struct too large (%d)", extra)
	}

	var name string
	n := extra

	for i := uint64(0); i < n; i++ {

		{
			sval, err := cbg.ReadStringWithMax(cr, 1000000)
			if err != nil {
				return err
			}

			name = string(sval)
		}

		switch name {
		// t.Did (string) (string)
		case "did":

			{
				sval, err := cbg.ReadStringWithMax(cr, 1000000)
				if err != nil {
					return err
				}

				t.Did = string(sval)
			}
			// t.Seq (int64) (int64)
		case "seq":
			{
				maj, extra, err := cr.ReadHeader()
				if err != nil {
					return err
				}
				var extraI int64
				switch maj {
				case cbg.MajUnsignedInt:
					extraI = int64(extra)
					if extraI < 0 {
						return fmt.Errorf("int64 positive overflow")
					}
				case cbg.MajNegativeInt:
					extraI = int64(extra)
					if extraI < 0 {
						return fmt.Errorf("int64 negative overflow")
					}
					extraI = -1 - extraI
				default:
					return fmt.Errorf("wrong type for int64 field: %d", maj)
				}

				t.Seq = int64(extraI)
			}
			// t.Time (string) (string)
		case "time":

			{
				sval, err := cbg.ReadStringWithMax(cr, 1000000)
				if err != nil {
					return err
				}

				t.Time = string(sval)
			}
			// t.Handle (string) (string)
		case "handle":

			{
				sval, err := cbg.ReadStringWithMax(cr, 1000000)
				if err != nil {
					return err
				}

				t.Handle = string(sval)
			}

		default:
			// Field doesn't exist on this type, so ignore it
			cbg.ScanForLinks(r, func(cid.Cid) {})
		}
	}

	return nil
}
func (t *SyncSubscribeRepos_Identity) MarshalCBOR(w io.Writer) error {
	if t == nil {
		_, err := w.Write(cbg.CborNull)
		return err
	}

	cw := cbg.NewCborWriter(w)

	if _, err := cw.Write([]byte{163}); err != nil {
		return err
	}

	// t.Did (string) (string)
	if len("did") > 1000000 {
		return xerrors.Errorf("Value in field \"did\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("did"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("did")); err != nil {
		return err
	}

	if len(t.Did) > 1000000 {
		return xerrors.Errorf("Value in field t.Did was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(t.Did))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string(t.Did)); err != nil {
		return err
	}

	// t.Seq (int64) (int64)
	if len("seq") > 1000000 {
		return xerrors.Errorf("Value in field \"seq\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("seq"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("seq")); err != nil {
		return err
	}

	if t.Seq >= 0 {
		if err := cw.WriteMajorTypeHeader(cbg.MajUnsignedInt, uint64(t.Seq)); err != nil {
			return err
		}
	} else {
		if err := cw.WriteMajorTypeHeader(cbg.MajNegativeInt, uint64(-t.Seq-1)); err != nil {
			return err
		}
	}

	// t.Time (string) (string)
	if len("time") > 1000000 {
		return xerrors.Errorf("Value in field \"time\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("time"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("time")); err != nil {
		return err
	}

	if len(t.Time) > 1000000 {
		return xerrors.Errorf("Value in field t.Time was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(t.Time))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string(t.Time)); err != nil {
		return err
	}
	return nil
}

func (t *SyncSubscribeRepos_Identity) UnmarshalCBOR(r io.Reader) (err error) {
	*t = SyncSubscribeRepos_Identity{}

	cr := cbg.NewCborReader(r)

	maj, extra, err := cr.ReadHeader()
	if err != nil {
		return err
	}
	defer func() {
		if err == io.EOF {
			err = io.ErrUnexpectedEOF
		}
	}()

	if maj != cbg.MajMap {
		return fmt.Errorf("cbor input should be of type map")
	}

	if extra > cbg.MaxLength {
		return fmt.Errorf("SyncSubscribeRepos_Identity: map struct too large (%d)", extra)
	}

	var name string
	n := extra

	for i := uint64(0); i < n; i++ {

		{
			sval, err := cbg.ReadStringWithMax(cr, 1000000)
			if err != nil {
				return err
			}

			name = string(sval)
		}

		switch name {
		// t.Did (string) (string)
		case "did":

			{
				sval, err := cbg.ReadStringWithMax(cr, 1000000)
				if err != nil {
					return err
				}

				t.Did = string(sval)
			}
			// t.Seq (int64) (int64)
		case "seq":
			{
				maj, extra, err := cr.ReadHeader()
				if err != nil {
					return err
				}
				var extraI int64
				switch maj {
				case cbg.MajUnsignedInt:
					extraI = int64(extra)
					if extraI < 0 {
						return fmt.Errorf("int64 positive overflow")
					}
				case cbg.MajNegativeInt:
					extraI = int64(extra)
					if extraI < 0 {
						return fmt.Errorf("int64 negative overflow")
					}
					extraI = -1 - extraI
				default:
					return fmt.Errorf("wrong type for int64 field: %d", maj)
				}

				t.Seq = int64(extraI)
			}
			// t.Time (string) (string)
		case "time":

			{
				sval, err := cbg.ReadStringWithMax(cr, 1000000)
				if err != nil {
					return err
				}

				t.Time = string(sval)
			}

		default:
			// Field doesn't exist on this type, so ignore it
			cbg.ScanForLinks(r, func(cid.Cid) {})
		}
	}

	return nil
}
func (t *SyncSubscribeRepos_Info) MarshalCBOR(w io.Writer) error {
	if t == nil {
		_, err := w.Write(cbg.CborNull)
		return err
	}

	cw := cbg.NewCborWriter(w)
	fieldCount := 2

	if t.Message == nil {
		fieldCount--
	}

	if _, err := cw.Write(cbg.CborEncodeMajorType(cbg.MajMap, uint64(fieldCount))); err != nil {
		return err
	}

	// t.Name (string) (string)
	if len("name") > 1000000 {
		return xerrors.Errorf("Value in field \"name\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("name"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("name")); err != nil {
		return err
	}

	if len(t.Name) > 1000000 {
		return xerrors.Errorf("Value in field t.Name was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(t.Name))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string(t.Name)); err != nil {
		return err
	}

	// t.Message (string) (string)
	if t.Message != nil {

		if len("message") > 1000000 {
			return xerrors.Errorf("Value in field \"message\" was too long")
		}

		if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("message"))); err != nil {
			return err
		}
		if _, err := cw.WriteString(string("message")); err != nil {
			return err
		}

		if t.Message == nil {
			if _, err := cw.Write(cbg.CborNull); err != nil {
				return err
			}
		} else {
			if len(*t.Message) > 1000000 {
				return xerrors.Errorf("Value in field t.Message was too long")
			}

			if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(*t.Message))); err != nil {
				return err
			}
			if _, err := cw.WriteString(string(*t.Message)); err != nil {
				return err
			}
		}
	}
	return nil
}

func (t *SyncSubscribeRepos_Info) UnmarshalCBOR(r io.Reader) (err error) {
	*t = SyncSubscribeRepos_Info{}

	cr := cbg.NewCborReader(r)

	maj, extra, err := cr.ReadHeader()
	if err != nil {
		return err
	}
	defer func() {
		if err == io.EOF {
			err = io.ErrUnexpectedEOF
		}
	}()

	if maj != cbg.MajMap {
		return fmt.Errorf("cbor input should be of type map")
	}

	if extra > cbg.MaxLength {
		return fmt.Errorf("SyncSubscribeRepos_Info: map struct too large (%d)", extra)
	}

	var name string
	n := extra

	for i := uint64(0); i < n; i++ {

		{
			sval, err := cbg.ReadStringWithMax(cr, 1000000)
			if err != nil {
				return err
			}

			name = string(sval)
		}

		switch name {
		// t.Name (string) (string)
		case "name":

			{
				sval, err := cbg.ReadStringWithMax(cr, 1000000)
				if err != nil {
					return err
				}

				t.Name = string(sval)
			}
			// t.Message (string) (string)
		case "message":

			{
				b, err := cr.ReadByte()
				if err != nil {
					return err
				}
				if b != cbg.CborNull[0] {
					if err := cr.UnreadByte(); err != nil {
						return err
					}

					sval, err := cbg.ReadStringWithMax(cr, 1000000)
					if err != nil {
						return err
					}

					t.Message = (*string)(&sval)
				}
			}

		default:
			// Field doesn't exist on this type, so ignore it
			cbg.ScanForLinks(r, func(cid.Cid) {})
		}
	}

	return nil
}
func (t *SyncSubscribeRepos_Migrate) MarshalCBOR(w io.Writer) error {
	if t == nil {
		_, err := w.Write(cbg.CborNull)
		return err
	}

	cw := cbg.NewCborWriter(w)

	if _, err := cw.Write([]byte{164}); err != nil {
		return err
	}

	// t.Did (string) (string)
	if len("did") > 1000000 {
		return xerrors.Errorf("Value in field \"did\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("did"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("did")); err != nil {
		return err
	}

	if len(t.Did) > 1000000 {
		return xerrors.Errorf("Value in field t.Did was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(t.Did))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string(t.Did)); err != nil {
		return err
	}

	// t.Seq (int64) (int64)
	if len("seq") > 1000000 {
		return xerrors.Errorf("Value in field \"seq\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("seq"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("seq")); err != nil {
		return err
	}

	if t.Seq >= 0 {
		if err := cw.WriteMajorTypeHeader(cbg.MajUnsignedInt, uint64(t.Seq)); err != nil {
			return err
		}
	} else {
		if err := cw.WriteMajorTypeHeader(cbg.MajNegativeInt, uint64(-t.Seq-1)); err != nil {
			return err
		}
	}

	// t.Time (string) (string)
	if len("time") > 1000000 {
		return xerrors.Errorf("Value in field \"time\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("time"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("time")); err != nil {
		return err
	}

	if len(t.Time) > 1000000 {
		return xerrors.Errorf("Value in field t.Time was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(t.Time))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string(t.Time)); err != nil {
		return err
	}

	// t.MigrateTo (string) (string)
	if len("migrateTo") > 1000000 {
		return xerrors.Errorf("Value in field \"migrateTo\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("migrateTo"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("migrateTo")); err != nil {
		return err
	}

	if t.MigrateTo == nil {
		if _, err := cw.Write(cbg.CborNull); err != nil {
			return err
		}
	} else {
		if len(*t.MigrateTo) > 1000000 {
			return xerrors.Errorf("Value in field t.MigrateTo was too long")
		}

		if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(*t.MigrateTo))); err != nil {
			return err
		}
		if _, err := cw.WriteString(string(*t.MigrateTo)); err != nil {
			return err
		}
	}
	return nil
}

func (t *SyncSubscribeRepos_Migrate) UnmarshalCBOR(r io.Reader) (err error) {
	*t = SyncSubscribeRepos_Migrate{}

	cr := cbg.NewCborReader(r)

	maj, extra, err := cr.ReadHeader()
	if err != nil {
		return err
	}
	defer func() {
		if err == io.EOF {
			err = io.ErrUnexpectedEOF
		}
	}()

	if maj != cbg.MajMap {
		return fmt.Errorf("cbor input should be of type map")
	}

	if extra > cbg.MaxLength {
		return fmt.Errorf("SyncSubscribeRepos_Migrate: map struct too large (%d)", extra)
	}

	var name string
	n := extra

	for i := uint64(0); i < n; i++ {

		{
			sval, err := cbg.ReadStringWithMax(cr, 1000000)
			if err != nil {
				return err
			}

			name = string(sval)
		}

		switch name {
		// t.Did (string) (string)
		case "did":

			{
				sval, err := cbg.ReadStringWithMax(cr, 1000000)
				if err != nil {
					return err
				}

				t.Did = string(sval)
			}
			// t.Seq (int64) (int64)
		case "seq":
			{
				maj, extra, err := cr.ReadHeader()
				if err != nil {
					return err
				}
				var extraI int64
				switch maj {
				case cbg.MajUnsignedInt:
					extraI = int64(extra)
					if extraI < 0 {
						return fmt.Errorf("int64 positive overflow")
					}
				case cbg.MajNegativeInt:
					extraI = int64(extra)
					if extraI < 0 {
						return fmt.Errorf("int64 negative overflow")
					}
					extraI = -1 - extraI
				default:
					return fmt.Errorf("wrong type for int64 field: %d", maj)
				}

				t.Seq = int64(extraI)
			}
			// t.Time (string) (string)
		case "time":

			{
				sval, err := cbg.ReadStringWithMax(cr, 1000000)
				if err != nil {
					return err
				}

				t.Time = string(sval)
			}
			// t.MigrateTo (string) (string)
		case "migrateTo":

			{
				b, err := cr.ReadByte()
				if err != nil {
					return err
				}
				if b != cbg.CborNull[0] {
					if err := cr.UnreadByte(); err != nil {
						return err
					}

					sval, err := cbg.ReadStringWithMax(cr, 1000000)
					if err != nil {
						return err
					}

					t.MigrateTo = (*string)(&sval)
				}
			}

		default:
			// Field doesn't exist on this type, so ignore it
			cbg.ScanForLinks(r, func(cid.Cid) {})
		}
	}

	return nil
}
func (t *SyncSubscribeRepos_RepoOp) MarshalCBOR(w io.Writer) error {
	if t == nil {
		_, err := w.Write(cbg.CborNull)
		return err
	}

	cw := cbg.NewCborWriter(w)

	if _, err := cw.Write([]byte{163}); err != nil {
		return err
	}

	// t.Cid (util.LexLink) (struct)
	if len("cid") > 1000000 {
		return xerrors.Errorf("Value in field \"cid\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("cid"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("cid")); err != nil {
		return err
	}

	if err := t.Cid.MarshalCBOR(cw); err != nil {
		return err
	}

	// t.Path (string) (string)
	if len("path") > 1000000 {
		return xerrors.Errorf("Value in field \"path\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("path"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("path")); err != nil {
		return err
	}

	if len(t.Path) > 1000000 {
		return xerrors.Errorf("Value in field t.Path was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(t.Path))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string(t.Path)); err != nil {
		return err
	}

	// t.Action (string) (string)
	if len("action") > 1000000 {
		return xerrors.Errorf("Value in field \"action\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("action"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("action")); err != nil {
		return err
	}

	if len(t.Action) > 1000000 {
		return xerrors.Errorf("Value in field t.Action was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(t.Action))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string(t.Action)); err != nil {
		return err
	}
	return nil
}

func (t *SyncSubscribeRepos_RepoOp) UnmarshalCBOR(r io.Reader) (err error) {
	*t = SyncSubscribeRepos_RepoOp{}

	cr := cbg.NewCborReader(r)

	maj, extra, err := cr.ReadHeader()
	if err != nil {
		return err
	}
	defer func() {
		if err == io.EOF {
			err = io.ErrUnexpectedEOF
		}
	}()

	if maj != cbg.MajMap {
		return fmt.Errorf("cbor input should be of type map")
	}

	if extra > cbg.MaxLength {
		return fmt.Errorf("SyncSubscribeRepos_RepoOp: map struct too large (%d)", extra)
	}

	var name string
	n := extra

	for i := uint64(0); i < n; i++ {

		{
			sval, err := cbg.ReadStringWithMax(cr, 1000000)
			if err != nil {
				return err
			}

			name = string(sval)
		}

		switch name {
		// t.Cid (util.LexLink) (struct)
		case "cid":

			{

				b, err := cr.ReadByte()
				if err != nil {
					return err
				}
				if b != cbg.CborNull[0] {
					if err := cr.UnreadByte(); err != nil {
						return err
					}
					t.Cid = new(util.LexLink)
					if err := t.Cid.UnmarshalCBOR(cr); err != nil {
						return xerrors.Errorf("unmarshaling t.Cid pointer: %w", err)
					}
				}

			}
			// t.Path (string) (string)
		case "path":

			{
				sval, err := cbg.ReadStringWithMax(cr, 1000000)
				if err != nil {
					return err
				}

				t.Path = string(sval)
			}
			// t.Action (string) (string)
		case "action":

			{
				sval, err := cbg.ReadStringWithMax(cr, 1000000)
				if err != nil {
					return err
				}

				t.Action = string(sval)
			}

		default:
			// Field doesn't exist on this type, so ignore it
			cbg.ScanForLinks(r, func(cid.Cid) {})
		}
	}

	return nil
}
func (t *SyncSubscribeRepos_Tombstone) MarshalCBOR(w io.Writer) error {
	if t == nil {
		_, err := w.Write(cbg.CborNull)
		return err
	}

	cw := cbg.NewCborWriter(w)

	if _, err := cw.Write([]byte{163}); err != nil {
		return err
	}

	// t.Did (string) (string)
	if len("did") > 1000000 {
		return xerrors.Errorf("Value in field \"did\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("did"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("did")); err != nil {
		return err
	}

	if len(t.Did) > 1000000 {
		return xerrors.Errorf("Value in field t.Did was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(t.Did))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string(t.Did)); err != nil {
		return err
	}

	// t.Seq (int64) (int64)
	if len("seq") > 1000000 {
		return xerrors.Errorf("Value in field \"seq\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("seq"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("seq")); err != nil {
		return err
	}

	if t.Seq >= 0 {
		if err := cw.WriteMajorTypeHeader(cbg.MajUnsignedInt, uint64(t.Seq)); err != nil {
			return err
		}
	} else {
		if err := cw.WriteMajorTypeHeader(cbg.MajNegativeInt, uint64(-t.Seq-1)); err != nil {
			return err
		}
	}

	// t.Time (string) (string)
	if len("time") > 1000000 {
		return xerrors.Errorf("Value in field \"time\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("time"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("time")); err != nil {
		return err
	}

	if len(t.Time) > 1000000 {
		return xerrors.Errorf("Value in field t.Time was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(t.Time))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string(t.Time)); err != nil {
		return err
	}
	return nil
}

func (t *SyncSubscribeRepos_Tombstone) UnmarshalCBOR(r io.Reader) (err error) {
	*t = SyncSubscribeRepos_Tombstone{}

	cr := cbg.NewCborReader(r)

	maj, extra, err := cr.ReadHeader()
	if err != nil {
		return err
	}
	defer func() {
		if err == io.EOF {
			err = io.ErrUnexpectedEOF
		}
	}()

	if maj != cbg.MajMap {
		return fmt.Errorf("cbor input should be of type map")
	}

	if extra > cbg.MaxLength {
		return fmt.Errorf("SyncSubscribeRepos_Tombstone: map struct too large (%d)", extra)
	}

	var name string
	n := extra

	for i := uint64(0); i < n; i++ {

		{
			sval, err := cbg.ReadStringWithMax(cr, 1000000)
			if err != nil {
				return err
			}

			name = string(sval)
		}

		switch name {
		// t.Did (string) (string)
		case "did":

			{
				sval, err := cbg.ReadStringWithMax(cr, 1000000)
				if err != nil {
					return err
				}

				t.Did = string(sval)
			}
			// t.Seq (int64) (int64)
		case "seq":
			{
				maj, extra, err := cr.ReadHeader()
				if err != nil {
					return err
				}
				var extraI int64
				switch maj {
				case cbg.MajUnsignedInt:
					extraI = int64(extra)
					if extraI < 0 {
						return fmt.Errorf("int64 positive overflow")
					}
				case cbg.MajNegativeInt:
					extraI = int64(extra)
					if extraI < 0 {
						return fmt.Errorf("int64 negative overflow")
					}
					extraI = -1 - extraI
				default:
					return fmt.Errorf("wrong type for int64 field: %d", maj)
				}

				t.Seq = int64(extraI)
			}
			// t.Time (string) (string)
		case "time":

			{
				sval, err := cbg.ReadStringWithMax(cr, 1000000)
				if err != nil {
					return err
				}

				t.Time = string(sval)
			}

		default:
			// Field doesn't exist on this type, so ignore it
			cbg.ScanForLinks(r, func(cid.Cid) {})
		}
	}

	return nil
}
func (t *LabelDefs_SelfLabels) MarshalCBOR(w io.Writer) error {
	if t == nil {
		_, err := w.Write(cbg.CborNull)
		return err
	}

	cw := cbg.NewCborWriter(w)

	if _, err := cw.Write([]byte{162}); err != nil {
		return err
	}

	// t.LexiconTypeID (string) (string)
	if len("$type") > 1000000 {
		return xerrors.Errorf("Value in field \"$type\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("$type"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("$type")); err != nil {
		return err
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("com.atproto.label.defs#selfLabels"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("com.atproto.label.defs#selfLabels")); err != nil {
		return err
	}

	// t.Values ([]*atproto.LabelDefs_SelfLabel) (slice)
	if len("values") > 1000000 {
		return xerrors.Errorf("Value in field \"values\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("values"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("values")); err != nil {
		return err
	}

	if len(t.Values) > 8192 {
		return xerrors.Errorf("Slice value in field t.Values was too long")
	}

	if t.Values == nil {
		_, err := w.Write(cbg.CborNull)
		if err != nil {
			return err
		}
	} else {

		if err := cw.WriteMajorTypeHeader(cbg.MajArray, uint64(len(t.Values))); err != nil {
			return err
		}
		for _, v := range t.Values {
			if err := v.MarshalCBOR(cw); err != nil {
				return err
			}

		}

	}
	return nil
}

func (t *LabelDefs_SelfLabels) UnmarshalCBOR(r io.Reader) (err error) {
	*t = LabelDefs_SelfLabels{}

	cr := cbg.NewCborReader(r)

	maj, extra, err := cr.ReadHeader()
	if err != nil {
		return err
	}
	defer func() {
		if err == io.EOF {
			err = io.ErrUnexpectedEOF
		}
	}()

	if maj != cbg.MajMap {
		return fmt.Errorf("cbor input should be of type map")
	}

	if extra > cbg.MaxLength {
		return fmt.Errorf("LabelDefs_SelfLabels: map struct too large (%d)", extra)
	}

	var name string
	n := extra

	for i := uint64(0); i < n; i++ {

		{
			sval, err := cbg.ReadStringWithMax(cr, 1000000)
			if err != nil {
				return err
			}

			name = string(sval)
		}

		switch name {
		// t.LexiconTypeID (string) (string)
		case "$type":

			{
				sval, err := cbg.ReadStringWithMax(cr, 1000000)
				if err != nil {
					return err
				}

				t.LexiconTypeID = string(sval)
			}
			// t.Values ([]*atproto.LabelDefs_SelfLabel) (slice)
		case "values":

			{
				b, err := cr.ReadByte()
				if err != nil {
					return err
				}
				if b != cbg.CborNull[0] {
					if err := cr.UnreadByte(); err != nil {
						return err
					}

					maj, extra, err = cr.ReadHeader()
					if err != nil {
						return err
					}

					if extra > 8192 {
						return fmt.Errorf("t.Values: array too large (%d)", extra)
					}

					if maj != cbg.MajArray {
						return fmt.Errorf("expected cbor array")
					}

					t.Values = make([]*LabelDefs_SelfLabel, extra)

					for i := 0; i < int(extra); i++ {
						{
							var maj byte
							var extra uint64
							var err error
							_ = maj
							_ = extra
							_ = err

							{

								b, err := cr.ReadByte()
								if err != nil {
									return err
								}
								if b != cbg.CborNull[0] {
									if err := cr.UnreadByte(); err != nil {
										return err
									}
									t.Values[i] = new(LabelDefs_SelfLabel)
									if err := t.Values[i].UnmarshalCBOR(cr); err != nil {
										return xerrors.Errorf("unmarshaling t.Values[i] pointer: %w", err)
									}
								}

							}

						}
					}

				}
			}

		default:
			// Field doesn't exist on this type, so ignore it
			cbg.ScanForLinks(r, func(cid.Cid) {})
		}
	}

	return nil
}
func (t *LabelDefs_SelfLabel) MarshalCBOR(w io.Writer) error {
	if t == nil {
		_, err := w.Write(cbg.CborNull)
		return err
	}

	cw := cbg.NewCborWriter(w)

	if _, err := cw.Write([]byte{161}); err != nil {
		return err
	}

	// t.Val (string) (string)
	if len("val") > 1000000 {
		return xerrors.Errorf("Value in field \"val\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("val"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("val")); err != nil {
		return err
	}

	if len(t.Val) > 1000000 {
		return xerrors.Errorf("Value in field t.Val was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(t.Val))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string(t.Val)); err != nil {
		return err
	}
	return nil
}

func (t *LabelDefs_SelfLabel) UnmarshalCBOR(r io.Reader) (err error) {
	*t = LabelDefs_SelfLabel{}

	cr := cbg.NewCborReader(r)

	maj, extra, err := cr.ReadHeader()
	if err != nil {
		return err
	}
	defer func() {
		if err == io.EOF {
			err = io.ErrUnexpectedEOF
		}
	}()

	if maj != cbg.MajMap {
		return fmt.Errorf("cbor input should be of type map")
	}

	if extra > cbg.MaxLength {
		return fmt.Errorf("LabelDefs_SelfLabel: map struct too large (%d)", extra)
	}

	var name string
	n := extra

	for i := uint64(0); i < n; i++ {

		{
			sval, err := cbg.ReadStringWithMax(cr, 1000000)
			if err != nil {
				return err
			}

			name = string(sval)
		}

		switch name {
		// t.Val (string) (string)
		case "val":

			{
				sval, err := cbg.ReadStringWithMax(cr, 1000000)
				if err != nil {
					return err
				}

				t.Val = string(sval)
			}

		default:
			// Field doesn't exist on this type, so ignore it
			cbg.ScanForLinks(r, func(cid.Cid) {})
		}
	}

	return nil
}
func (t *LabelDefs_Label) MarshalCBOR(w io.Writer) error {
	if t == nil {
		_, err := w.Write(cbg.CborNull)
		return err
	}

	cw := cbg.NewCborWriter(w)
	fieldCount := 9

	if t.Cid == nil {
		fieldCount--
	}

	if t.Exp == nil {
		fieldCount--
	}

	if t.Neg == nil {
		fieldCount--
	}

	if t.Sig == nil {
		fieldCount--
	}

	if t.Ver == nil {
		fieldCount--
	}

	if _, err := cw.Write(cbg.CborEncodeMajorType(cbg.MajMap, uint64(fieldCount))); err != nil {
		return err
	}

	// t.Cid (string) (string)
	if t.Cid != nil {

		if len("cid") > 1000000 {
			return xerrors.Errorf("Value in field \"cid\" was too long")
		}

		if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("cid"))); err != nil {
			return err
		}
		if _, err := cw.WriteString(string("cid")); err != nil {
			return err
		}

		if t.Cid == nil {
			if _, err := cw.Write(cbg.CborNull); err != nil {
				return err
			}
		} else {
			if len(*t.Cid) > 1000000 {
				return xerrors.Errorf("Value in field t.Cid was too long")
			}

			if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(*t.Cid))); err != nil {
				return err
			}
			if _, err := cw.WriteString(string(*t.Cid)); err != nil {
				return err
			}
		}
	}

	// t.Cts (string) (string)
	if len("cts") > 1000000 {
		return xerrors.Errorf("Value in field \"cts\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("cts"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("cts")); err != nil {
		return err
	}

	if len(t.Cts) > 1000000 {
		return xerrors.Errorf("Value in field t.Cts was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(t.Cts))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string(t.Cts)); err != nil {
		return err
	}

	// t.Exp (string) (string)
	if t.Exp != nil {

		if len("exp") > 1000000 {
			return xerrors.Errorf("Value in field \"exp\" was too long")
		}

		if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("exp"))); err != nil {
			return err
		}
		if _, err := cw.WriteString(string("exp")); err != nil {
			return err
		}

		if t.Exp == nil {
			if _, err := cw.Write(cbg.CborNull); err != nil {
				return err
			}
		} else {
			if len(*t.Exp) > 1000000 {
				return xerrors.Errorf("Value in field t.Exp was too long")
			}

			if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(*t.Exp))); err != nil {
				return err
			}
			if _, err := cw.WriteString(string(*t.Exp)); err != nil {
				return err
			}
		}
	}

	// t.Neg (bool) (bool)
	if t.Neg != nil {

		if len("neg") > 1000000 {
			return xerrors.Errorf("Value in field \"neg\" was too long")
		}

		if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("neg"))); err != nil {
			return err
		}
		if _, err := cw.WriteString(string("neg")); err != nil {
			return err
		}

		if t.Neg == nil {
			if _, err := cw.Write(cbg.CborNull); err != nil {
				return err
			}
		} else {
			if err := cbg.WriteBool(w, *t.Neg); err != nil {
				return err
			}
		}
	}

	// t.Sig (util.LexBytes) (slice)
	if t.Sig != nil {

		if len("sig") > 1000000 {
			return xerrors.Errorf("Value in field \"sig\" was too long")
		}

		if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("sig"))); err != nil {
			return err
		}
		if _, err := cw.WriteString(string("sig")); err != nil {
			return err
		}

		if len(t.Sig) > 2097152 {
			return xerrors.Errorf("Byte array in field t.Sig was too long")
		}

		if err := cw.WriteMajorTypeHeader(cbg.MajByteString, uint64(len(t.Sig))); err != nil {
			return err
		}

		if _, err := cw.Write(t.Sig); err != nil {
			return err
		}

	}

	// t.Src (string) (string)
	if len("src") > 1000000 {
		return xerrors.Errorf("Value in field \"src\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("src"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("src")); err != nil {
		return err
	}

	if len(t.Src) > 1000000 {
		return xerrors.Errorf("Value in field t.Src was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(t.Src))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string(t.Src)); err != nil {
		return err
	}

	// t.Uri (string) (string)
	if len("uri") > 1000000 {
		return xerrors.Errorf("Value in field \"uri\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("uri"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("uri")); err != nil {
		return err
	}

	if len(t.Uri) > 1000000 {
		return xerrors.Errorf("Value in field t.Uri was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(t.Uri))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string(t.Uri)); err != nil {
		return err
	}

	// t.Val (string) (string)
	if len("val") > 1000000 {
		return xerrors.Errorf("Value in field \"val\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("val"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("val")); err != nil {
		return err
	}

	if len(t.Val) > 1000000 {
		return xerrors.Errorf("Value in field t.Val was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(t.Val))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string(t.Val)); err != nil {
		return err
	}

	// t.Ver (int64) (int64)
	if t.Ver != nil {

		if len("ver") > 1000000 {
			return xerrors.Errorf("Value in field \"ver\" was too long")
		}

		if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("ver"))); err != nil {
			return err
		}
		if _, err := cw.WriteString(string("ver")); err != nil {
			return err
		}

		if t.Ver == nil {
			if _, err := cw.Write(cbg.CborNull); err != nil {
				return err
			}
		} else {
			if *t.Ver >= 0 {
				if err := cw.WriteMajorTypeHeader(cbg.MajUnsignedInt, uint64(*t.Ver)); err != nil {
					return err
				}
			} else {
				if err := cw.WriteMajorTypeHeader(cbg.MajNegativeInt, uint64(-*t.Ver-1)); err != nil {
					return err
				}
			}
		}

	}
	return nil
}

func (t *LabelDefs_Label) UnmarshalCBOR(r io.Reader) (err error) {
	*t = LabelDefs_Label{}

	cr := cbg.NewCborReader(r)

	maj, extra, err := cr.ReadHeader()
	if err != nil {
		return err
	}
	defer func() {
		if err == io.EOF {
			err = io.ErrUnexpectedEOF
		}
	}()

	if maj != cbg.MajMap {
		return fmt.Errorf("cbor input should be of type map")
	}

	if extra > cbg.MaxLength {
		return fmt.Errorf("LabelDefs_Label: map struct too large (%d)", extra)
	}

	var name string
	n := extra

	for i := uint64(0); i < n; i++ {

		{
			sval, err := cbg.ReadStringWithMax(cr, 1000000)
			if err != nil {
				return err
			}

			name = string(sval)
		}

		switch name {
		// t.Cid (string) (string)
		case "cid":

			{
				b, err := cr.ReadByte()
				if err != nil {
					return err
				}
				if b != cbg.CborNull[0] {
					if err := cr.UnreadByte(); err != nil {
						return err
					}

					sval, err := cbg.ReadStringWithMax(cr, 1000000)
					if err != nil {
						return err
					}

					t.Cid = (*string)(&sval)
				}
			}
			// t.Cts (string) (string)
		case "cts":

			{
				sval, err := cbg.ReadStringWithMax(cr, 1000000)
				if err != nil {
					return err
				}

				t.Cts = string(sval)
			}
			// t.Exp (string) (string)
		case "exp":

			{
				b, err := cr.ReadByte()
				if err != nil {
					return err
				}
				if b != cbg.CborNull[0] {
					if err := cr.UnreadByte(); err != nil {
						return err
					}

					sval, err := cbg.ReadStringWithMax(cr, 1000000)
					if err != nil {
						return err
					}

					t.Exp = (*string)(&sval)
				}
			}
			// t.Neg (bool) (bool)
		case "neg":

			{
				b, err := cr.ReadByte()
				if err != nil {
					return err
				}
				if b != cbg.CborNull[0] {
					if err := cr.UnreadByte(); err != nil {
						return err
					}

					maj, extra, err = cr.ReadHeader()
					if err != nil {
						return err
					}
					if maj != cbg.MajOther {
						return fmt.Errorf("booleans must be major type 7")
					}

					var val bool
					switch extra {
					case 20:
						val = false
					case 21:
						val = true
					default:
						return fmt.Errorf("booleans are either major type 7, value 20 or 21 (got %d)", extra)
					}
					t.Neg = &val
				}
			}
			// t.Sig (util.LexBytes) (slice)
		case "sig":

			maj, extra, err = cr.ReadHeader()
			if err != nil {
				return err
			}

			if extra > 2097152 {
				return fmt.Errorf("t.Sig: byte array too large (%d)", extra)
			}
			if maj != cbg.MajByteString {
				return fmt.Errorf("expected byte array")
			}

			if extra > 0 {
				t.Sig = make([]uint8, extra)
			}

			if _, err := io.ReadFull(cr, t.Sig); err != nil {
				return err
			}

			// t.Src (string) (string)
		case "src":

			{
				sval, err := cbg.ReadStringWithMax(cr, 1000000)
				if err != nil {
					return err
				}

				t.Src = string(sval)
			}
			// t.Uri (string) (string)
		case "uri":

			{
				sval, err := cbg.ReadStringWithMax(cr, 1000000)
				if err != nil {
					return err
				}

				t.Uri = string(sval)
			}
			// t.Val (string) (string)
		case "val":

			{
				sval, err := cbg.ReadStringWithMax(cr, 1000000)
				if err != nil {
					return err
				}

				t.Val = string(sval)
			}
			// t.Ver (int64) (int64)
		case "ver":
			{

				b, err := cr.ReadByte()
				if err != nil {
					return err
				}
				if b != cbg.CborNull[0] {
					if err := cr.UnreadByte(); err != nil {
						return err
					}
					maj, extra, err := cr.ReadHeader()
					if err != nil {
						return err
					}
					var extraI int64
					switch maj {
					case cbg.MajUnsignedInt:
						extraI = int64(extra)
						if extraI < 0 {
							return fmt.Errorf("int64 positive overflow")
						}
					case cbg.MajNegativeInt:
						extraI = int64(extra)
						if extraI < 0 {
							return fmt.Errorf("int64 negative overflow")
						}
						extraI = -1 - extraI
					default:
						return fmt.Errorf("wrong type for int64 field: %d", maj)
					}

					t.Ver = (*int64)(&extraI)
				}
			}

		default:
			// Field doesn't exist on this type, so ignore it
			cbg.ScanForLinks(r, func(cid.Cid) {})
		}
	}

	return nil
}
func (t *LabelSubscribeLabels_Labels) MarshalCBOR(w io.Writer) error {
	if t == nil {
		_, err := w.Write(cbg.CborNull)
		return err
	}

	cw := cbg.NewCborWriter(w)

	if _, err := cw.Write([]byte{162}); err != nil {
		return err
	}

	// t.Seq (int64) (int64)
	if len("seq") > 1000000 {
		return xerrors.Errorf("Value in field \"seq\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("seq"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("seq")); err != nil {
		return err
	}

	if t.Seq >= 0 {
		if err := cw.WriteMajorTypeHeader(cbg.MajUnsignedInt, uint64(t.Seq)); err != nil {
			return err
		}
	} else {
		if err := cw.WriteMajorTypeHeader(cbg.MajNegativeInt, uint64(-t.Seq-1)); err != nil {
			return err
		}
	}

	// t.Labels ([]*atproto.LabelDefs_Label) (slice)
	if len("labels") > 1000000 {
		return xerrors.Errorf("Value in field \"labels\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("labels"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("labels")); err != nil {
		return err
	}

	if len(t.Labels) > 8192 {
		return xerrors.Errorf("Slice value in field t.Labels was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajArray, uint64(len(t.Labels))); err != nil {
		return err
	}
	for _, v := range t.Labels {
		if err := v.MarshalCBOR(cw); err != nil {
			return err
		}

	}
	return nil
}

func (t *LabelSubscribeLabels_Labels) UnmarshalCBOR(r io.Reader) (err error) {
	*t = LabelSubscribeLabels_Labels{}

	cr := cbg.NewCborReader(r)

	maj, extra, err := cr.ReadHeader()
	if err != nil {
		return err
	}
	defer func() {
		if err == io.EOF {
			err = io.ErrUnexpectedEOF
		}
	}()

	if maj != cbg.MajMap {
		return fmt.Errorf("cbor input should be of type map")
	}

	if extra > cbg.MaxLength {
		return fmt.Errorf("LabelSubscribeLabels_Labels: map struct too large (%d)", extra)
	}

	var name string
	n := extra

	for i := uint64(0); i < n; i++ {

		{
			sval, err := cbg.ReadStringWithMax(cr, 1000000)
			if err != nil {
				return err
			}

			name = string(sval)
		}

		switch name {
		// t.Seq (int64) (int64)
		case "seq":
			{
				maj, extra, err := cr.ReadHeader()
				if err != nil {
					return err
				}
				var extraI int64
				switch maj {
				case cbg.MajUnsignedInt:
					extraI = int64(extra)
					if extraI < 0 {
						return fmt.Errorf("int64 positive overflow")
					}
				case cbg.MajNegativeInt:
					extraI = int64(extra)
					if extraI < 0 {
						return fmt.Errorf("int64 negative overflow")
					}
					extraI = -1 - extraI
				default:
					return fmt.Errorf("wrong type for int64 field: %d", maj)
				}

				t.Seq = int64(extraI)
			}
			// t.Labels ([]*atproto.LabelDefs_Label) (slice)
		case "labels":

			maj, extra, err = cr.ReadHeader()
			if err != nil {
				return err
			}

			if extra > 8192 {
				return fmt.Errorf("t.Labels: array too large (%d)", extra)
			}

			if maj != cbg.MajArray {
				return fmt.Errorf("expected cbor array")
			}

			if extra > 0 {
				t.Labels = make([]*LabelDefs_Label, extra)
			}

			for i := 0; i < int(extra); i++ {
				{
					var maj byte
					var extra uint64
					var err error
					_ = maj
					_ = extra
					_ = err

					{

						b, err := cr.ReadByte()
						if err != nil {
							return err
						}
						if b != cbg.CborNull[0] {
							if err := cr.UnreadByte(); err != nil {
								return err
							}
							t.Labels[i] = new(LabelDefs_Label)
							if err := t.Labels[i].UnmarshalCBOR(cr); err != nil {
								return xerrors.Errorf("unmarshaling t.Labels[i] pointer: %w", err)
							}
						}

					}

				}
			}

		default:
			// Field doesn't exist on this type, so ignore it
			cbg.ScanForLinks(r, func(cid.Cid) {})
		}
	}

	return nil
}
func (t *LabelSubscribeLabels_Info) MarshalCBOR(w io.Writer) error {
	if t == nil {
		_, err := w.Write(cbg.CborNull)
		return err
	}

	cw := cbg.NewCborWriter(w)
	fieldCount := 2

	if t.Message == nil {
		fieldCount--
	}

	if _, err := cw.Write(cbg.CborEncodeMajorType(cbg.MajMap, uint64(fieldCount))); err != nil {
		return err
	}

	// t.Name (string) (string)
	if len("name") > 1000000 {
		return xerrors.Errorf("Value in field \"name\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("name"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("name")); err != nil {
		return err
	}

	if len(t.Name) > 1000000 {
		return xerrors.Errorf("Value in field t.Name was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(t.Name))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string(t.Name)); err != nil {
		return err
	}

	// t.Message (string) (string)
	if t.Message != nil {

		if len("message") > 1000000 {
			return xerrors.Errorf("Value in field \"message\" was too long")
		}

		if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("message"))); err != nil {
			return err
		}
		if _, err := cw.WriteString(string("message")); err != nil {
			return err
		}

		if t.Message == nil {
			if _, err := cw.Write(cbg.CborNull); err != nil {
				return err
			}
		} else {
			if len(*t.Message) > 1000000 {
				return xerrors.Errorf("Value in field t.Message was too long")
			}

			if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(*t.Message))); err != nil {
				return err
			}
			if _, err := cw.WriteString(string(*t.Message)); err != nil {
				return err
			}
		}
	}
	return nil
}

func (t *LabelSubscribeLabels_Info) UnmarshalCBOR(r io.Reader) (err error) {
	*t = LabelSubscribeLabels_Info{}

	cr := cbg.NewCborReader(r)

	maj, extra, err := cr.ReadHeader()
	if err != nil {
		return err
	}
	defer func() {
		if err == io.EOF {
			err = io.ErrUnexpectedEOF
		}
	}()

	if maj != cbg.MajMap {
		return fmt.Errorf("cbor input should be of type map")
	}

	if extra > cbg.MaxLength {
		return fmt.Errorf("LabelSubscribeLabels_Info: map struct too large (%d)", extra)
	}

	var name string
	n := extra

	for i := uint64(0); i < n; i++ {

		{
			sval, err := cbg.ReadStringWithMax(cr, 1000000)
			if err != nil {
				return err
			}

			name = string(sval)
		}

		switch name {
		// t.Name (string) (string)
		case "name":

			{
				sval, err := cbg.ReadStringWithMax(cr, 1000000)
				if err != nil {
					return err
				}

				t.Name = string(sval)
			}
			// t.Message (string) (string)
		case "message":

			{
				b, err := cr.ReadByte()
				if err != nil {
					return err
				}
				if b != cbg.CborNull[0] {
					if err := cr.UnreadByte(); err != nil {
						return err
					}

					sval, err := cbg.ReadStringWithMax(cr, 1000000)
					if err != nil {
						return err
					}

					t.Message = (*string)(&sval)
				}
			}

		default:
			// Field doesn't exist on this type, so ignore it
			cbg.ScanForLinks(r, func(cid.Cid) {})
		}
	}

	return nil
}
func (t *LabelDefs_LabelValueDefinition) MarshalCBOR(w io.Writer) error {
	if t == nil {
		_, err := w.Write(cbg.CborNull)
		return err
	}

	cw := cbg.NewCborWriter(w)

	if _, err := cw.Write([]byte{164}); err != nil {
		return err
	}

	// t.Blurs (string) (string)
	if len("blurs") > 1000000 {
		return xerrors.Errorf("Value in field \"blurs\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("blurs"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("blurs")); err != nil {
		return err
	}

	if len(t.Blurs) > 1000000 {
		return xerrors.Errorf("Value in field t.Blurs was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(t.Blurs))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string(t.Blurs)); err != nil {
		return err
	}

	// t.Locales ([]*atproto.LabelDefs_LabelValueDefinitionStrings) (slice)
	if len("locales") > 1000000 {
		return xerrors.Errorf("Value in field \"locales\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("locales"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("locales")); err != nil {
		return err
	}

	if len(t.Locales) > 8192 {
		return xerrors.Errorf("Slice value in field t.Locales was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajArray, uint64(len(t.Locales))); err != nil {
		return err
	}
	for _, v := range t.Locales {
		if err := v.MarshalCBOR(cw); err != nil {
			return err
		}

	}

	// t.Severity (string) (string)
	if len("severity") > 1000000 {
		return xerrors.Errorf("Value in field \"severity\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("severity"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("severity")); err != nil {
		return err
	}

	if len(t.Severity) > 1000000 {
		return xerrors.Errorf("Value in field t.Severity was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(t.Severity))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string(t.Severity)); err != nil {
		return err
	}

	// t.Identifier (string) (string)
	if len("identifier") > 1000000 {
		return xerrors.Errorf("Value in field \"identifier\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("identifier"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("identifier")); err != nil {
		return err
	}

	if len(t.Identifier) > 1000000 {
		return xerrors.Errorf("Value in field t.Identifier was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(t.Identifier))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string(t.Identifier)); err != nil {
		return err
	}
	return nil
}

func (t *LabelDefs_LabelValueDefinition) UnmarshalCBOR(r io.Reader) (err error) {
	*t = LabelDefs_LabelValueDefinition{}

	cr := cbg.NewCborReader(r)

	maj, extra, err := cr.ReadHeader()
	if err != nil {
		return err
	}
	defer func() {
		if err == io.EOF {
			err = io.ErrUnexpectedEOF
		}
	}()

	if maj != cbg.MajMap {
		return fmt.Errorf("cbor input should be of type map")
	}

	if extra > cbg.MaxLength {
		return fmt.Errorf("LabelDefs_LabelValueDefinition: map struct too large (%d)", extra)
	}

	var name string
	n := extra

	for i := uint64(0); i < n; i++ {

		{
			sval, err := cbg.ReadStringWithMax(cr, 1000000)
			if err != nil {
				return err
			}

			name = string(sval)
		}

		switch name {
		// t.Blurs (string) (string)
		case "blurs":

			{
				sval, err := cbg.ReadStringWithMax(cr, 1000000)
				if err != nil {
					return err
				}

				t.Blurs = string(sval)
			}
			// t.Locales ([]*atproto.LabelDefs_LabelValueDefinitionStrings) (slice)
		case "locales":

			maj, extra, err = cr.ReadHeader()
			if err != nil {
				return err
			}

			if extra > 8192 {
				return fmt.Errorf("t.Locales: array too large (%d)", extra)
			}

			if maj != cbg.MajArray {
				return fmt.Errorf("expected cbor array")
			}

			if extra > 0 {
				t.Locales = make([]*LabelDefs_LabelValueDefinitionStrings, extra)
			}

			for i := 0; i < int(extra); i++ {
				{
					var maj byte
					var extra uint64
					var err error
					_ = maj
					_ = extra
					_ = err

					{

						b, err := cr.ReadByte()
						if err != nil {
							return err
						}
						if b != cbg.CborNull[0] {
							if err := cr.UnreadByte(); err != nil {
								return err
							}
							t.Locales[i] = new(LabelDefs_LabelValueDefinitionStrings)
							if err := t.Locales[i].UnmarshalCBOR(cr); err != nil {
								return xerrors.Errorf("unmarshaling t.Locales[i] pointer: %w", err)
							}
						}

					}

				}
			}
			// t.Severity (string) (string)
		case "severity":

			{
				sval, err := cbg.ReadStringWithMax(cr, 1000000)
				if err != nil {
					return err
				}

				t.Severity = string(sval)
			}
			// t.Identifier (string) (string)
		case "identifier":

			{
				sval, err := cbg.ReadStringWithMax(cr, 1000000)
				if err != nil {
					return err
				}

				t.Identifier = string(sval)
			}

		default:
			// Field doesn't exist on this type, so ignore it
			cbg.ScanForLinks(r, func(cid.Cid) {})
		}
	}

	return nil
}
func (t *LabelDefs_LabelValueDefinitionStrings) MarshalCBOR(w io.Writer) error {
	if t == nil {
		_, err := w.Write(cbg.CborNull)
		return err
	}

	cw := cbg.NewCborWriter(w)

	if _, err := cw.Write([]byte{163}); err != nil {
		return err
	}

	// t.Lang (string) (string)
	if len("lang") > 1000000 {
		return xerrors.Errorf("Value in field \"lang\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("lang"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("lang")); err != nil {
		return err
	}

	if len(t.Lang) > 1000000 {
		return xerrors.Errorf("Value in field t.Lang was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(t.Lang))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string(t.Lang)); err != nil {
		return err
	}

	// t.Name (string) (string)
	if len("name") > 1000000 {
		return xerrors.Errorf("Value in field \"name\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("name"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("name")); err != nil {
		return err
	}

	if len(t.Name) > 1000000 {
		return xerrors.Errorf("Value in field t.Name was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(t.Name))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string(t.Name)); err != nil {
		return err
	}

	// t.Description (string) (string)
	if len("description") > 1000000 {
		return xerrors.Errorf("Value in field \"description\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("description"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("description")); err != nil {
		return err
	}

	if len(t.Description) > 1000000 {
		return xerrors.Errorf("Value in field t.Description was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(t.Description))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string(t.Description)); err != nil {
		return err
	}
	return nil
}

func (t *LabelDefs_LabelValueDefinitionStrings) UnmarshalCBOR(r io.Reader) (err error) {
	*t = LabelDefs_LabelValueDefinitionStrings{}

	cr := cbg.NewCborReader(r)

	maj, extra, err := cr.ReadHeader()
	if err != nil {
		return err
	}
	defer func() {
		if err == io.EOF {
			err = io.ErrUnexpectedEOF
		}
	}()

	if maj != cbg.MajMap {
		return fmt.Errorf("cbor input should be of type map")
	}

	if extra > cbg.MaxLength {
		return fmt.Errorf("LabelDefs_LabelValueDefinitionStrings: map struct too large (%d)", extra)
	}

	var name string
	n := extra

	for i := uint64(0); i < n; i++ {

		{
			sval, err := cbg.ReadStringWithMax(cr, 1000000)
			if err != nil {
				return err
			}

			name = string(sval)
		}

		switch name {
		// t.Lang (string) (string)
		case "lang":

			{
				sval, err := cbg.ReadStringWithMax(cr, 1000000)
				if err != nil {
					return err
				}

				t.Lang = string(sval)
			}
			// t.Name (string) (string)
		case "name":

			{
				sval, err := cbg.ReadStringWithMax(cr, 1000000)
				if err != nil {
					return err
				}

				t.Name = string(sval)
			}
			// t.Description (string) (string)
		case "description":

			{
				sval, err := cbg.ReadStringWithMax(cr, 1000000)
				if err != nil {
					return err
				}

				t.Description = string(sval)
			}

		default:
			// Field doesn't exist on this type, so ignore it
			cbg.ScanForLinks(r, func(cid.Cid) {})
		}
	}

	return nil
}
