import Lean
/-!
# Attribute Errors

Tests errors generated by the core attribute infrastructure. Does *not* test errors generated by
attributes' individual preprocessing (e.g., `[reducible]`).
-/

/-- error: Unknown attribute `[nonexistent_attribute]` -/
#guard_msgs in
@[nonexistent_attribute] def x := 32

/--
error: Cannot add attribute `[unused_variables_ignore_fn]`: Declaration `notAnIgnoreFn` has type
  Bool
but `[unused_variables_ignore_fn]` can only be added to declarations of type
  Lean.Linter.IgnoreFunction
-/
#guard_msgs in
@[unused_variables_ignore_fn] def notAnIgnoreFn := true

/--
error: Cannot add attribute `[expose]`: This attribute can only be added when declaring a `def`
-/
#guard_msgs in
@[expose] theorem t : True := trivial

def foo := ()
/--
error: Cannot add attribute `[expose]`: This attribute can only be added when declaring a `def`
-/
#guard_msgs in
attribute [expose] foo

/-- error: Attribute `[expose]` cannot be erased -/
#guard_msgs in
attribute [-expose] Nat.add

/--
error: Cannot add attribute `[missing_docs_handler]` to declaration `Nat.succ` because it is in an imported module
-/
#guard_msgs in
attribute [missing_docs_handler] Nat.succ
