/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.junit;

import java.util.List;
import junit.framework.TestCase;
import org.gradle.api.internal.tasks.testing.TestSuiteExecutionException;
import org.gradle.api.internal.tasks.testing.junit.AllExceptIgnoredTestRunnerBuilder;
import org.junit.internal.runners.InitializationError;
import org.junit.internal.runners.JUnit38ClassRunner;
import org.junit.internal.runners.JUnit4ClassRunner;
import org.junit.runner.Description;
import org.junit.runner.Request;
import org.junit.runner.RunWith;
import org.junit.runner.Runner;
import org.junit.runners.AllTests;

public class IgnoredTestDescriptorProvider {
    public static List<Description> getAllDescriptions(Description description, String className) {
        try {
            Class<?> testClass = description.getClass().getClassLoader().loadClass(className);
            Runner runner = IgnoredTestDescriptorProvider.getRunner(testClass);
            Description runnerDescription = runner.getDescription();
            return runnerDescription.getChildren();
        }
        catch (Throwable throwable) {
            throw new TestSuiteExecutionException(String.format("Unable to process Ignored class %s.", className), throwable);
        }
    }

    private static Runner getRunner(Class<?> testClass) throws Throwable {
        try {
            AllExceptIgnoredTestRunnerBuilder allExceptIgnoredTestRunnerBuilder = new AllExceptIgnoredTestRunnerBuilder();
            Runner runner = allExceptIgnoredTestRunnerBuilder.runnerForClass(testClass);
            if (runner == null) {
                runner = Request.aClass(testClass).getRunner();
            }
            return runner;
        }
        catch (NoClassDefFoundError e) {
            return IgnoredTestDescriptorProvider.getRunnerLegacy(testClass);
        }
        catch (NoSuchMethodError e) {
            return IgnoredTestDescriptorProvider.getRunnerLegacy(testClass);
        }
    }

    static Runner getRunnerLegacy(Class<?> testClass) throws Throwable {
        RunWith annotation = testClass.getAnnotation(RunWith.class);
        if (annotation != null) {
            Class runnerClass = annotation.value();
            try {
                return (Runner)runnerClass.getConstructor(Class.class).newInstance(testClass);
            }
            catch (NoSuchMethodException e) {
                String simpleName = runnerClass.getSimpleName();
                throw new InitializationError("Custom runner class " + simpleName + " should have a public constructor with signature " + simpleName + "(Class testClass)");
            }
        }
        if (IgnoredTestDescriptorProvider.hasSuiteMethod(testClass)) {
            return new AllTests(testClass);
        }
        if (TestCase.class.isAssignableFrom(testClass)) {
            return new JUnit38ClassRunner(testClass);
        }
        return new JUnit4ClassRunner(testClass);
    }

    private static boolean hasSuiteMethod(Class<?> testClass) {
        try {
            testClass.getMethod("suite", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        return true;
    }
}

