/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch.juz;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Logger;
import com.jcraft.jsch.Session;
import java.util.function.Supplier;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;

public class Compression
implements com.jcraft.jsch.Compression {
    private static final int BUF_SIZE = 4096;
    private final int buffer_margin = 52;
    private Deflater deflater;
    private Inflater inflater;
    private byte[] tmpbuf = new byte[4096];
    private byte[] inflated_buf;
    private Session session;

    private void logMessage(int level, Supplier<String> message) {
        Logger logger;
        Logger logger2 = logger = this.session == null ? JSch.getLogger() : this.session.getLogger();
        if (!logger.isEnabled(level)) {
            return;
        }
        logger.log(level, message.get());
    }

    @Override
    public void end() {
        this.inflated_buf = null;
        if (this.inflater != null) {
            this.inflater.end();
            this.inflater = null;
        }
        if (this.deflater != null) {
            this.deflater.end();
            this.deflater = null;
        }
        this.session = null;
    }

    @Override
    public void init(int type, int level, Session session) {
        this.session = session;
        this.init(type, level);
    }

    @Override
    public void init(int type, int level) {
        if (type == 1) {
            this.deflater = new Deflater(level);
        } else if (type == 0) {
            this.inflater = new Inflater();
            this.inflated_buf = new byte[4096];
        }
        this.logMessage(0, () -> "zlib using " + this.getClass().getCanonicalName());
    }

    @Override
    public byte[] compress(byte[] buf, int start, int[] end) {
        if (this.tmpbuf.length < end[0]) {
            this.tmpbuf = new byte[end[0] * 2];
        }
        this.deflater.setInput(buf, start, end[0] - start);
        byte[] obuf = buf;
        int obuflen = start;
        do {
            int result;
            if (obuf.length < obuflen + (result = this.deflater.deflate(this.tmpbuf, 0, this.tmpbuf.length, 2)) + 52) {
                byte[] tmp = new byte[(obuflen + result + 52) * 2];
                System.arraycopy(obuf, 0, tmp, 0, obuf.length);
                obuf = tmp;
            }
            System.arraycopy(this.tmpbuf, 0, obuf, obuflen, result);
            obuflen += result;
        } while (!this.deflater.needsInput());
        end[0] = obuflen;
        return obuf;
    }

    @Override
    public byte[] uncompress(byte[] buf, int start, int[] len) {
        this.inflater.setInput(buf, start, len[0]);
        int inflated_end = 0;
        try {
            do {
                int result;
                if (this.inflated_buf.length < inflated_end + (result = this.inflater.inflate(this.tmpbuf, 0, this.tmpbuf.length))) {
                    byte[] tmp = new byte[inflated_end + result];
                    System.arraycopy(this.inflated_buf, 0, tmp, 0, inflated_end);
                    this.inflated_buf = tmp;
                }
                System.arraycopy(this.tmpbuf, 0, this.inflated_buf, inflated_end, result);
                inflated_end += result;
            } while (this.inflater.getRemaining() > 0);
        }
        catch (DataFormatException e) {
            this.logMessage(2, () -> "an exception during uncompress\n" + e.toString());
        }
        if (buf.length < this.inflated_buf.length + start) {
            byte[] tmp = new byte[this.inflated_buf.length + start];
            System.arraycopy(buf, 0, tmp, 0, start);
            buf = tmp;
        }
        System.arraycopy(this.inflated_buf, 0, buf, start, inflated_end);
        len[0] = inflated_end;
        return buf;
    }
}

