// generated by diplomat-tool
import type { CodePointRangeIterator } from "./CodePointRangeIterator"
import type { CodePointSetData } from "./CodePointSetData"
import type { DataError } from "./DataError"
import type { DataProvider } from "./DataProvider"
import type { GeneralCategoryGroup } from "./GeneralCategoryGroup"
import type { GeneralCategoryGroup_obj } from "./GeneralCategoryGroup"
import type { pointer, codepoint } from "./diplomat-runtime.d.ts";


/**
 * An ICU4X Unicode Map Property object, capable of querying whether a code point (key) to obtain the Unicode property value, for a specific Unicode property.
 *
 * For properties whose values fit into 8 bits.
 *
 * See the [Rust documentation for `properties`](https://docs.rs/icu/latest/icu/properties/index.html) for more information.
 *
 * See the [Rust documentation for `CodePointMapData`](https://docs.rs/icu/latest/icu/properties/struct.CodePointMapData.html) for more information.
 *
 * See the [Rust documentation for `CodePointMapDataBorrowed`](https://docs.rs/icu/latest/icu/properties/struct.CodePointMapDataBorrowed.html) for more information.
 */


export class CodePointMapData8 {
    get ffiValue(): pointer;


    /**
     * Gets the value for a code point.
     *
     * See the [Rust documentation for `get`](https://docs.rs/icu/latest/icu/properties/struct.CodePointMapDataBorrowed.html#method.get) for more information.
     */
    get(cp: codepoint): number;

    /**
     * Produces an iterator over ranges of code points that map to `value`
     *
     * See the [Rust documentation for `iter_ranges_for_value`](https://docs.rs/icu/latest/icu/properties/struct.CodePointMapDataBorrowed.html#method.iter_ranges_for_value) for more information.
     */
    iterRangesForValue(value: number): CodePointRangeIterator;

    /**
     * Produces an iterator over ranges of code points that do not map to `value`
     *
     * See the [Rust documentation for `iter_ranges_for_value_complemented`](https://docs.rs/icu/latest/icu/properties/struct.CodePointMapDataBorrowed.html#method.iter_ranges_for_value_complemented) for more information.
     */
    iterRangesForValueComplemented(value: number): CodePointRangeIterator;

    /**
     * Given a mask value (the nth bit marks property value = n), produce an iterator over ranges of code points
     * whose property values are contained in the mask.
     *
     * The main mask property supported is that for General_Category, which can be obtained via `general_category_to_mask()` or
     * by using `GeneralCategoryNameToMaskMapper`
     *
     * Should only be used on maps for properties with values less than 32 (like Generak_Category),
     * other maps will have unpredictable results
     *
     * See the [Rust documentation for `iter_ranges_for_group`](https://docs.rs/icu/latest/icu/properties/struct.CodePointMapDataBorrowed.html#method.iter_ranges_for_group) for more information.
     */
    iterRangesForGroup(group: GeneralCategoryGroup_obj): CodePointRangeIterator;

    /**
     * Gets a [`CodePointSetData`] representing all entries in this map that map to the given value
     *
     * See the [Rust documentation for `get_set_for_value`](https://docs.rs/icu/latest/icu/properties/struct.CodePointMapDataBorrowed.html#method.get_set_for_value) for more information.
     */
    getSetForValue(value: number): CodePointSetData;

    /**
     * Create a map for the `General_Category` property, using compiled data.
     *
     * See the [Rust documentation for `GeneralCategory`](https://docs.rs/icu/latest/icu/properties/props/enum.GeneralCategory.html) for more information.
     */
    static createGeneralCategory(): CodePointMapData8;

    /**
     * Create a map for the `General_Category` property, using a particular data source
     *
     * See the [Rust documentation for `GeneralCategory`](https://docs.rs/icu/latest/icu/properties/props/enum.GeneralCategory.html) for more information.
     */
    static createGeneralCategoryWithProvider(provider: DataProvider): CodePointMapData8;

    /**
     * Create a map for the `Bidi_Class` property, using compiled data.
     *
     * See the [Rust documentation for `BidiClass`](https://docs.rs/icu/latest/icu/properties/props/struct.BidiClass.html) for more information.
     */
    static createBidiClass(): CodePointMapData8;

    /**
     * Create a map for the `Bidi_Class` property, using a particular data source.
     *
     * See the [Rust documentation for `BidiClass`](https://docs.rs/icu/latest/icu/properties/props/struct.BidiClass.html) for more information.
     */
    static createBidiClassWithProvider(provider: DataProvider): CodePointMapData8;

    /**
     * Create a map for the `East_Asian_Width` property, using compiled data.
     *
     * See the [Rust documentation for `EastAsianWidth`](https://docs.rs/icu/latest/icu/properties/props/struct.EastAsianWidth.html) for more information.
     */
    static createEastAsianWidth(): CodePointMapData8;

    /**
     * Create a map for the `East_Asian_Width` property, using a particular data source.
     *
     * See the [Rust documentation for `EastAsianWidth`](https://docs.rs/icu/latest/icu/properties/props/struct.EastAsianWidth.html) for more information.
     */
    static createEastAsianWidthWithProvider(provider: DataProvider): CodePointMapData8;

    /**
     * Create a map for the `Hangul_Syllable_Type` property, using compiled data.
     *
     * See the [Rust documentation for `HangulSyllableType`](https://docs.rs/icu/latest/icu/properties/props/struct.HangulSyllableType.html) for more information.
     */
    static createHangulSyllableType(): CodePointMapData8;

    /**
     * Create a map for the `Hangul_Syllable_Type` property, using a particular data source.
     *
     * See the [Rust documentation for `HangulSyllableType`](https://docs.rs/icu/latest/icu/properties/props/struct.HangulSyllableType.html) for more information.
     */
    static createHangulSyllableTypeWithProvider(provider: DataProvider): CodePointMapData8;

    /**
     * Create a map for the `Indic_Syllabic_Property` property, using compiled data.
     *
     * See the [Rust documentation for `IndicSyllabicCategory`](https://docs.rs/icu/latest/icu/properties/props/struct.IndicSyllabicCategory.html) for more information.
     */
    static createIndicSyllabicCategory(): CodePointMapData8;

    /**
     * Create a map for the `Indic_Syllabic_Property` property, using a particular data source.
     *
     * See the [Rust documentation for `IndicSyllabicCategory`](https://docs.rs/icu/latest/icu/properties/props/struct.IndicSyllabicCategory.html) for more information.
     */
    static createIndicSyllabicCategoryWithProvider(provider: DataProvider): CodePointMapData8;

    /**
     * Create a map for the `Line_Break` property, using compiled data.
     *
     * See the [Rust documentation for `LineBreak`](https://docs.rs/icu/latest/icu/properties/props/struct.LineBreak.html) for more information.
     */
    static createLineBreak(): CodePointMapData8;

    /**
     * Create a map for the `Line_Break` property, using a particular data source.
     *
     * See the [Rust documentation for `LineBreak`](https://docs.rs/icu/latest/icu/properties/props/struct.LineBreak.html) for more information.
     */
    static createLineBreakWithProvider(provider: DataProvider): CodePointMapData8;

    /**
     * Create a map for the `Grapheme_Cluster_Break` property, using compiled data.
     *
     * See the [Rust documentation for `GraphemeClusterBreak`](https://docs.rs/icu/latest/icu/properties/props/struct.GraphemeClusterBreak.html) for more information.
     */
    static createGraphemeClusterBreak(): CodePointMapData8;

    /**
     * Create a map for the `Grapheme_Cluster_Break` property, using a particular data source.
     *
     * See the [Rust documentation for `GraphemeClusterBreak`](https://docs.rs/icu/latest/icu/properties/props/struct.GraphemeClusterBreak.html) for more information.
     */
    static createGraphemeClusterBreakWithProvider(provider: DataProvider): CodePointMapData8;

    /**
     * Create a map for the `Word_Break` property, using compiled data.
     *
     * See the [Rust documentation for `WordBreak`](https://docs.rs/icu/latest/icu/properties/props/struct.WordBreak.html) for more information.
     */
    static createWordBreak(): CodePointMapData8;

    /**
     * Create a map for the `Word_Break` property, using a particular data source.
     *
     * See the [Rust documentation for `WordBreak`](https://docs.rs/icu/latest/icu/properties/props/struct.WordBreak.html) for more information.
     */
    static createWordBreakWithProvider(provider: DataProvider): CodePointMapData8;

    /**
     * Create a map for the `Sentence_Break` property, using compiled data.
     *
     * See the [Rust documentation for `SentenceBreak`](https://docs.rs/icu/latest/icu/properties/props/struct.SentenceBreak.html) for more information.
     */
    static createSentenceBreak(): CodePointMapData8;

    /**
     * Create a map for the `Sentence_Break` property, using a particular data source.
     *
     * See the [Rust documentation for `SentenceBreak`](https://docs.rs/icu/latest/icu/properties/props/struct.SentenceBreak.html) for more information.
     */
    static createSentenceBreakWithProvider(provider: DataProvider): CodePointMapData8;

    /**
     * Create a map for the `Joining_Type` property, using compiled data.
     *
     * See the [Rust documentation for `JoiningType`](https://docs.rs/icu/latest/icu/properties/props/struct.JoiningType.html) for more information.
     */
    static createJoiningType(): CodePointMapData8;

    /**
     * Create a map for the `Joining_Type` property, using a particular data source.
     *
     * See the [Rust documentation for `JoiningType`](https://docs.rs/icu/latest/icu/properties/props/struct.JoiningType.html) for more information.
     */
    static createJoiningTypeWithProvider(provider: DataProvider): CodePointMapData8;

    /**
     * Create a map for the `Canonical_Combining_Class` property, using compiled data.
     *
     * See the [Rust documentation for `CanonicalCombiningClass`](https://docs.rs/icu/latest/icu/properties/props/struct.CanonicalCombiningClass.html) for more information.
     */
    static createCanonicalCombiningClass(): CodePointMapData8;

    /**
     * Create a map for the `Canonical_Combining_Class` property, using a particular data source.
     *
     * See the [Rust documentation for `CanonicalCombiningClass`](https://docs.rs/icu/latest/icu/properties/props/struct.CanonicalCombiningClass.html) for more information.
     */
    static createCanonicalCombiningClassWithProvider(provider: DataProvider): CodePointMapData8;

    /**
     * Create a map for the `Vertical_Orientation` property, using compiled data.
     *
     * See the [Rust documentation for `VerticalOrientation`](https://docs.rs/icu/latest/icu/properties/props/struct.VerticalOrientation.html) for more information.
     */
    static createVerticalOrientation(): CodePointMapData8;

    /**
     * Create a map for the `Vertical_Orientation` property, using a particular data source.
     *
     * See the [Rust documentation for `VerticalOrientation`](https://docs.rs/icu/latest/icu/properties/props/struct.VerticalOrientation.html) for more information.
     */
    static createVerticalOrientationWithProvider(provider: DataProvider): CodePointMapData8;
}