// generated by diplomat-tool
import type { BidiInfo } from "./BidiInfo"
import type { DataError } from "./DataError"
import type { DataProvider } from "./DataProvider"
import type { ReorderedIndexMap } from "./ReorderedIndexMap"
import type { pointer, codepoint } from "./diplomat-runtime.d.ts";


/**
 * An ICU4X Bidi object, containing loaded bidi data
 *
 * See the [Rust documentation for `BidiClass`](https://docs.rs/icu/latest/icu/properties/props/struct.BidiClass.html) for more information.
 */


export class Bidi {
    get ffiValue(): pointer;


    /**
     * Creates a new [`Bidi`] from locale data, and a particular data source.
     */
    static createWithProvider(provider: DataProvider): Bidi;

    /**
     * Use the data loaded in this object to process a string and calculate bidi information
     *
     * Takes in a Level for the default level, if it is an invalid value it will default to LTR
     *
     * See the [Rust documentation for `new_with_data_source`](https://docs.rs/unicode_bidi/latest/unicode_bidi/struct.BidiInfo.html#method.new_with_data_source) for more information.
     */
    forText(text: string, defaultLevel: number | null): BidiInfo;

    /**
     * Utility function for producing reorderings given a list of levels
     *
     * Produces a map saying which visual index maps to which source index.
     *
     * The levels array must not have values greater than 126 (this is the
     * Bidi maximum explicit depth plus one).
     * Failure to follow this invariant may lead to incorrect results,
     * but is still safe.
     *
     * See the [Rust documentation for `reorder_visual`](https://docs.rs/unicode_bidi/latest/unicode_bidi/struct.BidiInfo.html#method.reorder_visual) for more information.
     */
    reorderVisual(levels: Array<number>): ReorderedIndexMap;

    /**
     * Check if a Level returned by level_at is an RTL level.
     *
     * Invalid levels (numbers greater than 125) will be assumed LTR
     *
     * See the [Rust documentation for `is_rtl`](https://docs.rs/unicode_bidi/latest/unicode_bidi/struct.Level.html#method.is_rtl) for more information.
     */
    static levelIsRtl(level: number): boolean;

    /**
     * Check if a Level returned by level_at is an LTR level.
     *
     * Invalid levels (numbers greater than 125) will be assumed LTR
     *
     * See the [Rust documentation for `is_ltr`](https://docs.rs/unicode_bidi/latest/unicode_bidi/struct.Level.html#method.is_ltr) for more information.
     */
    static levelIsLtr(level: number): boolean;

    /**
     * Get a basic RTL Level value
     *
     * See the [Rust documentation for `rtl`](https://docs.rs/unicode_bidi/latest/unicode_bidi/struct.Level.html#method.rtl) for more information.
     */
    static levelRtl(): number;

    /**
     * Get a simple LTR Level value
     *
     * See the [Rust documentation for `ltr`](https://docs.rs/unicode_bidi/latest/unicode_bidi/struct.Level.html#method.ltr) for more information.
     */
    static levelLtr(): number;

    constructor();
}