// Code generated by deep-copy -pointer-receiver -o ./config.deepcopy.go -type RuntimeConfig ./; DO NOT EDIT.

package config

import (
	"crypto/tls"
	"crypto/x509"
	"crypto/x509/pkix"
	"encoding/asn1"
	"github.com/armon/go-metrics"
	"github.com/armon/go-metrics/prometheus"
	"github.com/hashicorp/consul/agent/structs"
	"github.com/hashicorp/consul/types"
	"math/big"
	"net"
	"net/url"
	"time"
)

// DeepCopy generates a deep copy of *RuntimeConfig
func (o *RuntimeConfig) DeepCopy() *RuntimeConfig {
	var cp RuntimeConfig = *o
	if o.Cloud.TLSConfig != nil {
		cp.Cloud.TLSConfig = new(tls.Config)
		*cp.Cloud.TLSConfig = *o.Cloud.TLSConfig
		if o.Cloud.TLSConfig.Certificates != nil {
			cp.Cloud.TLSConfig.Certificates = make([]tls.Certificate, len(o.Cloud.TLSConfig.Certificates))
			copy(cp.Cloud.TLSConfig.Certificates, o.Cloud.TLSConfig.Certificates)
			for i5 := range o.Cloud.TLSConfig.Certificates {
				if o.Cloud.TLSConfig.Certificates[i5].Certificate != nil {
					cp.Cloud.TLSConfig.Certificates[i5].Certificate = make([][]byte, len(o.Cloud.TLSConfig.Certificates[i5].Certificate))
					copy(cp.Cloud.TLSConfig.Certificates[i5].Certificate, o.Cloud.TLSConfig.Certificates[i5].Certificate)
					for i7 := range o.Cloud.TLSConfig.Certificates[i5].Certificate {
						if o.Cloud.TLSConfig.Certificates[i5].Certificate[i7] != nil {
							cp.Cloud.TLSConfig.Certificates[i5].Certificate[i7] = make([]byte, len(o.Cloud.TLSConfig.Certificates[i5].Certificate[i7]))
							copy(cp.Cloud.TLSConfig.Certificates[i5].Certificate[i7], o.Cloud.TLSConfig.Certificates[i5].Certificate[i7])
						}
					}
				}
				if o.Cloud.TLSConfig.Certificates[i5].SupportedSignatureAlgorithms != nil {
					cp.Cloud.TLSConfig.Certificates[i5].SupportedSignatureAlgorithms = make([]tls.SignatureScheme, len(o.Cloud.TLSConfig.Certificates[i5].SupportedSignatureAlgorithms))
					copy(cp.Cloud.TLSConfig.Certificates[i5].SupportedSignatureAlgorithms, o.Cloud.TLSConfig.Certificates[i5].SupportedSignatureAlgorithms)
				}
				if o.Cloud.TLSConfig.Certificates[i5].OCSPStaple != nil {
					cp.Cloud.TLSConfig.Certificates[i5].OCSPStaple = make([]byte, len(o.Cloud.TLSConfig.Certificates[i5].OCSPStaple))
					copy(cp.Cloud.TLSConfig.Certificates[i5].OCSPStaple, o.Cloud.TLSConfig.Certificates[i5].OCSPStaple)
				}
				if o.Cloud.TLSConfig.Certificates[i5].SignedCertificateTimestamps != nil {
					cp.Cloud.TLSConfig.Certificates[i5].SignedCertificateTimestamps = make([][]byte, len(o.Cloud.TLSConfig.Certificates[i5].SignedCertificateTimestamps))
					copy(cp.Cloud.TLSConfig.Certificates[i5].SignedCertificateTimestamps, o.Cloud.TLSConfig.Certificates[i5].SignedCertificateTimestamps)
					for i7 := range o.Cloud.TLSConfig.Certificates[i5].SignedCertificateTimestamps {
						if o.Cloud.TLSConfig.Certificates[i5].SignedCertificateTimestamps[i7] != nil {
							cp.Cloud.TLSConfig.Certificates[i5].SignedCertificateTimestamps[i7] = make([]byte, len(o.Cloud.TLSConfig.Certificates[i5].SignedCertificateTimestamps[i7]))
							copy(cp.Cloud.TLSConfig.Certificates[i5].SignedCertificateTimestamps[i7], o.Cloud.TLSConfig.Certificates[i5].SignedCertificateTimestamps[i7])
						}
					}
				}
				if o.Cloud.TLSConfig.Certificates[i5].Leaf != nil {
					cp.Cloud.TLSConfig.Certificates[i5].Leaf = new(x509.Certificate)
					*cp.Cloud.TLSConfig.Certificates[i5].Leaf = *o.Cloud.TLSConfig.Certificates[i5].Leaf
					if o.Cloud.TLSConfig.Certificates[i5].Leaf.Raw != nil {
						cp.Cloud.TLSConfig.Certificates[i5].Leaf.Raw = make([]byte, len(o.Cloud.TLSConfig.Certificates[i5].Leaf.Raw))
						copy(cp.Cloud.TLSConfig.Certificates[i5].Leaf.Raw, o.Cloud.TLSConfig.Certificates[i5].Leaf.Raw)
					}
					if o.Cloud.TLSConfig.Certificates[i5].Leaf.RawTBSCertificate != nil {
						cp.Cloud.TLSConfig.Certificates[i5].Leaf.RawTBSCertificate = make([]byte, len(o.Cloud.TLSConfig.Certificates[i5].Leaf.RawTBSCertificate))
						copy(cp.Cloud.TLSConfig.Certificates[i5].Leaf.RawTBSCertificate, o.Cloud.TLSConfig.Certificates[i5].Leaf.RawTBSCertificate)
					}
					if o.Cloud.TLSConfig.Certificates[i5].Leaf.RawSubjectPublicKeyInfo != nil {
						cp.Cloud.TLSConfig.Certificates[i5].Leaf.RawSubjectPublicKeyInfo = make([]byte, len(o.Cloud.TLSConfig.Certificates[i5].Leaf.RawSubjectPublicKeyInfo))
						copy(cp.Cloud.TLSConfig.Certificates[i5].Leaf.RawSubjectPublicKeyInfo, o.Cloud.TLSConfig.Certificates[i5].Leaf.RawSubjectPublicKeyInfo)
					}
					if o.Cloud.TLSConfig.Certificates[i5].Leaf.RawSubject != nil {
						cp.Cloud.TLSConfig.Certificates[i5].Leaf.RawSubject = make([]byte, len(o.Cloud.TLSConfig.Certificates[i5].Leaf.RawSubject))
						copy(cp.Cloud.TLSConfig.Certificates[i5].Leaf.RawSubject, o.Cloud.TLSConfig.Certificates[i5].Leaf.RawSubject)
					}
					if o.Cloud.TLSConfig.Certificates[i5].Leaf.RawIssuer != nil {
						cp.Cloud.TLSConfig.Certificates[i5].Leaf.RawIssuer = make([]byte, len(o.Cloud.TLSConfig.Certificates[i5].Leaf.RawIssuer))
						copy(cp.Cloud.TLSConfig.Certificates[i5].Leaf.RawIssuer, o.Cloud.TLSConfig.Certificates[i5].Leaf.RawIssuer)
					}
					if o.Cloud.TLSConfig.Certificates[i5].Leaf.Signature != nil {
						cp.Cloud.TLSConfig.Certificates[i5].Leaf.Signature = make([]byte, len(o.Cloud.TLSConfig.Certificates[i5].Leaf.Signature))
						copy(cp.Cloud.TLSConfig.Certificates[i5].Leaf.Signature, o.Cloud.TLSConfig.Certificates[i5].Leaf.Signature)
					}
					if o.Cloud.TLSConfig.Certificates[i5].Leaf.SerialNumber != nil {
						cp.Cloud.TLSConfig.Certificates[i5].Leaf.SerialNumber = new(big.Int)
						*cp.Cloud.TLSConfig.Certificates[i5].Leaf.SerialNumber = *o.Cloud.TLSConfig.Certificates[i5].Leaf.SerialNumber
					}
					if o.Cloud.TLSConfig.Certificates[i5].Leaf.Issuer.Country != nil {
						cp.Cloud.TLSConfig.Certificates[i5].Leaf.Issuer.Country = make([]string, len(o.Cloud.TLSConfig.Certificates[i5].Leaf.Issuer.Country))
						copy(cp.Cloud.TLSConfig.Certificates[i5].Leaf.Issuer.Country, o.Cloud.TLSConfig.Certificates[i5].Leaf.Issuer.Country)
					}
					if o.Cloud.TLSConfig.Certificates[i5].Leaf.Issuer.Organization != nil {
						cp.Cloud.TLSConfig.Certificates[i5].Leaf.Issuer.Organization = make([]string, len(o.Cloud.TLSConfig.Certificates[i5].Leaf.Issuer.Organization))
						copy(cp.Cloud.TLSConfig.Certificates[i5].Leaf.Issuer.Organization, o.Cloud.TLSConfig.Certificates[i5].Leaf.Issuer.Organization)
					}
					if o.Cloud.TLSConfig.Certificates[i5].Leaf.Issuer.OrganizationalUnit != nil {
						cp.Cloud.TLSConfig.Certificates[i5].Leaf.Issuer.OrganizationalUnit = make([]string, len(o.Cloud.TLSConfig.Certificates[i5].Leaf.Issuer.OrganizationalUnit))
						copy(cp.Cloud.TLSConfig.Certificates[i5].Leaf.Issuer.OrganizationalUnit, o.Cloud.TLSConfig.Certificates[i5].Leaf.Issuer.OrganizationalUnit)
					}
					if o.Cloud.TLSConfig.Certificates[i5].Leaf.Issuer.Locality != nil {
						cp.Cloud.TLSConfig.Certificates[i5].Leaf.Issuer.Locality = make([]string, len(o.Cloud.TLSConfig.Certificates[i5].Leaf.Issuer.Locality))
						copy(cp.Cloud.TLSConfig.Certificates[i5].Leaf.Issuer.Locality, o.Cloud.TLSConfig.Certificates[i5].Leaf.Issuer.Locality)
					}
					if o.Cloud.TLSConfig.Certificates[i5].Leaf.Issuer.Province != nil {
						cp.Cloud.TLSConfig.Certificates[i5].Leaf.Issuer.Province = make([]string, len(o.Cloud.TLSConfig.Certificates[i5].Leaf.Issuer.Province))
						copy(cp.Cloud.TLSConfig.Certificates[i5].Leaf.Issuer.Province, o.Cloud.TLSConfig.Certificates[i5].Leaf.Issuer.Province)
					}
					if o.Cloud.TLSConfig.Certificates[i5].Leaf.Issuer.StreetAddress != nil {
						cp.Cloud.TLSConfig.Certificates[i5].Leaf.Issuer.StreetAddress = make([]string, len(o.Cloud.TLSConfig.Certificates[i5].Leaf.Issuer.StreetAddress))
						copy(cp.Cloud.TLSConfig.Certificates[i5].Leaf.Issuer.StreetAddress, o.Cloud.TLSConfig.Certificates[i5].Leaf.Issuer.StreetAddress)
					}
					if o.Cloud.TLSConfig.Certificates[i5].Leaf.Issuer.PostalCode != nil {
						cp.Cloud.TLSConfig.Certificates[i5].Leaf.Issuer.PostalCode = make([]string, len(o.Cloud.TLSConfig.Certificates[i5].Leaf.Issuer.PostalCode))
						copy(cp.Cloud.TLSConfig.Certificates[i5].Leaf.Issuer.PostalCode, o.Cloud.TLSConfig.Certificates[i5].Leaf.Issuer.PostalCode)
					}
					if o.Cloud.TLSConfig.Certificates[i5].Leaf.Issuer.Names != nil {
						cp.Cloud.TLSConfig.Certificates[i5].Leaf.Issuer.Names = make([]pkix.AttributeTypeAndValue, len(o.Cloud.TLSConfig.Certificates[i5].Leaf.Issuer.Names))
						copy(cp.Cloud.TLSConfig.Certificates[i5].Leaf.Issuer.Names, o.Cloud.TLSConfig.Certificates[i5].Leaf.Issuer.Names)
						for i10 := range o.Cloud.TLSConfig.Certificates[i5].Leaf.Issuer.Names {
							if o.Cloud.TLSConfig.Certificates[i5].Leaf.Issuer.Names[i10].Type != nil {
								cp.Cloud.TLSConfig.Certificates[i5].Leaf.Issuer.Names[i10].Type = make([]int, len(o.Cloud.TLSConfig.Certificates[i5].Leaf.Issuer.Names[i10].Type))
								copy(cp.Cloud.TLSConfig.Certificates[i5].Leaf.Issuer.Names[i10].Type, o.Cloud.TLSConfig.Certificates[i5].Leaf.Issuer.Names[i10].Type)
							}
						}
					}
					if o.Cloud.TLSConfig.Certificates[i5].Leaf.Issuer.ExtraNames != nil {
						cp.Cloud.TLSConfig.Certificates[i5].Leaf.Issuer.ExtraNames = make([]pkix.AttributeTypeAndValue, len(o.Cloud.TLSConfig.Certificates[i5].Leaf.Issuer.ExtraNames))
						copy(cp.Cloud.TLSConfig.Certificates[i5].Leaf.Issuer.ExtraNames, o.Cloud.TLSConfig.Certificates[i5].Leaf.Issuer.ExtraNames)
						for i10 := range o.Cloud.TLSConfig.Certificates[i5].Leaf.Issuer.ExtraNames {
							if o.Cloud.TLSConfig.Certificates[i5].Leaf.Issuer.ExtraNames[i10].Type != nil {
								cp.Cloud.TLSConfig.Certificates[i5].Leaf.Issuer.ExtraNames[i10].Type = make([]int, len(o.Cloud.TLSConfig.Certificates[i5].Leaf.Issuer.ExtraNames[i10].Type))
								copy(cp.Cloud.TLSConfig.Certificates[i5].Leaf.Issuer.ExtraNames[i10].Type, o.Cloud.TLSConfig.Certificates[i5].Leaf.Issuer.ExtraNames[i10].Type)
							}
						}
					}
					if o.Cloud.TLSConfig.Certificates[i5].Leaf.Subject.Country != nil {
						cp.Cloud.TLSConfig.Certificates[i5].Leaf.Subject.Country = make([]string, len(o.Cloud.TLSConfig.Certificates[i5].Leaf.Subject.Country))
						copy(cp.Cloud.TLSConfig.Certificates[i5].Leaf.Subject.Country, o.Cloud.TLSConfig.Certificates[i5].Leaf.Subject.Country)
					}
					if o.Cloud.TLSConfig.Certificates[i5].Leaf.Subject.Organization != nil {
						cp.Cloud.TLSConfig.Certificates[i5].Leaf.Subject.Organization = make([]string, len(o.Cloud.TLSConfig.Certificates[i5].Leaf.Subject.Organization))
						copy(cp.Cloud.TLSConfig.Certificates[i5].Leaf.Subject.Organization, o.Cloud.TLSConfig.Certificates[i5].Leaf.Subject.Organization)
					}
					if o.Cloud.TLSConfig.Certificates[i5].Leaf.Subject.OrganizationalUnit != nil {
						cp.Cloud.TLSConfig.Certificates[i5].Leaf.Subject.OrganizationalUnit = make([]string, len(o.Cloud.TLSConfig.Certificates[i5].Leaf.Subject.OrganizationalUnit))
						copy(cp.Cloud.TLSConfig.Certificates[i5].Leaf.Subject.OrganizationalUnit, o.Cloud.TLSConfig.Certificates[i5].Leaf.Subject.OrganizationalUnit)
					}
					if o.Cloud.TLSConfig.Certificates[i5].Leaf.Subject.Locality != nil {
						cp.Cloud.TLSConfig.Certificates[i5].Leaf.Subject.Locality = make([]string, len(o.Cloud.TLSConfig.Certificates[i5].Leaf.Subject.Locality))
						copy(cp.Cloud.TLSConfig.Certificates[i5].Leaf.Subject.Locality, o.Cloud.TLSConfig.Certificates[i5].Leaf.Subject.Locality)
					}
					if o.Cloud.TLSConfig.Certificates[i5].Leaf.Subject.Province != nil {
						cp.Cloud.TLSConfig.Certificates[i5].Leaf.Subject.Province = make([]string, len(o.Cloud.TLSConfig.Certificates[i5].Leaf.Subject.Province))
						copy(cp.Cloud.TLSConfig.Certificates[i5].Leaf.Subject.Province, o.Cloud.TLSConfig.Certificates[i5].Leaf.Subject.Province)
					}
					if o.Cloud.TLSConfig.Certificates[i5].Leaf.Subject.StreetAddress != nil {
						cp.Cloud.TLSConfig.Certificates[i5].Leaf.Subject.StreetAddress = make([]string, len(o.Cloud.TLSConfig.Certificates[i5].Leaf.Subject.StreetAddress))
						copy(cp.Cloud.TLSConfig.Certificates[i5].Leaf.Subject.StreetAddress, o.Cloud.TLSConfig.Certificates[i5].Leaf.Subject.StreetAddress)
					}
					if o.Cloud.TLSConfig.Certificates[i5].Leaf.Subject.PostalCode != nil {
						cp.Cloud.TLSConfig.Certificates[i5].Leaf.Subject.PostalCode = make([]string, len(o.Cloud.TLSConfig.Certificates[i5].Leaf.Subject.PostalCode))
						copy(cp.Cloud.TLSConfig.Certificates[i5].Leaf.Subject.PostalCode, o.Cloud.TLSConfig.Certificates[i5].Leaf.Subject.PostalCode)
					}
					if o.Cloud.TLSConfig.Certificates[i5].Leaf.Subject.Names != nil {
						cp.Cloud.TLSConfig.Certificates[i5].Leaf.Subject.Names = make([]pkix.AttributeTypeAndValue, len(o.Cloud.TLSConfig.Certificates[i5].Leaf.Subject.Names))
						copy(cp.Cloud.TLSConfig.Certificates[i5].Leaf.Subject.Names, o.Cloud.TLSConfig.Certificates[i5].Leaf.Subject.Names)
						for i10 := range o.Cloud.TLSConfig.Certificates[i5].Leaf.Subject.Names {
							if o.Cloud.TLSConfig.Certificates[i5].Leaf.Subject.Names[i10].Type != nil {
								cp.Cloud.TLSConfig.Certificates[i5].Leaf.Subject.Names[i10].Type = make([]int, len(o.Cloud.TLSConfig.Certificates[i5].Leaf.Subject.Names[i10].Type))
								copy(cp.Cloud.TLSConfig.Certificates[i5].Leaf.Subject.Names[i10].Type, o.Cloud.TLSConfig.Certificates[i5].Leaf.Subject.Names[i10].Type)
							}
						}
					}
					if o.Cloud.TLSConfig.Certificates[i5].Leaf.Subject.ExtraNames != nil {
						cp.Cloud.TLSConfig.Certificates[i5].Leaf.Subject.ExtraNames = make([]pkix.AttributeTypeAndValue, len(o.Cloud.TLSConfig.Certificates[i5].Leaf.Subject.ExtraNames))
						copy(cp.Cloud.TLSConfig.Certificates[i5].Leaf.Subject.ExtraNames, o.Cloud.TLSConfig.Certificates[i5].Leaf.Subject.ExtraNames)
						for i10 := range o.Cloud.TLSConfig.Certificates[i5].Leaf.Subject.ExtraNames {
							if o.Cloud.TLSConfig.Certificates[i5].Leaf.Subject.ExtraNames[i10].Type != nil {
								cp.Cloud.TLSConfig.Certificates[i5].Leaf.Subject.ExtraNames[i10].Type = make([]int, len(o.Cloud.TLSConfig.Certificates[i5].Leaf.Subject.ExtraNames[i10].Type))
								copy(cp.Cloud.TLSConfig.Certificates[i5].Leaf.Subject.ExtraNames[i10].Type, o.Cloud.TLSConfig.Certificates[i5].Leaf.Subject.ExtraNames[i10].Type)
							}
						}
					}
					if o.Cloud.TLSConfig.Certificates[i5].Leaf.Extensions != nil {
						cp.Cloud.TLSConfig.Certificates[i5].Leaf.Extensions = make([]pkix.Extension, len(o.Cloud.TLSConfig.Certificates[i5].Leaf.Extensions))
						copy(cp.Cloud.TLSConfig.Certificates[i5].Leaf.Extensions, o.Cloud.TLSConfig.Certificates[i5].Leaf.Extensions)
						for i9 := range o.Cloud.TLSConfig.Certificates[i5].Leaf.Extensions {
							if o.Cloud.TLSConfig.Certificates[i5].Leaf.Extensions[i9].Id != nil {
								cp.Cloud.TLSConfig.Certificates[i5].Leaf.Extensions[i9].Id = make([]int, len(o.Cloud.TLSConfig.Certificates[i5].Leaf.Extensions[i9].Id))
								copy(cp.Cloud.TLSConfig.Certificates[i5].Leaf.Extensions[i9].Id, o.Cloud.TLSConfig.Certificates[i5].Leaf.Extensions[i9].Id)
							}
							if o.Cloud.TLSConfig.Certificates[i5].Leaf.Extensions[i9].Value != nil {
								cp.Cloud.TLSConfig.Certificates[i5].Leaf.Extensions[i9].Value = make([]byte, len(o.Cloud.TLSConfig.Certificates[i5].Leaf.Extensions[i9].Value))
								copy(cp.Cloud.TLSConfig.Certificates[i5].Leaf.Extensions[i9].Value, o.Cloud.TLSConfig.Certificates[i5].Leaf.Extensions[i9].Value)
							}
						}
					}
					if o.Cloud.TLSConfig.Certificates[i5].Leaf.ExtraExtensions != nil {
						cp.Cloud.TLSConfig.Certificates[i5].Leaf.ExtraExtensions = make([]pkix.Extension, len(o.Cloud.TLSConfig.Certificates[i5].Leaf.ExtraExtensions))
						copy(cp.Cloud.TLSConfig.Certificates[i5].Leaf.ExtraExtensions, o.Cloud.TLSConfig.Certificates[i5].Leaf.ExtraExtensions)
						for i9 := range o.Cloud.TLSConfig.Certificates[i5].Leaf.ExtraExtensions {
							if o.Cloud.TLSConfig.Certificates[i5].Leaf.ExtraExtensions[i9].Id != nil {
								cp.Cloud.TLSConfig.Certificates[i5].Leaf.ExtraExtensions[i9].Id = make([]int, len(o.Cloud.TLSConfig.Certificates[i5].Leaf.ExtraExtensions[i9].Id))
								copy(cp.Cloud.TLSConfig.Certificates[i5].Leaf.ExtraExtensions[i9].Id, o.Cloud.TLSConfig.Certificates[i5].Leaf.ExtraExtensions[i9].Id)
							}
							if o.Cloud.TLSConfig.Certificates[i5].Leaf.ExtraExtensions[i9].Value != nil {
								cp.Cloud.TLSConfig.Certificates[i5].Leaf.ExtraExtensions[i9].Value = make([]byte, len(o.Cloud.TLSConfig.Certificates[i5].Leaf.ExtraExtensions[i9].Value))
								copy(cp.Cloud.TLSConfig.Certificates[i5].Leaf.ExtraExtensions[i9].Value, o.Cloud.TLSConfig.Certificates[i5].Leaf.ExtraExtensions[i9].Value)
							}
						}
					}
					if o.Cloud.TLSConfig.Certificates[i5].Leaf.UnhandledCriticalExtensions != nil {
						cp.Cloud.TLSConfig.Certificates[i5].Leaf.UnhandledCriticalExtensions = make([]asn1.ObjectIdentifier, len(o.Cloud.TLSConfig.Certificates[i5].Leaf.UnhandledCriticalExtensions))
						copy(cp.Cloud.TLSConfig.Certificates[i5].Leaf.UnhandledCriticalExtensions, o.Cloud.TLSConfig.Certificates[i5].Leaf.UnhandledCriticalExtensions)
						for i9 := range o.Cloud.TLSConfig.Certificates[i5].Leaf.UnhandledCriticalExtensions {
							if o.Cloud.TLSConfig.Certificates[i5].Leaf.UnhandledCriticalExtensions[i9] != nil {
								cp.Cloud.TLSConfig.Certificates[i5].Leaf.UnhandledCriticalExtensions[i9] = make([]int, len(o.Cloud.TLSConfig.Certificates[i5].Leaf.UnhandledCriticalExtensions[i9]))
								copy(cp.Cloud.TLSConfig.Certificates[i5].Leaf.UnhandledCriticalExtensions[i9], o.Cloud.TLSConfig.Certificates[i5].Leaf.UnhandledCriticalExtensions[i9])
							}
						}
					}
					if o.Cloud.TLSConfig.Certificates[i5].Leaf.ExtKeyUsage != nil {
						cp.Cloud.TLSConfig.Certificates[i5].Leaf.ExtKeyUsage = make([]x509.ExtKeyUsage, len(o.Cloud.TLSConfig.Certificates[i5].Leaf.ExtKeyUsage))
						copy(cp.Cloud.TLSConfig.Certificates[i5].Leaf.ExtKeyUsage, o.Cloud.TLSConfig.Certificates[i5].Leaf.ExtKeyUsage)
					}
					if o.Cloud.TLSConfig.Certificates[i5].Leaf.UnknownExtKeyUsage != nil {
						cp.Cloud.TLSConfig.Certificates[i5].Leaf.UnknownExtKeyUsage = make([]asn1.ObjectIdentifier, len(o.Cloud.TLSConfig.Certificates[i5].Leaf.UnknownExtKeyUsage))
						copy(cp.Cloud.TLSConfig.Certificates[i5].Leaf.UnknownExtKeyUsage, o.Cloud.TLSConfig.Certificates[i5].Leaf.UnknownExtKeyUsage)
						for i9 := range o.Cloud.TLSConfig.Certificates[i5].Leaf.UnknownExtKeyUsage {
							if o.Cloud.TLSConfig.Certificates[i5].Leaf.UnknownExtKeyUsage[i9] != nil {
								cp.Cloud.TLSConfig.Certificates[i5].Leaf.UnknownExtKeyUsage[i9] = make([]int, len(o.Cloud.TLSConfig.Certificates[i5].Leaf.UnknownExtKeyUsage[i9]))
								copy(cp.Cloud.TLSConfig.Certificates[i5].Leaf.UnknownExtKeyUsage[i9], o.Cloud.TLSConfig.Certificates[i5].Leaf.UnknownExtKeyUsage[i9])
							}
						}
					}
					if o.Cloud.TLSConfig.Certificates[i5].Leaf.SubjectKeyId != nil {
						cp.Cloud.TLSConfig.Certificates[i5].Leaf.SubjectKeyId = make([]byte, len(o.Cloud.TLSConfig.Certificates[i5].Leaf.SubjectKeyId))
						copy(cp.Cloud.TLSConfig.Certificates[i5].Leaf.SubjectKeyId, o.Cloud.TLSConfig.Certificates[i5].Leaf.SubjectKeyId)
					}
					if o.Cloud.TLSConfig.Certificates[i5].Leaf.AuthorityKeyId != nil {
						cp.Cloud.TLSConfig.Certificates[i5].Leaf.AuthorityKeyId = make([]byte, len(o.Cloud.TLSConfig.Certificates[i5].Leaf.AuthorityKeyId))
						copy(cp.Cloud.TLSConfig.Certificates[i5].Leaf.AuthorityKeyId, o.Cloud.TLSConfig.Certificates[i5].Leaf.AuthorityKeyId)
					}
					if o.Cloud.TLSConfig.Certificates[i5].Leaf.OCSPServer != nil {
						cp.Cloud.TLSConfig.Certificates[i5].Leaf.OCSPServer = make([]string, len(o.Cloud.TLSConfig.Certificates[i5].Leaf.OCSPServer))
						copy(cp.Cloud.TLSConfig.Certificates[i5].Leaf.OCSPServer, o.Cloud.TLSConfig.Certificates[i5].Leaf.OCSPServer)
					}
					if o.Cloud.TLSConfig.Certificates[i5].Leaf.IssuingCertificateURL != nil {
						cp.Cloud.TLSConfig.Certificates[i5].Leaf.IssuingCertificateURL = make([]string, len(o.Cloud.TLSConfig.Certificates[i5].Leaf.IssuingCertificateURL))
						copy(cp.Cloud.TLSConfig.Certificates[i5].Leaf.IssuingCertificateURL, o.Cloud.TLSConfig.Certificates[i5].Leaf.IssuingCertificateURL)
					}
					if o.Cloud.TLSConfig.Certificates[i5].Leaf.DNSNames != nil {
						cp.Cloud.TLSConfig.Certificates[i5].Leaf.DNSNames = make([]string, len(o.Cloud.TLSConfig.Certificates[i5].Leaf.DNSNames))
						copy(cp.Cloud.TLSConfig.Certificates[i5].Leaf.DNSNames, o.Cloud.TLSConfig.Certificates[i5].Leaf.DNSNames)
					}
					if o.Cloud.TLSConfig.Certificates[i5].Leaf.EmailAddresses != nil {
						cp.Cloud.TLSConfig.Certificates[i5].Leaf.EmailAddresses = make([]string, len(o.Cloud.TLSConfig.Certificates[i5].Leaf.EmailAddresses))
						copy(cp.Cloud.TLSConfig.Certificates[i5].Leaf.EmailAddresses, o.Cloud.TLSConfig.Certificates[i5].Leaf.EmailAddresses)
					}
					if o.Cloud.TLSConfig.Certificates[i5].Leaf.IPAddresses != nil {
						cp.Cloud.TLSConfig.Certificates[i5].Leaf.IPAddresses = make([]net.IP, len(o.Cloud.TLSConfig.Certificates[i5].Leaf.IPAddresses))
						copy(cp.Cloud.TLSConfig.Certificates[i5].Leaf.IPAddresses, o.Cloud.TLSConfig.Certificates[i5].Leaf.IPAddresses)
						for i9 := range o.Cloud.TLSConfig.Certificates[i5].Leaf.IPAddresses {
							if o.Cloud.TLSConfig.Certificates[i5].Leaf.IPAddresses[i9] != nil {
								cp.Cloud.TLSConfig.Certificates[i5].Leaf.IPAddresses[i9] = make([]byte, len(o.Cloud.TLSConfig.Certificates[i5].Leaf.IPAddresses[i9]))
								copy(cp.Cloud.TLSConfig.Certificates[i5].Leaf.IPAddresses[i9], o.Cloud.TLSConfig.Certificates[i5].Leaf.IPAddresses[i9])
							}
						}
					}
					if o.Cloud.TLSConfig.Certificates[i5].Leaf.URIs != nil {
						cp.Cloud.TLSConfig.Certificates[i5].Leaf.URIs = make([]*url.URL, len(o.Cloud.TLSConfig.Certificates[i5].Leaf.URIs))
						copy(cp.Cloud.TLSConfig.Certificates[i5].Leaf.URIs, o.Cloud.TLSConfig.Certificates[i5].Leaf.URIs)
						for i9 := range o.Cloud.TLSConfig.Certificates[i5].Leaf.URIs {
							if o.Cloud.TLSConfig.Certificates[i5].Leaf.URIs[i9] != nil {
								cp.Cloud.TLSConfig.Certificates[i5].Leaf.URIs[i9] = new(url.URL)
								*cp.Cloud.TLSConfig.Certificates[i5].Leaf.URIs[i9] = *o.Cloud.TLSConfig.Certificates[i5].Leaf.URIs[i9]
								if o.Cloud.TLSConfig.Certificates[i5].Leaf.URIs[i9].User != nil {
									cp.Cloud.TLSConfig.Certificates[i5].Leaf.URIs[i9].User = new(url.Userinfo)
									*cp.Cloud.TLSConfig.Certificates[i5].Leaf.URIs[i9].User = *o.Cloud.TLSConfig.Certificates[i5].Leaf.URIs[i9].User
								}
							}
						}
					}
					if o.Cloud.TLSConfig.Certificates[i5].Leaf.PermittedDNSDomains != nil {
						cp.Cloud.TLSConfig.Certificates[i5].Leaf.PermittedDNSDomains = make([]string, len(o.Cloud.TLSConfig.Certificates[i5].Leaf.PermittedDNSDomains))
						copy(cp.Cloud.TLSConfig.Certificates[i5].Leaf.PermittedDNSDomains, o.Cloud.TLSConfig.Certificates[i5].Leaf.PermittedDNSDomains)
					}
					if o.Cloud.TLSConfig.Certificates[i5].Leaf.ExcludedDNSDomains != nil {
						cp.Cloud.TLSConfig.Certificates[i5].Leaf.ExcludedDNSDomains = make([]string, len(o.Cloud.TLSConfig.Certificates[i5].Leaf.ExcludedDNSDomains))
						copy(cp.Cloud.TLSConfig.Certificates[i5].Leaf.ExcludedDNSDomains, o.Cloud.TLSConfig.Certificates[i5].Leaf.ExcludedDNSDomains)
					}
					if o.Cloud.TLSConfig.Certificates[i5].Leaf.PermittedIPRanges != nil {
						cp.Cloud.TLSConfig.Certificates[i5].Leaf.PermittedIPRanges = make([]*net.IPNet, len(o.Cloud.TLSConfig.Certificates[i5].Leaf.PermittedIPRanges))
						copy(cp.Cloud.TLSConfig.Certificates[i5].Leaf.PermittedIPRanges, o.Cloud.TLSConfig.Certificates[i5].Leaf.PermittedIPRanges)
						for i9 := range o.Cloud.TLSConfig.Certificates[i5].Leaf.PermittedIPRanges {
							if o.Cloud.TLSConfig.Certificates[i5].Leaf.PermittedIPRanges[i9] != nil {
								cp.Cloud.TLSConfig.Certificates[i5].Leaf.PermittedIPRanges[i9] = new(net.IPNet)
								*cp.Cloud.TLSConfig.Certificates[i5].Leaf.PermittedIPRanges[i9] = *o.Cloud.TLSConfig.Certificates[i5].Leaf.PermittedIPRanges[i9]
								if o.Cloud.TLSConfig.Certificates[i5].Leaf.PermittedIPRanges[i9].IP != nil {
									cp.Cloud.TLSConfig.Certificates[i5].Leaf.PermittedIPRanges[i9].IP = make([]byte, len(o.Cloud.TLSConfig.Certificates[i5].Leaf.PermittedIPRanges[i9].IP))
									copy(cp.Cloud.TLSConfig.Certificates[i5].Leaf.PermittedIPRanges[i9].IP, o.Cloud.TLSConfig.Certificates[i5].Leaf.PermittedIPRanges[i9].IP)
								}
								if o.Cloud.TLSConfig.Certificates[i5].Leaf.PermittedIPRanges[i9].Mask != nil {
									cp.Cloud.TLSConfig.Certificates[i5].Leaf.PermittedIPRanges[i9].Mask = make([]byte, len(o.Cloud.TLSConfig.Certificates[i5].Leaf.PermittedIPRanges[i9].Mask))
									copy(cp.Cloud.TLSConfig.Certificates[i5].Leaf.PermittedIPRanges[i9].Mask, o.Cloud.TLSConfig.Certificates[i5].Leaf.PermittedIPRanges[i9].Mask)
								}
							}
						}
					}
					if o.Cloud.TLSConfig.Certificates[i5].Leaf.ExcludedIPRanges != nil {
						cp.Cloud.TLSConfig.Certificates[i5].Leaf.ExcludedIPRanges = make([]*net.IPNet, len(o.Cloud.TLSConfig.Certificates[i5].Leaf.ExcludedIPRanges))
						copy(cp.Cloud.TLSConfig.Certificates[i5].Leaf.ExcludedIPRanges, o.Cloud.TLSConfig.Certificates[i5].Leaf.ExcludedIPRanges)
						for i9 := range o.Cloud.TLSConfig.Certificates[i5].Leaf.ExcludedIPRanges {
							if o.Cloud.TLSConfig.Certificates[i5].Leaf.ExcludedIPRanges[i9] != nil {
								cp.Cloud.TLSConfig.Certificates[i5].Leaf.ExcludedIPRanges[i9] = new(net.IPNet)
								*cp.Cloud.TLSConfig.Certificates[i5].Leaf.ExcludedIPRanges[i9] = *o.Cloud.TLSConfig.Certificates[i5].Leaf.ExcludedIPRanges[i9]
								if o.Cloud.TLSConfig.Certificates[i5].Leaf.ExcludedIPRanges[i9].IP != nil {
									cp.Cloud.TLSConfig.Certificates[i5].Leaf.ExcludedIPRanges[i9].IP = make([]byte, len(o.Cloud.TLSConfig.Certificates[i5].Leaf.ExcludedIPRanges[i9].IP))
									copy(cp.Cloud.TLSConfig.Certificates[i5].Leaf.ExcludedIPRanges[i9].IP, o.Cloud.TLSConfig.Certificates[i5].Leaf.ExcludedIPRanges[i9].IP)
								}
								if o.Cloud.TLSConfig.Certificates[i5].Leaf.ExcludedIPRanges[i9].Mask != nil {
									cp.Cloud.TLSConfig.Certificates[i5].Leaf.ExcludedIPRanges[i9].Mask = make([]byte, len(o.Cloud.TLSConfig.Certificates[i5].Leaf.ExcludedIPRanges[i9].Mask))
									copy(cp.Cloud.TLSConfig.Certificates[i5].Leaf.ExcludedIPRanges[i9].Mask, o.Cloud.TLSConfig.Certificates[i5].Leaf.ExcludedIPRanges[i9].Mask)
								}
							}
						}
					}
					if o.Cloud.TLSConfig.Certificates[i5].Leaf.PermittedEmailAddresses != nil {
						cp.Cloud.TLSConfig.Certificates[i5].Leaf.PermittedEmailAddresses = make([]string, len(o.Cloud.TLSConfig.Certificates[i5].Leaf.PermittedEmailAddresses))
						copy(cp.Cloud.TLSConfig.Certificates[i5].Leaf.PermittedEmailAddresses, o.Cloud.TLSConfig.Certificates[i5].Leaf.PermittedEmailAddresses)
					}
					if o.Cloud.TLSConfig.Certificates[i5].Leaf.ExcludedEmailAddresses != nil {
						cp.Cloud.TLSConfig.Certificates[i5].Leaf.ExcludedEmailAddresses = make([]string, len(o.Cloud.TLSConfig.Certificates[i5].Leaf.ExcludedEmailAddresses))
						copy(cp.Cloud.TLSConfig.Certificates[i5].Leaf.ExcludedEmailAddresses, o.Cloud.TLSConfig.Certificates[i5].Leaf.ExcludedEmailAddresses)
					}
					if o.Cloud.TLSConfig.Certificates[i5].Leaf.PermittedURIDomains != nil {
						cp.Cloud.TLSConfig.Certificates[i5].Leaf.PermittedURIDomains = make([]string, len(o.Cloud.TLSConfig.Certificates[i5].Leaf.PermittedURIDomains))
						copy(cp.Cloud.TLSConfig.Certificates[i5].Leaf.PermittedURIDomains, o.Cloud.TLSConfig.Certificates[i5].Leaf.PermittedURIDomains)
					}
					if o.Cloud.TLSConfig.Certificates[i5].Leaf.ExcludedURIDomains != nil {
						cp.Cloud.TLSConfig.Certificates[i5].Leaf.ExcludedURIDomains = make([]string, len(o.Cloud.TLSConfig.Certificates[i5].Leaf.ExcludedURIDomains))
						copy(cp.Cloud.TLSConfig.Certificates[i5].Leaf.ExcludedURIDomains, o.Cloud.TLSConfig.Certificates[i5].Leaf.ExcludedURIDomains)
					}
					if o.Cloud.TLSConfig.Certificates[i5].Leaf.CRLDistributionPoints != nil {
						cp.Cloud.TLSConfig.Certificates[i5].Leaf.CRLDistributionPoints = make([]string, len(o.Cloud.TLSConfig.Certificates[i5].Leaf.CRLDistributionPoints))
						copy(cp.Cloud.TLSConfig.Certificates[i5].Leaf.CRLDistributionPoints, o.Cloud.TLSConfig.Certificates[i5].Leaf.CRLDistributionPoints)
					}
					if o.Cloud.TLSConfig.Certificates[i5].Leaf.PolicyIdentifiers != nil {
						cp.Cloud.TLSConfig.Certificates[i5].Leaf.PolicyIdentifiers = make([]asn1.ObjectIdentifier, len(o.Cloud.TLSConfig.Certificates[i5].Leaf.PolicyIdentifiers))
						copy(cp.Cloud.TLSConfig.Certificates[i5].Leaf.PolicyIdentifiers, o.Cloud.TLSConfig.Certificates[i5].Leaf.PolicyIdentifiers)
						for i9 := range o.Cloud.TLSConfig.Certificates[i5].Leaf.PolicyIdentifiers {
							if o.Cloud.TLSConfig.Certificates[i5].Leaf.PolicyIdentifiers[i9] != nil {
								cp.Cloud.TLSConfig.Certificates[i5].Leaf.PolicyIdentifiers[i9] = make([]int, len(o.Cloud.TLSConfig.Certificates[i5].Leaf.PolicyIdentifiers[i9]))
								copy(cp.Cloud.TLSConfig.Certificates[i5].Leaf.PolicyIdentifiers[i9], o.Cloud.TLSConfig.Certificates[i5].Leaf.PolicyIdentifiers[i9])
							}
						}
					}
					if o.Cloud.TLSConfig.Certificates[i5].Leaf.Policies != nil {
						cp.Cloud.TLSConfig.Certificates[i5].Leaf.Policies = make([]x509.OID, len(o.Cloud.TLSConfig.Certificates[i5].Leaf.Policies))
						copy(cp.Cloud.TLSConfig.Certificates[i5].Leaf.Policies, o.Cloud.TLSConfig.Certificates[i5].Leaf.Policies)
					}
				}
			}
		}
		if o.Cloud.TLSConfig.NameToCertificate != nil {
			cp.Cloud.TLSConfig.NameToCertificate = make(map[string]*tls.Certificate, len(o.Cloud.TLSConfig.NameToCertificate))
			for k5, v5 := range o.Cloud.TLSConfig.NameToCertificate {
				var cp_Cloud_TLSConfig_NameToCertificate_v5 *tls.Certificate
				if v5 != nil {
					cp_Cloud_TLSConfig_NameToCertificate_v5 = new(tls.Certificate)
					*cp_Cloud_TLSConfig_NameToCertificate_v5 = *v5
					if v5.Certificate != nil {
						cp_Cloud_TLSConfig_NameToCertificate_v5.Certificate = make([][]byte, len(v5.Certificate))
						copy(cp_Cloud_TLSConfig_NameToCertificate_v5.Certificate, v5.Certificate)
						for i8 := range v5.Certificate {
							if v5.Certificate[i8] != nil {
								cp_Cloud_TLSConfig_NameToCertificate_v5.Certificate[i8] = make([]byte, len(v5.Certificate[i8]))
								copy(cp_Cloud_TLSConfig_NameToCertificate_v5.Certificate[i8], v5.Certificate[i8])
							}
						}
					}
					if v5.SupportedSignatureAlgorithms != nil {
						cp_Cloud_TLSConfig_NameToCertificate_v5.SupportedSignatureAlgorithms = make([]tls.SignatureScheme, len(v5.SupportedSignatureAlgorithms))
						copy(cp_Cloud_TLSConfig_NameToCertificate_v5.SupportedSignatureAlgorithms, v5.SupportedSignatureAlgorithms)
					}
					if v5.OCSPStaple != nil {
						cp_Cloud_TLSConfig_NameToCertificate_v5.OCSPStaple = make([]byte, len(v5.OCSPStaple))
						copy(cp_Cloud_TLSConfig_NameToCertificate_v5.OCSPStaple, v5.OCSPStaple)
					}
					if v5.SignedCertificateTimestamps != nil {
						cp_Cloud_TLSConfig_NameToCertificate_v5.SignedCertificateTimestamps = make([][]byte, len(v5.SignedCertificateTimestamps))
						copy(cp_Cloud_TLSConfig_NameToCertificate_v5.SignedCertificateTimestamps, v5.SignedCertificateTimestamps)
						for i8 := range v5.SignedCertificateTimestamps {
							if v5.SignedCertificateTimestamps[i8] != nil {
								cp_Cloud_TLSConfig_NameToCertificate_v5.SignedCertificateTimestamps[i8] = make([]byte, len(v5.SignedCertificateTimestamps[i8]))
								copy(cp_Cloud_TLSConfig_NameToCertificate_v5.SignedCertificateTimestamps[i8], v5.SignedCertificateTimestamps[i8])
							}
						}
					}
					if v5.Leaf != nil {
						cp_Cloud_TLSConfig_NameToCertificate_v5.Leaf = new(x509.Certificate)
						*cp_Cloud_TLSConfig_NameToCertificate_v5.Leaf = *v5.Leaf
						if v5.Leaf.Raw != nil {
							cp_Cloud_TLSConfig_NameToCertificate_v5.Leaf.Raw = make([]byte, len(v5.Leaf.Raw))
							copy(cp_Cloud_TLSConfig_NameToCertificate_v5.Leaf.Raw, v5.Leaf.Raw)
						}
						if v5.Leaf.RawTBSCertificate != nil {
							cp_Cloud_TLSConfig_NameToCertificate_v5.Leaf.RawTBSCertificate = make([]byte, len(v5.Leaf.RawTBSCertificate))
							copy(cp_Cloud_TLSConfig_NameToCertificate_v5.Leaf.RawTBSCertificate, v5.Leaf.RawTBSCertificate)
						}
						if v5.Leaf.RawSubjectPublicKeyInfo != nil {
							cp_Cloud_TLSConfig_NameToCertificate_v5.Leaf.RawSubjectPublicKeyInfo = make([]byte, len(v5.Leaf.RawSubjectPublicKeyInfo))
							copy(cp_Cloud_TLSConfig_NameToCertificate_v5.Leaf.RawSubjectPublicKeyInfo, v5.Leaf.RawSubjectPublicKeyInfo)
						}
						if v5.Leaf.RawSubject != nil {
							cp_Cloud_TLSConfig_NameToCertificate_v5.Leaf.RawSubject = make([]byte, len(v5.Leaf.RawSubject))
							copy(cp_Cloud_TLSConfig_NameToCertificate_v5.Leaf.RawSubject, v5.Leaf.RawSubject)
						}
						if v5.Leaf.RawIssuer != nil {
							cp_Cloud_TLSConfig_NameToCertificate_v5.Leaf.RawIssuer = make([]byte, len(v5.Leaf.RawIssuer))
							copy(cp_Cloud_TLSConfig_NameToCertificate_v5.Leaf.RawIssuer, v5.Leaf.RawIssuer)
						}
						if v5.Leaf.Signature != nil {
							cp_Cloud_TLSConfig_NameToCertificate_v5.Leaf.Signature = make([]byte, len(v5.Leaf.Signature))
							copy(cp_Cloud_TLSConfig_NameToCertificate_v5.Leaf.Signature, v5.Leaf.Signature)
						}
						if v5.Leaf.SerialNumber != nil {
							cp_Cloud_TLSConfig_NameToCertificate_v5.Leaf.SerialNumber = new(big.Int)
							*cp_Cloud_TLSConfig_NameToCertificate_v5.Leaf.SerialNumber = *v5.Leaf.SerialNumber
						}
						if v5.Leaf.Issuer.Country != nil {
							cp_Cloud_TLSConfig_NameToCertificate_v5.Leaf.Issuer.Country = make([]string, len(v5.Leaf.Issuer.Country))
							copy(cp_Cloud_TLSConfig_NameToCertificate_v5.Leaf.Issuer.Country, v5.Leaf.Issuer.Country)
						}
						if v5.Leaf.Issuer.Organization != nil {
							cp_Cloud_TLSConfig_NameToCertificate_v5.Leaf.Issuer.Organization = make([]string, len(v5.Leaf.Issuer.Organization))
							copy(cp_Cloud_TLSConfig_NameToCertificate_v5.Leaf.Issuer.Organization, v5.Leaf.Issuer.Organization)
						}
						if v5.Leaf.Issuer.OrganizationalUnit != nil {
							cp_Cloud_TLSConfig_NameToCertificate_v5.Leaf.Issuer.OrganizationalUnit = make([]string, len(v5.Leaf.Issuer.OrganizationalUnit))
							copy(cp_Cloud_TLSConfig_NameToCertificate_v5.Leaf.Issuer.OrganizationalUnit, v5.Leaf.Issuer.OrganizationalUnit)
						}
						if v5.Leaf.Issuer.Locality != nil {
							cp_Cloud_TLSConfig_NameToCertificate_v5.Leaf.Issuer.Locality = make([]string, len(v5.Leaf.Issuer.Locality))
							copy(cp_Cloud_TLSConfig_NameToCertificate_v5.Leaf.Issuer.Locality, v5.Leaf.Issuer.Locality)
						}
						if v5.Leaf.Issuer.Province != nil {
							cp_Cloud_TLSConfig_NameToCertificate_v5.Leaf.Issuer.Province = make([]string, len(v5.Leaf.Issuer.Province))
							copy(cp_Cloud_TLSConfig_NameToCertificate_v5.Leaf.Issuer.Province, v5.Leaf.Issuer.Province)
						}
						if v5.Leaf.Issuer.StreetAddress != nil {
							cp_Cloud_TLSConfig_NameToCertificate_v5.Leaf.Issuer.StreetAddress = make([]string, len(v5.Leaf.Issuer.StreetAddress))
							copy(cp_Cloud_TLSConfig_NameToCertificate_v5.Leaf.Issuer.StreetAddress, v5.Leaf.Issuer.StreetAddress)
						}
						if v5.Leaf.Issuer.PostalCode != nil {
							cp_Cloud_TLSConfig_NameToCertificate_v5.Leaf.Issuer.PostalCode = make([]string, len(v5.Leaf.Issuer.PostalCode))
							copy(cp_Cloud_TLSConfig_NameToCertificate_v5.Leaf.Issuer.PostalCode, v5.Leaf.Issuer.PostalCode)
						}
						if v5.Leaf.Issuer.Names != nil {
							cp_Cloud_TLSConfig_NameToCertificate_v5.Leaf.Issuer.Names = make([]pkix.AttributeTypeAndValue, len(v5.Leaf.Issuer.Names))
							copy(cp_Cloud_TLSConfig_NameToCertificate_v5.Leaf.Issuer.Names, v5.Leaf.Issuer.Names)
							for i11 := range v5.Leaf.Issuer.Names {
								if v5.Leaf.Issuer.Names[i11].Type != nil {
									cp_Cloud_TLSConfig_NameToCertificate_v5.Leaf.Issuer.Names[i11].Type = make([]int, len(v5.Leaf.Issuer.Names[i11].Type))
									copy(cp_Cloud_TLSConfig_NameToCertificate_v5.Leaf.Issuer.Names[i11].Type, v5.Leaf.Issuer.Names[i11].Type)
								}
							}
						}
						if v5.Leaf.Issuer.ExtraNames != nil {
							cp_Cloud_TLSConfig_NameToCertificate_v5.Leaf.Issuer.ExtraNames = make([]pkix.AttributeTypeAndValue, len(v5.Leaf.Issuer.ExtraNames))
							copy(cp_Cloud_TLSConfig_NameToCertificate_v5.Leaf.Issuer.ExtraNames, v5.Leaf.Issuer.ExtraNames)
							for i11 := range v5.Leaf.Issuer.ExtraNames {
								if v5.Leaf.Issuer.ExtraNames[i11].Type != nil {
									cp_Cloud_TLSConfig_NameToCertificate_v5.Leaf.Issuer.ExtraNames[i11].Type = make([]int, len(v5.Leaf.Issuer.ExtraNames[i11].Type))
									copy(cp_Cloud_TLSConfig_NameToCertificate_v5.Leaf.Issuer.ExtraNames[i11].Type, v5.Leaf.Issuer.ExtraNames[i11].Type)
								}
							}
						}
						if v5.Leaf.Subject.Country != nil {
							cp_Cloud_TLSConfig_NameToCertificate_v5.Leaf.Subject.Country = make([]string, len(v5.Leaf.Subject.Country))
							copy(cp_Cloud_TLSConfig_NameToCertificate_v5.Leaf.Subject.Country, v5.Leaf.Subject.Country)
						}
						if v5.Leaf.Subject.Organization != nil {
							cp_Cloud_TLSConfig_NameToCertificate_v5.Leaf.Subject.Organization = make([]string, len(v5.Leaf.Subject.Organization))
							copy(cp_Cloud_TLSConfig_NameToCertificate_v5.Leaf.Subject.Organization, v5.Leaf.Subject.Organization)
						}
						if v5.Leaf.Subject.OrganizationalUnit != nil {
							cp_Cloud_TLSConfig_NameToCertificate_v5.Leaf.Subject.OrganizationalUnit = make([]string, len(v5.Leaf.Subject.OrganizationalUnit))
							copy(cp_Cloud_TLSConfig_NameToCertificate_v5.Leaf.Subject.OrganizationalUnit, v5.Leaf.Subject.OrganizationalUnit)
						}
						if v5.Leaf.Subject.Locality != nil {
							cp_Cloud_TLSConfig_NameToCertificate_v5.Leaf.Subject.Locality = make([]string, len(v5.Leaf.Subject.Locality))
							copy(cp_Cloud_TLSConfig_NameToCertificate_v5.Leaf.Subject.Locality, v5.Leaf.Subject.Locality)
						}
						if v5.Leaf.Subject.Province != nil {
							cp_Cloud_TLSConfig_NameToCertificate_v5.Leaf.Subject.Province = make([]string, len(v5.Leaf.Subject.Province))
							copy(cp_Cloud_TLSConfig_NameToCertificate_v5.Leaf.Subject.Province, v5.Leaf.Subject.Province)
						}
						if v5.Leaf.Subject.StreetAddress != nil {
							cp_Cloud_TLSConfig_NameToCertificate_v5.Leaf.Subject.StreetAddress = make([]string, len(v5.Leaf.Subject.StreetAddress))
							copy(cp_Cloud_TLSConfig_NameToCertificate_v5.Leaf.Subject.StreetAddress, v5.Leaf.Subject.StreetAddress)
						}
						if v5.Leaf.Subject.PostalCode != nil {
							cp_Cloud_TLSConfig_NameToCertificate_v5.Leaf.Subject.PostalCode = make([]string, len(v5.Leaf.Subject.PostalCode))
							copy(cp_Cloud_TLSConfig_NameToCertificate_v5.Leaf.Subject.PostalCode, v5.Leaf.Subject.PostalCode)
						}
						if v5.Leaf.Subject.Names != nil {
							cp_Cloud_TLSConfig_NameToCertificate_v5.Leaf.Subject.Names = make([]pkix.AttributeTypeAndValue, len(v5.Leaf.Subject.Names))
							copy(cp_Cloud_TLSConfig_NameToCertificate_v5.Leaf.Subject.Names, v5.Leaf.Subject.Names)
							for i11 := range v5.Leaf.Subject.Names {
								if v5.Leaf.Subject.Names[i11].Type != nil {
									cp_Cloud_TLSConfig_NameToCertificate_v5.Leaf.Subject.Names[i11].Type = make([]int, len(v5.Leaf.Subject.Names[i11].Type))
									copy(cp_Cloud_TLSConfig_NameToCertificate_v5.Leaf.Subject.Names[i11].Type, v5.Leaf.Subject.Names[i11].Type)
								}
							}
						}
						if v5.Leaf.Subject.ExtraNames != nil {
							cp_Cloud_TLSConfig_NameToCertificate_v5.Leaf.Subject.ExtraNames = make([]pkix.AttributeTypeAndValue, len(v5.Leaf.Subject.ExtraNames))
							copy(cp_Cloud_TLSConfig_NameToCertificate_v5.Leaf.Subject.ExtraNames, v5.Leaf.Subject.ExtraNames)
							for i11 := range v5.Leaf.Subject.ExtraNames {
								if v5.Leaf.Subject.ExtraNames[i11].Type != nil {
									cp_Cloud_TLSConfig_NameToCertificate_v5.Leaf.Subject.ExtraNames[i11].Type = make([]int, len(v5.Leaf.Subject.ExtraNames[i11].Type))
									copy(cp_Cloud_TLSConfig_NameToCertificate_v5.Leaf.Subject.ExtraNames[i11].Type, v5.Leaf.Subject.ExtraNames[i11].Type)
								}
							}
						}
						if v5.Leaf.Extensions != nil {
							cp_Cloud_TLSConfig_NameToCertificate_v5.Leaf.Extensions = make([]pkix.Extension, len(v5.Leaf.Extensions))
							copy(cp_Cloud_TLSConfig_NameToCertificate_v5.Leaf.Extensions, v5.Leaf.Extensions)
							for i10 := range v5.Leaf.Extensions {
								if v5.Leaf.Extensions[i10].Id != nil {
									cp_Cloud_TLSConfig_NameToCertificate_v5.Leaf.Extensions[i10].Id = make([]int, len(v5.Leaf.Extensions[i10].Id))
									copy(cp_Cloud_TLSConfig_NameToCertificate_v5.Leaf.Extensions[i10].Id, v5.Leaf.Extensions[i10].Id)
								}
								if v5.Leaf.Extensions[i10].Value != nil {
									cp_Cloud_TLSConfig_NameToCertificate_v5.Leaf.Extensions[i10].Value = make([]byte, len(v5.Leaf.Extensions[i10].Value))
									copy(cp_Cloud_TLSConfig_NameToCertificate_v5.Leaf.Extensions[i10].Value, v5.Leaf.Extensions[i10].Value)
								}
							}
						}
						if v5.Leaf.ExtraExtensions != nil {
							cp_Cloud_TLSConfig_NameToCertificate_v5.Leaf.ExtraExtensions = make([]pkix.Extension, len(v5.Leaf.ExtraExtensions))
							copy(cp_Cloud_TLSConfig_NameToCertificate_v5.Leaf.ExtraExtensions, v5.Leaf.ExtraExtensions)
							for i10 := range v5.Leaf.ExtraExtensions {
								if v5.Leaf.ExtraExtensions[i10].Id != nil {
									cp_Cloud_TLSConfig_NameToCertificate_v5.Leaf.ExtraExtensions[i10].Id = make([]int, len(v5.Leaf.ExtraExtensions[i10].Id))
									copy(cp_Cloud_TLSConfig_NameToCertificate_v5.Leaf.ExtraExtensions[i10].Id, v5.Leaf.ExtraExtensions[i10].Id)
								}
								if v5.Leaf.ExtraExtensions[i10].Value != nil {
									cp_Cloud_TLSConfig_NameToCertificate_v5.Leaf.ExtraExtensions[i10].Value = make([]byte, len(v5.Leaf.ExtraExtensions[i10].Value))
									copy(cp_Cloud_TLSConfig_NameToCertificate_v5.Leaf.ExtraExtensions[i10].Value, v5.Leaf.ExtraExtensions[i10].Value)
								}
							}
						}
						if v5.Leaf.UnhandledCriticalExtensions != nil {
							cp_Cloud_TLSConfig_NameToCertificate_v5.Leaf.UnhandledCriticalExtensions = make([]asn1.ObjectIdentifier, len(v5.Leaf.UnhandledCriticalExtensions))
							copy(cp_Cloud_TLSConfig_NameToCertificate_v5.Leaf.UnhandledCriticalExtensions, v5.Leaf.UnhandledCriticalExtensions)
							for i10 := range v5.Leaf.UnhandledCriticalExtensions {
								if v5.Leaf.UnhandledCriticalExtensions[i10] != nil {
									cp_Cloud_TLSConfig_NameToCertificate_v5.Leaf.UnhandledCriticalExtensions[i10] = make([]int, len(v5.Leaf.UnhandledCriticalExtensions[i10]))
									copy(cp_Cloud_TLSConfig_NameToCertificate_v5.Leaf.UnhandledCriticalExtensions[i10], v5.Leaf.UnhandledCriticalExtensions[i10])
								}
							}
						}
						if v5.Leaf.ExtKeyUsage != nil {
							cp_Cloud_TLSConfig_NameToCertificate_v5.Leaf.ExtKeyUsage = make([]x509.ExtKeyUsage, len(v5.Leaf.ExtKeyUsage))
							copy(cp_Cloud_TLSConfig_NameToCertificate_v5.Leaf.ExtKeyUsage, v5.Leaf.ExtKeyUsage)
						}
						if v5.Leaf.UnknownExtKeyUsage != nil {
							cp_Cloud_TLSConfig_NameToCertificate_v5.Leaf.UnknownExtKeyUsage = make([]asn1.ObjectIdentifier, len(v5.Leaf.UnknownExtKeyUsage))
							copy(cp_Cloud_TLSConfig_NameToCertificate_v5.Leaf.UnknownExtKeyUsage, v5.Leaf.UnknownExtKeyUsage)
							for i10 := range v5.Leaf.UnknownExtKeyUsage {
								if v5.Leaf.UnknownExtKeyUsage[i10] != nil {
									cp_Cloud_TLSConfig_NameToCertificate_v5.Leaf.UnknownExtKeyUsage[i10] = make([]int, len(v5.Leaf.UnknownExtKeyUsage[i10]))
									copy(cp_Cloud_TLSConfig_NameToCertificate_v5.Leaf.UnknownExtKeyUsage[i10], v5.Leaf.UnknownExtKeyUsage[i10])
								}
							}
						}
						if v5.Leaf.SubjectKeyId != nil {
							cp_Cloud_TLSConfig_NameToCertificate_v5.Leaf.SubjectKeyId = make([]byte, len(v5.Leaf.SubjectKeyId))
							copy(cp_Cloud_TLSConfig_NameToCertificate_v5.Leaf.SubjectKeyId, v5.Leaf.SubjectKeyId)
						}
						if v5.Leaf.AuthorityKeyId != nil {
							cp_Cloud_TLSConfig_NameToCertificate_v5.Leaf.AuthorityKeyId = make([]byte, len(v5.Leaf.AuthorityKeyId))
							copy(cp_Cloud_TLSConfig_NameToCertificate_v5.Leaf.AuthorityKeyId, v5.Leaf.AuthorityKeyId)
						}
						if v5.Leaf.OCSPServer != nil {
							cp_Cloud_TLSConfig_NameToCertificate_v5.Leaf.OCSPServer = make([]string, len(v5.Leaf.OCSPServer))
							copy(cp_Cloud_TLSConfig_NameToCertificate_v5.Leaf.OCSPServer, v5.Leaf.OCSPServer)
						}
						if v5.Leaf.IssuingCertificateURL != nil {
							cp_Cloud_TLSConfig_NameToCertificate_v5.Leaf.IssuingCertificateURL = make([]string, len(v5.Leaf.IssuingCertificateURL))
							copy(cp_Cloud_TLSConfig_NameToCertificate_v5.Leaf.IssuingCertificateURL, v5.Leaf.IssuingCertificateURL)
						}
						if v5.Leaf.DNSNames != nil {
							cp_Cloud_TLSConfig_NameToCertificate_v5.Leaf.DNSNames = make([]string, len(v5.Leaf.DNSNames))
							copy(cp_Cloud_TLSConfig_NameToCertificate_v5.Leaf.DNSNames, v5.Leaf.DNSNames)
						}
						if v5.Leaf.EmailAddresses != nil {
							cp_Cloud_TLSConfig_NameToCertificate_v5.Leaf.EmailAddresses = make([]string, len(v5.Leaf.EmailAddresses))
							copy(cp_Cloud_TLSConfig_NameToCertificate_v5.Leaf.EmailAddresses, v5.Leaf.EmailAddresses)
						}
						if v5.Leaf.IPAddresses != nil {
							cp_Cloud_TLSConfig_NameToCertificate_v5.Leaf.IPAddresses = make([]net.IP, len(v5.Leaf.IPAddresses))
							copy(cp_Cloud_TLSConfig_NameToCertificate_v5.Leaf.IPAddresses, v5.Leaf.IPAddresses)
							for i10 := range v5.Leaf.IPAddresses {
								if v5.Leaf.IPAddresses[i10] != nil {
									cp_Cloud_TLSConfig_NameToCertificate_v5.Leaf.IPAddresses[i10] = make([]byte, len(v5.Leaf.IPAddresses[i10]))
									copy(cp_Cloud_TLSConfig_NameToCertificate_v5.Leaf.IPAddresses[i10], v5.Leaf.IPAddresses[i10])
								}
							}
						}
						if v5.Leaf.URIs != nil {
							cp_Cloud_TLSConfig_NameToCertificate_v5.Leaf.URIs = make([]*url.URL, len(v5.Leaf.URIs))
							copy(cp_Cloud_TLSConfig_NameToCertificate_v5.Leaf.URIs, v5.Leaf.URIs)
							for i10 := range v5.Leaf.URIs {
								if v5.Leaf.URIs[i10] != nil {
									cp_Cloud_TLSConfig_NameToCertificate_v5.Leaf.URIs[i10] = new(url.URL)
									*cp_Cloud_TLSConfig_NameToCertificate_v5.Leaf.URIs[i10] = *v5.Leaf.URIs[i10]
									if v5.Leaf.URIs[i10].User != nil {
										cp_Cloud_TLSConfig_NameToCertificate_v5.Leaf.URIs[i10].User = new(url.Userinfo)
										*cp_Cloud_TLSConfig_NameToCertificate_v5.Leaf.URIs[i10].User = *v5.Leaf.URIs[i10].User
									}
								}
							}
						}
						if v5.Leaf.PermittedDNSDomains != nil {
							cp_Cloud_TLSConfig_NameToCertificate_v5.Leaf.PermittedDNSDomains = make([]string, len(v5.Leaf.PermittedDNSDomains))
							copy(cp_Cloud_TLSConfig_NameToCertificate_v5.Leaf.PermittedDNSDomains, v5.Leaf.PermittedDNSDomains)
						}
						if v5.Leaf.ExcludedDNSDomains != nil {
							cp_Cloud_TLSConfig_NameToCertificate_v5.Leaf.ExcludedDNSDomains = make([]string, len(v5.Leaf.ExcludedDNSDomains))
							copy(cp_Cloud_TLSConfig_NameToCertificate_v5.Leaf.ExcludedDNSDomains, v5.Leaf.ExcludedDNSDomains)
						}
						if v5.Leaf.PermittedIPRanges != nil {
							cp_Cloud_TLSConfig_NameToCertificate_v5.Leaf.PermittedIPRanges = make([]*net.IPNet, len(v5.Leaf.PermittedIPRanges))
							copy(cp_Cloud_TLSConfig_NameToCertificate_v5.Leaf.PermittedIPRanges, v5.Leaf.PermittedIPRanges)
							for i10 := range v5.Leaf.PermittedIPRanges {
								if v5.Leaf.PermittedIPRanges[i10] != nil {
									cp_Cloud_TLSConfig_NameToCertificate_v5.Leaf.PermittedIPRanges[i10] = new(net.IPNet)
									*cp_Cloud_TLSConfig_NameToCertificate_v5.Leaf.PermittedIPRanges[i10] = *v5.Leaf.PermittedIPRanges[i10]
									if v5.Leaf.PermittedIPRanges[i10].IP != nil {
										cp_Cloud_TLSConfig_NameToCertificate_v5.Leaf.PermittedIPRanges[i10].IP = make([]byte, len(v5.Leaf.PermittedIPRanges[i10].IP))
										copy(cp_Cloud_TLSConfig_NameToCertificate_v5.Leaf.PermittedIPRanges[i10].IP, v5.Leaf.PermittedIPRanges[i10].IP)
									}
									if v5.Leaf.PermittedIPRanges[i10].Mask != nil {
										cp_Cloud_TLSConfig_NameToCertificate_v5.Leaf.PermittedIPRanges[i10].Mask = make([]byte, len(v5.Leaf.PermittedIPRanges[i10].Mask))
										copy(cp_Cloud_TLSConfig_NameToCertificate_v5.Leaf.PermittedIPRanges[i10].Mask, v5.Leaf.PermittedIPRanges[i10].Mask)
									}
								}
							}
						}
						if v5.Leaf.ExcludedIPRanges != nil {
							cp_Cloud_TLSConfig_NameToCertificate_v5.Leaf.ExcludedIPRanges = make([]*net.IPNet, len(v5.Leaf.ExcludedIPRanges))
							copy(cp_Cloud_TLSConfig_NameToCertificate_v5.Leaf.ExcludedIPRanges, v5.Leaf.ExcludedIPRanges)
							for i10 := range v5.Leaf.ExcludedIPRanges {
								if v5.Leaf.ExcludedIPRanges[i10] != nil {
									cp_Cloud_TLSConfig_NameToCertificate_v5.Leaf.ExcludedIPRanges[i10] = new(net.IPNet)
									*cp_Cloud_TLSConfig_NameToCertificate_v5.Leaf.ExcludedIPRanges[i10] = *v5.Leaf.ExcludedIPRanges[i10]
									if v5.Leaf.ExcludedIPRanges[i10].IP != nil {
										cp_Cloud_TLSConfig_NameToCertificate_v5.Leaf.ExcludedIPRanges[i10].IP = make([]byte, len(v5.Leaf.ExcludedIPRanges[i10].IP))
										copy(cp_Cloud_TLSConfig_NameToCertificate_v5.Leaf.ExcludedIPRanges[i10].IP, v5.Leaf.ExcludedIPRanges[i10].IP)
									}
									if v5.Leaf.ExcludedIPRanges[i10].Mask != nil {
										cp_Cloud_TLSConfig_NameToCertificate_v5.Leaf.ExcludedIPRanges[i10].Mask = make([]byte, len(v5.Leaf.ExcludedIPRanges[i10].Mask))
										copy(cp_Cloud_TLSConfig_NameToCertificate_v5.Leaf.ExcludedIPRanges[i10].Mask, v5.Leaf.ExcludedIPRanges[i10].Mask)
									}
								}
							}
						}
						if v5.Leaf.PermittedEmailAddresses != nil {
							cp_Cloud_TLSConfig_NameToCertificate_v5.Leaf.PermittedEmailAddresses = make([]string, len(v5.Leaf.PermittedEmailAddresses))
							copy(cp_Cloud_TLSConfig_NameToCertificate_v5.Leaf.PermittedEmailAddresses, v5.Leaf.PermittedEmailAddresses)
						}
						if v5.Leaf.ExcludedEmailAddresses != nil {
							cp_Cloud_TLSConfig_NameToCertificate_v5.Leaf.ExcludedEmailAddresses = make([]string, len(v5.Leaf.ExcludedEmailAddresses))
							copy(cp_Cloud_TLSConfig_NameToCertificate_v5.Leaf.ExcludedEmailAddresses, v5.Leaf.ExcludedEmailAddresses)
						}
						if v5.Leaf.PermittedURIDomains != nil {
							cp_Cloud_TLSConfig_NameToCertificate_v5.Leaf.PermittedURIDomains = make([]string, len(v5.Leaf.PermittedURIDomains))
							copy(cp_Cloud_TLSConfig_NameToCertificate_v5.Leaf.PermittedURIDomains, v5.Leaf.PermittedURIDomains)
						}
						if v5.Leaf.ExcludedURIDomains != nil {
							cp_Cloud_TLSConfig_NameToCertificate_v5.Leaf.ExcludedURIDomains = make([]string, len(v5.Leaf.ExcludedURIDomains))
							copy(cp_Cloud_TLSConfig_NameToCertificate_v5.Leaf.ExcludedURIDomains, v5.Leaf.ExcludedURIDomains)
						}
						if v5.Leaf.CRLDistributionPoints != nil {
							cp_Cloud_TLSConfig_NameToCertificate_v5.Leaf.CRLDistributionPoints = make([]string, len(v5.Leaf.CRLDistributionPoints))
							copy(cp_Cloud_TLSConfig_NameToCertificate_v5.Leaf.CRLDistributionPoints, v5.Leaf.CRLDistributionPoints)
						}
						if v5.Leaf.PolicyIdentifiers != nil {
							cp_Cloud_TLSConfig_NameToCertificate_v5.Leaf.PolicyIdentifiers = make([]asn1.ObjectIdentifier, len(v5.Leaf.PolicyIdentifiers))
							copy(cp_Cloud_TLSConfig_NameToCertificate_v5.Leaf.PolicyIdentifiers, v5.Leaf.PolicyIdentifiers)
							for i10 := range v5.Leaf.PolicyIdentifiers {
								if v5.Leaf.PolicyIdentifiers[i10] != nil {
									cp_Cloud_TLSConfig_NameToCertificate_v5.Leaf.PolicyIdentifiers[i10] = make([]int, len(v5.Leaf.PolicyIdentifiers[i10]))
									copy(cp_Cloud_TLSConfig_NameToCertificate_v5.Leaf.PolicyIdentifiers[i10], v5.Leaf.PolicyIdentifiers[i10])
								}
							}
						}
						if v5.Leaf.Policies != nil {
							cp_Cloud_TLSConfig_NameToCertificate_v5.Leaf.Policies = make([]x509.OID, len(v5.Leaf.Policies))
							copy(cp_Cloud_TLSConfig_NameToCertificate_v5.Leaf.Policies, v5.Leaf.Policies)
						}
					}
				}
				cp.Cloud.TLSConfig.NameToCertificate[k5] = cp_Cloud_TLSConfig_NameToCertificate_v5
			}
		}
		if o.Cloud.TLSConfig.RootCAs != nil {
			cp.Cloud.TLSConfig.RootCAs = new(x509.CertPool)
			*cp.Cloud.TLSConfig.RootCAs = *o.Cloud.TLSConfig.RootCAs
		}
		if o.Cloud.TLSConfig.NextProtos != nil {
			cp.Cloud.TLSConfig.NextProtos = make([]string, len(o.Cloud.TLSConfig.NextProtos))
			copy(cp.Cloud.TLSConfig.NextProtos, o.Cloud.TLSConfig.NextProtos)
		}
		if o.Cloud.TLSConfig.ClientCAs != nil {
			cp.Cloud.TLSConfig.ClientCAs = new(x509.CertPool)
			*cp.Cloud.TLSConfig.ClientCAs = *o.Cloud.TLSConfig.ClientCAs
		}
		if o.Cloud.TLSConfig.CipherSuites != nil {
			cp.Cloud.TLSConfig.CipherSuites = make([]uint16, len(o.Cloud.TLSConfig.CipherSuites))
			copy(cp.Cloud.TLSConfig.CipherSuites, o.Cloud.TLSConfig.CipherSuites)
		}
		if o.Cloud.TLSConfig.CurvePreferences != nil {
			cp.Cloud.TLSConfig.CurvePreferences = make([]tls.CurveID, len(o.Cloud.TLSConfig.CurvePreferences))
			copy(cp.Cloud.TLSConfig.CurvePreferences, o.Cloud.TLSConfig.CurvePreferences)
		}
	}
	if o.DNSServiceTTL != nil {
		cp.DNSServiceTTL = make(map[string]time.Duration, len(o.DNSServiceTTL))
		for k2, v2 := range o.DNSServiceTTL {
			cp.DNSServiceTTL[k2] = v2
		}
	}
	if o.DNSRecursors != nil {
		cp.DNSRecursors = make([]string, len(o.DNSRecursors))
		copy(cp.DNSRecursors, o.DNSRecursors)
	}
	if o.HTTPBlockEndpoints != nil {
		cp.HTTPBlockEndpoints = make([]string, len(o.HTTPBlockEndpoints))
		copy(cp.HTTPBlockEndpoints, o.HTTPBlockEndpoints)
	}
	if o.AllowWriteHTTPFrom != nil {
		cp.AllowWriteHTTPFrom = make([]*net.IPNet, len(o.AllowWriteHTTPFrom))
		copy(cp.AllowWriteHTTPFrom, o.AllowWriteHTTPFrom)
		for i2 := range o.AllowWriteHTTPFrom {
			if o.AllowWriteHTTPFrom[i2] != nil {
				cp.AllowWriteHTTPFrom[i2] = new(net.IPNet)
				*cp.AllowWriteHTTPFrom[i2] = *o.AllowWriteHTTPFrom[i2]
				if o.AllowWriteHTTPFrom[i2].IP != nil {
					cp.AllowWriteHTTPFrom[i2].IP = make([]byte, len(o.AllowWriteHTTPFrom[i2].IP))
					copy(cp.AllowWriteHTTPFrom[i2].IP, o.AllowWriteHTTPFrom[i2].IP)
				}
				if o.AllowWriteHTTPFrom[i2].Mask != nil {
					cp.AllowWriteHTTPFrom[i2].Mask = make([]byte, len(o.AllowWriteHTTPFrom[i2].Mask))
					copy(cp.AllowWriteHTTPFrom[i2].Mask, o.AllowWriteHTTPFrom[i2].Mask)
				}
			}
		}
	}
	if o.HTTPResponseHeaders != nil {
		cp.HTTPResponseHeaders = make(map[string]string, len(o.HTTPResponseHeaders))
		for k2, v2 := range o.HTTPResponseHeaders {
			cp.HTTPResponseHeaders[k2] = v2
		}
	}
	if o.Telemetry.DogstatsdTags != nil {
		cp.Telemetry.DogstatsdTags = make([]string, len(o.Telemetry.DogstatsdTags))
		copy(cp.Telemetry.DogstatsdTags, o.Telemetry.DogstatsdTags)
	}
	if o.Telemetry.AllowedPrefixes != nil {
		cp.Telemetry.AllowedPrefixes = make([]string, len(o.Telemetry.AllowedPrefixes))
		copy(cp.Telemetry.AllowedPrefixes, o.Telemetry.AllowedPrefixes)
	}
	if o.Telemetry.BlockedPrefixes != nil {
		cp.Telemetry.BlockedPrefixes = make([]string, len(o.Telemetry.BlockedPrefixes))
		copy(cp.Telemetry.BlockedPrefixes, o.Telemetry.BlockedPrefixes)
	}
	if o.Telemetry.PrometheusOpts.GaugeDefinitions != nil {
		cp.Telemetry.PrometheusOpts.GaugeDefinitions = make([]prometheus.GaugeDefinition, len(o.Telemetry.PrometheusOpts.GaugeDefinitions))
		copy(cp.Telemetry.PrometheusOpts.GaugeDefinitions, o.Telemetry.PrometheusOpts.GaugeDefinitions)
		for i4 := range o.Telemetry.PrometheusOpts.GaugeDefinitions {
			if o.Telemetry.PrometheusOpts.GaugeDefinitions[i4].Name != nil {
				cp.Telemetry.PrometheusOpts.GaugeDefinitions[i4].Name = make([]string, len(o.Telemetry.PrometheusOpts.GaugeDefinitions[i4].Name))
				copy(cp.Telemetry.PrometheusOpts.GaugeDefinitions[i4].Name, o.Telemetry.PrometheusOpts.GaugeDefinitions[i4].Name)
			}
			if o.Telemetry.PrometheusOpts.GaugeDefinitions[i4].ConstLabels != nil {
				cp.Telemetry.PrometheusOpts.GaugeDefinitions[i4].ConstLabels = make([]metrics.Label, len(o.Telemetry.PrometheusOpts.GaugeDefinitions[i4].ConstLabels))
				copy(cp.Telemetry.PrometheusOpts.GaugeDefinitions[i4].ConstLabels, o.Telemetry.PrometheusOpts.GaugeDefinitions[i4].ConstLabels)
			}
		}
	}
	if o.Telemetry.PrometheusOpts.SummaryDefinitions != nil {
		cp.Telemetry.PrometheusOpts.SummaryDefinitions = make([]prometheus.SummaryDefinition, len(o.Telemetry.PrometheusOpts.SummaryDefinitions))
		copy(cp.Telemetry.PrometheusOpts.SummaryDefinitions, o.Telemetry.PrometheusOpts.SummaryDefinitions)
		for i4 := range o.Telemetry.PrometheusOpts.SummaryDefinitions {
			if o.Telemetry.PrometheusOpts.SummaryDefinitions[i4].Name != nil {
				cp.Telemetry.PrometheusOpts.SummaryDefinitions[i4].Name = make([]string, len(o.Telemetry.PrometheusOpts.SummaryDefinitions[i4].Name))
				copy(cp.Telemetry.PrometheusOpts.SummaryDefinitions[i4].Name, o.Telemetry.PrometheusOpts.SummaryDefinitions[i4].Name)
			}
			if o.Telemetry.PrometheusOpts.SummaryDefinitions[i4].ConstLabels != nil {
				cp.Telemetry.PrometheusOpts.SummaryDefinitions[i4].ConstLabels = make([]metrics.Label, len(o.Telemetry.PrometheusOpts.SummaryDefinitions[i4].ConstLabels))
				copy(cp.Telemetry.PrometheusOpts.SummaryDefinitions[i4].ConstLabels, o.Telemetry.PrometheusOpts.SummaryDefinitions[i4].ConstLabels)
			}
		}
	}
	if o.Telemetry.PrometheusOpts.CounterDefinitions != nil {
		cp.Telemetry.PrometheusOpts.CounterDefinitions = make([]prometheus.CounterDefinition, len(o.Telemetry.PrometheusOpts.CounterDefinitions))
		copy(cp.Telemetry.PrometheusOpts.CounterDefinitions, o.Telemetry.PrometheusOpts.CounterDefinitions)
		for i4 := range o.Telemetry.PrometheusOpts.CounterDefinitions {
			if o.Telemetry.PrometheusOpts.CounterDefinitions[i4].Name != nil {
				cp.Telemetry.PrometheusOpts.CounterDefinitions[i4].Name = make([]string, len(o.Telemetry.PrometheusOpts.CounterDefinitions[i4].Name))
				copy(cp.Telemetry.PrometheusOpts.CounterDefinitions[i4].Name, o.Telemetry.PrometheusOpts.CounterDefinitions[i4].Name)
			}
			if o.Telemetry.PrometheusOpts.CounterDefinitions[i4].ConstLabels != nil {
				cp.Telemetry.PrometheusOpts.CounterDefinitions[i4].ConstLabels = make([]metrics.Label, len(o.Telemetry.PrometheusOpts.CounterDefinitions[i4].ConstLabels))
				copy(cp.Telemetry.PrometheusOpts.CounterDefinitions[i4].ConstLabels, o.Telemetry.PrometheusOpts.CounterDefinitions[i4].ConstLabels)
			}
		}
	}
	if o.AdvertiseAddrLAN != nil {
		cp.AdvertiseAddrLAN = new(net.IPAddr)
		*cp.AdvertiseAddrLAN = *o.AdvertiseAddrLAN
		if o.AdvertiseAddrLAN.IP != nil {
			cp.AdvertiseAddrLAN.IP = make([]byte, len(o.AdvertiseAddrLAN.IP))
			copy(cp.AdvertiseAddrLAN.IP, o.AdvertiseAddrLAN.IP)
		}
	}
	if o.AdvertiseAddrWAN != nil {
		cp.AdvertiseAddrWAN = new(net.IPAddr)
		*cp.AdvertiseAddrWAN = *o.AdvertiseAddrWAN
		if o.AdvertiseAddrWAN.IP != nil {
			cp.AdvertiseAddrWAN.IP = make([]byte, len(o.AdvertiseAddrWAN.IP))
			copy(cp.AdvertiseAddrWAN.IP, o.AdvertiseAddrWAN.IP)
		}
	}
	if o.BindAddr != nil {
		cp.BindAddr = new(net.IPAddr)
		*cp.BindAddr = *o.BindAddr
		if o.BindAddr.IP != nil {
			cp.BindAddr.IP = make([]byte, len(o.BindAddr.IP))
			copy(cp.BindAddr.IP, o.BindAddr.IP)
		}
	}
	if o.Checks != nil {
		cp.Checks = make([]*structs.CheckDefinition, len(o.Checks))
		copy(cp.Checks, o.Checks)
		for i2 := range o.Checks {
			if o.Checks[i2] != nil {
				cp.Checks[i2] = new(structs.CheckDefinition)
				*cp.Checks[i2] = *o.Checks[i2]
				if o.Checks[i2].ScriptArgs != nil {
					cp.Checks[i2].ScriptArgs = make([]string, len(o.Checks[i2].ScriptArgs))
					copy(cp.Checks[i2].ScriptArgs, o.Checks[i2].ScriptArgs)
				}
				if o.Checks[i2].Header != nil {
					cp.Checks[i2].Header = make(map[string][]string, len(o.Checks[i2].Header))
					for k5, v5 := range o.Checks[i2].Header {
						var cp_Checks_i2_Header_v5 []string
						if v5 != nil {
							cp_Checks_i2_Header_v5 = make([]string, len(v5))
							copy(cp_Checks_i2_Header_v5, v5)
						}
						cp.Checks[i2].Header[k5] = cp_Checks_i2_Header_v5
					}
				}
			}
		}
	}
	if o.ClientAddrs != nil {
		cp.ClientAddrs = make([]*net.IPAddr, len(o.ClientAddrs))
		copy(cp.ClientAddrs, o.ClientAddrs)
		for i2 := range o.ClientAddrs {
			if o.ClientAddrs[i2] != nil {
				cp.ClientAddrs[i2] = new(net.IPAddr)
				*cp.ClientAddrs[i2] = *o.ClientAddrs[i2]
				if o.ClientAddrs[i2].IP != nil {
					cp.ClientAddrs[i2].IP = make([]byte, len(o.ClientAddrs[i2].IP))
					copy(cp.ClientAddrs[i2].IP, o.ClientAddrs[i2].IP)
				}
			}
		}
	}
	if o.ConfigEntryBootstrap != nil {
		cp.ConfigEntryBootstrap = make([]structs.ConfigEntry, len(o.ConfigEntryBootstrap))
		copy(cp.ConfigEntryBootstrap, o.ConfigEntryBootstrap)
	}
	if o.AutoEncryptDNSSAN != nil {
		cp.AutoEncryptDNSSAN = make([]string, len(o.AutoEncryptDNSSAN))
		copy(cp.AutoEncryptDNSSAN, o.AutoEncryptDNSSAN)
	}
	if o.AutoEncryptIPSAN != nil {
		cp.AutoEncryptIPSAN = make([]net.IP, len(o.AutoEncryptIPSAN))
		copy(cp.AutoEncryptIPSAN, o.AutoEncryptIPSAN)
		for i2 := range o.AutoEncryptIPSAN {
			if o.AutoEncryptIPSAN[i2] != nil {
				cp.AutoEncryptIPSAN[i2] = make([]byte, len(o.AutoEncryptIPSAN[i2]))
				copy(cp.AutoEncryptIPSAN[i2], o.AutoEncryptIPSAN[i2])
			}
		}
	}
	if o.AutoConfig.ServerAddresses != nil {
		cp.AutoConfig.ServerAddresses = make([]string, len(o.AutoConfig.ServerAddresses))
		copy(cp.AutoConfig.ServerAddresses, o.AutoConfig.ServerAddresses)
	}
	if o.AutoConfig.DNSSANs != nil {
		cp.AutoConfig.DNSSANs = make([]string, len(o.AutoConfig.DNSSANs))
		copy(cp.AutoConfig.DNSSANs, o.AutoConfig.DNSSANs)
	}
	if o.AutoConfig.IPSANs != nil {
		cp.AutoConfig.IPSANs = make([]net.IP, len(o.AutoConfig.IPSANs))
		copy(cp.AutoConfig.IPSANs, o.AutoConfig.IPSANs)
		for i3 := range o.AutoConfig.IPSANs {
			if o.AutoConfig.IPSANs[i3] != nil {
				cp.AutoConfig.IPSANs[i3] = make([]byte, len(o.AutoConfig.IPSANs[i3]))
				copy(cp.AutoConfig.IPSANs[i3], o.AutoConfig.IPSANs[i3])
			}
		}
	}
	if o.AutoConfig.Authorizer.AuthMethod.Config != nil {
		cp.AutoConfig.Authorizer.AuthMethod.Config = make(map[string]interface{}, len(o.AutoConfig.Authorizer.AuthMethod.Config))
		for k5, v5 := range o.AutoConfig.Authorizer.AuthMethod.Config {
			cp.AutoConfig.Authorizer.AuthMethod.Config[k5] = v5
		}
	}
	if o.AutoConfig.Authorizer.ClaimAssertions != nil {
		cp.AutoConfig.Authorizer.ClaimAssertions = make([]string, len(o.AutoConfig.Authorizer.ClaimAssertions))
		copy(cp.AutoConfig.Authorizer.ClaimAssertions, o.AutoConfig.Authorizer.ClaimAssertions)
	}
	if o.ConnectCAConfig != nil {
		cp.ConnectCAConfig = make(map[string]interface{}, len(o.ConnectCAConfig))
		for k2, v2 := range o.ConnectCAConfig {
			cp.ConnectCAConfig[k2] = v2
		}
	}
	if o.DNSAddrs != nil {
		cp.DNSAddrs = make([]net.Addr, len(o.DNSAddrs))
		copy(cp.DNSAddrs, o.DNSAddrs)
	}
	if o.GRPCAddrs != nil {
		cp.GRPCAddrs = make([]net.Addr, len(o.GRPCAddrs))
		copy(cp.GRPCAddrs, o.GRPCAddrs)
	}
	if o.GRPCTLSAddrs != nil {
		cp.GRPCTLSAddrs = make([]net.Addr, len(o.GRPCTLSAddrs))
		copy(cp.GRPCTLSAddrs, o.GRPCTLSAddrs)
	}
	if o.HTTPAddrs != nil {
		cp.HTTPAddrs = make([]net.Addr, len(o.HTTPAddrs))
		copy(cp.HTTPAddrs, o.HTTPAddrs)
	}
	if o.HTTPSAddrs != nil {
		cp.HTTPSAddrs = make([]net.Addr, len(o.HTTPSAddrs))
		copy(cp.HTTPSAddrs, o.HTTPSAddrs)
	}
	if o.Locality != nil {
		cp.Locality = new(Locality)
		*cp.Locality = *o.Locality
		if o.Locality.Region != nil {
			cp.Locality.Region = new(string)
			*cp.Locality.Region = *o.Locality.Region
		}
		if o.Locality.Zone != nil {
			cp.Locality.Zone = new(string)
			*cp.Locality.Zone = *o.Locality.Zone
		}
	}
	if o.NodeMeta != nil {
		cp.NodeMeta = make(map[string]string, len(o.NodeMeta))
		for k2, v2 := range o.NodeMeta {
			cp.NodeMeta[k2] = v2
		}
	}
	if o.PrimaryGateways != nil {
		cp.PrimaryGateways = make([]string, len(o.PrimaryGateways))
		copy(cp.PrimaryGateways, o.PrimaryGateways)
	}
	if o.RPCAdvertiseAddr != nil {
		cp.RPCAdvertiseAddr = new(net.TCPAddr)
		*cp.RPCAdvertiseAddr = *o.RPCAdvertiseAddr
		if o.RPCAdvertiseAddr.IP != nil {
			cp.RPCAdvertiseAddr.IP = make([]byte, len(o.RPCAdvertiseAddr.IP))
			copy(cp.RPCAdvertiseAddr.IP, o.RPCAdvertiseAddr.IP)
		}
	}
	if o.RPCBindAddr != nil {
		cp.RPCBindAddr = new(net.TCPAddr)
		*cp.RPCBindAddr = *o.RPCBindAddr
		if o.RPCBindAddr.IP != nil {
			cp.RPCBindAddr.IP = make([]byte, len(o.RPCBindAddr.IP))
			copy(cp.RPCBindAddr.IP, o.RPCBindAddr.IP)
		}
	}
	if o.RetryJoinLAN != nil {
		cp.RetryJoinLAN = make([]string, len(o.RetryJoinLAN))
		copy(cp.RetryJoinLAN, o.RetryJoinLAN)
	}
	if o.RetryJoinWAN != nil {
		cp.RetryJoinWAN = make([]string, len(o.RetryJoinWAN))
		copy(cp.RetryJoinWAN, o.RetryJoinWAN)
	}
	if o.Segments != nil {
		cp.Segments = make([]structs.NetworkSegment, len(o.Segments))
		copy(cp.Segments, o.Segments)
		for i2 := range o.Segments {
			if o.Segments[i2].Bind != nil {
				cp.Segments[i2].Bind = new(net.TCPAddr)
				*cp.Segments[i2].Bind = *o.Segments[i2].Bind
				if o.Segments[i2].Bind.IP != nil {
					cp.Segments[i2].Bind.IP = make([]byte, len(o.Segments[i2].Bind.IP))
					copy(cp.Segments[i2].Bind.IP, o.Segments[i2].Bind.IP)
				}
			}
			if o.Segments[i2].Advertise != nil {
				cp.Segments[i2].Advertise = new(net.TCPAddr)
				*cp.Segments[i2].Advertise = *o.Segments[i2].Advertise
				if o.Segments[i2].Advertise.IP != nil {
					cp.Segments[i2].Advertise.IP = make([]byte, len(o.Segments[i2].Advertise.IP))
					copy(cp.Segments[i2].Advertise.IP, o.Segments[i2].Advertise.IP)
				}
			}
		}
	}
	if o.SerfAdvertiseAddrLAN != nil {
		cp.SerfAdvertiseAddrLAN = new(net.TCPAddr)
		*cp.SerfAdvertiseAddrLAN = *o.SerfAdvertiseAddrLAN
		if o.SerfAdvertiseAddrLAN.IP != nil {
			cp.SerfAdvertiseAddrLAN.IP = make([]byte, len(o.SerfAdvertiseAddrLAN.IP))
			copy(cp.SerfAdvertiseAddrLAN.IP, o.SerfAdvertiseAddrLAN.IP)
		}
	}
	if o.SerfAdvertiseAddrWAN != nil {
		cp.SerfAdvertiseAddrWAN = new(net.TCPAddr)
		*cp.SerfAdvertiseAddrWAN = *o.SerfAdvertiseAddrWAN
		if o.SerfAdvertiseAddrWAN.IP != nil {
			cp.SerfAdvertiseAddrWAN.IP = make([]byte, len(o.SerfAdvertiseAddrWAN.IP))
			copy(cp.SerfAdvertiseAddrWAN.IP, o.SerfAdvertiseAddrWAN.IP)
		}
	}
	if o.SerfAllowedCIDRsLAN != nil {
		cp.SerfAllowedCIDRsLAN = make([]net.IPNet, len(o.SerfAllowedCIDRsLAN))
		copy(cp.SerfAllowedCIDRsLAN, o.SerfAllowedCIDRsLAN)
		for i2 := range o.SerfAllowedCIDRsLAN {
			if o.SerfAllowedCIDRsLAN[i2].IP != nil {
				cp.SerfAllowedCIDRsLAN[i2].IP = make([]byte, len(o.SerfAllowedCIDRsLAN[i2].IP))
				copy(cp.SerfAllowedCIDRsLAN[i2].IP, o.SerfAllowedCIDRsLAN[i2].IP)
			}
			if o.SerfAllowedCIDRsLAN[i2].Mask != nil {
				cp.SerfAllowedCIDRsLAN[i2].Mask = make([]byte, len(o.SerfAllowedCIDRsLAN[i2].Mask))
				copy(cp.SerfAllowedCIDRsLAN[i2].Mask, o.SerfAllowedCIDRsLAN[i2].Mask)
			}
		}
	}
	if o.SerfAllowedCIDRsWAN != nil {
		cp.SerfAllowedCIDRsWAN = make([]net.IPNet, len(o.SerfAllowedCIDRsWAN))
		copy(cp.SerfAllowedCIDRsWAN, o.SerfAllowedCIDRsWAN)
		for i2 := range o.SerfAllowedCIDRsWAN {
			if o.SerfAllowedCIDRsWAN[i2].IP != nil {
				cp.SerfAllowedCIDRsWAN[i2].IP = make([]byte, len(o.SerfAllowedCIDRsWAN[i2].IP))
				copy(cp.SerfAllowedCIDRsWAN[i2].IP, o.SerfAllowedCIDRsWAN[i2].IP)
			}
			if o.SerfAllowedCIDRsWAN[i2].Mask != nil {
				cp.SerfAllowedCIDRsWAN[i2].Mask = make([]byte, len(o.SerfAllowedCIDRsWAN[i2].Mask))
				copy(cp.SerfAllowedCIDRsWAN[i2].Mask, o.SerfAllowedCIDRsWAN[i2].Mask)
			}
		}
	}
	if o.SerfBindAddrLAN != nil {
		cp.SerfBindAddrLAN = new(net.TCPAddr)
		*cp.SerfBindAddrLAN = *o.SerfBindAddrLAN
		if o.SerfBindAddrLAN.IP != nil {
			cp.SerfBindAddrLAN.IP = make([]byte, len(o.SerfBindAddrLAN.IP))
			copy(cp.SerfBindAddrLAN.IP, o.SerfBindAddrLAN.IP)
		}
	}
	if o.SerfBindAddrWAN != nil {
		cp.SerfBindAddrWAN = new(net.TCPAddr)
		*cp.SerfBindAddrWAN = *o.SerfBindAddrWAN
		if o.SerfBindAddrWAN.IP != nil {
			cp.SerfBindAddrWAN.IP = make([]byte, len(o.SerfBindAddrWAN.IP))
			copy(cp.SerfBindAddrWAN.IP, o.SerfBindAddrWAN.IP)
		}
	}
	if o.Services != nil {
		cp.Services = make([]*structs.ServiceDefinition, len(o.Services))
		copy(cp.Services, o.Services)
		for i2 := range o.Services {
			if o.Services[i2] != nil {
				cp.Services[i2] = o.Services[i2].DeepCopy()
			}
		}
	}
	if o.TLS.InternalRPC.CipherSuites != nil {
		cp.TLS.InternalRPC.CipherSuites = make([]types.TLSCipherSuite, len(o.TLS.InternalRPC.CipherSuites))
		copy(cp.TLS.InternalRPC.CipherSuites, o.TLS.InternalRPC.CipherSuites)
	}
	if o.TLS.GRPC.CipherSuites != nil {
		cp.TLS.GRPC.CipherSuites = make([]types.TLSCipherSuite, len(o.TLS.GRPC.CipherSuites))
		copy(cp.TLS.GRPC.CipherSuites, o.TLS.GRPC.CipherSuites)
	}
	if o.TLS.HTTPS.CipherSuites != nil {
		cp.TLS.HTTPS.CipherSuites = make([]types.TLSCipherSuite, len(o.TLS.HTTPS.CipherSuites))
		copy(cp.TLS.HTTPS.CipherSuites, o.TLS.HTTPS.CipherSuites)
	}
	if o.TaggedAddresses != nil {
		cp.TaggedAddresses = make(map[string]string, len(o.TaggedAddresses))
		for k2, v2 := range o.TaggedAddresses {
			cp.TaggedAddresses[k2] = v2
		}
	}
	if o.UIConfig.MetricsProviderFiles != nil {
		cp.UIConfig.MetricsProviderFiles = make([]string, len(o.UIConfig.MetricsProviderFiles))
		copy(cp.UIConfig.MetricsProviderFiles, o.UIConfig.MetricsProviderFiles)
	}
	if o.UIConfig.MetricsProxy.AddHeaders != nil {
		cp.UIConfig.MetricsProxy.AddHeaders = make([]UIMetricsProxyAddHeader, len(o.UIConfig.MetricsProxy.AddHeaders))
		copy(cp.UIConfig.MetricsProxy.AddHeaders, o.UIConfig.MetricsProxy.AddHeaders)
	}
	if o.UIConfig.MetricsProxy.PathAllowlist != nil {
		cp.UIConfig.MetricsProxy.PathAllowlist = make([]string, len(o.UIConfig.MetricsProxy.PathAllowlist))
		copy(cp.UIConfig.MetricsProxy.PathAllowlist, o.UIConfig.MetricsProxy.PathAllowlist)
	}
	if o.UIConfig.DashboardURLTemplates != nil {
		cp.UIConfig.DashboardURLTemplates = make(map[string]string, len(o.UIConfig.DashboardURLTemplates))
		for k3, v3 := range o.UIConfig.DashboardURLTemplates {
			cp.UIConfig.DashboardURLTemplates[k3] = v3
		}
	}
	if o.Watches != nil {
		cp.Watches = make([]map[string]interface{}, len(o.Watches))
		copy(cp.Watches, o.Watches)
		for i2 := range o.Watches {
			if o.Watches[i2] != nil {
				cp.Watches[i2] = make(map[string]interface{}, len(o.Watches[i2]))
				for k3, v3 := range o.Watches[i2] {
					cp.Watches[i2][k3] = v3
				}
			}
		}
	}
	if o.Experiments != nil {
		cp.Experiments = make([]string, len(o.Experiments))
		copy(cp.Experiments, o.Experiments)
	}
	return &cp
}
