/*
 * Decompiled with CFR 0.152.
 */
package org.dita.index;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Locale;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.dita.dost.log.DITAOTAntLogger;
import org.dita.dost.log.DITAOTLogger;
import org.dita.index.IndexEntry;
import org.dita.index.IndexPreprocessResult;
import org.dita.index.IndexPreprocessor;
import org.dita.index.configuration.IndexConfiguration;
import org.dita.index.configuration.ParseException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class IndexPreprocessorTask
extends Task {
    private static final String PREFIX = "opentopic-index";
    private static final String NAMESPACE_URL = "http://www.idiominc.com/opentopic/index";
    public static boolean failOnError = false;
    public static boolean processingFaild = false;
    private File input;
    private File output;
    private Locale locale;
    private File indexConfig;
    private boolean draft;

    public void execute() throws BuildException {
        IndexConfiguration configuration;
        Document doc;
        DocumentBuilder documentBuilder;
        this.checkParameters();
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            documentBuilder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new BuildException((Throwable)e);
        }
        try {
            doc = documentBuilder.parse(this.input);
        }
        catch (IOException | SAXException e) {
            throw new BuildException((Throwable)e);
        }
        try {
            Document configDocument = documentBuilder.parse(this.indexConfig);
            configuration = IndexConfiguration.parse(configDocument);
        }
        catch (IOException | ParseException | SAXException e) {
            throw new BuildException((Throwable)e);
        }
        IndexPreprocessor preprocessor = new IndexPreprocessor(PREFIX, NAMESPACE_URL, this.draft);
        preprocessor.setLogger((DITAOTLogger)new DITAOTAntLogger(this.getProject()));
        IndexPreprocessResult result = preprocessor.process(doc);
        Document resultDoc = result.document;
        Collection<IndexEntry> indexEntries = result.indexEntries;
        preprocessor.createAndAddIndexGroups(indexEntries, configuration, resultDoc, this.locale);
        if (processingFaild) {
            this.setActiveProjectProperty("ws.runtime.index.preprocess.fail", "true");
        }
        try (FileOutputStream out = new FileOutputStream(this.output);){
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "no");
            transformer.setOutputProperty("indent", "no");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("standalone", "yes");
            if (doc.getDoctype() != null) {
                if (null != doc.getDoctype().getPublicId()) {
                    transformer.setOutputProperty("doctype-public", doc.getDoctype().getPublicId());
                }
                if (null != doc.getDoctype().getSystemId()) {
                    transformer.setOutputProperty("doctype-system", doc.getDoctype().getSystemId());
                }
            }
            DOMSource source = new DOMSource(resultDoc);
            StreamResult streamResult = new StreamResult(out);
            transformer.transform(source, streamResult);
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }

    private void checkParameters() throws BuildException {
        if (null == this.locale || null == this.input || null == this.output || null == this.indexConfig) {
            throw new BuildException("locale, indexConfig, input, output attributes are required");
        }
    }

    public void setInput(File input) {
        this.input = input;
    }

    public void setOutput(File output) {
        this.output = output;
    }

    public void setLocale(String locale) {
        this.locale = locale.indexOf("-") == 2 || locale.indexOf("_") == 2 ? new Locale(locale.substring(0, 2), locale.substring(3)) : new Locale(locale);
    }

    public void setIndexConfig(File indexConfig) {
        this.indexConfig = indexConfig;
    }

    public void setFailOnError(boolean failOnError) {
        IndexPreprocessorTask.failOnError = failOnError;
    }

    public void setDraft(boolean draftValue) {
        this.draft = draftValue;
    }

    private void setActiveProjectProperty(String propertyName, String propertyValue) {
        Project activeProject = this.getProject();
        if (activeProject != null) {
            activeProject.setProperty(propertyName, propertyValue);
        }
    }
}

