/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.db2.editors;

import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.db2.model.DB2DataSource;
import org.jkiss.utils.CommonUtils;

public enum DB2DDLFormat {
    FORMAT("Format DDL", true),
    NO_FORMAT("Raw Text", false);

    private final String title;
    private final boolean needsFormatting;
    private static final Log log;

    static {
        log = Log.getLog(DB2DDLFormat.class);
    }

    private DB2DDLFormat(String title, boolean needFormatting) {
        this.title = title;
        this.needsFormatting = needFormatting;
    }

    public static DB2DDLFormat getCurrentFormat(DB2DataSource dataSource) {
        String ddlFormatString = dataSource.getContainer().getPreferenceStore().getString("db2.ddl.format");
        if (!CommonUtils.isEmpty((String)ddlFormatString)) {
            try {
                return DB2DDLFormat.valueOf(ddlFormatString);
            }
            catch (IllegalArgumentException e) {
                log.error((Object)e);
            }
        }
        return FORMAT;
    }

    public String getTitle() {
        return this.title;
    }

    public boolean needsFormatting() {
        return this.needsFormatting;
    }
}

