/*
 * Decompiled with CFR 0.152.
 */
package org.cts.registry;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.cts.registry.AbstractProjRegistry;
import org.cts.registry.RegistryException;

public class IGNFRegistry
extends AbstractProjRegistry {
    static final Pattern IGNF_REGEX = Pattern.compile("[ ]\\+|\\s<>");

    @Override
    public String getRegistryName() {
        return "ignf";
    }

    @Override
    public Map<String, String> getParameters(String code) throws RegistryException {
        try {
            return this.projParser.readParameters(code, IGNF_REGEX);
        }
        catch (IOException ex) {
            throw new RegistryException("Cannot load the IGNF registry", ex);
        }
    }

    @Override
    public Set<String> getSupportedCodes() throws RegistryException {
        try {
            return this.projParser.getSupportedCodes(IGNF_REGEX);
        }
        catch (IOException ex) {
            throw new RegistryException("Cannot load the IGNF registry", ex);
        }
    }
}

