/*
 * Decompiled with CFR 0.152.
 */
package net.yura.mobile.gui.plaf;

import java.util.Enumeration;
import java.util.Hashtable;
import net.yura.mobile.gui.Font;
import net.yura.mobile.gui.border.Border;
import net.yura.mobile.util.SystemUtil;

public class Style {
    public static final int NO_COLOR = 0;
    public static final int ALL = 0;
    public static final int SELECTED = 8;
    public static final int DISABLED = 2;
    public static final int FOCUSED = 4;
    private static final int[] searchOrder = new int[]{8, 4, 2};
    private Font font;
    private Border border;
    private Integer background;
    private Integer foreground;
    private Hashtable properties;
    private Hashtable fontStates;
    private Hashtable borderStates;
    private Hashtable backgroundStates;
    private Hashtable foregroundStates;
    private Hashtable propertiesStates;

    public Style() {
    }

    public Style(Style st) {
        this.putAll(st);
    }

    public void putAll(Style st) {
        if (st.font != null) {
            this.font = st.font;
        }
        if (st.border != null) {
            this.border = st.border;
        }
        if (st.background != null) {
            this.background = st.background;
        }
        if (st.foreground != null) {
            this.foreground = st.foreground;
        }
        if (st.properties != null) {
            if (this.properties == null) {
                this.properties = new Hashtable();
            }
            SystemUtil.hashtablePutAll(st.properties, this.properties);
        }
        if (st.fontStates != null) {
            if (this.fontStates == null) {
                this.fontStates = new Hashtable();
            }
            SystemUtil.hashtablePutAll(st.fontStates, this.fontStates);
        }
        if (st.borderStates != null) {
            if (this.borderStates == null) {
                this.borderStates = new Hashtable();
            }
            SystemUtil.hashtablePutAll(st.borderStates, this.borderStates);
        }
        if (st.backgroundStates != null) {
            if (this.backgroundStates == null) {
                this.backgroundStates = new Hashtable();
            }
            SystemUtil.hashtablePutAll(st.backgroundStates, this.backgroundStates);
        }
        if (st.foregroundStates != null) {
            if (this.foregroundStates == null) {
                this.foregroundStates = new Hashtable();
            }
            SystemUtil.hashtablePutAll(st.foregroundStates, this.foregroundStates);
        }
        if (st.propertiesStates != null) {
            if (this.propertiesStates == null) {
                this.propertiesStates = new Hashtable();
            }
            Enumeration en = st.propertiesStates.keys();
            while (en.hasMoreElements()) {
                Object key = en.nextElement();
                Hashtable src = (Hashtable)st.propertiesStates.get(key);
                Hashtable dest = (Hashtable)this.propertiesStates.get(key);
                if (dest == null) {
                    dest = new Hashtable();
                    this.propertiesStates.put(key, dest);
                }
                SystemUtil.hashtablePutAll(src, dest);
            }
        }
    }

    private Object getValueFromMap(Hashtable t, int state, Object defaultObject) {
        if (state == 0 || t == null) {
            return defaultObject;
        }
        Object a = t.get(new Integer(state));
        for (int c = 0; c < searchOrder.length && a == null; ++c) {
            if ((state & searchOrder[c]) == 0) continue;
            a = t.get(new Integer(searchOrder[c]));
        }
        return a == null ? defaultObject : a;
    }

    public void addBorder(Border b, int state) {
        if (state == 0) {
            this.border = b;
            return;
        }
        if (this.borderStates == null) {
            this.borderStates = new Hashtable();
        }
        this.borderStates.put(new Integer(state), b);
    }

    public Border getBorder(int state) {
        return (Border)this.getValueFromMap(this.borderStates, state, this.border);
    }

    public void addFont(Font b, int state) {
        if (state == 0) {
            this.font = b;
            return;
        }
        if (this.fontStates == null) {
            this.fontStates = new Hashtable();
        }
        this.fontStates.put(new Integer(state), b);
    }

    public Font getFont(int state) {
        return (Font)this.getValueFromMap(this.fontStates, state, this.font);
    }

    public void addBackground(int b, int state) {
        Integer i = new Integer(b);
        if (state == 0) {
            this.background = i;
            return;
        }
        if (this.backgroundStates == null) {
            this.backgroundStates = new Hashtable();
        }
        this.backgroundStates.put(new Integer(state), i);
    }

    public int getBackground(int state) {
        Integer i = (Integer)this.getValueFromMap(this.backgroundStates, state, this.background);
        return i == null ? 0 : i;
    }

    public void addForeground(int b, int state) {
        Integer i = new Integer(b);
        if (state == 0) {
            this.foreground = i;
            return;
        }
        if (this.foregroundStates == null) {
            this.foregroundStates = new Hashtable();
        }
        this.foregroundStates.put(new Integer(state), i);
    }

    public int getForeground(int state) {
        Integer i = (Integer)this.getValueFromMap(this.foregroundStates, state, this.foreground);
        return i == null ? 0 : i;
    }

    public void addProperty(Object b, String key, int state) {
        Hashtable<String, Object> table;
        if (state == 0) {
            if (this.properties == null) {
                this.properties = new Hashtable();
            }
            this.properties.put(key, b);
            return;
        }
        if (this.propertiesStates == null) {
            this.propertiesStates = new Hashtable();
        }
        if ((table = (Hashtable<String, Object>)this.propertiesStates.get(new Integer(state))) == null) {
            table = new Hashtable<String, Object>();
            this.propertiesStates.put(new Integer(state), table);
        }
        table.put(key, b);
    }

    public int getIntProperty(String key, int state) {
        Integer value = (Integer)this.getProperty(key, state);
        if (value != null) {
            return value;
        }
        return 0;
    }

    public Object getProperty(String key, int state) {
        if (state == 0 || this.propertiesStates == null) {
            if (this.properties == null) {
                return null;
            }
            return this.properties.get(key);
        }
        Object a = null;
        Hashtable t = (Hashtable)this.propertiesStates.get(new Integer(state));
        if (t != null) {
            a = t.get(key);
        }
        for (int c = 0; c < searchOrder.length && a == null; ++c) {
            if ((state & searchOrder[c]) == 0 || (t = (Hashtable)this.propertiesStates.get(new Integer(searchOrder[c]))) == null) continue;
            a = t.get(key);
        }
        return a;
    }

    protected void reset() {
        this.font = null;
        this.border = null;
        this.background = null;
        this.foreground = null;
        this.properties = null;
        this.fontStates = null;
        this.borderStates = null;
        this.backgroundStates = null;
        this.foregroundStates = null;
        this.propertiesStates = null;
    }

    public String toString() {
        return "Style " + this.font + " " + this.border + " " + this.background + " " + this.foreground + " " + this.properties + " " + this.fontStates + " " + this.borderStates + " " + this.backgroundStates + " " + this.foregroundStates + " " + this.propertiesStates;
    }
}

