/*
 * Decompiled with CFR 0.152.
 */
package net.yura.mobile.gui.components;

import javax.microedition.lcdui.game.Sprite;
import net.yura.mobile.gui.Animation;
import net.yura.mobile.gui.Graphics2D;
import net.yura.mobile.gui.components.Component;

public class ProgressBar
extends Component {
    protected int loaded;
    protected int loading;
    private boolean indeterminate;
    private Sprite sprite;

    public ProgressBar() {
        this.focusable = false;
        this.loaded = 100;
    }

    public ProgressBar(Sprite sp) {
        this();
        this.setSprite(sp);
    }

    public void setSprite(Sprite sp) {
        this.sprite = sp;
        this.loaded = this.sprite.getFrameSequenceLength() - 1;
    }

    public void paintComponent(Graphics2D g) {
        if (this.indeterminate) {
            Animation.registerAnimated(this);
        }
        if (this.sprite != null) {
            g.drawSprite(this.sprite, this.loading, (this.width - this.sprite.getWidth()) / 2, (this.height - this.sprite.getHeight()) / 2);
        } else {
            g.setColor(this.getForeground());
            if (this.indeterminate) {
                int thickness = 20;
                int pos = this.loading > this.loaded / 2 ? this.loaded - this.loading : this.loading;
                g.fillRect((this.width - thickness) * pos / (this.loaded / 2), 0, thickness, this.height);
            } else {
                g.fillRect(0, 0, this.width * this.loading / this.loaded, this.height);
            }
        }
    }

    public void animate() {
        this.loading = this.loading == this.loaded ? 0 : ++this.loading;
        this.repaint();
    }

    public void setIndeterminate(boolean v) {
        this.indeterminate = v;
        this.repaint();
    }

    public int getMaximum() {
        return this.loaded;
    }

    public void setMaximum(int max) {
        this.loaded = max;
    }

    public Object getValue() {
        return new Integer(this.loading);
    }

    public void setValue(int v) {
        this.loading = v;
    }

    protected void workoutMinimumSize() {
        if (this.sprite != null) {
            this.width = this.sprite.getWidth();
            this.height = this.sprite.getHeight();
        } else {
            this.height = 20;
            this.width = 50;
        }
    }

    public String getDefaultName() {
        return "ProgressBar";
    }

    public void updateUI() {
        super.updateUI();
        Sprite sp = (Sprite)this.theme.getProperty("sprite", 0);
        if (sp != null) {
            this.setSprite(sp);
        }
    }
}

