/*
 * Decompiled with CFR 0.152.
 */
package net.yura.mobile.gui.components;

import net.yura.mobile.gui.Font;
import net.yura.mobile.gui.Graphics2D;
import net.yura.mobile.gui.Icon;
import net.yura.mobile.gui.border.Border;
import net.yura.mobile.gui.components.Component;
import net.yura.mobile.gui.components.TextArea;
import net.yura.mobile.util.Option;

public class Label
extends Component {
    public static String extension = "...";
    protected Font font;
    protected String string;
    protected Icon icon;
    protected int padding = 2;
    protected int gap = 2;
    protected int alignment;
    protected int textPosition;

    public Label() {
        this((String)null);
    }

    public Label(String text) {
        this.focusable = false;
        this.string = text == null ? "" : text;
        this.alignment = 6;
        this.textPosition = 10;
    }

    public Label(Icon icon) {
        this();
        this.setIcon(icon);
        this.setHorizontalAlignment(1);
    }

    public Label(String text, Icon icon) {
        this(text);
        this.setIcon(icon);
    }

    public void setMargin(int padding) {
        this.padding = padding;
    }

    public int getMargin() {
        return this.padding;
    }

    protected void workoutMinimumSize() {
        int w = this.getCombinedWidth();
        int h = this.getCombinedHeight();
        if (w == 0 && h == 0) {
            this.width = 0;
            this.height = 0;
        } else {
            this.width = w + this.padding * 2;
            this.height = h + this.padding * 2;
            int max = this.getMaxWidth();
            if (this.width > max) {
                this.width = max;
            }
        }
    }

    public void paintComponent(Graphics2D g) {
        int x = this.padding;
        int y = this.padding;
        int iconWidth = this.getIconWidth();
        String drawString = this.string;
        if ("".equals(drawString)) {
            drawString = null;
        }
        int combinedwidth = this.getCombinedWidth();
        if (this.font != null && drawString != null && combinedwidth > this.width - this.padding * 2) {
            combinedwidth = this.width - this.padding * 2;
            int w = ((this.textPosition & 1) == 0 && iconWidth > 0 ? combinedwidth - iconWidth - this.gap : combinedwidth) - this.font.getWidth(extension);
            int a = TextArea.searchStringCharOffset(drawString, this.font, w);
            drawString = drawString.substring(0, a) + extension;
        }
        int combinedheight = this.getCombinedHeight();
        if ((this.alignment & 1) != 0) {
            x = (this.width - combinedwidth) / 2;
        } else if ((this.alignment & 8) != 0) {
            x = this.width - combinedwidth - this.padding;
        }
        if ((this.alignment & 2) != 0) {
            y = (this.height - combinedheight) / 2;
        } else if ((this.alignment & 0x20) != 0) {
            y = this.height - combinedheight - this.padding;
        }
        if (iconWidth > 0) {
            int ix = x;
            int iy = y;
            if ((this.textPosition & 1) != 0) {
                ix = x + (combinedwidth - iconWidth) / 2;
            } else if ((this.textPosition & 4) != 0 && this.font != null && drawString != null) {
                ix = x + this.font.getWidth(drawString) + this.gap;
            }
            if ((this.textPosition & 2) != 0 || (this.textPosition & 8) != 0 || (this.textPosition & 4) != 0) {
                iy = y + (combinedheight - this.getIconHeight()) / 2;
            } else if ((this.textPosition & 0x10) != 0 && this.font != null && drawString != null) {
                iy = y + this.font.getHeight() + this.gap;
            }
            this.paintIcon(g, ix, iy);
        }
        if (this.font != null && drawString != null) {
            int tx = x;
            int ty = y;
            if ((this.textPosition & 1) != 0) {
                tx = x + (combinedwidth - this.font.getWidth(drawString)) / 2;
            } else if ((this.textPosition & 8) != 0 && iconWidth > 0) {
                tx = x + iconWidth + this.gap;
            }
            if ((this.textPosition & 2) != 0) {
                ty = y + (combinedheight - this.font.getHeight()) / 2;
            } else if ((this.textPosition & 0x20) != 0 && iconWidth > 0) {
                ty = y + this.getIconHeight() + this.gap;
            }
            g.setColor(this.getForeground());
            g.setFont(this.font);
            g.drawString(drawString, tx, ty);
        }
    }

    protected void paintIcon(Graphics2D g, int x, int y) {
        this.getIcon().paintIcon(this, g, x, y);
    }

    protected int getCombinedWidth() {
        return this.getCombinedWidth(this.string, this.getIconWidth());
    }

    protected int getCombinedWidth(String string, int iconWidth) {
        int fw;
        int n = fw = this.font != null && string != null ? this.font.getWidth(string) : 0;
        if ((this.textPosition & 1) != 0) {
            if (iconWidth <= 0 && this.font == null) {
                return 0;
            }
            if (iconWidth > 0) {
                return iconWidth > fw ? iconWidth : fw;
            }
            return fw;
        }
        if (iconWidth > 0) {
            fw = (fw == 0 ? 0 : this.gap) + fw + iconWidth;
        }
        return fw;
    }

    protected int getCombinedHeight() {
        return this.getCombinedHeight(this.getIconHeight());
    }

    protected int getCombinedHeight(int iconHeight) {
        int fw;
        int n = fw = this.font != null && !"".equals(this.string) && this.string != null ? this.font.getHeight() : 0;
        if ((this.textPosition & 2) != 0 || (this.textPosition & 8) != 0 || (this.textPosition & 4) != 0) {
            if (iconHeight <= 0 && this.font == null) {
                return 0;
            }
            if (iconHeight > 0) {
                return iconHeight > fw ? iconHeight : fw;
            }
            return fw;
        }
        if (iconHeight > 0) {
            fw = (fw == 0 ? 0 : this.gap) + fw + iconHeight;
        }
        return fw;
    }

    public void setText(String a) {
        String oldValue = this.string;
        this.string = a;
        if (this.string == null || oldValue == null || !this.string.equals(oldValue)) {
            this.repaint();
        }
    }

    public String getText() {
        return this.string;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public Icon getIcon() {
        if (this.icon != null) {
            return this.icon;
        }
        return (Icon)this.theme.getProperty("icon", 0);
    }

    public void setIcon(Icon icon) {
        Icon oldValue = this.icon;
        this.icon = icon;
        if (this.icon != oldValue) {
            this.repaint();
        }
    }

    public void setHorizontalTextPosition(int a) {
        this.textPosition = this.getVerticalTextPosition() | a;
    }

    public void setVerticalTextPosition(int a) {
        this.textPosition = a | this.getHorizontalTextPosition();
    }

    public void setHorizontalAlignment(int a) {
        this.alignment = this.getVerticalAlignment() | a;
    }

    public void setVerticalAlignment(int a) {
        this.alignment = a | this.getHorizontalAlignment();
    }

    public void setIconTextGap(int iconTextGap) {
        this.gap = iconTextGap;
    }

    public int getHorizontalTextPosition() {
        return (this.textPosition & 4) != 0 ? 4 : ((this.textPosition & 8) != 0 ? 8 : 1);
    }

    public int getVerticalTextPosition() {
        return (this.textPosition & 0x10) != 0 ? 16 : ((this.textPosition & 0x20) != 0 ? 32 : 2);
    }

    public int getHorizontalAlignment() {
        return (this.alignment & 4) != 0 ? 4 : ((this.alignment & 8) != 0 ? 8 : 1);
    }

    public int getVerticalAlignment() {
        return (this.alignment & 0x10) != 0 ? 16 : ((this.alignment & 0x20) != 0 ? 32 : 2);
    }

    public void setValue(Object obj) {
        String drawString = null;
        Icon image = null;
        String tip = null;
        if (obj instanceof Option) {
            Option option = (Option)obj;
            drawString = option.getValue();
            image = option.getIcon();
            tip = option.getToolTip();
        } else if (obj != null) {
            drawString = String.valueOf(obj);
        }
        this.string = drawString;
        this.setIcon(image);
        this.setToolTipText(tip);
    }

    public int getMaxWidth() {
        Border b = this.getInsets();
        int resonableTextLength = this.getDesktopPane().getWidth() - (b.getLeft() + b.getRight());
        int minimumIconWidth = this.getIconWidth() + this.padding * 2;
        return Math.max(resonableTextLength, minimumIconWidth);
    }

    public void updateUI() {
        super.updateUI();
        this.font = this.theme.getFont(0);
        Integer iconTextGap = (Integer)this.theme.getProperty("iconTextGap", 0);
        if (iconTextGap != null) {
            this.gap = iconTextGap;
        }
    }

    private int getIconWidth() {
        Icon icon = this.getIcon();
        return icon != null ? icon.getIconWidth() : 0;
    }

    private int getIconHeight() {
        Icon icon = this.getIcon();
        return icon != null ? icon.getIconHeight() : 0;
    }

    protected String getDefaultName() {
        return "Label";
    }

    public String toString() {
        return super.toString() + "(" + this.string + ")";
    }
}

