/*
 * Decompiled with CFR 0.152.
 */
package net.yura.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.Document;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import net.yura.swing.TableSize;

public class YuraTextEditor
extends JPanel
implements ActionListener,
DocumentListener {
    private JLabel label;
    private JTextArea text;
    private JLabel preview;
    private JScrollPane scroll;
    private JToggleButton editb;
    private JToolBar tools;
    private TableSize pop;
    private String org;
    private Box toolbar;
    private UndoManager undo;
    private ActionListener myActionListener;

    public YuraTextEditor() {
        this.setLayout(new BorderLayout());
        this.label = new JLabel();
        this.text = new JTextArea();
        this.preview = new JLabel();
        this.text.setBackground(new Color(0, 0, 0, 0));
        Dimension size = new Dimension(80, 20);
        this.label.setMaximumSize(size);
        this.label.setMinimumSize(size);
        this.label.setPreferredSize(size);
        this.text.getDocument().addDocumentListener(this);
        this.text.setWrapStyleWord(true);
        this.text.setOpaque(false);
        this.toolbar = Box.createHorizontalBox();
        JToggleButton previewb = new JToggleButton("Preview");
        previewb.setActionCommand("preview");
        previewb.addActionListener(this);
        this.editb = new JToggleButton("   Edit   ");
        this.editb.setActionCommand("edit");
        this.editb.addActionListener(this);
        Insets insets = new Insets(0, 10, 0, 10);
        previewb.setMargin(insets);
        this.editb.setMargin(insets);
        ButtonGroup bg = new ButtonGroup();
        bg.add(previewb);
        bg.add(this.editb);
        this.toolbar.add(this.label);
        this.toolbar.add(this.editb);
        this.toolbar.add(previewb);
        this.toolbar.add(Box.createHorizontalGlue());
        this.add((Component)this.toolbar, "North");
        this.scroll = new JScrollPane(this.text);
        JPanel tmp = new JPanel(new BorderLayout());
        this.tools = new JToolBar();
        this.tools.setRollover(true);
        this.addSqButton("bold", "<html><b>B</b></html>");
        this.addSqButton("strike", "<html><s>S</s></html>");
        this.addSqButton("underline", "<html><u>U</u></html>");
        this.addSqButton("italic", "<html><i>I</i></html>");
        this.addSqButton("highlight", "<html><font style=\"background-color:yellow\">&nbsp;H&nbsp;</font></html>");
        this.addSqButton("color", "<html><font color=\"red\">F</font></html>");
        this.tools.addSeparator();
        this.addSqButton("bullet", "\u2022");
        this.addSqButton("list", "1.");
        this.tools.addSeparator();
        this.addSqButton("heading", "H1");
        this.addSqButton("heading2", "H2");
        this.addSqButton("link", "<html><a href=\"bob\">lnk</a></html>");
        this.addSqButton("image", new ImageIcon(YuraTextEditor.class.getResource("img.gif")));
        this.tools.addSeparator();
        JButton b = this.addButton("table", "table");
        this.tools.addSeparator();
        this.addSqButton("param", "{0}");
        this.pop = new TableSize();
        this.pop.addActionListener(this);
        tmp.add((Component)this.tools, "North");
        tmp.setBorder(BorderFactory.createLoweredBevelBorder());
        tmp.add(this.scroll);
        this.scroll.setBorder(null);
        this.add(tmp);
        this.setOpaque(false);
        tmp.setOpaque(false);
        this.scroll.setOpaque(false);
        this.scroll.getViewport().setOpaque(false);
        this.undo = new UndoManager();
        Document doc = this.text.getDocument();
        doc.addUndoableEditListener(new UndoableEditListener(){

            public void undoableEditHappened(UndoableEditEvent evt) {
                YuraTextEditor.this.undo.addEdit(evt.getEdit());
            }
        });
        this.text.getActionMap().put("Undo", new AbstractAction("Undo"){

            public void actionPerformed(ActionEvent evt) {
                try {
                    if (YuraTextEditor.this.undo.canUndo()) {
                        YuraTextEditor.this.undo.undo();
                    }
                }
                catch (CannotUndoException cannotUndoException) {
                    // empty catch block
                }
            }
        });
        this.text.getInputMap().put(KeyStroke.getKeyStroke("control Z"), "Undo");
        this.text.getActionMap().put("Redo", new AbstractAction("Redo"){

            public void actionPerformed(ActionEvent evt) {
                try {
                    if (YuraTextEditor.this.undo.canRedo()) {
                        YuraTextEditor.this.undo.redo();
                    }
                }
                catch (CannotRedoException cannotRedoException) {
                    // empty catch block
                }
            }
        });
        this.text.getInputMap().put(KeyStroke.getKeyStroke("control Y"), "Redo");
        final YuraTextEditor yep = this;
        this.text.getActionMap().put("Save", new AbstractAction("Save"){

            public void actionPerformed(ActionEvent evt) {
                yep.actionPerformed(new ActionEvent(evt.getSource(), evt.getID(), "save", evt.getWhen(), evt.getModifiers()));
            }
        });
        this.text.getInputMap().put(KeyStroke.getKeyStroke("control S"), "Save");
    }

    public Component add(AbstractButton comp) {
        comp.addActionListener(this);
        return this.toolbar.add(comp);
    }

    private JButton addButton(String a, Object s) {
        JButton b = s instanceof Icon ? new JButton((Icon)s) : new JButton(s.toString());
        b.setToolTipText(a);
        b.setActionCommand("format " + a);
        b.addActionListener(this);
        Dimension size = new Dimension(50, 25);
        b.setMinimumSize(size);
        b.setPreferredSize(size);
        b.setMaximumSize(size);
        b.setMargin(new Insets(0, 0, 0, 0));
        this.tools.add(b);
        return b;
    }

    private JButton addSqButton(String a, Object s) {
        JButton b = this.addButton(a, s);
        Dimension size = new Dimension(25, 25);
        b.setMinimumSize(size);
        b.setPreferredSize(size);
        b.setMaximumSize(size);
        return b;
    }

    public void insertUpdate(DocumentEvent e) {
        this.aChange();
    }

    public void removeUpdate(DocumentEvent e) {
        this.aChange();
    }

    public void changedUpdate(DocumentEvent e) {
    }

    private void aChange() {
        boolean changed;
        if (!this.text.isOpaque()) {
            this.text.setOpaque(true);
            this.text.repaint();
        }
        if ((changed = this.checkChange()) && this.text.getBackground().equals(Color.WHITE)) {
            this.text.setBackground(Color.PINK);
            this.text.repaint();
        }
        if (!changed && this.text.getBackground().equals(Color.PINK)) {
            this.text.setBackground(Color.WHITE);
            this.text.repaint();
        }
    }

    public boolean checkChange() {
        return this.org == null && this.text.isOpaque() || this.org != null && !this.text.getText().equals(this.org);
    }

    public void addActionListener(ActionListener l) {
        this.myActionListener = l;
    }

    public void actionPerformed(ActionEvent ae) {
        if (ae.getActionCommand().equals("preview")) {
            this.tools.setVisible(false);
            String thetext = this.text.getText();
            this.preview.setText(thetext);
            this.scroll.setViewportView(this.preview);
        } else if (ae.getActionCommand().equals("edit")) {
            this.tools.setVisible(true);
            this.scroll.setViewportView(this.text);
        } else if (ae.getActionCommand().equals("format bold")) {
            this.format("<b>", "</b>");
        } else if (ae.getActionCommand().equals("format strike")) {
            this.format("<s>", "</s>");
        } else if (ae.getActionCommand().equals("format underline")) {
            this.format("<u>", "</u>");
        } else if (ae.getActionCommand().equals("format italic")) {
            this.format("<i>", "</i>");
        } else if (ae.getActionCommand().equals("format highlight")) {
            this.format("<font style=\"background-color: yellow\">", "</font>");
        } else if (ae.getActionCommand().equals("format color")) {
            String a = JOptionPane.showInputDialog(this, (Object)"colour:");
            if (a != null) {
                this.format("<font color=\"" + a + "\">", "</font>");
            }
        } else if (ae.getActionCommand().equals("format bullet")) {
            this.lineformatHTML("ul", "li");
        } else if (ae.getActionCommand().equals("format list")) {
            this.lineformatHTML("ol", "li");
        } else if (ae.getActionCommand().equals("format heading")) {
            this.format("<h1>", "</h1>");
        } else if (ae.getActionCommand().equals("format heading2")) {
            this.format("<h2>", "</h2>");
        } else if (ae.getActionCommand().equals("format link")) {
            Object[] options;
            Object[] message = new Object[]{"label:", new JTextField(this.text.getSelectedText()), "URL:", new JTextField()};
            int result = JOptionPane.showOptionDialog(null, message, "insert link", 2, 3, null, options = new String[]{"OK", "cancel"}, options[0]);
            if (result == 0) {
                String s1 = ((JTextField)message[1]).getText();
                String s2 = ((JTextField)message[3]).getText();
                this.insert("<a href=\"" + s2 + "\">" + (s1.equals("") ? s2 : s1) + "</a>");
            }
        } else if (ae.getActionCommand().equals("format image")) {
            Object[] options;
            Object[] message = new Object[]{"alt text:", new JTextField(this.text.getSelectedText()), "URL:", new JTextField()};
            int result = JOptionPane.showOptionDialog(null, message, "insert image", 2, 3, null, options = new String[]{"OK", "cancel"}, options[0]);
            if (result == 0) {
                String s1 = ((JTextField)message[1]).getText();
                String s2 = ((JTextField)message[3]).getText();
                this.insert("<img src=\"" + s2 + "\" alt=\"" + s1 + "\">");
            }
        } else if (ae.getActionCommand().equals("format param")) {
            String a = JOptionPane.showInputDialog(this, (Object)"number:");
            if (a != null) {
                this.insert("{" + a + "}");
            }
        } else if (ae.getActionCommand().equals("format table")) {
            Component component = (Component)ae.getSource();
            Point point = component.getLocationOnScreen();
            this.pop.setSize(100, 100);
            this.pop.setLocation(point.x, point.y + component.getHeight());
            this.pop.showPopup();
        } else if (ae.getActionCommand().equals("yuratable")) {
            Dimension d = ((TableSize)ae.getSource()).getTableSize();
            String st = this.text.getSelectedText();
            if (st == null) {
                st = "";
            }
            StringBuffer sb = new StringBuffer();
            sb.append("<table>\n");
            for (int y = 0; y < d.height; ++y) {
                sb.append("  <tr>\n");
                for (int x = 0; x < d.width; ++x) {
                    sb.append("    <td>");
                    if (x == 0 && y == 0) {
                        sb.append(st);
                    }
                    sb.append("</td>\n");
                }
                sb.append("  </tr>\n");
            }
            sb.append("</table>");
            this.insert(sb.toString());
        } else {
            this.myActionListener.actionPerformed(new ActionEvent(this, ae.getID(), ae.getActionCommand(), ae.getWhen(), ae.getModifiers()));
        }
    }

    private void format(String s) {
        this.format(s, s);
    }

    private void format(String s, String a) {
        String st = this.text.getSelectedText();
        if (st == null) {
            st = "";
        }
        this.text.replaceSelection(s + st + a);
        this.text.setCaretPosition(this.text.getCaretPosition() - a.length() - st.length());
        this.text.moveCaretPosition(this.text.getCaretPosition() + st.length());
        this.text.grabFocus();
    }

    private void lineformat(String s) {
        try {
            int sline = this.text.getLineOfOffset(this.text.getSelectionStart());
            int fline = this.text.getLineOfOffset(this.text.getSelectionEnd());
            for (int a = sline; a <= fline; ++a) {
                this.text.insert(s + " ", this.text.getLineStartOffset(a));
            }
            this.text.grabFocus();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void lineformatHTML(String s, String b) {
        try {
            int sline = this.text.getLineOfOffset(this.text.getSelectionStart());
            int fline = this.text.getLineOfOffset(this.text.getSelectionEnd());
            int num = this.text.getLineCount() - 1;
            for (int a = sline; a <= fline; ++a) {
                this.text.insert("  <" + b + ">", this.text.getLineStartOffset(a));
                int c = this.text.getLineEndOffset(a);
                if (a != num) {
                    --c;
                }
                this.text.insert("</" + b + ">", c);
            }
            int c = this.text.getLineEndOffset(fline);
            if (fline != num) {
                --c;
            }
            this.text.insert("\n</" + s + ">", c);
            this.text.insert("<" + s + ">\n", this.text.getLineStartOffset(sline));
            this.text.grabFocus();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void insert(String a) {
        this.text.replaceSelection(a);
        this.text.grabFocus();
    }

    public void setText(String b) {
        this.org = b;
        this.text.setBackground(Color.WHITE);
        this.text.setText(b);
        this.text.setOpaque(b != null);
        this.text.repaint();
        this.editb.doClick();
        this.undo.discardAllEdits();
    }

    public boolean isEditMode() {
        return this.editb.isSelected();
    }

    public String getText() {
        return this.text.getText();
    }

    public void revert() {
        this.setText(this.org);
    }

    public void setLabel(String a) {
        this.label.setText(a);
    }

    public void setWrap(boolean a) {
        this.text.setLineWrap(a);
    }

    public void setTextLocale(Locale l) {
        ComponentOrientation orientation = ComponentOrientation.getOrientation(l);
        this.text.applyComponentOrientation(orientation);
        this.preview.applyComponentOrientation(orientation);
    }
}

