# -*- coding: utf-8 -*-
from operator import attrgetter
from pyangbind.lib.yangtypes import RestrictedPrecisionDecimalType
from pyangbind.lib.yangtypes import RestrictedClassType
from pyangbind.lib.yangtypes import TypedListType
from pyangbind.lib.yangtypes import YANGBool
from pyangbind.lib.yangtypes import YANGListType
from pyangbind.lib.yangtypes import YANGDynClass
from pyangbind.lib.yangtypes import ReferenceType
from pyangbind.lib.base import PybindBase
from collections import OrderedDict
from decimal import Decimal
from bitarray import bitarray
import six

# PY3 support of some PY2 keywords (needs improved)
if six.PY3:
  import builtins as __builtin__
  long = int
elif six.PY2:
  import __builtin__

class yc_config_openconfig_lldp__lldp_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-lldp - based on the path /lldp/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration data 
  """
  __slots__ = ('_path_helper', '_extmethods', '__enabled','__hello_timer','__suppress_tlv_advertisement','__system_name','__system_description','__chassis_id','__chassis_id_type',)

  _yang_name = 'config'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__enabled = YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='boolean', is_config=True)
    self.__hello_timer = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="hello-timer", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='uint64', is_config=True)
    self.__suppress_tlv_advertisement = YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'CHASSIS_ID': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'oc-lldp-types:CHASSIS_ID': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'PORT_ID': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'oc-lldp-types:PORT_ID': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'PORT_DESCRIPTION': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'oc-lldp-types:PORT_DESCRIPTION': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'SYSTEM_NAME': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'oc-lldp-types:SYSTEM_NAME': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'SYSTEM_DESCRIPTION': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'oc-lldp-types:SYSTEM_DESCRIPTION': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'SYSTEM_CAPABILITIES': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'oc-lldp-types:SYSTEM_CAPABILITIES': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'MANAGEMENT_ADDRESS': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'oc-lldp-types:MANAGEMENT_ADDRESS': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}},)), is_leaf=False, yang_name="suppress-tlv-advertisement", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='identityref', is_config=True)
    self.__system_name = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'length': ['0..255']}), is_leaf=True, yang_name="system-name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='string', is_config=True)
    self.__system_description = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'length': ['0..255']}), is_leaf=True, yang_name="system-description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='string', is_config=True)
    self.__chassis_id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="chassis-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='string', is_config=True)
    self.__chassis_id_type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'CHASSIS_COMPONENT': {}, 'INTERFACE_ALIAS': {}, 'PORT_COMPONENT': {}, 'MAC_ADDRESS': {}, 'NETWORK_ADDRESS': {}, 'INTERFACE_NAME': {}, 'LOCAL': {}},), is_leaf=True, yang_name="chassis-id-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='oc-lldp-types:chassis-id-type', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['lldp', 'config']

  def _get_enabled(self):
    """
    Getter method for enabled, mapped from YANG variable /lldp/config/enabled (boolean)

    YANG Description: System level state of the LLDP protocol.
    """
    return self.__enabled
      
  def _set_enabled(self, v, load=False):
    """
    Setter method for enabled, mapped from YANG variable /lldp/config/enabled (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_enabled is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_enabled() directly.

    YANG Description: System level state of the LLDP protocol.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='boolean', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """enabled must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='boolean', is_config=True)""",
        })

    self.__enabled = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_enabled(self):
    self.__enabled = YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='boolean', is_config=True)


  def _get_hello_timer(self):
    """
    Getter method for hello_timer, mapped from YANG variable /lldp/config/hello_timer (uint64)

    YANG Description: System level hello timer for the LLDP protocol.
    """
    return self.__hello_timer
      
  def _set_hello_timer(self, v, load=False):
    """
    Setter method for hello_timer, mapped from YANG variable /lldp/config/hello_timer (uint64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_hello_timer is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_hello_timer() directly.

    YANG Description: System level hello timer for the LLDP protocol.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="hello-timer", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='uint64', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """hello_timer must be of a type compatible with uint64""",
          'defined-type': "uint64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="hello-timer", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='uint64', is_config=True)""",
        })

    self.__hello_timer = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_hello_timer(self):
    self.__hello_timer = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="hello-timer", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='uint64', is_config=True)


  def _get_suppress_tlv_advertisement(self):
    """
    Getter method for suppress_tlv_advertisement, mapped from YANG variable /lldp/config/suppress_tlv_advertisement (identityref)

    YANG Description: Indicates whether the local system should suppress the
advertisement of particular TLVs with the LLDP PDUs that it
transmits. Where a TLV type is specified within this list, it
should not be included in any LLDP PDU transmitted by the
local agent.
    """
    return self.__suppress_tlv_advertisement
      
  def _set_suppress_tlv_advertisement(self, v, load=False):
    """
    Setter method for suppress_tlv_advertisement, mapped from YANG variable /lldp/config/suppress_tlv_advertisement (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_suppress_tlv_advertisement is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_suppress_tlv_advertisement() directly.

    YANG Description: Indicates whether the local system should suppress the
advertisement of particular TLVs with the LLDP PDUs that it
transmits. Where a TLV type is specified within this list, it
should not be included in any LLDP PDU transmitted by the
local agent.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'CHASSIS_ID': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'oc-lldp-types:CHASSIS_ID': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'PORT_ID': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'oc-lldp-types:PORT_ID': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'PORT_DESCRIPTION': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'oc-lldp-types:PORT_DESCRIPTION': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'SYSTEM_NAME': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'oc-lldp-types:SYSTEM_NAME': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'SYSTEM_DESCRIPTION': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'oc-lldp-types:SYSTEM_DESCRIPTION': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'SYSTEM_CAPABILITIES': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'oc-lldp-types:SYSTEM_CAPABILITIES': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'MANAGEMENT_ADDRESS': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'oc-lldp-types:MANAGEMENT_ADDRESS': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}},)), is_leaf=False, yang_name="suppress-tlv-advertisement", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='identityref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """suppress_tlv_advertisement must be of a type compatible with identityref""",
          'defined-type': "openconfig-lldp:identityref",
          'generated-type': """YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'CHASSIS_ID': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'oc-lldp-types:CHASSIS_ID': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'PORT_ID': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'oc-lldp-types:PORT_ID': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'PORT_DESCRIPTION': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'oc-lldp-types:PORT_DESCRIPTION': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'SYSTEM_NAME': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'oc-lldp-types:SYSTEM_NAME': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'SYSTEM_DESCRIPTION': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'oc-lldp-types:SYSTEM_DESCRIPTION': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'SYSTEM_CAPABILITIES': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'oc-lldp-types:SYSTEM_CAPABILITIES': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'MANAGEMENT_ADDRESS': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'oc-lldp-types:MANAGEMENT_ADDRESS': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}},)), is_leaf=False, yang_name="suppress-tlv-advertisement", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='identityref', is_config=True)""",
        })

    self.__suppress_tlv_advertisement = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_suppress_tlv_advertisement(self):
    self.__suppress_tlv_advertisement = YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'CHASSIS_ID': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'oc-lldp-types:CHASSIS_ID': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'PORT_ID': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'oc-lldp-types:PORT_ID': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'PORT_DESCRIPTION': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'oc-lldp-types:PORT_DESCRIPTION': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'SYSTEM_NAME': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'oc-lldp-types:SYSTEM_NAME': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'SYSTEM_DESCRIPTION': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'oc-lldp-types:SYSTEM_DESCRIPTION': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'SYSTEM_CAPABILITIES': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'oc-lldp-types:SYSTEM_CAPABILITIES': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'MANAGEMENT_ADDRESS': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'oc-lldp-types:MANAGEMENT_ADDRESS': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}},)), is_leaf=False, yang_name="suppress-tlv-advertisement", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='identityref', is_config=True)


  def _get_system_name(self):
    """
    Getter method for system_name, mapped from YANG variable /lldp/config/system_name (string)

    YANG Description: The system name field shall contain an alpha-numeric string
that indicates the system's administratively assigned name.
The system name should be the system's fully qualified domain
name. If implementations support IETF RFC 3418, the sysName
object should be used for this field.
    """
    return self.__system_name
      
  def _set_system_name(self, v, load=False):
    """
    Setter method for system_name, mapped from YANG variable /lldp/config/system_name (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_system_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_system_name() directly.

    YANG Description: The system name field shall contain an alpha-numeric string
that indicates the system's administratively assigned name.
The system name should be the system's fully qualified domain
name. If implementations support IETF RFC 3418, the sysName
object should be used for this field.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'length': ['0..255']}), is_leaf=True, yang_name="system-name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='string', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """system_name must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'length': ['0..255']}), is_leaf=True, yang_name="system-name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='string', is_config=True)""",
        })

    self.__system_name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_system_name(self):
    self.__system_name = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'length': ['0..255']}), is_leaf=True, yang_name="system-name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='string', is_config=True)


  def _get_system_description(self):
    """
    Getter method for system_description, mapped from YANG variable /lldp/config/system_description (string)

    YANG Description: The system description field shall contain an alpha-numeric
string that is the textual description of the network entity.
The system description should include the full name and
version identification of the system's hardware type,
software operating system, and networking software. If
implementations support IETF RFC 3418, the sysDescr object
should be used for this field.
    """
    return self.__system_description
      
  def _set_system_description(self, v, load=False):
    """
    Setter method for system_description, mapped from YANG variable /lldp/config/system_description (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_system_description is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_system_description() directly.

    YANG Description: The system description field shall contain an alpha-numeric
string that is the textual description of the network entity.
The system description should include the full name and
version identification of the system's hardware type,
software operating system, and networking software. If
implementations support IETF RFC 3418, the sysDescr object
should be used for this field.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'length': ['0..255']}), is_leaf=True, yang_name="system-description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='string', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """system_description must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'length': ['0..255']}), is_leaf=True, yang_name="system-description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='string', is_config=True)""",
        })

    self.__system_description = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_system_description(self):
    self.__system_description = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'length': ['0..255']}), is_leaf=True, yang_name="system-description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='string', is_config=True)


  def _get_chassis_id(self):
    """
    Getter method for chassis_id, mapped from YANG variable /lldp/config/chassis_id (string)

    YANG Description: The Chassis ID is a mandatory TLV which identifies the
chassis component of the endpoint identifier associated with
the transmitting LLDP agent
    """
    return self.__chassis_id
      
  def _set_chassis_id(self, v, load=False):
    """
    Setter method for chassis_id, mapped from YANG variable /lldp/config/chassis_id (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_chassis_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_chassis_id() directly.

    YANG Description: The Chassis ID is a mandatory TLV which identifies the
chassis component of the endpoint identifier associated with
the transmitting LLDP agent
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="chassis-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='string', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """chassis_id must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="chassis-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='string', is_config=True)""",
        })

    self.__chassis_id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_chassis_id(self):
    self.__chassis_id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="chassis-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='string', is_config=True)


  def _get_chassis_id_type(self):
    """
    Getter method for chassis_id_type, mapped from YANG variable /lldp/config/chassis_id_type (oc-lldp-types:chassis-id-type)

    YANG Description: This field identifies the format and source of the chassis
identifier string. It is an enumerator defined by the
LldpChassisIdSubtype object from IEEE 802.1AB MIB.
    """
    return self.__chassis_id_type
      
  def _set_chassis_id_type(self, v, load=False):
    """
    Setter method for chassis_id_type, mapped from YANG variable /lldp/config/chassis_id_type (oc-lldp-types:chassis-id-type)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_chassis_id_type is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_chassis_id_type() directly.

    YANG Description: This field identifies the format and source of the chassis
identifier string. It is an enumerator defined by the
LldpChassisIdSubtype object from IEEE 802.1AB MIB.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'CHASSIS_COMPONENT': {}, 'INTERFACE_ALIAS': {}, 'PORT_COMPONENT': {}, 'MAC_ADDRESS': {}, 'NETWORK_ADDRESS': {}, 'INTERFACE_NAME': {}, 'LOCAL': {}},), is_leaf=True, yang_name="chassis-id-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='oc-lldp-types:chassis-id-type', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """chassis_id_type must be of a type compatible with oc-lldp-types:chassis-id-type""",
          'defined-type': "oc-lldp-types:chassis-id-type",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'CHASSIS_COMPONENT': {}, 'INTERFACE_ALIAS': {}, 'PORT_COMPONENT': {}, 'MAC_ADDRESS': {}, 'NETWORK_ADDRESS': {}, 'INTERFACE_NAME': {}, 'LOCAL': {}},), is_leaf=True, yang_name="chassis-id-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='oc-lldp-types:chassis-id-type', is_config=True)""",
        })

    self.__chassis_id_type = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_chassis_id_type(self):
    self.__chassis_id_type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'CHASSIS_COMPONENT': {}, 'INTERFACE_ALIAS': {}, 'PORT_COMPONENT': {}, 'MAC_ADDRESS': {}, 'NETWORK_ADDRESS': {}, 'INTERFACE_NAME': {}, 'LOCAL': {}},), is_leaf=True, yang_name="chassis-id-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='oc-lldp-types:chassis-id-type', is_config=True)

  enabled = __builtin__.property(_get_enabled, _set_enabled)
  hello_timer = __builtin__.property(_get_hello_timer, _set_hello_timer)
  suppress_tlv_advertisement = __builtin__.property(_get_suppress_tlv_advertisement, _set_suppress_tlv_advertisement)
  system_name = __builtin__.property(_get_system_name, _set_system_name)
  system_description = __builtin__.property(_get_system_description, _set_system_description)
  chassis_id = __builtin__.property(_get_chassis_id, _set_chassis_id)
  chassis_id_type = __builtin__.property(_get_chassis_id_type, _set_chassis_id_type)


  _pyangbind_elements = OrderedDict([('enabled', enabled), ('hello_timer', hello_timer), ('suppress_tlv_advertisement', suppress_tlv_advertisement), ('system_name', system_name), ('system_description', system_description), ('chassis_id', chassis_id), ('chassis_id_type', chassis_id_type), ])


class yc_counters_openconfig_lldp__lldp_state_counters(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-lldp - based on the path /lldp/state/counters. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Global LLDP counters
  """
  __slots__ = ('_path_helper', '_extmethods', '__frame_in','__frame_out','__frame_error_in','__frame_discard','__tlv_discard','__tlv_unknown','__last_clear','__tlv_accepted','__entries_aged_out',)

  _yang_name = 'counters'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__frame_in = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="frame-in", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='yang:counter64', is_config=False)
    self.__frame_out = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="frame-out", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='yang:counter64', is_config=False)
    self.__frame_error_in = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="frame-error-in", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='yang:counter64', is_config=False)
    self.__frame_discard = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="frame-discard", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='yang:counter64', is_config=False)
    self.__tlv_discard = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="tlv-discard", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='yang:counter64', is_config=False)
    self.__tlv_unknown = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="tlv-unknown", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='yang:counter64', is_config=False)
    self.__last_clear = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}(\\.\\d+)?(Z|[\\+\\-]\\d{2}:\\d{2})'}), is_leaf=True, yang_name="last-clear", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='yang:date-and-time', is_config=False)
    self.__tlv_accepted = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="tlv-accepted", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='yang:counter64', is_config=False)
    self.__entries_aged_out = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="entries-aged-out", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='yang:counter64', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['lldp', 'state', 'counters']

  def _get_frame_in(self):
    """
    Getter method for frame_in, mapped from YANG variable /lldp/state/counters/frame_in (yang:counter64)

    YANG Description: The number of lldp frames received.
    """
    return self.__frame_in
      
  def _set_frame_in(self, v, load=False):
    """
    Setter method for frame_in, mapped from YANG variable /lldp/state/counters/frame_in (yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_frame_in is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_frame_in() directly.

    YANG Description: The number of lldp frames received.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="frame-in", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """frame_in must be of a type compatible with yang:counter64""",
          'defined-type': "yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="frame-in", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='yang:counter64', is_config=False)""",
        })

    self.__frame_in = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_frame_in(self):
    self.__frame_in = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="frame-in", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='yang:counter64', is_config=False)


  def _get_frame_out(self):
    """
    Getter method for frame_out, mapped from YANG variable /lldp/state/counters/frame_out (yang:counter64)

    YANG Description: The number of frames transmitted out.
    """
    return self.__frame_out
      
  def _set_frame_out(self, v, load=False):
    """
    Setter method for frame_out, mapped from YANG variable /lldp/state/counters/frame_out (yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_frame_out is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_frame_out() directly.

    YANG Description: The number of frames transmitted out.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="frame-out", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """frame_out must be of a type compatible with yang:counter64""",
          'defined-type': "yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="frame-out", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='yang:counter64', is_config=False)""",
        })

    self.__frame_out = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_frame_out(self):
    self.__frame_out = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="frame-out", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='yang:counter64', is_config=False)


  def _get_frame_error_in(self):
    """
    Getter method for frame_error_in, mapped from YANG variable /lldp/state/counters/frame_error_in (yang:counter64)

    YANG Description: The number of LLDP frames received with errors.
    """
    return self.__frame_error_in
      
  def _set_frame_error_in(self, v, load=False):
    """
    Setter method for frame_error_in, mapped from YANG variable /lldp/state/counters/frame_error_in (yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_frame_error_in is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_frame_error_in() directly.

    YANG Description: The number of LLDP frames received with errors.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="frame-error-in", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """frame_error_in must be of a type compatible with yang:counter64""",
          'defined-type': "yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="frame-error-in", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='yang:counter64', is_config=False)""",
        })

    self.__frame_error_in = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_frame_error_in(self):
    self.__frame_error_in = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="frame-error-in", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='yang:counter64', is_config=False)


  def _get_frame_discard(self):
    """
    Getter method for frame_discard, mapped from YANG variable /lldp/state/counters/frame_discard (yang:counter64)

    YANG Description: The number of LLDP frames received and discarded.
    """
    return self.__frame_discard
      
  def _set_frame_discard(self, v, load=False):
    """
    Setter method for frame_discard, mapped from YANG variable /lldp/state/counters/frame_discard (yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_frame_discard is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_frame_discard() directly.

    YANG Description: The number of LLDP frames received and discarded.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="frame-discard", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """frame_discard must be of a type compatible with yang:counter64""",
          'defined-type': "yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="frame-discard", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='yang:counter64', is_config=False)""",
        })

    self.__frame_discard = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_frame_discard(self):
    self.__frame_discard = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="frame-discard", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='yang:counter64', is_config=False)


  def _get_tlv_discard(self):
    """
    Getter method for tlv_discard, mapped from YANG variable /lldp/state/counters/tlv_discard (yang:counter64)

    YANG Description: The number of TLV frames received and discarded.
    """
    return self.__tlv_discard
      
  def _set_tlv_discard(self, v, load=False):
    """
    Setter method for tlv_discard, mapped from YANG variable /lldp/state/counters/tlv_discard (yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_tlv_discard is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_tlv_discard() directly.

    YANG Description: The number of TLV frames received and discarded.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="tlv-discard", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """tlv_discard must be of a type compatible with yang:counter64""",
          'defined-type': "yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="tlv-discard", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='yang:counter64', is_config=False)""",
        })

    self.__tlv_discard = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_tlv_discard(self):
    self.__tlv_discard = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="tlv-discard", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='yang:counter64', is_config=False)


  def _get_tlv_unknown(self):
    """
    Getter method for tlv_unknown, mapped from YANG variable /lldp/state/counters/tlv_unknown (yang:counter64)

    YANG Description: The number of frames received with unknown TLV.
    """
    return self.__tlv_unknown
      
  def _set_tlv_unknown(self, v, load=False):
    """
    Setter method for tlv_unknown, mapped from YANG variable /lldp/state/counters/tlv_unknown (yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_tlv_unknown is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_tlv_unknown() directly.

    YANG Description: The number of frames received with unknown TLV.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="tlv-unknown", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """tlv_unknown must be of a type compatible with yang:counter64""",
          'defined-type': "yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="tlv-unknown", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='yang:counter64', is_config=False)""",
        })

    self.__tlv_unknown = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_tlv_unknown(self):
    self.__tlv_unknown = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="tlv-unknown", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='yang:counter64', is_config=False)


  def _get_last_clear(self):
    """
    Getter method for last_clear, mapped from YANG variable /lldp/state/counters/last_clear (yang:date-and-time)

    YANG Description: Indicates the last time the counters were
cleared.
    """
    return self.__last_clear
      
  def _set_last_clear(self, v, load=False):
    """
    Setter method for last_clear, mapped from YANG variable /lldp/state/counters/last_clear (yang:date-and-time)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_last_clear is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_last_clear() directly.

    YANG Description: Indicates the last time the counters were
cleared.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}(\\.\\d+)?(Z|[\\+\\-]\\d{2}:\\d{2})'}), is_leaf=True, yang_name="last-clear", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='yang:date-and-time', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """last_clear must be of a type compatible with yang:date-and-time""",
          'defined-type': "yang:date-and-time",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}(\\.\\d+)?(Z|[\\+\\-]\\d{2}:\\d{2})'}), is_leaf=True, yang_name="last-clear", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='yang:date-and-time', is_config=False)""",
        })

    self.__last_clear = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_last_clear(self):
    self.__last_clear = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}(\\.\\d+)?(Z|[\\+\\-]\\d{2}:\\d{2})'}), is_leaf=True, yang_name="last-clear", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='yang:date-and-time', is_config=False)


  def _get_tlv_accepted(self):
    """
    Getter method for tlv_accepted, mapped from YANG variable /lldp/state/counters/tlv_accepted (yang:counter64)

    YANG Description: The number of valid TLVs received.
    """
    return self.__tlv_accepted
      
  def _set_tlv_accepted(self, v, load=False):
    """
    Setter method for tlv_accepted, mapped from YANG variable /lldp/state/counters/tlv_accepted (yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_tlv_accepted is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_tlv_accepted() directly.

    YANG Description: The number of valid TLVs received.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="tlv-accepted", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """tlv_accepted must be of a type compatible with yang:counter64""",
          'defined-type': "yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="tlv-accepted", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='yang:counter64', is_config=False)""",
        })

    self.__tlv_accepted = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_tlv_accepted(self):
    self.__tlv_accepted = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="tlv-accepted", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='yang:counter64', is_config=False)


  def _get_entries_aged_out(self):
    """
    Getter method for entries_aged_out, mapped from YANG variable /lldp/state/counters/entries_aged_out (yang:counter64)

    YANG Description: The number of entries aged out due to timeout.
    """
    return self.__entries_aged_out
      
  def _set_entries_aged_out(self, v, load=False):
    """
    Setter method for entries_aged_out, mapped from YANG variable /lldp/state/counters/entries_aged_out (yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_entries_aged_out is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_entries_aged_out() directly.

    YANG Description: The number of entries aged out due to timeout.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="entries-aged-out", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """entries_aged_out must be of a type compatible with yang:counter64""",
          'defined-type': "yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="entries-aged-out", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='yang:counter64', is_config=False)""",
        })

    self.__entries_aged_out = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_entries_aged_out(self):
    self.__entries_aged_out = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="entries-aged-out", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='yang:counter64', is_config=False)

  frame_in = __builtin__.property(_get_frame_in)
  frame_out = __builtin__.property(_get_frame_out)
  frame_error_in = __builtin__.property(_get_frame_error_in)
  frame_discard = __builtin__.property(_get_frame_discard)
  tlv_discard = __builtin__.property(_get_tlv_discard)
  tlv_unknown = __builtin__.property(_get_tlv_unknown)
  last_clear = __builtin__.property(_get_last_clear)
  tlv_accepted = __builtin__.property(_get_tlv_accepted)
  entries_aged_out = __builtin__.property(_get_entries_aged_out)


  _pyangbind_elements = OrderedDict([('frame_in', frame_in), ('frame_out', frame_out), ('frame_error_in', frame_error_in), ('frame_discard', frame_discard), ('tlv_discard', tlv_discard), ('tlv_unknown', tlv_unknown), ('last_clear', last_clear), ('tlv_accepted', tlv_accepted), ('entries_aged_out', entries_aged_out), ])


class yc_state_openconfig_lldp__lldp_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-lldp - based on the path /lldp/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state data 
  """
  __slots__ = ('_path_helper', '_extmethods', '__enabled','__hello_timer','__suppress_tlv_advertisement','__system_name','__system_description','__chassis_id','__chassis_id_type','__counters',)

  _yang_name = 'state'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__enabled = YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='boolean', is_config=False)
    self.__hello_timer = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="hello-timer", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='uint64', is_config=False)
    self.__suppress_tlv_advertisement = YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'CHASSIS_ID': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'oc-lldp-types:CHASSIS_ID': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'PORT_ID': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'oc-lldp-types:PORT_ID': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'PORT_DESCRIPTION': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'oc-lldp-types:PORT_DESCRIPTION': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'SYSTEM_NAME': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'oc-lldp-types:SYSTEM_NAME': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'SYSTEM_DESCRIPTION': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'oc-lldp-types:SYSTEM_DESCRIPTION': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'SYSTEM_CAPABILITIES': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'oc-lldp-types:SYSTEM_CAPABILITIES': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'MANAGEMENT_ADDRESS': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'oc-lldp-types:MANAGEMENT_ADDRESS': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}},)), is_leaf=False, yang_name="suppress-tlv-advertisement", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='identityref', is_config=False)
    self.__system_name = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'length': ['0..255']}), is_leaf=True, yang_name="system-name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='string', is_config=False)
    self.__system_description = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'length': ['0..255']}), is_leaf=True, yang_name="system-description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='string', is_config=False)
    self.__chassis_id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="chassis-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='string', is_config=False)
    self.__chassis_id_type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'CHASSIS_COMPONENT': {}, 'INTERFACE_ALIAS': {}, 'PORT_COMPONENT': {}, 'MAC_ADDRESS': {}, 'NETWORK_ADDRESS': {}, 'INTERFACE_NAME': {}, 'LOCAL': {}},), is_leaf=True, yang_name="chassis-id-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='oc-lldp-types:chassis-id-type', is_config=False)
    self.__counters = YANGDynClass(base=yc_counters_openconfig_lldp__lldp_state_counters, is_container='container', yang_name="counters", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='container', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['lldp', 'state']

  def _get_enabled(self):
    """
    Getter method for enabled, mapped from YANG variable /lldp/state/enabled (boolean)

    YANG Description: System level state of the LLDP protocol.
    """
    return self.__enabled
      
  def _set_enabled(self, v, load=False):
    """
    Setter method for enabled, mapped from YANG variable /lldp/state/enabled (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_enabled is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_enabled() directly.

    YANG Description: System level state of the LLDP protocol.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='boolean', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """enabled must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='boolean', is_config=False)""",
        })

    self.__enabled = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_enabled(self):
    self.__enabled = YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='boolean', is_config=False)


  def _get_hello_timer(self):
    """
    Getter method for hello_timer, mapped from YANG variable /lldp/state/hello_timer (uint64)

    YANG Description: System level hello timer for the LLDP protocol.
    """
    return self.__hello_timer
      
  def _set_hello_timer(self, v, load=False):
    """
    Setter method for hello_timer, mapped from YANG variable /lldp/state/hello_timer (uint64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_hello_timer is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_hello_timer() directly.

    YANG Description: System level hello timer for the LLDP protocol.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="hello-timer", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='uint64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """hello_timer must be of a type compatible with uint64""",
          'defined-type': "uint64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="hello-timer", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='uint64', is_config=False)""",
        })

    self.__hello_timer = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_hello_timer(self):
    self.__hello_timer = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="hello-timer", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='uint64', is_config=False)


  def _get_suppress_tlv_advertisement(self):
    """
    Getter method for suppress_tlv_advertisement, mapped from YANG variable /lldp/state/suppress_tlv_advertisement (identityref)

    YANG Description: Indicates whether the local system should suppress the
advertisement of particular TLVs with the LLDP PDUs that it
transmits. Where a TLV type is specified within this list, it
should not be included in any LLDP PDU transmitted by the
local agent.
    """
    return self.__suppress_tlv_advertisement
      
  def _set_suppress_tlv_advertisement(self, v, load=False):
    """
    Setter method for suppress_tlv_advertisement, mapped from YANG variable /lldp/state/suppress_tlv_advertisement (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_suppress_tlv_advertisement is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_suppress_tlv_advertisement() directly.

    YANG Description: Indicates whether the local system should suppress the
advertisement of particular TLVs with the LLDP PDUs that it
transmits. Where a TLV type is specified within this list, it
should not be included in any LLDP PDU transmitted by the
local agent.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'CHASSIS_ID': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'oc-lldp-types:CHASSIS_ID': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'PORT_ID': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'oc-lldp-types:PORT_ID': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'PORT_DESCRIPTION': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'oc-lldp-types:PORT_DESCRIPTION': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'SYSTEM_NAME': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'oc-lldp-types:SYSTEM_NAME': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'SYSTEM_DESCRIPTION': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'oc-lldp-types:SYSTEM_DESCRIPTION': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'SYSTEM_CAPABILITIES': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'oc-lldp-types:SYSTEM_CAPABILITIES': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'MANAGEMENT_ADDRESS': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'oc-lldp-types:MANAGEMENT_ADDRESS': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}},)), is_leaf=False, yang_name="suppress-tlv-advertisement", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='identityref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """suppress_tlv_advertisement must be of a type compatible with identityref""",
          'defined-type': "openconfig-lldp:identityref",
          'generated-type': """YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'CHASSIS_ID': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'oc-lldp-types:CHASSIS_ID': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'PORT_ID': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'oc-lldp-types:PORT_ID': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'PORT_DESCRIPTION': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'oc-lldp-types:PORT_DESCRIPTION': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'SYSTEM_NAME': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'oc-lldp-types:SYSTEM_NAME': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'SYSTEM_DESCRIPTION': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'oc-lldp-types:SYSTEM_DESCRIPTION': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'SYSTEM_CAPABILITIES': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'oc-lldp-types:SYSTEM_CAPABILITIES': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'MANAGEMENT_ADDRESS': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'oc-lldp-types:MANAGEMENT_ADDRESS': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}},)), is_leaf=False, yang_name="suppress-tlv-advertisement", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='identityref', is_config=False)""",
        })

    self.__suppress_tlv_advertisement = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_suppress_tlv_advertisement(self):
    self.__suppress_tlv_advertisement = YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'CHASSIS_ID': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'oc-lldp-types:CHASSIS_ID': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'PORT_ID': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'oc-lldp-types:PORT_ID': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'PORT_DESCRIPTION': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'oc-lldp-types:PORT_DESCRIPTION': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'SYSTEM_NAME': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'oc-lldp-types:SYSTEM_NAME': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'SYSTEM_DESCRIPTION': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'oc-lldp-types:SYSTEM_DESCRIPTION': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'SYSTEM_CAPABILITIES': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'oc-lldp-types:SYSTEM_CAPABILITIES': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'MANAGEMENT_ADDRESS': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'oc-lldp-types:MANAGEMENT_ADDRESS': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}},)), is_leaf=False, yang_name="suppress-tlv-advertisement", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='identityref', is_config=False)


  def _get_system_name(self):
    """
    Getter method for system_name, mapped from YANG variable /lldp/state/system_name (string)

    YANG Description: The system name field shall contain an alpha-numeric string
that indicates the system's administratively assigned name.
The system name should be the system's fully qualified domain
name. If implementations support IETF RFC 3418, the sysName
object should be used for this field.
    """
    return self.__system_name
      
  def _set_system_name(self, v, load=False):
    """
    Setter method for system_name, mapped from YANG variable /lldp/state/system_name (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_system_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_system_name() directly.

    YANG Description: The system name field shall contain an alpha-numeric string
that indicates the system's administratively assigned name.
The system name should be the system's fully qualified domain
name. If implementations support IETF RFC 3418, the sysName
object should be used for this field.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'length': ['0..255']}), is_leaf=True, yang_name="system-name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """system_name must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'length': ['0..255']}), is_leaf=True, yang_name="system-name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='string', is_config=False)""",
        })

    self.__system_name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_system_name(self):
    self.__system_name = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'length': ['0..255']}), is_leaf=True, yang_name="system-name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='string', is_config=False)


  def _get_system_description(self):
    """
    Getter method for system_description, mapped from YANG variable /lldp/state/system_description (string)

    YANG Description: The system description field shall contain an alpha-numeric
string that is the textual description of the network entity.
The system description should include the full name and
version identification of the system's hardware type,
software operating system, and networking software. If
implementations support IETF RFC 3418, the sysDescr object
should be used for this field.
    """
    return self.__system_description
      
  def _set_system_description(self, v, load=False):
    """
    Setter method for system_description, mapped from YANG variable /lldp/state/system_description (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_system_description is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_system_description() directly.

    YANG Description: The system description field shall contain an alpha-numeric
string that is the textual description of the network entity.
The system description should include the full name and
version identification of the system's hardware type,
software operating system, and networking software. If
implementations support IETF RFC 3418, the sysDescr object
should be used for this field.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'length': ['0..255']}), is_leaf=True, yang_name="system-description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """system_description must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'length': ['0..255']}), is_leaf=True, yang_name="system-description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='string', is_config=False)""",
        })

    self.__system_description = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_system_description(self):
    self.__system_description = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'length': ['0..255']}), is_leaf=True, yang_name="system-description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='string', is_config=False)


  def _get_chassis_id(self):
    """
    Getter method for chassis_id, mapped from YANG variable /lldp/state/chassis_id (string)

    YANG Description: The Chassis ID is a mandatory TLV which identifies the
chassis component of the endpoint identifier associated with
the transmitting LLDP agent
    """
    return self.__chassis_id
      
  def _set_chassis_id(self, v, load=False):
    """
    Setter method for chassis_id, mapped from YANG variable /lldp/state/chassis_id (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_chassis_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_chassis_id() directly.

    YANG Description: The Chassis ID is a mandatory TLV which identifies the
chassis component of the endpoint identifier associated with
the transmitting LLDP agent
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="chassis-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """chassis_id must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="chassis-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='string', is_config=False)""",
        })

    self.__chassis_id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_chassis_id(self):
    self.__chassis_id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="chassis-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='string', is_config=False)


  def _get_chassis_id_type(self):
    """
    Getter method for chassis_id_type, mapped from YANG variable /lldp/state/chassis_id_type (oc-lldp-types:chassis-id-type)

    YANG Description: This field identifies the format and source of the chassis
identifier string. It is an enumerator defined by the
LldpChassisIdSubtype object from IEEE 802.1AB MIB.
    """
    return self.__chassis_id_type
      
  def _set_chassis_id_type(self, v, load=False):
    """
    Setter method for chassis_id_type, mapped from YANG variable /lldp/state/chassis_id_type (oc-lldp-types:chassis-id-type)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_chassis_id_type is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_chassis_id_type() directly.

    YANG Description: This field identifies the format and source of the chassis
identifier string. It is an enumerator defined by the
LldpChassisIdSubtype object from IEEE 802.1AB MIB.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'CHASSIS_COMPONENT': {}, 'INTERFACE_ALIAS': {}, 'PORT_COMPONENT': {}, 'MAC_ADDRESS': {}, 'NETWORK_ADDRESS': {}, 'INTERFACE_NAME': {}, 'LOCAL': {}},), is_leaf=True, yang_name="chassis-id-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='oc-lldp-types:chassis-id-type', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """chassis_id_type must be of a type compatible with oc-lldp-types:chassis-id-type""",
          'defined-type': "oc-lldp-types:chassis-id-type",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'CHASSIS_COMPONENT': {}, 'INTERFACE_ALIAS': {}, 'PORT_COMPONENT': {}, 'MAC_ADDRESS': {}, 'NETWORK_ADDRESS': {}, 'INTERFACE_NAME': {}, 'LOCAL': {}},), is_leaf=True, yang_name="chassis-id-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='oc-lldp-types:chassis-id-type', is_config=False)""",
        })

    self.__chassis_id_type = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_chassis_id_type(self):
    self.__chassis_id_type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'CHASSIS_COMPONENT': {}, 'INTERFACE_ALIAS': {}, 'PORT_COMPONENT': {}, 'MAC_ADDRESS': {}, 'NETWORK_ADDRESS': {}, 'INTERFACE_NAME': {}, 'LOCAL': {}},), is_leaf=True, yang_name="chassis-id-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='oc-lldp-types:chassis-id-type', is_config=False)


  def _get_counters(self):
    """
    Getter method for counters, mapped from YANG variable /lldp/state/counters (container)

    YANG Description: Global LLDP counters
    """
    return self.__counters
      
  def _set_counters(self, v, load=False):
    """
    Setter method for counters, mapped from YANG variable /lldp/state/counters (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_counters is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_counters() directly.

    YANG Description: Global LLDP counters
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_counters_openconfig_lldp__lldp_state_counters, is_container='container', yang_name="counters", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """counters must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_counters_openconfig_lldp__lldp_state_counters, is_container='container', yang_name="counters", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='container', is_config=False)""",
        })

    self.__counters = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_counters(self):
    self.__counters = YANGDynClass(base=yc_counters_openconfig_lldp__lldp_state_counters, is_container='container', yang_name="counters", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='container', is_config=False)

  enabled = __builtin__.property(_get_enabled)
  hello_timer = __builtin__.property(_get_hello_timer)
  suppress_tlv_advertisement = __builtin__.property(_get_suppress_tlv_advertisement)
  system_name = __builtin__.property(_get_system_name)
  system_description = __builtin__.property(_get_system_description)
  chassis_id = __builtin__.property(_get_chassis_id)
  chassis_id_type = __builtin__.property(_get_chassis_id_type)
  counters = __builtin__.property(_get_counters)


  _pyangbind_elements = OrderedDict([('enabled', enabled), ('hello_timer', hello_timer), ('suppress_tlv_advertisement', suppress_tlv_advertisement), ('system_name', system_name), ('system_description', system_description), ('chassis_id', chassis_id), ('chassis_id_type', chassis_id_type), ('counters', counters), ])


class yc_config_openconfig_lldp__lldp_interfaces_interface_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-lldp - based on the path /lldp/interfaces/interface/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration data for LLDP on each interface
  """
  __slots__ = ('_path_helper', '_extmethods', '__name','__enabled',)

  _yang_name = 'config'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='oc-if:base-interface-ref', is_config=True)
    self.__enabled = YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='boolean', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['lldp', 'interfaces', 'interface', 'config']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /lldp/interfaces/interface/config/name (oc-if:base-interface-ref)

    YANG Description: Reference to the LLDP Ethernet interface
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /lldp/interfaces/interface/config/name (oc-if:base-interface-ref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: Reference to the LLDP Ethernet interface
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='oc-if:base-interface-ref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with oc-if:base-interface-ref""",
          'defined-type': "oc-if:base-interface-ref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='oc-if:base-interface-ref', is_config=True)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='oc-if:base-interface-ref', is_config=True)


  def _get_enabled(self):
    """
    Getter method for enabled, mapped from YANG variable /lldp/interfaces/interface/config/enabled (boolean)

    YANG Description: Enable or disable the LLDP protocol on the interface.
    """
    return self.__enabled
      
  def _set_enabled(self, v, load=False):
    """
    Setter method for enabled, mapped from YANG variable /lldp/interfaces/interface/config/enabled (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_enabled is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_enabled() directly.

    YANG Description: Enable or disable the LLDP protocol on the interface.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='boolean', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """enabled must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='boolean', is_config=True)""",
        })

    self.__enabled = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_enabled(self):
    self.__enabled = YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='boolean', is_config=True)

  name = __builtin__.property(_get_name, _set_name)
  enabled = __builtin__.property(_get_enabled, _set_enabled)


  _pyangbind_elements = OrderedDict([('name', name), ('enabled', enabled), ])


class yc_counters_openconfig_lldp__lldp_interfaces_interface_state_counters(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-lldp - based on the path /lldp/interfaces/interface/state/counters. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: LLDP counters on each interface
  """
  __slots__ = ('_path_helper', '_extmethods', '__frame_in','__frame_out','__frame_error_in','__frame_discard','__tlv_discard','__tlv_unknown','__last_clear','__frame_error_out',)

  _yang_name = 'counters'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__frame_in = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="frame-in", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='yang:counter64', is_config=False)
    self.__frame_out = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="frame-out", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='yang:counter64', is_config=False)
    self.__frame_error_in = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="frame-error-in", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='yang:counter64', is_config=False)
    self.__frame_discard = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="frame-discard", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='yang:counter64', is_config=False)
    self.__tlv_discard = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="tlv-discard", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='yang:counter64', is_config=False)
    self.__tlv_unknown = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="tlv-unknown", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='yang:counter64', is_config=False)
    self.__last_clear = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}(\\.\\d+)?(Z|[\\+\\-]\\d{2}:\\d{2})'}), is_leaf=True, yang_name="last-clear", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='yang:date-and-time', is_config=False)
    self.__frame_error_out = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="frame-error-out", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='yang:counter64', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['lldp', 'interfaces', 'interface', 'state', 'counters']

  def _get_frame_in(self):
    """
    Getter method for frame_in, mapped from YANG variable /lldp/interfaces/interface/state/counters/frame_in (yang:counter64)

    YANG Description: The number of lldp frames received.
    """
    return self.__frame_in
      
  def _set_frame_in(self, v, load=False):
    """
    Setter method for frame_in, mapped from YANG variable /lldp/interfaces/interface/state/counters/frame_in (yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_frame_in is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_frame_in() directly.

    YANG Description: The number of lldp frames received.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="frame-in", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """frame_in must be of a type compatible with yang:counter64""",
          'defined-type': "yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="frame-in", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='yang:counter64', is_config=False)""",
        })

    self.__frame_in = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_frame_in(self):
    self.__frame_in = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="frame-in", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='yang:counter64', is_config=False)


  def _get_frame_out(self):
    """
    Getter method for frame_out, mapped from YANG variable /lldp/interfaces/interface/state/counters/frame_out (yang:counter64)

    YANG Description: The number of frames transmitted out.
    """
    return self.__frame_out
      
  def _set_frame_out(self, v, load=False):
    """
    Setter method for frame_out, mapped from YANG variable /lldp/interfaces/interface/state/counters/frame_out (yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_frame_out is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_frame_out() directly.

    YANG Description: The number of frames transmitted out.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="frame-out", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """frame_out must be of a type compatible with yang:counter64""",
          'defined-type': "yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="frame-out", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='yang:counter64', is_config=False)""",
        })

    self.__frame_out = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_frame_out(self):
    self.__frame_out = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="frame-out", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='yang:counter64', is_config=False)


  def _get_frame_error_in(self):
    """
    Getter method for frame_error_in, mapped from YANG variable /lldp/interfaces/interface/state/counters/frame_error_in (yang:counter64)

    YANG Description: The number of LLDP frames received with errors.
    """
    return self.__frame_error_in
      
  def _set_frame_error_in(self, v, load=False):
    """
    Setter method for frame_error_in, mapped from YANG variable /lldp/interfaces/interface/state/counters/frame_error_in (yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_frame_error_in is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_frame_error_in() directly.

    YANG Description: The number of LLDP frames received with errors.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="frame-error-in", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """frame_error_in must be of a type compatible with yang:counter64""",
          'defined-type': "yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="frame-error-in", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='yang:counter64', is_config=False)""",
        })

    self.__frame_error_in = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_frame_error_in(self):
    self.__frame_error_in = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="frame-error-in", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='yang:counter64', is_config=False)


  def _get_frame_discard(self):
    """
    Getter method for frame_discard, mapped from YANG variable /lldp/interfaces/interface/state/counters/frame_discard (yang:counter64)

    YANG Description: The number of LLDP frames received and discarded.
    """
    return self.__frame_discard
      
  def _set_frame_discard(self, v, load=False):
    """
    Setter method for frame_discard, mapped from YANG variable /lldp/interfaces/interface/state/counters/frame_discard (yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_frame_discard is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_frame_discard() directly.

    YANG Description: The number of LLDP frames received and discarded.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="frame-discard", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """frame_discard must be of a type compatible with yang:counter64""",
          'defined-type': "yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="frame-discard", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='yang:counter64', is_config=False)""",
        })

    self.__frame_discard = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_frame_discard(self):
    self.__frame_discard = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="frame-discard", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='yang:counter64', is_config=False)


  def _get_tlv_discard(self):
    """
    Getter method for tlv_discard, mapped from YANG variable /lldp/interfaces/interface/state/counters/tlv_discard (yang:counter64)

    YANG Description: The number of TLV frames received and discarded.
    """
    return self.__tlv_discard
      
  def _set_tlv_discard(self, v, load=False):
    """
    Setter method for tlv_discard, mapped from YANG variable /lldp/interfaces/interface/state/counters/tlv_discard (yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_tlv_discard is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_tlv_discard() directly.

    YANG Description: The number of TLV frames received and discarded.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="tlv-discard", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """tlv_discard must be of a type compatible with yang:counter64""",
          'defined-type': "yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="tlv-discard", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='yang:counter64', is_config=False)""",
        })

    self.__tlv_discard = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_tlv_discard(self):
    self.__tlv_discard = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="tlv-discard", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='yang:counter64', is_config=False)


  def _get_tlv_unknown(self):
    """
    Getter method for tlv_unknown, mapped from YANG variable /lldp/interfaces/interface/state/counters/tlv_unknown (yang:counter64)

    YANG Description: The number of frames received with unknown TLV.
    """
    return self.__tlv_unknown
      
  def _set_tlv_unknown(self, v, load=False):
    """
    Setter method for tlv_unknown, mapped from YANG variable /lldp/interfaces/interface/state/counters/tlv_unknown (yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_tlv_unknown is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_tlv_unknown() directly.

    YANG Description: The number of frames received with unknown TLV.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="tlv-unknown", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """tlv_unknown must be of a type compatible with yang:counter64""",
          'defined-type': "yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="tlv-unknown", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='yang:counter64', is_config=False)""",
        })

    self.__tlv_unknown = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_tlv_unknown(self):
    self.__tlv_unknown = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="tlv-unknown", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='yang:counter64', is_config=False)


  def _get_last_clear(self):
    """
    Getter method for last_clear, mapped from YANG variable /lldp/interfaces/interface/state/counters/last_clear (yang:date-and-time)

    YANG Description: Indicates the last time the counters were
cleared.
    """
    return self.__last_clear
      
  def _set_last_clear(self, v, load=False):
    """
    Setter method for last_clear, mapped from YANG variable /lldp/interfaces/interface/state/counters/last_clear (yang:date-and-time)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_last_clear is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_last_clear() directly.

    YANG Description: Indicates the last time the counters were
cleared.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}(\\.\\d+)?(Z|[\\+\\-]\\d{2}:\\d{2})'}), is_leaf=True, yang_name="last-clear", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='yang:date-and-time', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """last_clear must be of a type compatible with yang:date-and-time""",
          'defined-type': "yang:date-and-time",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}(\\.\\d+)?(Z|[\\+\\-]\\d{2}:\\d{2})'}), is_leaf=True, yang_name="last-clear", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='yang:date-and-time', is_config=False)""",
        })

    self.__last_clear = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_last_clear(self):
    self.__last_clear = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}(\\.\\d+)?(Z|[\\+\\-]\\d{2}:\\d{2})'}), is_leaf=True, yang_name="last-clear", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='yang:date-and-time', is_config=False)


  def _get_frame_error_out(self):
    """
    Getter method for frame_error_out, mapped from YANG variable /lldp/interfaces/interface/state/counters/frame_error_out (yang:counter64)

    YANG Description: The number of frame transmit errors on the
interface.
    """
    return self.__frame_error_out
      
  def _set_frame_error_out(self, v, load=False):
    """
    Setter method for frame_error_out, mapped from YANG variable /lldp/interfaces/interface/state/counters/frame_error_out (yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_frame_error_out is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_frame_error_out() directly.

    YANG Description: The number of frame transmit errors on the
interface.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="frame-error-out", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """frame_error_out must be of a type compatible with yang:counter64""",
          'defined-type': "yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="frame-error-out", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='yang:counter64', is_config=False)""",
        })

    self.__frame_error_out = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_frame_error_out(self):
    self.__frame_error_out = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="frame-error-out", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='yang:counter64', is_config=False)

  frame_in = __builtin__.property(_get_frame_in)
  frame_out = __builtin__.property(_get_frame_out)
  frame_error_in = __builtin__.property(_get_frame_error_in)
  frame_discard = __builtin__.property(_get_frame_discard)
  tlv_discard = __builtin__.property(_get_tlv_discard)
  tlv_unknown = __builtin__.property(_get_tlv_unknown)
  last_clear = __builtin__.property(_get_last_clear)
  frame_error_out = __builtin__.property(_get_frame_error_out)


  _pyangbind_elements = OrderedDict([('frame_in', frame_in), ('frame_out', frame_out), ('frame_error_in', frame_error_in), ('frame_discard', frame_discard), ('tlv_discard', tlv_discard), ('tlv_unknown', tlv_unknown), ('last_clear', last_clear), ('frame_error_out', frame_error_out), ])


class yc_state_openconfig_lldp__lldp_interfaces_interface_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-lldp - based on the path /lldp/interfaces/interface/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state data 
  """
  __slots__ = ('_path_helper', '_extmethods', '__name','__enabled','__counters',)

  _yang_name = 'state'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='oc-if:base-interface-ref', is_config=False)
    self.__enabled = YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='boolean', is_config=False)
    self.__counters = YANGDynClass(base=yc_counters_openconfig_lldp__lldp_interfaces_interface_state_counters, is_container='container', yang_name="counters", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='container', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['lldp', 'interfaces', 'interface', 'state']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /lldp/interfaces/interface/state/name (oc-if:base-interface-ref)

    YANG Description: Reference to the LLDP Ethernet interface
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /lldp/interfaces/interface/state/name (oc-if:base-interface-ref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: Reference to the LLDP Ethernet interface
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='oc-if:base-interface-ref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with oc-if:base-interface-ref""",
          'defined-type': "oc-if:base-interface-ref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='oc-if:base-interface-ref', is_config=False)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='oc-if:base-interface-ref', is_config=False)


  def _get_enabled(self):
    """
    Getter method for enabled, mapped from YANG variable /lldp/interfaces/interface/state/enabled (boolean)

    YANG Description: Enable or disable the LLDP protocol on the interface.
    """
    return self.__enabled
      
  def _set_enabled(self, v, load=False):
    """
    Setter method for enabled, mapped from YANG variable /lldp/interfaces/interface/state/enabled (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_enabled is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_enabled() directly.

    YANG Description: Enable or disable the LLDP protocol on the interface.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='boolean', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """enabled must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='boolean', is_config=False)""",
        })

    self.__enabled = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_enabled(self):
    self.__enabled = YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='boolean', is_config=False)


  def _get_counters(self):
    """
    Getter method for counters, mapped from YANG variable /lldp/interfaces/interface/state/counters (container)

    YANG Description: LLDP counters on each interface
    """
    return self.__counters
      
  def _set_counters(self, v, load=False):
    """
    Setter method for counters, mapped from YANG variable /lldp/interfaces/interface/state/counters (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_counters is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_counters() directly.

    YANG Description: LLDP counters on each interface
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_counters_openconfig_lldp__lldp_interfaces_interface_state_counters, is_container='container', yang_name="counters", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """counters must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_counters_openconfig_lldp__lldp_interfaces_interface_state_counters, is_container='container', yang_name="counters", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='container', is_config=False)""",
        })

    self.__counters = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_counters(self):
    self.__counters = YANGDynClass(base=yc_counters_openconfig_lldp__lldp_interfaces_interface_state_counters, is_container='container', yang_name="counters", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='container', is_config=False)

  name = __builtin__.property(_get_name)
  enabled = __builtin__.property(_get_enabled)
  counters = __builtin__.property(_get_counters)


  _pyangbind_elements = OrderedDict([('name', name), ('enabled', enabled), ('counters', counters), ])


class yc_state_openconfig_lldp__lldp_interfaces_interface_neighbors_neighbor_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-lldp - based on the path /lldp/interfaces/interface/neighbors/neighbor/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state data 
  """
  __slots__ = ('_path_helper', '_extmethods', '__system_name','__system_description','__chassis_id','__chassis_id_type','__id','__age','__last_update','__ttl','__port_id','__port_id_type','__port_description','__management_address','__management_address_type',)

  _yang_name = 'state'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__system_name = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'length': ['0..255']}), is_leaf=True, yang_name="system-name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='string', is_config=False)
    self.__system_description = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'length': ['0..255']}), is_leaf=True, yang_name="system-description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='string', is_config=False)
    self.__chassis_id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="chassis-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='string', is_config=False)
    self.__chassis_id_type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'CHASSIS_COMPONENT': {}, 'INTERFACE_ALIAS': {}, 'PORT_COMPONENT': {}, 'MAC_ADDRESS': {}, 'NETWORK_ADDRESS': {}, 'INTERFACE_NAME': {}, 'LOCAL': {}},), is_leaf=True, yang_name="chassis-id-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='oc-lldp-types:chassis-id-type', is_config=False)
    self.__id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='string', is_config=False)
    self.__age = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="age", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='uint64', is_config=False)
    self.__last_update = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['-9223372036854775808..9223372036854775807']}, int_size=64), is_leaf=True, yang_name="last-update", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='int64', is_config=False)
    self.__ttl = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="ttl", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='uint16', is_config=False)
    self.__port_id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="port-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='string', is_config=False)
    self.__port_id_type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'INTERFACE_ALIAS': {}, 'PORT_COMPONENT': {}, 'MAC_ADDRESS': {}, 'NETWORK_ADDRESS': {}, 'INTERFACE_NAME': {}, 'AGENT_CIRCUIT_ID': {}, 'LOCAL': {}},), is_leaf=True, yang_name="port-id-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='oc-lldp-types:port-id-type', is_config=False)
    self.__port_description = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="port-description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='string', is_config=False)
    self.__management_address = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="management-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='string', is_config=False)
    self.__management_address_type = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="management-address-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='string', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['lldp', 'interfaces', 'interface', 'neighbors', 'neighbor', 'state']

  def _get_system_name(self):
    """
    Getter method for system_name, mapped from YANG variable /lldp/interfaces/interface/neighbors/neighbor/state/system_name (string)

    YANG Description: The system name field shall contain an alpha-numeric string
that indicates the system's administratively assigned name.
The system name should be the system's fully qualified domain
name. If implementations support IETF RFC 3418, the sysName
object should be used for this field.
    """
    return self.__system_name
      
  def _set_system_name(self, v, load=False):
    """
    Setter method for system_name, mapped from YANG variable /lldp/interfaces/interface/neighbors/neighbor/state/system_name (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_system_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_system_name() directly.

    YANG Description: The system name field shall contain an alpha-numeric string
that indicates the system's administratively assigned name.
The system name should be the system's fully qualified domain
name. If implementations support IETF RFC 3418, the sysName
object should be used for this field.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'length': ['0..255']}), is_leaf=True, yang_name="system-name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """system_name must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'length': ['0..255']}), is_leaf=True, yang_name="system-name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='string', is_config=False)""",
        })

    self.__system_name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_system_name(self):
    self.__system_name = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'length': ['0..255']}), is_leaf=True, yang_name="system-name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='string', is_config=False)


  def _get_system_description(self):
    """
    Getter method for system_description, mapped from YANG variable /lldp/interfaces/interface/neighbors/neighbor/state/system_description (string)

    YANG Description: The system description field shall contain an alpha-numeric
string that is the textual description of the network entity.
The system description should include the full name and
version identification of the system's hardware type,
software operating system, and networking software. If
implementations support IETF RFC 3418, the sysDescr object
should be used for this field.
    """
    return self.__system_description
      
  def _set_system_description(self, v, load=False):
    """
    Setter method for system_description, mapped from YANG variable /lldp/interfaces/interface/neighbors/neighbor/state/system_description (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_system_description is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_system_description() directly.

    YANG Description: The system description field shall contain an alpha-numeric
string that is the textual description of the network entity.
The system description should include the full name and
version identification of the system's hardware type,
software operating system, and networking software. If
implementations support IETF RFC 3418, the sysDescr object
should be used for this field.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'length': ['0..255']}), is_leaf=True, yang_name="system-description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """system_description must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'length': ['0..255']}), is_leaf=True, yang_name="system-description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='string', is_config=False)""",
        })

    self.__system_description = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_system_description(self):
    self.__system_description = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'length': ['0..255']}), is_leaf=True, yang_name="system-description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='string', is_config=False)


  def _get_chassis_id(self):
    """
    Getter method for chassis_id, mapped from YANG variable /lldp/interfaces/interface/neighbors/neighbor/state/chassis_id (string)

    YANG Description: The Chassis ID is a mandatory TLV which identifies the
chassis component of the endpoint identifier associated with
the transmitting LLDP agent
    """
    return self.__chassis_id
      
  def _set_chassis_id(self, v, load=False):
    """
    Setter method for chassis_id, mapped from YANG variable /lldp/interfaces/interface/neighbors/neighbor/state/chassis_id (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_chassis_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_chassis_id() directly.

    YANG Description: The Chassis ID is a mandatory TLV which identifies the
chassis component of the endpoint identifier associated with
the transmitting LLDP agent
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="chassis-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """chassis_id must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="chassis-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='string', is_config=False)""",
        })

    self.__chassis_id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_chassis_id(self):
    self.__chassis_id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="chassis-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='string', is_config=False)


  def _get_chassis_id_type(self):
    """
    Getter method for chassis_id_type, mapped from YANG variable /lldp/interfaces/interface/neighbors/neighbor/state/chassis_id_type (oc-lldp-types:chassis-id-type)

    YANG Description: This field identifies the format and source of the chassis
identifier string. It is an enumerator defined by the
LldpChassisIdSubtype object from IEEE 802.1AB MIB.
    """
    return self.__chassis_id_type
      
  def _set_chassis_id_type(self, v, load=False):
    """
    Setter method for chassis_id_type, mapped from YANG variable /lldp/interfaces/interface/neighbors/neighbor/state/chassis_id_type (oc-lldp-types:chassis-id-type)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_chassis_id_type is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_chassis_id_type() directly.

    YANG Description: This field identifies the format and source of the chassis
identifier string. It is an enumerator defined by the
LldpChassisIdSubtype object from IEEE 802.1AB MIB.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'CHASSIS_COMPONENT': {}, 'INTERFACE_ALIAS': {}, 'PORT_COMPONENT': {}, 'MAC_ADDRESS': {}, 'NETWORK_ADDRESS': {}, 'INTERFACE_NAME': {}, 'LOCAL': {}},), is_leaf=True, yang_name="chassis-id-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='oc-lldp-types:chassis-id-type', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """chassis_id_type must be of a type compatible with oc-lldp-types:chassis-id-type""",
          'defined-type': "oc-lldp-types:chassis-id-type",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'CHASSIS_COMPONENT': {}, 'INTERFACE_ALIAS': {}, 'PORT_COMPONENT': {}, 'MAC_ADDRESS': {}, 'NETWORK_ADDRESS': {}, 'INTERFACE_NAME': {}, 'LOCAL': {}},), is_leaf=True, yang_name="chassis-id-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='oc-lldp-types:chassis-id-type', is_config=False)""",
        })

    self.__chassis_id_type = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_chassis_id_type(self):
    self.__chassis_id_type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'CHASSIS_COMPONENT': {}, 'INTERFACE_ALIAS': {}, 'PORT_COMPONENT': {}, 'MAC_ADDRESS': {}, 'NETWORK_ADDRESS': {}, 'INTERFACE_NAME': {}, 'LOCAL': {}},), is_leaf=True, yang_name="chassis-id-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='oc-lldp-types:chassis-id-type', is_config=False)


  def _get_id(self):
    """
    Getter method for id, mapped from YANG variable /lldp/interfaces/interface/neighbors/neighbor/state/id (string)

    YANG Description: System generated identifier for the neighbor on the
interface.
    """
    return self.__id
      
  def _set_id(self, v, load=False):
    """
    Setter method for id, mapped from YANG variable /lldp/interfaces/interface/neighbors/neighbor/state/id (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_id() directly.

    YANG Description: System generated identifier for the neighbor on the
interface.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """id must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='string', is_config=False)""",
        })

    self.__id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_id(self):
    self.__id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='string', is_config=False)


  def _get_age(self):
    """
    Getter method for age, mapped from YANG variable /lldp/interfaces/interface/neighbors/neighbor/state/age (uint64)

    YANG Description: Age since discovery
    """
    return self.__age
      
  def _set_age(self, v, load=False):
    """
    Setter method for age, mapped from YANG variable /lldp/interfaces/interface/neighbors/neighbor/state/age (uint64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_age is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_age() directly.

    YANG Description: Age since discovery
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="age", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='uint64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """age must be of a type compatible with uint64""",
          'defined-type': "uint64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="age", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='uint64', is_config=False)""",
        })

    self.__age = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_age(self):
    self.__age = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="age", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='uint64', is_config=False)


  def _get_last_update(self):
    """
    Getter method for last_update, mapped from YANG variable /lldp/interfaces/interface/neighbors/neighbor/state/last_update (int64)

    YANG Description: Seconds since last update received.
    """
    return self.__last_update
      
  def _set_last_update(self, v, load=False):
    """
    Setter method for last_update, mapped from YANG variable /lldp/interfaces/interface/neighbors/neighbor/state/last_update (int64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_last_update is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_last_update() directly.

    YANG Description: Seconds since last update received.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range': ['-9223372036854775808..9223372036854775807']}, int_size=64), is_leaf=True, yang_name="last-update", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='int64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """last_update must be of a type compatible with int64""",
          'defined-type': "int64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['-9223372036854775808..9223372036854775807']}, int_size=64), is_leaf=True, yang_name="last-update", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='int64', is_config=False)""",
        })

    self.__last_update = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_last_update(self):
    self.__last_update = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['-9223372036854775808..9223372036854775807']}, int_size=64), is_leaf=True, yang_name="last-update", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='int64', is_config=False)


  def _get_ttl(self):
    """
    Getter method for ttl, mapped from YANG variable /lldp/interfaces/interface/neighbors/neighbor/state/ttl (uint16)

    YANG Description: The time-to-live (TTL) is a mandatory TLV which indicates
how long information from the neighbor should be considered
valid.
    """
    return self.__ttl
      
  def _set_ttl(self, v, load=False):
    """
    Setter method for ttl, mapped from YANG variable /lldp/interfaces/interface/neighbors/neighbor/state/ttl (uint16)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_ttl is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_ttl() directly.

    YANG Description: The time-to-live (TTL) is a mandatory TLV which indicates
how long information from the neighbor should be considered
valid.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="ttl", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='uint16', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """ttl must be of a type compatible with uint16""",
          'defined-type': "uint16",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="ttl", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='uint16', is_config=False)""",
        })

    self.__ttl = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_ttl(self):
    self.__ttl = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="ttl", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='uint16', is_config=False)


  def _get_port_id(self):
    """
    Getter method for port_id, mapped from YANG variable /lldp/interfaces/interface/neighbors/neighbor/state/port_id (string)

    YANG Description: The Port ID is a mandatory TLV which identifies the port
component of the endpoint identifier associated with the
transmitting LLDP agent. If the specified port is an IEEE
802.3 Repeater port, then this TLV is optional.
    """
    return self.__port_id
      
  def _set_port_id(self, v, load=False):
    """
    Setter method for port_id, mapped from YANG variable /lldp/interfaces/interface/neighbors/neighbor/state/port_id (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_port_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_port_id() directly.

    YANG Description: The Port ID is a mandatory TLV which identifies the port
component of the endpoint identifier associated with the
transmitting LLDP agent. If the specified port is an IEEE
802.3 Repeater port, then this TLV is optional.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="port-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """port_id must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="port-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='string', is_config=False)""",
        })

    self.__port_id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_port_id(self):
    self.__port_id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="port-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='string', is_config=False)


  def _get_port_id_type(self):
    """
    Getter method for port_id_type, mapped from YANG variable /lldp/interfaces/interface/neighbors/neighbor/state/port_id_type (oc-lldp-types:port-id-type)

    YANG Description: This field identifies the format and source of the port
identifier string. It is an enumerator defined by the
PtopoPortIdType object from RFC2922.
    """
    return self.__port_id_type
      
  def _set_port_id_type(self, v, load=False):
    """
    Setter method for port_id_type, mapped from YANG variable /lldp/interfaces/interface/neighbors/neighbor/state/port_id_type (oc-lldp-types:port-id-type)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_port_id_type is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_port_id_type() directly.

    YANG Description: This field identifies the format and source of the port
identifier string. It is an enumerator defined by the
PtopoPortIdType object from RFC2922.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'INTERFACE_ALIAS': {}, 'PORT_COMPONENT': {}, 'MAC_ADDRESS': {}, 'NETWORK_ADDRESS': {}, 'INTERFACE_NAME': {}, 'AGENT_CIRCUIT_ID': {}, 'LOCAL': {}},), is_leaf=True, yang_name="port-id-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='oc-lldp-types:port-id-type', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """port_id_type must be of a type compatible with oc-lldp-types:port-id-type""",
          'defined-type': "oc-lldp-types:port-id-type",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'INTERFACE_ALIAS': {}, 'PORT_COMPONENT': {}, 'MAC_ADDRESS': {}, 'NETWORK_ADDRESS': {}, 'INTERFACE_NAME': {}, 'AGENT_CIRCUIT_ID': {}, 'LOCAL': {}},), is_leaf=True, yang_name="port-id-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='oc-lldp-types:port-id-type', is_config=False)""",
        })

    self.__port_id_type = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_port_id_type(self):
    self.__port_id_type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'INTERFACE_ALIAS': {}, 'PORT_COMPONENT': {}, 'MAC_ADDRESS': {}, 'NETWORK_ADDRESS': {}, 'INTERFACE_NAME': {}, 'AGENT_CIRCUIT_ID': {}, 'LOCAL': {}},), is_leaf=True, yang_name="port-id-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='oc-lldp-types:port-id-type', is_config=False)


  def _get_port_description(self):
    """
    Getter method for port_description, mapped from YANG variable /lldp/interfaces/interface/neighbors/neighbor/state/port_description (string)

    YANG Description: The binary string containing the actual port identifier for
the port which this LLDP PDU was transmitted. The source and
format of this field is defined by PtopoPortId from
RFC2922.
    """
    return self.__port_description
      
  def _set_port_description(self, v, load=False):
    """
    Setter method for port_description, mapped from YANG variable /lldp/interfaces/interface/neighbors/neighbor/state/port_description (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_port_description is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_port_description() directly.

    YANG Description: The binary string containing the actual port identifier for
the port which this LLDP PDU was transmitted. The source and
format of this field is defined by PtopoPortId from
RFC2922.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="port-description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """port_description must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="port-description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='string', is_config=False)""",
        })

    self.__port_description = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_port_description(self):
    self.__port_description = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="port-description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='string', is_config=False)


  def _get_management_address(self):
    """
    Getter method for management_address, mapped from YANG variable /lldp/interfaces/interface/neighbors/neighbor/state/management_address (string)

    YANG Description: The Management Address is a mandatory TLV which identifies a
network address associated with the local LLDP agent, which
can be used to reach the agent on the port identified in the
Port ID TLV.
    """
    return self.__management_address
      
  def _set_management_address(self, v, load=False):
    """
    Setter method for management_address, mapped from YANG variable /lldp/interfaces/interface/neighbors/neighbor/state/management_address (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_management_address is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_management_address() directly.

    YANG Description: The Management Address is a mandatory TLV which identifies a
network address associated with the local LLDP agent, which
can be used to reach the agent on the port identified in the
Port ID TLV.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="management-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """management_address must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="management-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='string', is_config=False)""",
        })

    self.__management_address = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_management_address(self):
    self.__management_address = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="management-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='string', is_config=False)


  def _get_management_address_type(self):
    """
    Getter method for management_address_type, mapped from YANG variable /lldp/interfaces/interface/neighbors/neighbor/state/management_address_type (string)

    YANG Description: The enumerated value for the network address type
identified in this TLV. This enumeration is defined in the
'Assigned Numbers' RFC [RFC3232] and the
ianaAddressFamilyNumbers object.
    """
    return self.__management_address_type
      
  def _set_management_address_type(self, v, load=False):
    """
    Setter method for management_address_type, mapped from YANG variable /lldp/interfaces/interface/neighbors/neighbor/state/management_address_type (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_management_address_type is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_management_address_type() directly.

    YANG Description: The enumerated value for the network address type
identified in this TLV. This enumeration is defined in the
'Assigned Numbers' RFC [RFC3232] and the
ianaAddressFamilyNumbers object.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="management-address-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """management_address_type must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="management-address-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='string', is_config=False)""",
        })

    self.__management_address_type = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_management_address_type(self):
    self.__management_address_type = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="management-address-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='string', is_config=False)

  system_name = __builtin__.property(_get_system_name)
  system_description = __builtin__.property(_get_system_description)
  chassis_id = __builtin__.property(_get_chassis_id)
  chassis_id_type = __builtin__.property(_get_chassis_id_type)
  id = __builtin__.property(_get_id)
  age = __builtin__.property(_get_age)
  last_update = __builtin__.property(_get_last_update)
  ttl = __builtin__.property(_get_ttl)
  port_id = __builtin__.property(_get_port_id)
  port_id_type = __builtin__.property(_get_port_id_type)
  port_description = __builtin__.property(_get_port_description)
  management_address = __builtin__.property(_get_management_address)
  management_address_type = __builtin__.property(_get_management_address_type)


  _pyangbind_elements = OrderedDict([('system_name', system_name), ('system_description', system_description), ('chassis_id', chassis_id), ('chassis_id_type', chassis_id_type), ('id', id), ('age', age), ('last_update', last_update), ('ttl', ttl), ('port_id', port_id), ('port_id_type', port_id_type), ('port_description', port_description), ('management_address', management_address), ('management_address_type', management_address_type), ])


class yc_state_openconfig_lldp__lldp_interfaces_interface_neighbors_neighbor_custom_tlvs_tlv_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-lldp - based on the path /lldp/interfaces/interface/neighbors/neighbor/custom-tlvs/tlv/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state data 
  """
  __slots__ = ('_path_helper', '_extmethods', '__type','__oui','__oui_subtype','__value',)

  _yang_name = 'state'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__type = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['-2147483648..2147483647']}, int_size=32), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='int32', is_config=False)
    self.__oui = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="oui", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='string', is_config=False)
    self.__oui_subtype = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="oui-subtype", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='string', is_config=False)
    self.__value = YANGDynClass(base=bitarray, is_leaf=True, yang_name="value", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='binary', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['lldp', 'interfaces', 'interface', 'neighbors', 'neighbor', 'custom-tlvs', 'tlv', 'state']

  def _get_type(self):
    """
    Getter method for type, mapped from YANG variable /lldp/interfaces/interface/neighbors/neighbor/custom_tlvs/tlv/state/type (int32)

    YANG Description: The integer value identifying the type of information
contained in the value field.
    """
    return self.__type
      
  def _set_type(self, v, load=False):
    """
    Setter method for type, mapped from YANG variable /lldp/interfaces/interface/neighbors/neighbor/custom_tlvs/tlv/state/type (int32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_type is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_type() directly.

    YANG Description: The integer value identifying the type of information
contained in the value field.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range': ['-2147483648..2147483647']}, int_size=32), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='int32', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """type must be of a type compatible with int32""",
          'defined-type': "int32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['-2147483648..2147483647']}, int_size=32), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='int32', is_config=False)""",
        })

    self.__type = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_type(self):
    self.__type = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['-2147483648..2147483647']}, int_size=32), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='int32', is_config=False)


  def _get_oui(self):
    """
    Getter method for oui, mapped from YANG variable /lldp/interfaces/interface/neighbors/neighbor/custom_tlvs/tlv/state/oui (string)

    YANG Description: The organizationally unique identifier field shall contain
the organization's OUI as defined in Clause 9 of IEEE Std
802. The high-order octet is 0 and the low-order 3 octets
are the SMI Network Management Private Enterprise Code of
the Vendor in network byte order, as defined in the
'Assigned Numbers' RFC [RFC3232].
    """
    return self.__oui
      
  def _set_oui(self, v, load=False):
    """
    Setter method for oui, mapped from YANG variable /lldp/interfaces/interface/neighbors/neighbor/custom_tlvs/tlv/state/oui (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_oui is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_oui() directly.

    YANG Description: The organizationally unique identifier field shall contain
the organization's OUI as defined in Clause 9 of IEEE Std
802. The high-order octet is 0 and the low-order 3 octets
are the SMI Network Management Private Enterprise Code of
the Vendor in network byte order, as defined in the
'Assigned Numbers' RFC [RFC3232].
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="oui", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """oui must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="oui", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='string', is_config=False)""",
        })

    self.__oui = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_oui(self):
    self.__oui = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="oui", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='string', is_config=False)


  def _get_oui_subtype(self):
    """
    Getter method for oui_subtype, mapped from YANG variable /lldp/interfaces/interface/neighbors/neighbor/custom_tlvs/tlv/state/oui_subtype (string)

    YANG Description: The organizationally defined subtype field shall contain a
unique subtype value assigned by the defining organization.
    """
    return self.__oui_subtype
      
  def _set_oui_subtype(self, v, load=False):
    """
    Setter method for oui_subtype, mapped from YANG variable /lldp/interfaces/interface/neighbors/neighbor/custom_tlvs/tlv/state/oui_subtype (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_oui_subtype is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_oui_subtype() directly.

    YANG Description: The organizationally defined subtype field shall contain a
unique subtype value assigned by the defining organization.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="oui-subtype", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """oui_subtype must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="oui-subtype", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='string', is_config=False)""",
        })

    self.__oui_subtype = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_oui_subtype(self):
    self.__oui_subtype = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="oui-subtype", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='string', is_config=False)


  def _get_value(self):
    """
    Getter method for value, mapped from YANG variable /lldp/interfaces/interface/neighbors/neighbor/custom_tlvs/tlv/state/value (binary)

    YANG Description: A variable-length octet-string containing the
instance-specific information for this TLV.
    """
    return self.__value
      
  def _set_value(self, v, load=False):
    """
    Setter method for value, mapped from YANG variable /lldp/interfaces/interface/neighbors/neighbor/custom_tlvs/tlv/state/value (binary)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_value is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_value() directly.

    YANG Description: A variable-length octet-string containing the
instance-specific information for this TLV.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=bitarray, is_leaf=True, yang_name="value", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='binary', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """value must be of a type compatible with binary""",
          'defined-type': "binary",
          'generated-type': """YANGDynClass(base=bitarray, is_leaf=True, yang_name="value", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='binary', is_config=False)""",
        })

    self.__value = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_value(self):
    self.__value = YANGDynClass(base=bitarray, is_leaf=True, yang_name="value", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='binary', is_config=False)

  type = __builtin__.property(_get_type)
  oui = __builtin__.property(_get_oui)
  oui_subtype = __builtin__.property(_get_oui_subtype)
  value = __builtin__.property(_get_value)


  _pyangbind_elements = OrderedDict([('type', type), ('oui', oui), ('oui_subtype', oui_subtype), ('value', value), ])


class yc_tlv_openconfig_lldp__lldp_interfaces_interface_neighbors_neighbor_custom_tlvs_tlv(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-lldp - based on the path /lldp/interfaces/interface/neighbors/neighbor/custom-tlvs/tlv. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: List of custom LLDP TLVs from a neighbor
  """
  __slots__ = ('_path_helper', '_extmethods', '__type','__oui','__oui_subtype','__state',)

  _yang_name = 'tlv'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__type = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='leafref', is_config=False)
    self.__oui = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="oui", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='leafref', is_config=False)
    self.__oui_subtype = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="oui-subtype", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='leafref', is_config=False)
    self.__state = YANGDynClass(base=yc_state_openconfig_lldp__lldp_interfaces_interface_neighbors_neighbor_custom_tlvs_tlv_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='container', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['lldp', 'interfaces', 'interface', 'neighbors', 'neighbor', 'custom-tlvs', 'tlv']

  def _get_type(self):
    """
    Getter method for type, mapped from YANG variable /lldp/interfaces/interface/neighbors/neighbor/custom_tlvs/tlv/type (leafref)

    YANG Description: Reference to type list key
    """
    return self.__type
      
  def _set_type(self, v, load=False):
    """
    Setter method for type, mapped from YANG variable /lldp/interfaces/interface/neighbors/neighbor/custom_tlvs/tlv/type (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_type is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_type() directly.

    YANG Description: Reference to type list key
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """type must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='leafref', is_config=False)""",
        })

    self.__type = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_type(self):
    self.__type = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='leafref', is_config=False)


  def _get_oui(self):
    """
    Getter method for oui, mapped from YANG variable /lldp/interfaces/interface/neighbors/neighbor/custom_tlvs/tlv/oui (leafref)

    YANG Description: Reference to oui list key
    """
    return self.__oui
      
  def _set_oui(self, v, load=False):
    """
    Setter method for oui, mapped from YANG variable /lldp/interfaces/interface/neighbors/neighbor/custom_tlvs/tlv/oui (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_oui is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_oui() directly.

    YANG Description: Reference to oui list key
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="oui", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """oui must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="oui", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='leafref', is_config=False)""",
        })

    self.__oui = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_oui(self):
    self.__oui = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="oui", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='leafref', is_config=False)


  def _get_oui_subtype(self):
    """
    Getter method for oui_subtype, mapped from YANG variable /lldp/interfaces/interface/neighbors/neighbor/custom_tlvs/tlv/oui_subtype (leafref)

    YANG Description: Reference to oui-subtype list key
    """
    return self.__oui_subtype
      
  def _set_oui_subtype(self, v, load=False):
    """
    Setter method for oui_subtype, mapped from YANG variable /lldp/interfaces/interface/neighbors/neighbor/custom_tlvs/tlv/oui_subtype (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_oui_subtype is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_oui_subtype() directly.

    YANG Description: Reference to oui-subtype list key
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="oui-subtype", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """oui_subtype must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="oui-subtype", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='leafref', is_config=False)""",
        })

    self.__oui_subtype = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_oui_subtype(self):
    self.__oui_subtype = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="oui-subtype", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='leafref', is_config=False)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /lldp/interfaces/interface/neighbors/neighbor/custom_tlvs/tlv/state (container)

    YANG Description: Operational state data 
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /lldp/interfaces/interface/neighbors/neighbor/custom_tlvs/tlv/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state data 
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_lldp__lldp_interfaces_interface_neighbors_neighbor_custom_tlvs_tlv_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_lldp__lldp_interfaces_interface_neighbors_neighbor_custom_tlvs_tlv_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='container', is_config=False)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_lldp__lldp_interfaces_interface_neighbors_neighbor_custom_tlvs_tlv_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='container', is_config=False)

  type = __builtin__.property(_get_type)
  oui = __builtin__.property(_get_oui)
  oui_subtype = __builtin__.property(_get_oui_subtype)
  state = __builtin__.property(_get_state)


  _pyangbind_elements = OrderedDict([('type', type), ('oui', oui), ('oui_subtype', oui_subtype), ('state', state), ])


class yc_custom_tlvs_openconfig_lldp__lldp_interfaces_interface_neighbors_neighbor_custom_tlvs(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-lldp - based on the path /lldp/interfaces/interface/neighbors/neighbor/custom-tlvs. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Enclosing container for list of custom TLVs from a
neighbor
  """
  __slots__ = ('_path_helper', '_extmethods', '__tlv',)

  _yang_name = 'custom-tlvs'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__tlv = YANGDynClass(base=YANGListType("type oui oui_subtype",yc_tlv_openconfig_lldp__lldp_interfaces_interface_neighbors_neighbor_custom_tlvs_tlv, yang_name="tlv", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='type oui oui-subtype', extensions=None), is_container='list', yang_name="tlv", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='list', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['lldp', 'interfaces', 'interface', 'neighbors', 'neighbor', 'custom-tlvs']

  def _get_tlv(self):
    """
    Getter method for tlv, mapped from YANG variable /lldp/interfaces/interface/neighbors/neighbor/custom_tlvs/tlv (list)

    YANG Description: List of custom LLDP TLVs from a neighbor
    """
    return self.__tlv
      
  def _set_tlv(self, v, load=False):
    """
    Setter method for tlv, mapped from YANG variable /lldp/interfaces/interface/neighbors/neighbor/custom_tlvs/tlv (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_tlv is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_tlv() directly.

    YANG Description: List of custom LLDP TLVs from a neighbor
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("type oui oui_subtype",yc_tlv_openconfig_lldp__lldp_interfaces_interface_neighbors_neighbor_custom_tlvs_tlv, yang_name="tlv", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='type oui oui-subtype', extensions=None), is_container='list', yang_name="tlv", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='list', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """tlv must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("type oui oui_subtype",yc_tlv_openconfig_lldp__lldp_interfaces_interface_neighbors_neighbor_custom_tlvs_tlv, yang_name="tlv", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='type oui oui-subtype', extensions=None), is_container='list', yang_name="tlv", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='list', is_config=False)""",
        })

    self.__tlv = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_tlv(self):
    self.__tlv = YANGDynClass(base=YANGListType("type oui oui_subtype",yc_tlv_openconfig_lldp__lldp_interfaces_interface_neighbors_neighbor_custom_tlvs_tlv, yang_name="tlv", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='type oui oui-subtype', extensions=None), is_container='list', yang_name="tlv", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='list', is_config=False)

  tlv = __builtin__.property(_get_tlv)


  _pyangbind_elements = OrderedDict([('tlv', tlv), ])


class yc_state_openconfig_lldp__lldp_interfaces_interface_neighbors_neighbor_capabilities_capability_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-lldp - based on the path /lldp/interfaces/interface/neighbors/neighbor/capabilities/capability/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state data for LLDP capabilities
  """
  __slots__ = ('_path_helper', '_extmethods', '__name','__enabled',)

  _yang_name = 'state'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'OTHER': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'oc-lldp-types:OTHER': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'REPEATER': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'oc-lldp-types:REPEATER': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'MAC_BRIDGE': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'oc-lldp-types:MAC_BRIDGE': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'WLAN_ACCESS_POINT': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'oc-lldp-types:WLAN_ACCESS_POINT': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'ROUTER': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'oc-lldp-types:ROUTER': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'TELEPHONE': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'oc-lldp-types:TELEPHONE': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'DOCSIS_CABLE_DEVICE': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'oc-lldp-types:DOCSIS_CABLE_DEVICE': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'STATION_ONLY': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'oc-lldp-types:STATION_ONLY': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'C_VLAN': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'oc-lldp-types:C_VLAN': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'S_VLAN': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'oc-lldp-types:S_VLAN': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'TWO_PORT_MAC_RELAY': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'oc-lldp-types:TWO_PORT_MAC_RELAY': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}},), is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='identityref', is_config=False)
    self.__enabled = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='boolean', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['lldp', 'interfaces', 'interface', 'neighbors', 'neighbor', 'capabilities', 'capability', 'state']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /lldp/interfaces/interface/neighbors/neighbor/capabilities/capability/state/name (identityref)

    YANG Description: Name of the system capability advertised by the neighbor.
Capabilities are represented in a bitmap that defines the
primary functions of the system. The capabilities are
defined in IEEE 802.1AB.
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /lldp/interfaces/interface/neighbors/neighbor/capabilities/capability/state/name (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: Name of the system capability advertised by the neighbor.
Capabilities are represented in a bitmap that defines the
primary functions of the system. The capabilities are
defined in IEEE 802.1AB.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'OTHER': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'oc-lldp-types:OTHER': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'REPEATER': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'oc-lldp-types:REPEATER': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'MAC_BRIDGE': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'oc-lldp-types:MAC_BRIDGE': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'WLAN_ACCESS_POINT': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'oc-lldp-types:WLAN_ACCESS_POINT': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'ROUTER': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'oc-lldp-types:ROUTER': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'TELEPHONE': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'oc-lldp-types:TELEPHONE': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'DOCSIS_CABLE_DEVICE': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'oc-lldp-types:DOCSIS_CABLE_DEVICE': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'STATION_ONLY': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'oc-lldp-types:STATION_ONLY': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'C_VLAN': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'oc-lldp-types:C_VLAN': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'S_VLAN': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'oc-lldp-types:S_VLAN': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'TWO_PORT_MAC_RELAY': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'oc-lldp-types:TWO_PORT_MAC_RELAY': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}},), is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='identityref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with identityref""",
          'defined-type': "openconfig-lldp:identityref",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'OTHER': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'oc-lldp-types:OTHER': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'REPEATER': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'oc-lldp-types:REPEATER': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'MAC_BRIDGE': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'oc-lldp-types:MAC_BRIDGE': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'WLAN_ACCESS_POINT': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'oc-lldp-types:WLAN_ACCESS_POINT': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'ROUTER': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'oc-lldp-types:ROUTER': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'TELEPHONE': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'oc-lldp-types:TELEPHONE': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'DOCSIS_CABLE_DEVICE': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'oc-lldp-types:DOCSIS_CABLE_DEVICE': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'STATION_ONLY': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'oc-lldp-types:STATION_ONLY': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'C_VLAN': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'oc-lldp-types:C_VLAN': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'S_VLAN': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'oc-lldp-types:S_VLAN': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'TWO_PORT_MAC_RELAY': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'oc-lldp-types:TWO_PORT_MAC_RELAY': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}},), is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='identityref', is_config=False)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'OTHER': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'oc-lldp-types:OTHER': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'REPEATER': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'oc-lldp-types:REPEATER': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'MAC_BRIDGE': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'oc-lldp-types:MAC_BRIDGE': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'WLAN_ACCESS_POINT': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'oc-lldp-types:WLAN_ACCESS_POINT': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'ROUTER': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'oc-lldp-types:ROUTER': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'TELEPHONE': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'oc-lldp-types:TELEPHONE': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'DOCSIS_CABLE_DEVICE': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'oc-lldp-types:DOCSIS_CABLE_DEVICE': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'STATION_ONLY': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'oc-lldp-types:STATION_ONLY': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'C_VLAN': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'oc-lldp-types:C_VLAN': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'S_VLAN': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'oc-lldp-types:S_VLAN': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'TWO_PORT_MAC_RELAY': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}, 'oc-lldp-types:TWO_PORT_MAC_RELAY': {'@module': 'openconfig-lldp-types', '@namespace': 'http://openconfig.net/yang/lldp/types'}},), is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='identityref', is_config=False)


  def _get_enabled(self):
    """
    Getter method for enabled, mapped from YANG variable /lldp/interfaces/interface/neighbors/neighbor/capabilities/capability/state/enabled (boolean)

    YANG Description: Indicates whether the corresponding system capability is
enabled on the neighbor.
    """
    return self.__enabled
      
  def _set_enabled(self, v, load=False):
    """
    Setter method for enabled, mapped from YANG variable /lldp/interfaces/interface/neighbors/neighbor/capabilities/capability/state/enabled (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_enabled is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_enabled() directly.

    YANG Description: Indicates whether the corresponding system capability is
enabled on the neighbor.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='boolean', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """enabled must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='boolean', is_config=False)""",
        })

    self.__enabled = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_enabled(self):
    self.__enabled = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='boolean', is_config=False)

  name = __builtin__.property(_get_name)
  enabled = __builtin__.property(_get_enabled)


  _pyangbind_elements = OrderedDict([('name', name), ('enabled', enabled), ])


class yc_capability_openconfig_lldp__lldp_interfaces_interface_neighbors_neighbor_capabilities_capability(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-lldp - based on the path /lldp/interfaces/interface/neighbors/neighbor/capabilities/capability. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: List of LLDP system capabilities advertised by the
neighbor
  """
  __slots__ = ('_path_helper', '_extmethods', '__name','__state',)

  _yang_name = 'capability'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='leafref', is_config=False)
    self.__state = YANGDynClass(base=yc_state_openconfig_lldp__lldp_interfaces_interface_neighbors_neighbor_capabilities_capability_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='container', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['lldp', 'interfaces', 'interface', 'neighbors', 'neighbor', 'capabilities', 'capability']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /lldp/interfaces/interface/neighbors/neighbor/capabilities/capability/name (leafref)

    YANG Description: Reference to capabilities list key
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /lldp/interfaces/interface/neighbors/neighbor/capabilities/capability/name (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: Reference to capabilities list key
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='leafref', is_config=False)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='leafref', is_config=False)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /lldp/interfaces/interface/neighbors/neighbor/capabilities/capability/state (container)

    YANG Description: Operational state data for LLDP capabilities
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /lldp/interfaces/interface/neighbors/neighbor/capabilities/capability/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state data for LLDP capabilities
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_lldp__lldp_interfaces_interface_neighbors_neighbor_capabilities_capability_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_lldp__lldp_interfaces_interface_neighbors_neighbor_capabilities_capability_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='container', is_config=False)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_lldp__lldp_interfaces_interface_neighbors_neighbor_capabilities_capability_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='container', is_config=False)

  name = __builtin__.property(_get_name)
  state = __builtin__.property(_get_state)


  _pyangbind_elements = OrderedDict([('name', name), ('state', state), ])


class yc_capabilities_openconfig_lldp__lldp_interfaces_interface_neighbors_neighbor_capabilities(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-lldp - based on the path /lldp/interfaces/interface/neighbors/neighbor/capabilities. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Enclosing container for list of LLDP capabilities
  """
  __slots__ = ('_path_helper', '_extmethods', '__capability',)

  _yang_name = 'capabilities'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__capability = YANGDynClass(base=YANGListType("name",yc_capability_openconfig_lldp__lldp_interfaces_interface_neighbors_neighbor_capabilities_capability, yang_name="capability", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="capability", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='list', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['lldp', 'interfaces', 'interface', 'neighbors', 'neighbor', 'capabilities']

  def _get_capability(self):
    """
    Getter method for capability, mapped from YANG variable /lldp/interfaces/interface/neighbors/neighbor/capabilities/capability (list)

    YANG Description: List of LLDP system capabilities advertised by the
neighbor
    """
    return self.__capability
      
  def _set_capability(self, v, load=False):
    """
    Setter method for capability, mapped from YANG variable /lldp/interfaces/interface/neighbors/neighbor/capabilities/capability (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_capability is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_capability() directly.

    YANG Description: List of LLDP system capabilities advertised by the
neighbor
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("name",yc_capability_openconfig_lldp__lldp_interfaces_interface_neighbors_neighbor_capabilities_capability, yang_name="capability", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="capability", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='list', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """capability must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("name",yc_capability_openconfig_lldp__lldp_interfaces_interface_neighbors_neighbor_capabilities_capability, yang_name="capability", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="capability", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='list', is_config=False)""",
        })

    self.__capability = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_capability(self):
    self.__capability = YANGDynClass(base=YANGListType("name",yc_capability_openconfig_lldp__lldp_interfaces_interface_neighbors_neighbor_capabilities_capability, yang_name="capability", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="capability", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='list', is_config=False)

  capability = __builtin__.property(_get_capability)


  _pyangbind_elements = OrderedDict([('capability', capability), ])


class yc_neighbor_openconfig_lldp__lldp_interfaces_interface_neighbors_neighbor(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-lldp - based on the path /lldp/interfaces/interface/neighbors/neighbor. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: List of LLDP neighbors
  """
  __slots__ = ('_path_helper', '_extmethods', '__id','__state','__custom_tlvs','__capabilities',)

  _yang_name = 'neighbor'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='leafref', is_config=False)
    self.__state = YANGDynClass(base=yc_state_openconfig_lldp__lldp_interfaces_interface_neighbors_neighbor_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='container', is_config=False)
    self.__custom_tlvs = YANGDynClass(base=yc_custom_tlvs_openconfig_lldp__lldp_interfaces_interface_neighbors_neighbor_custom_tlvs, is_container='container', yang_name="custom-tlvs", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='container', is_config=False)
    self.__capabilities = YANGDynClass(base=yc_capabilities_openconfig_lldp__lldp_interfaces_interface_neighbors_neighbor_capabilities, is_container='container', yang_name="capabilities", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='container', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['lldp', 'interfaces', 'interface', 'neighbors', 'neighbor']

  def _get_id(self):
    """
    Getter method for id, mapped from YANG variable /lldp/interfaces/interface/neighbors/neighbor/id (leafref)

    YANG Description:  
    """
    return self.__id
      
  def _set_id(self, v, load=False):
    """
    Setter method for id, mapped from YANG variable /lldp/interfaces/interface/neighbors/neighbor/id (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_id() directly.

    YANG Description:  
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """id must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='leafref', is_config=False)""",
        })

    self.__id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_id(self):
    self.__id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='leafref', is_config=False)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /lldp/interfaces/interface/neighbors/neighbor/state (container)

    YANG Description: Operational state data 
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /lldp/interfaces/interface/neighbors/neighbor/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state data 
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_lldp__lldp_interfaces_interface_neighbors_neighbor_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_lldp__lldp_interfaces_interface_neighbors_neighbor_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='container', is_config=False)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_lldp__lldp_interfaces_interface_neighbors_neighbor_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='container', is_config=False)


  def _get_custom_tlvs(self):
    """
    Getter method for custom_tlvs, mapped from YANG variable /lldp/interfaces/interface/neighbors/neighbor/custom_tlvs (container)

    YANG Description: Enclosing container for list of custom TLVs from a
neighbor
    """
    return self.__custom_tlvs
      
  def _set_custom_tlvs(self, v, load=False):
    """
    Setter method for custom_tlvs, mapped from YANG variable /lldp/interfaces/interface/neighbors/neighbor/custom_tlvs (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_custom_tlvs is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_custom_tlvs() directly.

    YANG Description: Enclosing container for list of custom TLVs from a
neighbor
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_custom_tlvs_openconfig_lldp__lldp_interfaces_interface_neighbors_neighbor_custom_tlvs, is_container='container', yang_name="custom-tlvs", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """custom_tlvs must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_custom_tlvs_openconfig_lldp__lldp_interfaces_interface_neighbors_neighbor_custom_tlvs, is_container='container', yang_name="custom-tlvs", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='container', is_config=False)""",
        })

    self.__custom_tlvs = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_custom_tlvs(self):
    self.__custom_tlvs = YANGDynClass(base=yc_custom_tlvs_openconfig_lldp__lldp_interfaces_interface_neighbors_neighbor_custom_tlvs, is_container='container', yang_name="custom-tlvs", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='container', is_config=False)


  def _get_capabilities(self):
    """
    Getter method for capabilities, mapped from YANG variable /lldp/interfaces/interface/neighbors/neighbor/capabilities (container)

    YANG Description: Enclosing container for list of LLDP capabilities
    """
    return self.__capabilities
      
  def _set_capabilities(self, v, load=False):
    """
    Setter method for capabilities, mapped from YANG variable /lldp/interfaces/interface/neighbors/neighbor/capabilities (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_capabilities is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_capabilities() directly.

    YANG Description: Enclosing container for list of LLDP capabilities
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_capabilities_openconfig_lldp__lldp_interfaces_interface_neighbors_neighbor_capabilities, is_container='container', yang_name="capabilities", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """capabilities must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_capabilities_openconfig_lldp__lldp_interfaces_interface_neighbors_neighbor_capabilities, is_container='container', yang_name="capabilities", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='container', is_config=False)""",
        })

    self.__capabilities = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_capabilities(self):
    self.__capabilities = YANGDynClass(base=yc_capabilities_openconfig_lldp__lldp_interfaces_interface_neighbors_neighbor_capabilities, is_container='container', yang_name="capabilities", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='container', is_config=False)

  id = __builtin__.property(_get_id)
  state = __builtin__.property(_get_state)
  custom_tlvs = __builtin__.property(_get_custom_tlvs)
  capabilities = __builtin__.property(_get_capabilities)


  _pyangbind_elements = OrderedDict([('id', id), ('state', state), ('custom_tlvs', custom_tlvs), ('capabilities', capabilities), ])


class yc_neighbors_openconfig_lldp__lldp_interfaces_interface_neighbors(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-lldp - based on the path /lldp/interfaces/interface/neighbors. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Enclosing container for list of LLDP neighbors on an
interface
  """
  __slots__ = ('_path_helper', '_extmethods', '__neighbor',)

  _yang_name = 'neighbors'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__neighbor = YANGDynClass(base=YANGListType("id",yc_neighbor_openconfig_lldp__lldp_interfaces_interface_neighbors_neighbor, yang_name="neighbor", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='id', extensions=None), is_container='list', yang_name="neighbor", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='list', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['lldp', 'interfaces', 'interface', 'neighbors']

  def _get_neighbor(self):
    """
    Getter method for neighbor, mapped from YANG variable /lldp/interfaces/interface/neighbors/neighbor (list)

    YANG Description: List of LLDP neighbors
    """
    return self.__neighbor
      
  def _set_neighbor(self, v, load=False):
    """
    Setter method for neighbor, mapped from YANG variable /lldp/interfaces/interface/neighbors/neighbor (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_neighbor is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_neighbor() directly.

    YANG Description: List of LLDP neighbors
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("id",yc_neighbor_openconfig_lldp__lldp_interfaces_interface_neighbors_neighbor, yang_name="neighbor", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='id', extensions=None), is_container='list', yang_name="neighbor", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='list', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """neighbor must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("id",yc_neighbor_openconfig_lldp__lldp_interfaces_interface_neighbors_neighbor, yang_name="neighbor", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='id', extensions=None), is_container='list', yang_name="neighbor", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='list', is_config=False)""",
        })

    self.__neighbor = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_neighbor(self):
    self.__neighbor = YANGDynClass(base=YANGListType("id",yc_neighbor_openconfig_lldp__lldp_interfaces_interface_neighbors_neighbor, yang_name="neighbor", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='id', extensions=None), is_container='list', yang_name="neighbor", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='list', is_config=False)

  neighbor = __builtin__.property(_get_neighbor)


  _pyangbind_elements = OrderedDict([('neighbor', neighbor), ])


class yc_interface_openconfig_lldp__lldp_interfaces_interface(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-lldp - based on the path /lldp/interfaces/interface. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: List of interfaces on which LLDP is enabled / available
  """
  __slots__ = ('_path_helper', '_extmethods', '__name','__config','__state','__neighbors',)

  _yang_name = 'interface'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='leafref', is_config=True)
    self.__config = YANGDynClass(base=yc_config_openconfig_lldp__lldp_interfaces_interface_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_lldp__lldp_interfaces_interface_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='container', is_config=True)
    self.__neighbors = YANGDynClass(base=yc_neighbors_openconfig_lldp__lldp_interfaces_interface_neighbors, is_container='container', yang_name="neighbors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['lldp', 'interfaces', 'interface']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /lldp/interfaces/interface/name (leafref)

    YANG Description: Reference to the list key
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /lldp/interfaces/interface/name (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: Reference to the list key
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='leafref', is_config=True)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='leafref', is_config=True)


  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /lldp/interfaces/interface/config (container)

    YANG Description: Configuration data for LLDP on each interface
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /lldp/interfaces/interface/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration data for LLDP on each interface
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_lldp__lldp_interfaces_interface_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_lldp__lldp_interfaces_interface_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_lldp__lldp_interfaces_interface_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /lldp/interfaces/interface/state (container)

    YANG Description: Operational state data 
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /lldp/interfaces/interface/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state data 
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_lldp__lldp_interfaces_interface_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_lldp__lldp_interfaces_interface_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_lldp__lldp_interfaces_interface_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='container', is_config=True)


  def _get_neighbors(self):
    """
    Getter method for neighbors, mapped from YANG variable /lldp/interfaces/interface/neighbors (container)

    YANG Description: Enclosing container for list of LLDP neighbors on an
interface
    """
    return self.__neighbors
      
  def _set_neighbors(self, v, load=False):
    """
    Setter method for neighbors, mapped from YANG variable /lldp/interfaces/interface/neighbors (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_neighbors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_neighbors() directly.

    YANG Description: Enclosing container for list of LLDP neighbors on an
interface
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_neighbors_openconfig_lldp__lldp_interfaces_interface_neighbors, is_container='container', yang_name="neighbors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """neighbors must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_neighbors_openconfig_lldp__lldp_interfaces_interface_neighbors, is_container='container', yang_name="neighbors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='container', is_config=True)""",
        })

    self.__neighbors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_neighbors(self):
    self.__neighbors = YANGDynClass(base=yc_neighbors_openconfig_lldp__lldp_interfaces_interface_neighbors, is_container='container', yang_name="neighbors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='container', is_config=True)

  name = __builtin__.property(_get_name, _set_name)
  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)
  neighbors = __builtin__.property(_get_neighbors, _set_neighbors)


  _pyangbind_elements = OrderedDict([('name', name), ('config', config), ('state', state), ('neighbors', neighbors), ])


class yc_interfaces_openconfig_lldp__lldp_interfaces(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-lldp - based on the path /lldp/interfaces. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Enclosing container 
  """
  __slots__ = ('_path_helper', '_extmethods', '__interface',)

  _yang_name = 'interfaces'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__interface = YANGDynClass(base=YANGListType("name",yc_interface_openconfig_lldp__lldp_interfaces_interface, yang_name="interface", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='list', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['lldp', 'interfaces']

  def _get_interface(self):
    """
    Getter method for interface, mapped from YANG variable /lldp/interfaces/interface (list)

    YANG Description: List of interfaces on which LLDP is enabled / available
    """
    return self.__interface
      
  def _set_interface(self, v, load=False):
    """
    Setter method for interface, mapped from YANG variable /lldp/interfaces/interface (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_interface is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_interface() directly.

    YANG Description: List of interfaces on which LLDP is enabled / available
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("name",yc_interface_openconfig_lldp__lldp_interfaces_interface, yang_name="interface", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='list', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """interface must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("name",yc_interface_openconfig_lldp__lldp_interfaces_interface, yang_name="interface", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='list', is_config=True)""",
        })

    self.__interface = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_interface(self):
    self.__interface = YANGDynClass(base=YANGListType("name",yc_interface_openconfig_lldp__lldp_interfaces_interface, yang_name="interface", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='list', is_config=True)

  interface = __builtin__.property(_get_interface, _set_interface)


  _pyangbind_elements = OrderedDict([('interface', interface), ])


class yc_lldp_openconfig_lldp__lldp(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-lldp - based on the path /lldp. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Top-level container for LLDP configuration and state data
  """
  __slots__ = ('_path_helper', '_extmethods', '__config','__state','__interfaces',)

  _yang_name = 'lldp'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__config = YANGDynClass(base=yc_config_openconfig_lldp__lldp_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_lldp__lldp_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='container', is_config=True)
    self.__interfaces = YANGDynClass(base=yc_interfaces_openconfig_lldp__lldp_interfaces, is_container='container', yang_name="interfaces", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['lldp']

  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /lldp/config (container)

    YANG Description: Configuration data 
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /lldp/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration data 
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_lldp__lldp_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_lldp__lldp_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_lldp__lldp_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /lldp/state (container)

    YANG Description: Operational state data 
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /lldp/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state data 
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_lldp__lldp_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_lldp__lldp_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_lldp__lldp_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='container', is_config=True)


  def _get_interfaces(self):
    """
    Getter method for interfaces, mapped from YANG variable /lldp/interfaces (container)

    YANG Description: Enclosing container 
    """
    return self.__interfaces
      
  def _set_interfaces(self, v, load=False):
    """
    Setter method for interfaces, mapped from YANG variable /lldp/interfaces (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_interfaces is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_interfaces() directly.

    YANG Description: Enclosing container 
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_interfaces_openconfig_lldp__lldp_interfaces, is_container='container', yang_name="interfaces", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """interfaces must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_interfaces_openconfig_lldp__lldp_interfaces, is_container='container', yang_name="interfaces", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='container', is_config=True)""",
        })

    self.__interfaces = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_interfaces(self):
    self.__interfaces = YANGDynClass(base=yc_interfaces_openconfig_lldp__lldp_interfaces, is_container='container', yang_name="interfaces", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='container', is_config=True)

  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)
  interfaces = __builtin__.property(_get_interfaces, _set_interfaces)


  _pyangbind_elements = OrderedDict([('config', config), ('state', state), ('interfaces', interfaces), ])


class openconfig_lldp(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-lldp - based on the path /openconfig-lldp. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: This module defines configuration and operational state data
for the LLDP protocol.
  """
  __slots__ = ('_path_helper', '_extmethods', '__lldp',)

  _yang_name = 'openconfig-lldp'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__lldp = YANGDynClass(base=yc_lldp_openconfig_lldp__lldp, is_container='container', yang_name="lldp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return []

  def _get_lldp(self):
    """
    Getter method for lldp, mapped from YANG variable /lldp (container)

    YANG Description: Top-level container for LLDP configuration and state data
    """
    return self.__lldp
      
  def _set_lldp(self, v, load=False):
    """
    Setter method for lldp, mapped from YANG variable /lldp (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_lldp is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_lldp() directly.

    YANG Description: Top-level container for LLDP configuration and state data
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_lldp_openconfig_lldp__lldp, is_container='container', yang_name="lldp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """lldp must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_lldp_openconfig_lldp__lldp, is_container='container', yang_name="lldp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='container', is_config=True)""",
        })

    self.__lldp = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_lldp(self):
    self.__lldp = YANGDynClass(base=yc_lldp_openconfig_lldp__lldp, is_container='container', yang_name="lldp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/lldp', defining_module='openconfig-lldp', yang_type='container', is_config=True)

  lldp = __builtin__.property(_get_lldp, _set_lldp)


  _pyangbind_elements = OrderedDict([('lldp', lldp), ])


class openconfig_lldp_types(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-lldp-types - based on the path /openconfig-lldp-types. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: This module defines types related to the LLDP protocol model.
  """
  _pyangbind_elements = {}

  

