# -*- coding: utf-8 -*-
from operator import attrgetter
from pyangbind.lib.yangtypes import RestrictedPrecisionDecimalType
from pyangbind.lib.yangtypes import RestrictedClassType
from pyangbind.lib.yangtypes import TypedListType
from pyangbind.lib.yangtypes import YANGBool
from pyangbind.lib.yangtypes import YANGListType
from pyangbind.lib.yangtypes import YANGDynClass
from pyangbind.lib.yangtypes import ReferenceType
from pyangbind.lib.base import PybindBase
from collections import OrderedDict
from decimal import Decimal
from bitarray import bitarray
import six

# PY3 support of some PY2 keywords (needs improved)
if six.PY3:
  import builtins as __builtin__
  long = int
elif six.PY2:
  import __builtin__

class openconfig_packet_match(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-packet-match - based on the path /openconfig-packet-match. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: This module defines data related to packet header fields
used in matching operations, for example in ACLs.  When a
field is omitted from a match expression, the effect is a
wildcard ('any') for that field.
  """
  _pyangbind_elements = {}

  

class openconfig_packet_match_types(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-packet-match-types - based on the path /openconfig-packet-match-types. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: This module defines common types for use in models requiring
data definitions related to packet matches.
  """
  _pyangbind_elements = {}

  

class yc_state_openconfig_acl__acl_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-acl - based on the path /acl/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Global operational state data for ACLs
  """
  __slots__ = ('_path_helper', '_extmethods', '__counter_capability',)

  _yang_name = 'state'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__counter_capability = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'INTERFACE_ONLY': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:INTERFACE_ONLY': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'AGGREGATE_ONLY': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:AGGREGATE_ONLY': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'INTERFACE_AGGREGATE': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:INTERFACE_AGGREGATE': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}},), is_leaf=True, yang_name="counter-capability", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='identityref', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['acl', 'state']

  def _get_counter_capability(self):
    """
    Getter method for counter_capability, mapped from YANG variable /acl/state/counter_capability (identityref)

    YANG Description: System reported indication of how ACL counters are reported
by the target
    """
    return self.__counter_capability
      
  def _set_counter_capability(self, v, load=False):
    """
    Setter method for counter_capability, mapped from YANG variable /acl/state/counter_capability (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_counter_capability is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_counter_capability() directly.

    YANG Description: System reported indication of how ACL counters are reported
by the target
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'INTERFACE_ONLY': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:INTERFACE_ONLY': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'AGGREGATE_ONLY': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:AGGREGATE_ONLY': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'INTERFACE_AGGREGATE': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:INTERFACE_AGGREGATE': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}},), is_leaf=True, yang_name="counter-capability", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='identityref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """counter_capability must be of a type compatible with identityref""",
          'defined-type': "openconfig-acl:identityref",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'INTERFACE_ONLY': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:INTERFACE_ONLY': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'AGGREGATE_ONLY': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:AGGREGATE_ONLY': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'INTERFACE_AGGREGATE': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:INTERFACE_AGGREGATE': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}},), is_leaf=True, yang_name="counter-capability", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='identityref', is_config=False)""",
        })

    self.__counter_capability = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_counter_capability(self):
    self.__counter_capability = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'INTERFACE_ONLY': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:INTERFACE_ONLY': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'AGGREGATE_ONLY': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:AGGREGATE_ONLY': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'INTERFACE_AGGREGATE': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:INTERFACE_AGGREGATE': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}},), is_leaf=True, yang_name="counter-capability", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='identityref', is_config=False)

  counter_capability = __builtin__.property(_get_counter_capability)


  _pyangbind_elements = OrderedDict([('counter_capability', counter_capability), ])


class yc_config_openconfig_acl__acl_acl_sets_acl_set_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-acl - based on the path /acl/acl-sets/acl-set/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Access list config
  """
  __slots__ = ('_path_helper', '_extmethods', '__name','__type','__description',)

  _yang_name = 'config'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='string', is_config=True)
    self.__type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ACL_IPV4': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:ACL_IPV4': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'ACL_IPV6': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:ACL_IPV6': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'ACL_L2': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:ACL_L2': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'ACL_MIXED': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:ACL_MIXED': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'ACL_MPLS': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:ACL_MPLS': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}},), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='identityref', is_config=True)
    self.__description = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='string', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['acl', 'acl-sets', 'acl-set', 'config']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /acl/acl_sets/acl_set/config/name (string)

    YANG Description: The name of the access-list set
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /acl/acl_sets/acl_set/config/name (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: The name of the access-list set
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='string', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='string', is_config=True)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='string', is_config=True)


  def _get_type(self):
    """
    Getter method for type, mapped from YANG variable /acl/acl_sets/acl_set/config/type (identityref)

    YANG Description: The type determines the fields allowed in the ACL entries
belonging to the ACL set (e.g., IPv4, IPv6, etc.)
    """
    return self.__type
      
  def _set_type(self, v, load=False):
    """
    Setter method for type, mapped from YANG variable /acl/acl_sets/acl_set/config/type (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_type is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_type() directly.

    YANG Description: The type determines the fields allowed in the ACL entries
belonging to the ACL set (e.g., IPv4, IPv6, etc.)
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ACL_IPV4': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:ACL_IPV4': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'ACL_IPV6': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:ACL_IPV6': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'ACL_L2': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:ACL_L2': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'ACL_MIXED': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:ACL_MIXED': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'ACL_MPLS': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:ACL_MPLS': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}},), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='identityref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """type must be of a type compatible with identityref""",
          'defined-type': "openconfig-acl:identityref",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ACL_IPV4': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:ACL_IPV4': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'ACL_IPV6': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:ACL_IPV6': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'ACL_L2': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:ACL_L2': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'ACL_MIXED': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:ACL_MIXED': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'ACL_MPLS': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:ACL_MPLS': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}},), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='identityref', is_config=True)""",
        })

    self.__type = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_type(self):
    self.__type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ACL_IPV4': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:ACL_IPV4': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'ACL_IPV6': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:ACL_IPV6': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'ACL_L2': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:ACL_L2': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'ACL_MIXED': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:ACL_MIXED': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'ACL_MPLS': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:ACL_MPLS': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}},), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='identityref', is_config=True)


  def _get_description(self):
    """
    Getter method for description, mapped from YANG variable /acl/acl_sets/acl_set/config/description (string)

    YANG Description: Description, or comment, for the ACL set
    """
    return self.__description
      
  def _set_description(self, v, load=False):
    """
    Setter method for description, mapped from YANG variable /acl/acl_sets/acl_set/config/description (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_description is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_description() directly.

    YANG Description: Description, or comment, for the ACL set
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='string', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """description must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='string', is_config=True)""",
        })

    self.__description = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_description(self):
    self.__description = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='string', is_config=True)

  name = __builtin__.property(_get_name, _set_name)
  type = __builtin__.property(_get_type, _set_type)
  description = __builtin__.property(_get_description, _set_description)


  _pyangbind_elements = OrderedDict([('name', name), ('type', type), ('description', description), ])


class yc_state_openconfig_acl__acl_acl_sets_acl_set_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-acl - based on the path /acl/acl-sets/acl-set/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Access list state information
  """
  __slots__ = ('_path_helper', '_extmethods', '__name','__type','__description',)

  _yang_name = 'state'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='string', is_config=False)
    self.__type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ACL_IPV4': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:ACL_IPV4': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'ACL_IPV6': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:ACL_IPV6': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'ACL_L2': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:ACL_L2': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'ACL_MIXED': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:ACL_MIXED': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'ACL_MPLS': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:ACL_MPLS': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}},), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='identityref', is_config=False)
    self.__description = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='string', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['acl', 'acl-sets', 'acl-set', 'state']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /acl/acl_sets/acl_set/state/name (string)

    YANG Description: The name of the access-list set
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /acl/acl_sets/acl_set/state/name (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: The name of the access-list set
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='string', is_config=False)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='string', is_config=False)


  def _get_type(self):
    """
    Getter method for type, mapped from YANG variable /acl/acl_sets/acl_set/state/type (identityref)

    YANG Description: The type determines the fields allowed in the ACL entries
belonging to the ACL set (e.g., IPv4, IPv6, etc.)
    """
    return self.__type
      
  def _set_type(self, v, load=False):
    """
    Setter method for type, mapped from YANG variable /acl/acl_sets/acl_set/state/type (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_type is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_type() directly.

    YANG Description: The type determines the fields allowed in the ACL entries
belonging to the ACL set (e.g., IPv4, IPv6, etc.)
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ACL_IPV4': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:ACL_IPV4': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'ACL_IPV6': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:ACL_IPV6': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'ACL_L2': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:ACL_L2': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'ACL_MIXED': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:ACL_MIXED': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'ACL_MPLS': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:ACL_MPLS': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}},), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='identityref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """type must be of a type compatible with identityref""",
          'defined-type': "openconfig-acl:identityref",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ACL_IPV4': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:ACL_IPV4': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'ACL_IPV6': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:ACL_IPV6': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'ACL_L2': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:ACL_L2': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'ACL_MIXED': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:ACL_MIXED': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'ACL_MPLS': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:ACL_MPLS': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}},), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='identityref', is_config=False)""",
        })

    self.__type = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_type(self):
    self.__type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ACL_IPV4': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:ACL_IPV4': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'ACL_IPV6': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:ACL_IPV6': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'ACL_L2': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:ACL_L2': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'ACL_MIXED': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:ACL_MIXED': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'ACL_MPLS': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:ACL_MPLS': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}},), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='identityref', is_config=False)


  def _get_description(self):
    """
    Getter method for description, mapped from YANG variable /acl/acl_sets/acl_set/state/description (string)

    YANG Description: Description, or comment, for the ACL set
    """
    return self.__description
      
  def _set_description(self, v, load=False):
    """
    Setter method for description, mapped from YANG variable /acl/acl_sets/acl_set/state/description (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_description is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_description() directly.

    YANG Description: Description, or comment, for the ACL set
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """description must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='string', is_config=False)""",
        })

    self.__description = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_description(self):
    self.__description = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='string', is_config=False)

  name = __builtin__.property(_get_name)
  type = __builtin__.property(_get_type)
  description = __builtin__.property(_get_description)


  _pyangbind_elements = OrderedDict([('name', name), ('type', type), ('description', description), ])


class yc_config_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-acl - based on the path /acl/acl-sets/acl-set/acl-entries/acl-entry/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Access list entries config
  """
  __slots__ = ('_path_helper', '_extmethods', '__sequence_id','__description',)

  _yang_name = 'config'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__sequence_id = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="sequence-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='uint32', is_config=True)
    self.__description = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='string', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['acl', 'acl-sets', 'acl-set', 'acl-entries', 'acl-entry', 'config']

  def _get_sequence_id(self):
    """
    Getter method for sequence_id, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/config/sequence_id (uint32)

    YANG Description: The sequence id determines the order in which ACL entries
are applied.  The sequence id must be unique for each entry
in an ACL set.  Target devices should apply the ACL entry
rules in ascending order determined by sequence id (low to
high), rather than the relying only on order in the list.
    """
    return self.__sequence_id
      
  def _set_sequence_id(self, v, load=False):
    """
    Setter method for sequence_id, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/config/sequence_id (uint32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_sequence_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_sequence_id() directly.

    YANG Description: The sequence id determines the order in which ACL entries
are applied.  The sequence id must be unique for each entry
in an ACL set.  Target devices should apply the ACL entry
rules in ascending order determined by sequence id (low to
high), rather than the relying only on order in the list.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="sequence-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='uint32', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """sequence_id must be of a type compatible with uint32""",
          'defined-type': "uint32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="sequence-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='uint32', is_config=True)""",
        })

    self.__sequence_id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_sequence_id(self):
    self.__sequence_id = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="sequence-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='uint32', is_config=True)


  def _get_description(self):
    """
    Getter method for description, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/config/description (string)

    YANG Description: A user-defined description, or comment, for this Access List
Entry.
    """
    return self.__description
      
  def _set_description(self, v, load=False):
    """
    Setter method for description, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/config/description (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_description is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_description() directly.

    YANG Description: A user-defined description, or comment, for this Access List
Entry.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='string', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """description must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='string', is_config=True)""",
        })

    self.__description = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_description(self):
    self.__description = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='string', is_config=True)

  sequence_id = __builtin__.property(_get_sequence_id, _set_sequence_id)
  description = __builtin__.property(_get_description, _set_description)


  _pyangbind_elements = OrderedDict([('sequence_id', sequence_id), ('description', description), ])


class yc_state_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-acl - based on the path /acl/acl-sets/acl-set/acl-entries/acl-entry/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: State information for ACL entries
  """
  __slots__ = ('_path_helper', '_extmethods', '__sequence_id','__description','__matched_packets','__matched_octets',)

  _yang_name = 'state'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__sequence_id = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="sequence-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='uint32', is_config=False)
    self.__description = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='string', is_config=False)
    self.__matched_packets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="matched-packets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-yang:counter64', is_config=False)
    self.__matched_octets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="matched-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-yang:counter64', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['acl', 'acl-sets', 'acl-set', 'acl-entries', 'acl-entry', 'state']

  def _get_sequence_id(self):
    """
    Getter method for sequence_id, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/state/sequence_id (uint32)

    YANG Description: The sequence id determines the order in which ACL entries
are applied.  The sequence id must be unique for each entry
in an ACL set.  Target devices should apply the ACL entry
rules in ascending order determined by sequence id (low to
high), rather than the relying only on order in the list.
    """
    return self.__sequence_id
      
  def _set_sequence_id(self, v, load=False):
    """
    Setter method for sequence_id, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/state/sequence_id (uint32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_sequence_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_sequence_id() directly.

    YANG Description: The sequence id determines the order in which ACL entries
are applied.  The sequence id must be unique for each entry
in an ACL set.  Target devices should apply the ACL entry
rules in ascending order determined by sequence id (low to
high), rather than the relying only on order in the list.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="sequence-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='uint32', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """sequence_id must be of a type compatible with uint32""",
          'defined-type': "uint32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="sequence-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='uint32', is_config=False)""",
        })

    self.__sequence_id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_sequence_id(self):
    self.__sequence_id = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="sequence-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='uint32', is_config=False)


  def _get_description(self):
    """
    Getter method for description, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/state/description (string)

    YANG Description: A user-defined description, or comment, for this Access List
Entry.
    """
    return self.__description
      
  def _set_description(self, v, load=False):
    """
    Setter method for description, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/state/description (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_description is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_description() directly.

    YANG Description: A user-defined description, or comment, for this Access List
Entry.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """description must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='string', is_config=False)""",
        })

    self.__description = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_description(self):
    self.__description = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='string', is_config=False)


  def _get_matched_packets(self):
    """
    Getter method for matched_packets, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/state/matched_packets (oc-yang:counter64)

    YANG Description: Count of the number of packets matching the current ACL
entry.

An implementation should provide this counter on a
per-interface per-ACL-entry if possible.

If an implementation only supports ACL counters per entry
(i.e., not broken out per interface), then the value
should be equal to the aggregate count across all interfaces.

An implementation that provides counters per entry per
interface is not required to also provide an aggregate count,
e.g., per entry -- the user is expected to be able implement
the required aggregation if such a count is needed.
    """
    return self.__matched_packets
      
  def _set_matched_packets(self, v, load=False):
    """
    Setter method for matched_packets, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/state/matched_packets (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_matched_packets is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_matched_packets() directly.

    YANG Description: Count of the number of packets matching the current ACL
entry.

An implementation should provide this counter on a
per-interface per-ACL-entry if possible.

If an implementation only supports ACL counters per entry
(i.e., not broken out per interface), then the value
should be equal to the aggregate count across all interfaces.

An implementation that provides counters per entry per
interface is not required to also provide an aggregate count,
e.g., per entry -- the user is expected to be able implement
the required aggregation if such a count is needed.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="matched-packets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """matched_packets must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="matched-packets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__matched_packets = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_matched_packets(self):
    self.__matched_packets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="matched-packets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-yang:counter64', is_config=False)


  def _get_matched_octets(self):
    """
    Getter method for matched_octets, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/state/matched_octets (oc-yang:counter64)

    YANG Description: Count of the number of octets (bytes) matching the current
ACL entry.

An implementation should provide this counter on a
per-interface per-ACL-entry if possible.

If an implementation only supports ACL counters per entry
(i.e., not broken out per interface), then the value
should be equal to the aggregate count across all interfaces.

An implementation that provides counters per entry per
interface is not required to also provide an aggregate count,
e.g., per entry -- the user is expected to be able implement
the required aggregation if such a count is needed.
    """
    return self.__matched_octets
      
  def _set_matched_octets(self, v, load=False):
    """
    Setter method for matched_octets, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/state/matched_octets (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_matched_octets is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_matched_octets() directly.

    YANG Description: Count of the number of octets (bytes) matching the current
ACL entry.

An implementation should provide this counter on a
per-interface per-ACL-entry if possible.

If an implementation only supports ACL counters per entry
(i.e., not broken out per interface), then the value
should be equal to the aggregate count across all interfaces.

An implementation that provides counters per entry per
interface is not required to also provide an aggregate count,
e.g., per entry -- the user is expected to be able implement
the required aggregation if such a count is needed.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="matched-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """matched_octets must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="matched-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__matched_octets = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_matched_octets(self):
    self.__matched_octets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="matched-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-yang:counter64', is_config=False)

  sequence_id = __builtin__.property(_get_sequence_id)
  description = __builtin__.property(_get_description)
  matched_packets = __builtin__.property(_get_matched_packets)
  matched_octets = __builtin__.property(_get_matched_octets)


  _pyangbind_elements = OrderedDict([('sequence_id', sequence_id), ('description', description), ('matched_packets', matched_packets), ('matched_octets', matched_octets), ])


class yc_config_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_l2_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-acl - based on the path /acl/acl-sets/acl-set/acl-entries/acl-entry/l2/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration data
  """
  __slots__ = ('_path_helper', '_extmethods', '__source_mac','__source_mac_mask','__destination_mac','__destination_mac_mask','__ethertype',)

  _yang_name = 'config'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__source_mac = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="source-mac", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-yang:mac-address', is_config=True)
    self.__source_mac_mask = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="source-mac-mask", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-yang:mac-address', is_config=True)
    self.__destination_mac = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="destination-mac", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-yang:mac-address', is_config=True)
    self.__destination_mac_mask = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="destination-mac-mask", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-yang:mac-address', is_config=True)
    self.__ethertype = YANGDynClass(base=[RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1536..65535']}),RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ETHERTYPE_IPV4': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_IPV4': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_ARP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_ARP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_VLAN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_VLAN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_IPV6': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_IPV6': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_MPLS': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_MPLS': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_LLDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_LLDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_ROCE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_ROCE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}},),], is_leaf=True, yang_name="ethertype", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-pkt-match-types:ethertype-type', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['acl', 'acl-sets', 'acl-set', 'acl-entries', 'acl-entry', 'l2', 'config']

  def _get_source_mac(self):
    """
    Getter method for source_mac, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/l2/config/source_mac (oc-yang:mac-address)

    YANG Description: Source IEEE 802 MAC address.
    """
    return self.__source_mac
      
  def _set_source_mac(self, v, load=False):
    """
    Setter method for source_mac, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/l2/config/source_mac (oc-yang:mac-address)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_source_mac is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_source_mac() directly.

    YANG Description: Source IEEE 802 MAC address.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="source-mac", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-yang:mac-address', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """source_mac must be of a type compatible with oc-yang:mac-address""",
          'defined-type': "oc-yang:mac-address",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="source-mac", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-yang:mac-address', is_config=True)""",
        })

    self.__source_mac = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_source_mac(self):
    self.__source_mac = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="source-mac", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-yang:mac-address', is_config=True)


  def _get_source_mac_mask(self):
    """
    Getter method for source_mac_mask, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/l2/config/source_mac_mask (oc-yang:mac-address)

    YANG Description: Source IEEE 802 MAC address mask.
    """
    return self.__source_mac_mask
      
  def _set_source_mac_mask(self, v, load=False):
    """
    Setter method for source_mac_mask, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/l2/config/source_mac_mask (oc-yang:mac-address)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_source_mac_mask is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_source_mac_mask() directly.

    YANG Description: Source IEEE 802 MAC address mask.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="source-mac-mask", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-yang:mac-address', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """source_mac_mask must be of a type compatible with oc-yang:mac-address""",
          'defined-type': "oc-yang:mac-address",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="source-mac-mask", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-yang:mac-address', is_config=True)""",
        })

    self.__source_mac_mask = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_source_mac_mask(self):
    self.__source_mac_mask = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="source-mac-mask", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-yang:mac-address', is_config=True)


  def _get_destination_mac(self):
    """
    Getter method for destination_mac, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/l2/config/destination_mac (oc-yang:mac-address)

    YANG Description: Destination IEEE 802 MAC address.
    """
    return self.__destination_mac
      
  def _set_destination_mac(self, v, load=False):
    """
    Setter method for destination_mac, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/l2/config/destination_mac (oc-yang:mac-address)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_destination_mac is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_destination_mac() directly.

    YANG Description: Destination IEEE 802 MAC address.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="destination-mac", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-yang:mac-address', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """destination_mac must be of a type compatible with oc-yang:mac-address""",
          'defined-type': "oc-yang:mac-address",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="destination-mac", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-yang:mac-address', is_config=True)""",
        })

    self.__destination_mac = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_destination_mac(self):
    self.__destination_mac = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="destination-mac", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-yang:mac-address', is_config=True)


  def _get_destination_mac_mask(self):
    """
    Getter method for destination_mac_mask, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/l2/config/destination_mac_mask (oc-yang:mac-address)

    YANG Description: Destination IEEE 802 MAC address mask.
    """
    return self.__destination_mac_mask
      
  def _set_destination_mac_mask(self, v, load=False):
    """
    Setter method for destination_mac_mask, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/l2/config/destination_mac_mask (oc-yang:mac-address)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_destination_mac_mask is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_destination_mac_mask() directly.

    YANG Description: Destination IEEE 802 MAC address mask.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="destination-mac-mask", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-yang:mac-address', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """destination_mac_mask must be of a type compatible with oc-yang:mac-address""",
          'defined-type': "oc-yang:mac-address",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="destination-mac-mask", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-yang:mac-address', is_config=True)""",
        })

    self.__destination_mac_mask = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_destination_mac_mask(self):
    self.__destination_mac_mask = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="destination-mac-mask", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-yang:mac-address', is_config=True)


  def _get_ethertype(self):
    """
    Getter method for ethertype, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/l2/config/ethertype (oc-pkt-match-types:ethertype-type)

    YANG Description: Ethertype field to match in Ethernet packets
    """
    return self.__ethertype
      
  def _set_ethertype(self, v, load=False):
    """
    Setter method for ethertype, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/l2/config/ethertype (oc-pkt-match-types:ethertype-type)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_ethertype is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_ethertype() directly.

    YANG Description: Ethertype field to match in Ethernet packets
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=[RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1536..65535']}),RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ETHERTYPE_IPV4': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_IPV4': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_ARP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_ARP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_VLAN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_VLAN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_IPV6': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_IPV6': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_MPLS': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_MPLS': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_LLDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_LLDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_ROCE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_ROCE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}},),], is_leaf=True, yang_name="ethertype", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-pkt-match-types:ethertype-type', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """ethertype must be of a type compatible with oc-pkt-match-types:ethertype-type""",
          'defined-type': "oc-pkt-match-types:ethertype-type",
          'generated-type': """YANGDynClass(base=[RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1536..65535']}),RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ETHERTYPE_IPV4': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_IPV4': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_ARP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_ARP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_VLAN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_VLAN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_IPV6': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_IPV6': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_MPLS': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_MPLS': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_LLDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_LLDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_ROCE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_ROCE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}},),], is_leaf=True, yang_name="ethertype", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-pkt-match-types:ethertype-type', is_config=True)""",
        })

    self.__ethertype = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_ethertype(self):
    self.__ethertype = YANGDynClass(base=[RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1536..65535']}),RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ETHERTYPE_IPV4': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_IPV4': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_ARP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_ARP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_VLAN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_VLAN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_IPV6': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_IPV6': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_MPLS': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_MPLS': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_LLDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_LLDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_ROCE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_ROCE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}},),], is_leaf=True, yang_name="ethertype", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-pkt-match-types:ethertype-type', is_config=True)

  source_mac = __builtin__.property(_get_source_mac, _set_source_mac)
  source_mac_mask = __builtin__.property(_get_source_mac_mask, _set_source_mac_mask)
  destination_mac = __builtin__.property(_get_destination_mac, _set_destination_mac)
  destination_mac_mask = __builtin__.property(_get_destination_mac_mask, _set_destination_mac_mask)
  ethertype = __builtin__.property(_get_ethertype, _set_ethertype)


  _pyangbind_elements = OrderedDict([('source_mac', source_mac), ('source_mac_mask', source_mac_mask), ('destination_mac', destination_mac), ('destination_mac_mask', destination_mac_mask), ('ethertype', ethertype), ])


class yc_state_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_l2_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-acl - based on the path /acl/acl-sets/acl-set/acl-entries/acl-entry/l2/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: State Information.
  """
  __slots__ = ('_path_helper', '_extmethods', '__source_mac','__source_mac_mask','__destination_mac','__destination_mac_mask','__ethertype',)

  _yang_name = 'state'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__source_mac = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="source-mac", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-yang:mac-address', is_config=False)
    self.__source_mac_mask = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="source-mac-mask", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-yang:mac-address', is_config=False)
    self.__destination_mac = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="destination-mac", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-yang:mac-address', is_config=False)
    self.__destination_mac_mask = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="destination-mac-mask", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-yang:mac-address', is_config=False)
    self.__ethertype = YANGDynClass(base=[RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1536..65535']}),RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ETHERTYPE_IPV4': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_IPV4': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_ARP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_ARP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_VLAN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_VLAN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_IPV6': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_IPV6': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_MPLS': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_MPLS': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_LLDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_LLDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_ROCE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_ROCE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}},),], is_leaf=True, yang_name="ethertype", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-pkt-match-types:ethertype-type', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['acl', 'acl-sets', 'acl-set', 'acl-entries', 'acl-entry', 'l2', 'state']

  def _get_source_mac(self):
    """
    Getter method for source_mac, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/l2/state/source_mac (oc-yang:mac-address)

    YANG Description: Source IEEE 802 MAC address.
    """
    return self.__source_mac
      
  def _set_source_mac(self, v, load=False):
    """
    Setter method for source_mac, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/l2/state/source_mac (oc-yang:mac-address)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_source_mac is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_source_mac() directly.

    YANG Description: Source IEEE 802 MAC address.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="source-mac", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-yang:mac-address', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """source_mac must be of a type compatible with oc-yang:mac-address""",
          'defined-type': "oc-yang:mac-address",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="source-mac", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-yang:mac-address', is_config=False)""",
        })

    self.__source_mac = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_source_mac(self):
    self.__source_mac = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="source-mac", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-yang:mac-address', is_config=False)


  def _get_source_mac_mask(self):
    """
    Getter method for source_mac_mask, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/l2/state/source_mac_mask (oc-yang:mac-address)

    YANG Description: Source IEEE 802 MAC address mask.
    """
    return self.__source_mac_mask
      
  def _set_source_mac_mask(self, v, load=False):
    """
    Setter method for source_mac_mask, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/l2/state/source_mac_mask (oc-yang:mac-address)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_source_mac_mask is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_source_mac_mask() directly.

    YANG Description: Source IEEE 802 MAC address mask.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="source-mac-mask", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-yang:mac-address', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """source_mac_mask must be of a type compatible with oc-yang:mac-address""",
          'defined-type': "oc-yang:mac-address",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="source-mac-mask", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-yang:mac-address', is_config=False)""",
        })

    self.__source_mac_mask = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_source_mac_mask(self):
    self.__source_mac_mask = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="source-mac-mask", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-yang:mac-address', is_config=False)


  def _get_destination_mac(self):
    """
    Getter method for destination_mac, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/l2/state/destination_mac (oc-yang:mac-address)

    YANG Description: Destination IEEE 802 MAC address.
    """
    return self.__destination_mac
      
  def _set_destination_mac(self, v, load=False):
    """
    Setter method for destination_mac, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/l2/state/destination_mac (oc-yang:mac-address)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_destination_mac is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_destination_mac() directly.

    YANG Description: Destination IEEE 802 MAC address.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="destination-mac", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-yang:mac-address', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """destination_mac must be of a type compatible with oc-yang:mac-address""",
          'defined-type': "oc-yang:mac-address",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="destination-mac", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-yang:mac-address', is_config=False)""",
        })

    self.__destination_mac = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_destination_mac(self):
    self.__destination_mac = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="destination-mac", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-yang:mac-address', is_config=False)


  def _get_destination_mac_mask(self):
    """
    Getter method for destination_mac_mask, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/l2/state/destination_mac_mask (oc-yang:mac-address)

    YANG Description: Destination IEEE 802 MAC address mask.
    """
    return self.__destination_mac_mask
      
  def _set_destination_mac_mask(self, v, load=False):
    """
    Setter method for destination_mac_mask, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/l2/state/destination_mac_mask (oc-yang:mac-address)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_destination_mac_mask is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_destination_mac_mask() directly.

    YANG Description: Destination IEEE 802 MAC address mask.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="destination-mac-mask", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-yang:mac-address', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """destination_mac_mask must be of a type compatible with oc-yang:mac-address""",
          'defined-type': "oc-yang:mac-address",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="destination-mac-mask", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-yang:mac-address', is_config=False)""",
        })

    self.__destination_mac_mask = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_destination_mac_mask(self):
    self.__destination_mac_mask = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="destination-mac-mask", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-yang:mac-address', is_config=False)


  def _get_ethertype(self):
    """
    Getter method for ethertype, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/l2/state/ethertype (oc-pkt-match-types:ethertype-type)

    YANG Description: Ethertype field to match in Ethernet packets
    """
    return self.__ethertype
      
  def _set_ethertype(self, v, load=False):
    """
    Setter method for ethertype, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/l2/state/ethertype (oc-pkt-match-types:ethertype-type)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_ethertype is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_ethertype() directly.

    YANG Description: Ethertype field to match in Ethernet packets
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=[RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1536..65535']}),RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ETHERTYPE_IPV4': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_IPV4': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_ARP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_ARP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_VLAN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_VLAN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_IPV6': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_IPV6': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_MPLS': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_MPLS': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_LLDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_LLDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_ROCE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_ROCE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}},),], is_leaf=True, yang_name="ethertype", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-pkt-match-types:ethertype-type', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """ethertype must be of a type compatible with oc-pkt-match-types:ethertype-type""",
          'defined-type': "oc-pkt-match-types:ethertype-type",
          'generated-type': """YANGDynClass(base=[RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1536..65535']}),RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ETHERTYPE_IPV4': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_IPV4': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_ARP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_ARP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_VLAN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_VLAN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_IPV6': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_IPV6': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_MPLS': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_MPLS': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_LLDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_LLDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_ROCE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_ROCE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}},),], is_leaf=True, yang_name="ethertype", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-pkt-match-types:ethertype-type', is_config=False)""",
        })

    self.__ethertype = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_ethertype(self):
    self.__ethertype = YANGDynClass(base=[RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1536..65535']}),RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ETHERTYPE_IPV4': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_IPV4': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_ARP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_ARP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_VLAN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_VLAN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_IPV6': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_IPV6': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_MPLS': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_MPLS': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_LLDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_LLDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_ROCE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_ROCE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}},),], is_leaf=True, yang_name="ethertype", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-pkt-match-types:ethertype-type', is_config=False)

  source_mac = __builtin__.property(_get_source_mac)
  source_mac_mask = __builtin__.property(_get_source_mac_mask)
  destination_mac = __builtin__.property(_get_destination_mac)
  destination_mac_mask = __builtin__.property(_get_destination_mac_mask)
  ethertype = __builtin__.property(_get_ethertype)


  _pyangbind_elements = OrderedDict([('source_mac', source_mac), ('source_mac_mask', source_mac_mask), ('destination_mac', destination_mac), ('destination_mac_mask', destination_mac_mask), ('ethertype', ethertype), ])


class yc_l2_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_l2(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-acl - based on the path /acl/acl-sets/acl-set/acl-entries/acl-entry/l2. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Ethernet header fields
  """
  __slots__ = ('_path_helper', '_extmethods', '__config','__state',)

  _yang_name = 'l2'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__config = YANGDynClass(base=yc_config_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_l2_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_l2_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['acl', 'acl-sets', 'acl-set', 'acl-entries', 'acl-entry', 'l2']

  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/l2/config (container)

    YANG Description: Configuration data
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/l2/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration data
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_l2_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_l2_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_l2_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/l2/state (container)

    YANG Description: State Information.
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/l2/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: State Information.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_l2_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_l2_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_l2_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)

  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)


  _pyangbind_elements = OrderedDict([('config', config), ('state', state), ])


class yc_config_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_ipv4_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-acl - based on the path /acl/acl-sets/acl-set/acl-entries/acl-entry/ipv4/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration data for IPv4 match fields
  """
  __slots__ = ('_path_helper', '_extmethods', '__source_address','__destination_address','__dscp','__dscp_set','__protocol','__hop_limit',)

  _yang_name = 'config'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__source_address = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}/([0-9]|[12][0-9]|3[0-2])'}), is_leaf=True, yang_name="source-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:ipv4-prefix', is_config=True)
    self.__destination_address = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}/([0-9]|[12][0-9]|3[0-2])'}), is_leaf=True, yang_name="destination-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:ipv4-prefix', is_config=True)
    self.__dscp = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']}), is_leaf=True, yang_name="dscp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:dscp', is_config=True)
    self.__dscp_set = YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']})), is_leaf=False, yang_name="dscp-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:dscp', is_config=True)
    self.__protocol = YANGDynClass(base=[RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..254']}),RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'IP_TCP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_TCP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_UDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_UDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_ICMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_ICMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_IGMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_IGMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_PIM': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_PIM': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_RSVP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_RSVP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_GRE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_GRE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_AUTH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_AUTH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_L2TP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_L2TP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_IN_IP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_IN_IP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}},),], is_leaf=True, yang_name="protocol", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-pkt-match-types:ip-protocol-type', is_config=True)
    self.__hop_limit = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..255']}), is_leaf=True, yang_name="hop-limit", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='uint8', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['acl', 'acl-sets', 'acl-set', 'acl-entries', 'acl-entry', 'ipv4', 'config']

  def _get_source_address(self):
    """
    Getter method for source_address, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv4/config/source_address (oc-inet:ipv4-prefix)

    YANG Description: Source IPv4 address prefix.
    """
    return self.__source_address
      
  def _set_source_address(self, v, load=False):
    """
    Setter method for source_address, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv4/config/source_address (oc-inet:ipv4-prefix)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_source_address is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_source_address() directly.

    YANG Description: Source IPv4 address prefix.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}/([0-9]|[12][0-9]|3[0-2])'}), is_leaf=True, yang_name="source-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:ipv4-prefix', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """source_address must be of a type compatible with oc-inet:ipv4-prefix""",
          'defined-type': "oc-inet:ipv4-prefix",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}/([0-9]|[12][0-9]|3[0-2])'}), is_leaf=True, yang_name="source-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:ipv4-prefix', is_config=True)""",
        })

    self.__source_address = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_source_address(self):
    self.__source_address = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}/([0-9]|[12][0-9]|3[0-2])'}), is_leaf=True, yang_name="source-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:ipv4-prefix', is_config=True)


  def _get_destination_address(self):
    """
    Getter method for destination_address, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv4/config/destination_address (oc-inet:ipv4-prefix)

    YANG Description: Destination IPv4 address prefix.
    """
    return self.__destination_address
      
  def _set_destination_address(self, v, load=False):
    """
    Setter method for destination_address, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv4/config/destination_address (oc-inet:ipv4-prefix)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_destination_address is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_destination_address() directly.

    YANG Description: Destination IPv4 address prefix.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}/([0-9]|[12][0-9]|3[0-2])'}), is_leaf=True, yang_name="destination-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:ipv4-prefix', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """destination_address must be of a type compatible with oc-inet:ipv4-prefix""",
          'defined-type': "oc-inet:ipv4-prefix",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}/([0-9]|[12][0-9]|3[0-2])'}), is_leaf=True, yang_name="destination-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:ipv4-prefix', is_config=True)""",
        })

    self.__destination_address = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_destination_address(self):
    self.__destination_address = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}/([0-9]|[12][0-9]|3[0-2])'}), is_leaf=True, yang_name="destination-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:ipv4-prefix', is_config=True)


  def _get_dscp(self):
    """
    Getter method for dscp, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv4/config/dscp (oc-inet:dscp)

    YANG Description: Value of diffserv codepoint.
    """
    return self.__dscp
      
  def _set_dscp(self, v, load=False):
    """
    Setter method for dscp, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv4/config/dscp (oc-inet:dscp)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_dscp is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_dscp() directly.

    YANG Description: Value of diffserv codepoint.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']}), is_leaf=True, yang_name="dscp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:dscp', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """dscp must be of a type compatible with oc-inet:dscp""",
          'defined-type': "oc-inet:dscp",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']}), is_leaf=True, yang_name="dscp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:dscp', is_config=True)""",
        })

    self.__dscp = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_dscp(self):
    self.__dscp = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']}), is_leaf=True, yang_name="dscp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:dscp', is_config=True)


  def _get_dscp_set(self):
    """
    Getter method for dscp_set, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv4/config/dscp_set (oc-inet:dscp)

    YANG Description: A list of DSCP values to be matched for incoming packets. AN OR match should
be performed, such that a packet must match one of the values defined in this
list. If the field is left empty then any DSCP value matches unless the 'dscp'
leaf is specified. It is not valid to specify both 'dscp' and 'dscp-set together.'
    """
    return self.__dscp_set
      
  def _set_dscp_set(self, v, load=False):
    """
    Setter method for dscp_set, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv4/config/dscp_set (oc-inet:dscp)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_dscp_set is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_dscp_set() directly.

    YANG Description: A list of DSCP values to be matched for incoming packets. AN OR match should
be performed, such that a packet must match one of the values defined in this
list. If the field is left empty then any DSCP value matches unless the 'dscp'
leaf is specified. It is not valid to specify both 'dscp' and 'dscp-set together.'
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']})), is_leaf=False, yang_name="dscp-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:dscp', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """dscp_set must be of a type compatible with oc-inet:dscp""",
          'defined-type': "oc-inet:dscp",
          'generated-type': """YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']})), is_leaf=False, yang_name="dscp-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:dscp', is_config=True)""",
        })

    self.__dscp_set = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_dscp_set(self):
    self.__dscp_set = YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']})), is_leaf=False, yang_name="dscp-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:dscp', is_config=True)


  def _get_protocol(self):
    """
    Getter method for protocol, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv4/config/protocol (oc-pkt-match-types:ip-protocol-type)

    YANG Description: The protocol carried in the IP packet, expressed either
as its IP protocol number, or by a defined identity.
    """
    return self.__protocol
      
  def _set_protocol(self, v, load=False):
    """
    Setter method for protocol, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv4/config/protocol (oc-pkt-match-types:ip-protocol-type)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_protocol is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_protocol() directly.

    YANG Description: The protocol carried in the IP packet, expressed either
as its IP protocol number, or by a defined identity.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=[RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..254']}),RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'IP_TCP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_TCP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_UDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_UDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_ICMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_ICMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_IGMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_IGMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_PIM': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_PIM': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_RSVP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_RSVP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_GRE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_GRE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_AUTH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_AUTH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_L2TP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_L2TP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_IN_IP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_IN_IP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}},),], is_leaf=True, yang_name="protocol", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-pkt-match-types:ip-protocol-type', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """protocol must be of a type compatible with oc-pkt-match-types:ip-protocol-type""",
          'defined-type': "oc-pkt-match-types:ip-protocol-type",
          'generated-type': """YANGDynClass(base=[RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..254']}),RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'IP_TCP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_TCP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_UDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_UDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_ICMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_ICMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_IGMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_IGMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_PIM': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_PIM': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_RSVP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_RSVP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_GRE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_GRE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_AUTH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_AUTH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_L2TP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_L2TP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_IN_IP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_IN_IP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}},),], is_leaf=True, yang_name="protocol", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-pkt-match-types:ip-protocol-type', is_config=True)""",
        })

    self.__protocol = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_protocol(self):
    self.__protocol = YANGDynClass(base=[RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..254']}),RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'IP_TCP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_TCP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_UDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_UDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_ICMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_ICMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_IGMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_IGMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_PIM': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_PIM': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_RSVP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_RSVP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_GRE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_GRE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_AUTH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_AUTH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_L2TP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_L2TP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_IN_IP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_IN_IP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}},),], is_leaf=True, yang_name="protocol", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-pkt-match-types:ip-protocol-type', is_config=True)


  def _get_hop_limit(self):
    """
    Getter method for hop_limit, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv4/config/hop_limit (uint8)

    YANG Description: The IP packet's hop limit -- known as TTL (in hops) in
IPv4 packets, and hop limit in IPv6
    """
    return self.__hop_limit
      
  def _set_hop_limit(self, v, load=False):
    """
    Setter method for hop_limit, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv4/config/hop_limit (uint8)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_hop_limit is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_hop_limit() directly.

    YANG Description: The IP packet's hop limit -- known as TTL (in hops) in
IPv4 packets, and hop limit in IPv6
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..255']}), is_leaf=True, yang_name="hop-limit", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='uint8', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """hop_limit must be of a type compatible with uint8""",
          'defined-type': "uint8",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..255']}), is_leaf=True, yang_name="hop-limit", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='uint8', is_config=True)""",
        })

    self.__hop_limit = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_hop_limit(self):
    self.__hop_limit = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..255']}), is_leaf=True, yang_name="hop-limit", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='uint8', is_config=True)

  source_address = __builtin__.property(_get_source_address, _set_source_address)
  destination_address = __builtin__.property(_get_destination_address, _set_destination_address)
  dscp = __builtin__.property(_get_dscp, _set_dscp)
  dscp_set = __builtin__.property(_get_dscp_set, _set_dscp_set)
  protocol = __builtin__.property(_get_protocol, _set_protocol)
  hop_limit = __builtin__.property(_get_hop_limit, _set_hop_limit)


  _pyangbind_elements = OrderedDict([('source_address', source_address), ('destination_address', destination_address), ('dscp', dscp), ('dscp_set', dscp_set), ('protocol', protocol), ('hop_limit', hop_limit), ])


class yc_state_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_ipv4_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-acl - based on the path /acl/acl-sets/acl-set/acl-entries/acl-entry/ipv4/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: State information for IPv4 match fields
  """
  __slots__ = ('_path_helper', '_extmethods', '__source_address','__destination_address','__dscp','__dscp_set','__protocol','__hop_limit',)

  _yang_name = 'state'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__source_address = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}/([0-9]|[12][0-9]|3[0-2])'}), is_leaf=True, yang_name="source-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:ipv4-prefix', is_config=False)
    self.__destination_address = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}/([0-9]|[12][0-9]|3[0-2])'}), is_leaf=True, yang_name="destination-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:ipv4-prefix', is_config=False)
    self.__dscp = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']}), is_leaf=True, yang_name="dscp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:dscp', is_config=False)
    self.__dscp_set = YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']})), is_leaf=False, yang_name="dscp-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:dscp', is_config=False)
    self.__protocol = YANGDynClass(base=[RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..254']}),RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'IP_TCP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_TCP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_UDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_UDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_ICMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_ICMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_IGMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_IGMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_PIM': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_PIM': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_RSVP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_RSVP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_GRE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_GRE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_AUTH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_AUTH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_L2TP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_L2TP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_IN_IP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_IN_IP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}},),], is_leaf=True, yang_name="protocol", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-pkt-match-types:ip-protocol-type', is_config=False)
    self.__hop_limit = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..255']}), is_leaf=True, yang_name="hop-limit", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='uint8', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['acl', 'acl-sets', 'acl-set', 'acl-entries', 'acl-entry', 'ipv4', 'state']

  def _get_source_address(self):
    """
    Getter method for source_address, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv4/state/source_address (oc-inet:ipv4-prefix)

    YANG Description: Source IPv4 address prefix.
    """
    return self.__source_address
      
  def _set_source_address(self, v, load=False):
    """
    Setter method for source_address, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv4/state/source_address (oc-inet:ipv4-prefix)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_source_address is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_source_address() directly.

    YANG Description: Source IPv4 address prefix.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}/([0-9]|[12][0-9]|3[0-2])'}), is_leaf=True, yang_name="source-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:ipv4-prefix', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """source_address must be of a type compatible with oc-inet:ipv4-prefix""",
          'defined-type': "oc-inet:ipv4-prefix",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}/([0-9]|[12][0-9]|3[0-2])'}), is_leaf=True, yang_name="source-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:ipv4-prefix', is_config=False)""",
        })

    self.__source_address = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_source_address(self):
    self.__source_address = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}/([0-9]|[12][0-9]|3[0-2])'}), is_leaf=True, yang_name="source-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:ipv4-prefix', is_config=False)


  def _get_destination_address(self):
    """
    Getter method for destination_address, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv4/state/destination_address (oc-inet:ipv4-prefix)

    YANG Description: Destination IPv4 address prefix.
    """
    return self.__destination_address
      
  def _set_destination_address(self, v, load=False):
    """
    Setter method for destination_address, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv4/state/destination_address (oc-inet:ipv4-prefix)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_destination_address is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_destination_address() directly.

    YANG Description: Destination IPv4 address prefix.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}/([0-9]|[12][0-9]|3[0-2])'}), is_leaf=True, yang_name="destination-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:ipv4-prefix', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """destination_address must be of a type compatible with oc-inet:ipv4-prefix""",
          'defined-type': "oc-inet:ipv4-prefix",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}/([0-9]|[12][0-9]|3[0-2])'}), is_leaf=True, yang_name="destination-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:ipv4-prefix', is_config=False)""",
        })

    self.__destination_address = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_destination_address(self):
    self.__destination_address = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}/([0-9]|[12][0-9]|3[0-2])'}), is_leaf=True, yang_name="destination-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:ipv4-prefix', is_config=False)


  def _get_dscp(self):
    """
    Getter method for dscp, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv4/state/dscp (oc-inet:dscp)

    YANG Description: Value of diffserv codepoint.
    """
    return self.__dscp
      
  def _set_dscp(self, v, load=False):
    """
    Setter method for dscp, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv4/state/dscp (oc-inet:dscp)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_dscp is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_dscp() directly.

    YANG Description: Value of diffserv codepoint.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']}), is_leaf=True, yang_name="dscp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:dscp', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """dscp must be of a type compatible with oc-inet:dscp""",
          'defined-type': "oc-inet:dscp",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']}), is_leaf=True, yang_name="dscp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:dscp', is_config=False)""",
        })

    self.__dscp = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_dscp(self):
    self.__dscp = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']}), is_leaf=True, yang_name="dscp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:dscp', is_config=False)


  def _get_dscp_set(self):
    """
    Getter method for dscp_set, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv4/state/dscp_set (oc-inet:dscp)

    YANG Description: A list of DSCP values to be matched for incoming packets. AN OR match should
be performed, such that a packet must match one of the values defined in this
list. If the field is left empty then any DSCP value matches unless the 'dscp'
leaf is specified. It is not valid to specify both 'dscp' and 'dscp-set together.'
    """
    return self.__dscp_set
      
  def _set_dscp_set(self, v, load=False):
    """
    Setter method for dscp_set, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv4/state/dscp_set (oc-inet:dscp)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_dscp_set is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_dscp_set() directly.

    YANG Description: A list of DSCP values to be matched for incoming packets. AN OR match should
be performed, such that a packet must match one of the values defined in this
list. If the field is left empty then any DSCP value matches unless the 'dscp'
leaf is specified. It is not valid to specify both 'dscp' and 'dscp-set together.'
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']})), is_leaf=False, yang_name="dscp-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:dscp', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """dscp_set must be of a type compatible with oc-inet:dscp""",
          'defined-type': "oc-inet:dscp",
          'generated-type': """YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']})), is_leaf=False, yang_name="dscp-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:dscp', is_config=False)""",
        })

    self.__dscp_set = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_dscp_set(self):
    self.__dscp_set = YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']})), is_leaf=False, yang_name="dscp-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:dscp', is_config=False)


  def _get_protocol(self):
    """
    Getter method for protocol, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv4/state/protocol (oc-pkt-match-types:ip-protocol-type)

    YANG Description: The protocol carried in the IP packet, expressed either
as its IP protocol number, or by a defined identity.
    """
    return self.__protocol
      
  def _set_protocol(self, v, load=False):
    """
    Setter method for protocol, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv4/state/protocol (oc-pkt-match-types:ip-protocol-type)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_protocol is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_protocol() directly.

    YANG Description: The protocol carried in the IP packet, expressed either
as its IP protocol number, or by a defined identity.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=[RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..254']}),RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'IP_TCP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_TCP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_UDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_UDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_ICMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_ICMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_IGMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_IGMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_PIM': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_PIM': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_RSVP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_RSVP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_GRE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_GRE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_AUTH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_AUTH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_L2TP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_L2TP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_IN_IP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_IN_IP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}},),], is_leaf=True, yang_name="protocol", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-pkt-match-types:ip-protocol-type', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """protocol must be of a type compatible with oc-pkt-match-types:ip-protocol-type""",
          'defined-type': "oc-pkt-match-types:ip-protocol-type",
          'generated-type': """YANGDynClass(base=[RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..254']}),RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'IP_TCP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_TCP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_UDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_UDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_ICMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_ICMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_IGMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_IGMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_PIM': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_PIM': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_RSVP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_RSVP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_GRE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_GRE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_AUTH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_AUTH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_L2TP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_L2TP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_IN_IP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_IN_IP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}},),], is_leaf=True, yang_name="protocol", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-pkt-match-types:ip-protocol-type', is_config=False)""",
        })

    self.__protocol = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_protocol(self):
    self.__protocol = YANGDynClass(base=[RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..254']}),RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'IP_TCP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_TCP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_UDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_UDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_ICMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_ICMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_IGMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_IGMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_PIM': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_PIM': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_RSVP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_RSVP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_GRE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_GRE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_AUTH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_AUTH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_L2TP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_L2TP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_IN_IP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_IN_IP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}},),], is_leaf=True, yang_name="protocol", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-pkt-match-types:ip-protocol-type', is_config=False)


  def _get_hop_limit(self):
    """
    Getter method for hop_limit, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv4/state/hop_limit (uint8)

    YANG Description: The IP packet's hop limit -- known as TTL (in hops) in
IPv4 packets, and hop limit in IPv6
    """
    return self.__hop_limit
      
  def _set_hop_limit(self, v, load=False):
    """
    Setter method for hop_limit, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv4/state/hop_limit (uint8)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_hop_limit is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_hop_limit() directly.

    YANG Description: The IP packet's hop limit -- known as TTL (in hops) in
IPv4 packets, and hop limit in IPv6
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..255']}), is_leaf=True, yang_name="hop-limit", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='uint8', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """hop_limit must be of a type compatible with uint8""",
          'defined-type': "uint8",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..255']}), is_leaf=True, yang_name="hop-limit", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='uint8', is_config=False)""",
        })

    self.__hop_limit = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_hop_limit(self):
    self.__hop_limit = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..255']}), is_leaf=True, yang_name="hop-limit", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='uint8', is_config=False)

  source_address = __builtin__.property(_get_source_address)
  destination_address = __builtin__.property(_get_destination_address)
  dscp = __builtin__.property(_get_dscp)
  dscp_set = __builtin__.property(_get_dscp_set)
  protocol = __builtin__.property(_get_protocol)
  hop_limit = __builtin__.property(_get_hop_limit)


  _pyangbind_elements = OrderedDict([('source_address', source_address), ('destination_address', destination_address), ('dscp', dscp), ('dscp_set', dscp_set), ('protocol', protocol), ('hop_limit', hop_limit), ])


class yc_ipv4_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_ipv4(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-acl - based on the path /acl/acl-sets/acl-set/acl-entries/acl-entry/ipv4. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Top level container for IPv4 match field data
  """
  __slots__ = ('_path_helper', '_extmethods', '__config','__state',)

  _yang_name = 'ipv4'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__config = YANGDynClass(base=yc_config_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_ipv4_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_ipv4_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['acl', 'acl-sets', 'acl-set', 'acl-entries', 'acl-entry', 'ipv4']

  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv4/config (container)

    YANG Description: Configuration data for IPv4 match fields
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv4/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration data for IPv4 match fields
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_ipv4_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_ipv4_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_ipv4_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv4/state (container)

    YANG Description: State information for IPv4 match fields
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv4/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: State information for IPv4 match fields
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_ipv4_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_ipv4_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_ipv4_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)

  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)


  _pyangbind_elements = OrderedDict([('config', config), ('state', state), ])


class yc_config_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_mpls_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-acl - based on the path /acl/acl-sets/acl-set/acl-entries/acl-entry/mpls/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration parameters relating to fields within
the MPLS header.
  """
  __slots__ = ('_path_helper', '_extmethods', '__traffic_class','__start_label_value','__end_label_value','__ttl_value',)

  _yang_name = 'config'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__traffic_class = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..7']}), is_leaf=True, yang_name="traffic-class", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-mpls:mpls-tc', is_config=True)
    self.__start_label_value = YANGDynClass(base=[RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['16..1048575']}),RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'IPV4_EXPLICIT_NULL': {'value': 0}, 'ROUTER_ALERT': {'value': 1}, 'IPV6_EXPLICIT_NULL': {'value': 2}, 'IMPLICIT_NULL': {'value': 3}, 'ENTROPY_LABEL_INDICATOR': {'value': 7}, 'NO_LABEL': {}},),], is_leaf=True, yang_name="start-label-value", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-mpls:mpls-label', is_config=True)
    self.__end_label_value = YANGDynClass(base=[RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['16..1048575']}),RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'IPV4_EXPLICIT_NULL': {'value': 0}, 'ROUTER_ALERT': {'value': 1}, 'IPV6_EXPLICIT_NULL': {'value': 2}, 'IMPLICIT_NULL': {'value': 3}, 'ENTROPY_LABEL_INDICATOR': {'value': 7}, 'NO_LABEL': {}},),], is_leaf=True, yang_name="end-label-value", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-mpls:mpls-label', is_config=True)
    self.__ttl_value = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="ttl-value", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='uint8', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['acl', 'acl-sets', 'acl-set', 'acl-entries', 'acl-entry', 'mpls', 'config']

  def _get_traffic_class(self):
    """
    Getter method for traffic_class, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/mpls/config/traffic_class (oc-mpls:mpls-tc)

    YANG Description: The value of the MPLS traffic class (TC) bits,
formerly known as the EXP bits.
    """
    return self.__traffic_class
      
  def _set_traffic_class(self, v, load=False):
    """
    Setter method for traffic_class, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/mpls/config/traffic_class (oc-mpls:mpls-tc)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_traffic_class is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_traffic_class() directly.

    YANG Description: The value of the MPLS traffic class (TC) bits,
formerly known as the EXP bits.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..7']}), is_leaf=True, yang_name="traffic-class", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-mpls:mpls-tc', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """traffic_class must be of a type compatible with oc-mpls:mpls-tc""",
          'defined-type': "oc-mpls:mpls-tc",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..7']}), is_leaf=True, yang_name="traffic-class", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-mpls:mpls-tc', is_config=True)""",
        })

    self.__traffic_class = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_traffic_class(self):
    self.__traffic_class = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..7']}), is_leaf=True, yang_name="traffic-class", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-mpls:mpls-tc', is_config=True)


  def _get_start_label_value(self):
    """
    Getter method for start_label_value, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/mpls/config/start_label_value (oc-mpls:mpls-label)

    YANG Description: Match MPLS label value on the MPLS header.
The usage of this field indicated the upper
range value in the top of the stack.
The range that is used is inclusive. The match that
is done for a particular received pkt_label is:
start-label-value <= pkt_label <= end-label-value.
The 20-bit label value in an MPLS label
stack as specified in RFC 3032.
This label value does not include the
encodings of Traffic Class and TTL.
    """
    return self.__start_label_value
      
  def _set_start_label_value(self, v, load=False):
    """
    Setter method for start_label_value, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/mpls/config/start_label_value (oc-mpls:mpls-label)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_start_label_value is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_start_label_value() directly.

    YANG Description: Match MPLS label value on the MPLS header.
The usage of this field indicated the upper
range value in the top of the stack.
The range that is used is inclusive. The match that
is done for a particular received pkt_label is:
start-label-value <= pkt_label <= end-label-value.
The 20-bit label value in an MPLS label
stack as specified in RFC 3032.
This label value does not include the
encodings of Traffic Class and TTL.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=[RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['16..1048575']}),RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'IPV4_EXPLICIT_NULL': {'value': 0}, 'ROUTER_ALERT': {'value': 1}, 'IPV6_EXPLICIT_NULL': {'value': 2}, 'IMPLICIT_NULL': {'value': 3}, 'ENTROPY_LABEL_INDICATOR': {'value': 7}, 'NO_LABEL': {}},),], is_leaf=True, yang_name="start-label-value", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-mpls:mpls-label', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """start_label_value must be of a type compatible with oc-mpls:mpls-label""",
          'defined-type': "oc-mpls:mpls-label",
          'generated-type': """YANGDynClass(base=[RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['16..1048575']}),RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'IPV4_EXPLICIT_NULL': {'value': 0}, 'ROUTER_ALERT': {'value': 1}, 'IPV6_EXPLICIT_NULL': {'value': 2}, 'IMPLICIT_NULL': {'value': 3}, 'ENTROPY_LABEL_INDICATOR': {'value': 7}, 'NO_LABEL': {}},),], is_leaf=True, yang_name="start-label-value", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-mpls:mpls-label', is_config=True)""",
        })

    self.__start_label_value = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_start_label_value(self):
    self.__start_label_value = YANGDynClass(base=[RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['16..1048575']}),RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'IPV4_EXPLICIT_NULL': {'value': 0}, 'ROUTER_ALERT': {'value': 1}, 'IPV6_EXPLICIT_NULL': {'value': 2}, 'IMPLICIT_NULL': {'value': 3}, 'ENTROPY_LABEL_INDICATOR': {'value': 7}, 'NO_LABEL': {}},),], is_leaf=True, yang_name="start-label-value", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-mpls:mpls-label', is_config=True)


  def _get_end_label_value(self):
    """
    Getter method for end_label_value, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/mpls/config/end_label_value (oc-mpls:mpls-label)

    YANG Description: Match MPLS label value on the MPLS header.
The usage of this field indicated the upper
range value in the top of the stack.
The range that is used is inclusive. The match that
is done for a particular received pkt_label is:
start-label-value <= pkt_label <= end-label-value.
The 20-bit label value in an MPLS label
stack as specified in RFC 3032.
This label value does not include the
encodings of Traffic Class and TTL.
    """
    return self.__end_label_value
      
  def _set_end_label_value(self, v, load=False):
    """
    Setter method for end_label_value, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/mpls/config/end_label_value (oc-mpls:mpls-label)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_end_label_value is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_end_label_value() directly.

    YANG Description: Match MPLS label value on the MPLS header.
The usage of this field indicated the upper
range value in the top of the stack.
The range that is used is inclusive. The match that
is done for a particular received pkt_label is:
start-label-value <= pkt_label <= end-label-value.
The 20-bit label value in an MPLS label
stack as specified in RFC 3032.
This label value does not include the
encodings of Traffic Class and TTL.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=[RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['16..1048575']}),RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'IPV4_EXPLICIT_NULL': {'value': 0}, 'ROUTER_ALERT': {'value': 1}, 'IPV6_EXPLICIT_NULL': {'value': 2}, 'IMPLICIT_NULL': {'value': 3}, 'ENTROPY_LABEL_INDICATOR': {'value': 7}, 'NO_LABEL': {}},),], is_leaf=True, yang_name="end-label-value", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-mpls:mpls-label', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """end_label_value must be of a type compatible with oc-mpls:mpls-label""",
          'defined-type': "oc-mpls:mpls-label",
          'generated-type': """YANGDynClass(base=[RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['16..1048575']}),RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'IPV4_EXPLICIT_NULL': {'value': 0}, 'ROUTER_ALERT': {'value': 1}, 'IPV6_EXPLICIT_NULL': {'value': 2}, 'IMPLICIT_NULL': {'value': 3}, 'ENTROPY_LABEL_INDICATOR': {'value': 7}, 'NO_LABEL': {}},),], is_leaf=True, yang_name="end-label-value", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-mpls:mpls-label', is_config=True)""",
        })

    self.__end_label_value = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_end_label_value(self):
    self.__end_label_value = YANGDynClass(base=[RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['16..1048575']}),RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'IPV4_EXPLICIT_NULL': {'value': 0}, 'ROUTER_ALERT': {'value': 1}, 'IPV6_EXPLICIT_NULL': {'value': 2}, 'IMPLICIT_NULL': {'value': 3}, 'ENTROPY_LABEL_INDICATOR': {'value': 7}, 'NO_LABEL': {}},),], is_leaf=True, yang_name="end-label-value", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-mpls:mpls-label', is_config=True)


  def _get_ttl_value(self):
    """
    Getter method for ttl_value, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/mpls/config/ttl_value (uint8)

    YANG Description: Time-to-live MPLS packet value match.
    """
    return self.__ttl_value
      
  def _set_ttl_value(self, v, load=False):
    """
    Setter method for ttl_value, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/mpls/config/ttl_value (uint8)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_ttl_value is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_ttl_value() directly.

    YANG Description: Time-to-live MPLS packet value match.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="ttl-value", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='uint8', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """ttl_value must be of a type compatible with uint8""",
          'defined-type': "uint8",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="ttl-value", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='uint8', is_config=True)""",
        })

    self.__ttl_value = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_ttl_value(self):
    self.__ttl_value = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="ttl-value", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='uint8', is_config=True)

  traffic_class = __builtin__.property(_get_traffic_class, _set_traffic_class)
  start_label_value = __builtin__.property(_get_start_label_value, _set_start_label_value)
  end_label_value = __builtin__.property(_get_end_label_value, _set_end_label_value)
  ttl_value = __builtin__.property(_get_ttl_value, _set_ttl_value)


  _pyangbind_elements = OrderedDict([('traffic_class', traffic_class), ('start_label_value', start_label_value), ('end_label_value', end_label_value), ('ttl_value', ttl_value), ])


class yc_state_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_mpls_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-acl - based on the path /acl/acl-sets/acl-set/acl-entries/acl-entry/mpls/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state parameters relating to fields
within the MPLS header
  """
  __slots__ = ('_path_helper', '_extmethods', '__traffic_class','__start_label_value','__end_label_value','__ttl_value',)

  _yang_name = 'state'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__traffic_class = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..7']}), is_leaf=True, yang_name="traffic-class", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-mpls:mpls-tc', is_config=False)
    self.__start_label_value = YANGDynClass(base=[RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['16..1048575']}),RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'IPV4_EXPLICIT_NULL': {'value': 0}, 'ROUTER_ALERT': {'value': 1}, 'IPV6_EXPLICIT_NULL': {'value': 2}, 'IMPLICIT_NULL': {'value': 3}, 'ENTROPY_LABEL_INDICATOR': {'value': 7}, 'NO_LABEL': {}},),], is_leaf=True, yang_name="start-label-value", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-mpls:mpls-label', is_config=False)
    self.__end_label_value = YANGDynClass(base=[RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['16..1048575']}),RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'IPV4_EXPLICIT_NULL': {'value': 0}, 'ROUTER_ALERT': {'value': 1}, 'IPV6_EXPLICIT_NULL': {'value': 2}, 'IMPLICIT_NULL': {'value': 3}, 'ENTROPY_LABEL_INDICATOR': {'value': 7}, 'NO_LABEL': {}},),], is_leaf=True, yang_name="end-label-value", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-mpls:mpls-label', is_config=False)
    self.__ttl_value = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="ttl-value", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='uint8', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['acl', 'acl-sets', 'acl-set', 'acl-entries', 'acl-entry', 'mpls', 'state']

  def _get_traffic_class(self):
    """
    Getter method for traffic_class, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/mpls/state/traffic_class (oc-mpls:mpls-tc)

    YANG Description: The value of the MPLS traffic class (TC) bits,
formerly known as the EXP bits.
    """
    return self.__traffic_class
      
  def _set_traffic_class(self, v, load=False):
    """
    Setter method for traffic_class, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/mpls/state/traffic_class (oc-mpls:mpls-tc)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_traffic_class is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_traffic_class() directly.

    YANG Description: The value of the MPLS traffic class (TC) bits,
formerly known as the EXP bits.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..7']}), is_leaf=True, yang_name="traffic-class", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-mpls:mpls-tc', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """traffic_class must be of a type compatible with oc-mpls:mpls-tc""",
          'defined-type': "oc-mpls:mpls-tc",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..7']}), is_leaf=True, yang_name="traffic-class", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-mpls:mpls-tc', is_config=False)""",
        })

    self.__traffic_class = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_traffic_class(self):
    self.__traffic_class = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..7']}), is_leaf=True, yang_name="traffic-class", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-mpls:mpls-tc', is_config=False)


  def _get_start_label_value(self):
    """
    Getter method for start_label_value, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/mpls/state/start_label_value (oc-mpls:mpls-label)

    YANG Description: Match MPLS label value on the MPLS header.
The usage of this field indicated the upper
range value in the top of the stack.
The range that is used is inclusive. The match that
is done for a particular received pkt_label is:
start-label-value <= pkt_label <= end-label-value.
The 20-bit label value in an MPLS label
stack as specified in RFC 3032.
This label value does not include the
encodings of Traffic Class and TTL.
    """
    return self.__start_label_value
      
  def _set_start_label_value(self, v, load=False):
    """
    Setter method for start_label_value, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/mpls/state/start_label_value (oc-mpls:mpls-label)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_start_label_value is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_start_label_value() directly.

    YANG Description: Match MPLS label value on the MPLS header.
The usage of this field indicated the upper
range value in the top of the stack.
The range that is used is inclusive. The match that
is done for a particular received pkt_label is:
start-label-value <= pkt_label <= end-label-value.
The 20-bit label value in an MPLS label
stack as specified in RFC 3032.
This label value does not include the
encodings of Traffic Class and TTL.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=[RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['16..1048575']}),RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'IPV4_EXPLICIT_NULL': {'value': 0}, 'ROUTER_ALERT': {'value': 1}, 'IPV6_EXPLICIT_NULL': {'value': 2}, 'IMPLICIT_NULL': {'value': 3}, 'ENTROPY_LABEL_INDICATOR': {'value': 7}, 'NO_LABEL': {}},),], is_leaf=True, yang_name="start-label-value", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-mpls:mpls-label', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """start_label_value must be of a type compatible with oc-mpls:mpls-label""",
          'defined-type': "oc-mpls:mpls-label",
          'generated-type': """YANGDynClass(base=[RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['16..1048575']}),RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'IPV4_EXPLICIT_NULL': {'value': 0}, 'ROUTER_ALERT': {'value': 1}, 'IPV6_EXPLICIT_NULL': {'value': 2}, 'IMPLICIT_NULL': {'value': 3}, 'ENTROPY_LABEL_INDICATOR': {'value': 7}, 'NO_LABEL': {}},),], is_leaf=True, yang_name="start-label-value", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-mpls:mpls-label', is_config=False)""",
        })

    self.__start_label_value = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_start_label_value(self):
    self.__start_label_value = YANGDynClass(base=[RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['16..1048575']}),RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'IPV4_EXPLICIT_NULL': {'value': 0}, 'ROUTER_ALERT': {'value': 1}, 'IPV6_EXPLICIT_NULL': {'value': 2}, 'IMPLICIT_NULL': {'value': 3}, 'ENTROPY_LABEL_INDICATOR': {'value': 7}, 'NO_LABEL': {}},),], is_leaf=True, yang_name="start-label-value", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-mpls:mpls-label', is_config=False)


  def _get_end_label_value(self):
    """
    Getter method for end_label_value, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/mpls/state/end_label_value (oc-mpls:mpls-label)

    YANG Description: Match MPLS label value on the MPLS header.
The usage of this field indicated the upper
range value in the top of the stack.
The range that is used is inclusive. The match that
is done for a particular received pkt_label is:
start-label-value <= pkt_label <= end-label-value.
The 20-bit label value in an MPLS label
stack as specified in RFC 3032.
This label value does not include the
encodings of Traffic Class and TTL.
    """
    return self.__end_label_value
      
  def _set_end_label_value(self, v, load=False):
    """
    Setter method for end_label_value, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/mpls/state/end_label_value (oc-mpls:mpls-label)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_end_label_value is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_end_label_value() directly.

    YANG Description: Match MPLS label value on the MPLS header.
The usage of this field indicated the upper
range value in the top of the stack.
The range that is used is inclusive. The match that
is done for a particular received pkt_label is:
start-label-value <= pkt_label <= end-label-value.
The 20-bit label value in an MPLS label
stack as specified in RFC 3032.
This label value does not include the
encodings of Traffic Class and TTL.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=[RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['16..1048575']}),RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'IPV4_EXPLICIT_NULL': {'value': 0}, 'ROUTER_ALERT': {'value': 1}, 'IPV6_EXPLICIT_NULL': {'value': 2}, 'IMPLICIT_NULL': {'value': 3}, 'ENTROPY_LABEL_INDICATOR': {'value': 7}, 'NO_LABEL': {}},),], is_leaf=True, yang_name="end-label-value", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-mpls:mpls-label', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """end_label_value must be of a type compatible with oc-mpls:mpls-label""",
          'defined-type': "oc-mpls:mpls-label",
          'generated-type': """YANGDynClass(base=[RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['16..1048575']}),RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'IPV4_EXPLICIT_NULL': {'value': 0}, 'ROUTER_ALERT': {'value': 1}, 'IPV6_EXPLICIT_NULL': {'value': 2}, 'IMPLICIT_NULL': {'value': 3}, 'ENTROPY_LABEL_INDICATOR': {'value': 7}, 'NO_LABEL': {}},),], is_leaf=True, yang_name="end-label-value", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-mpls:mpls-label', is_config=False)""",
        })

    self.__end_label_value = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_end_label_value(self):
    self.__end_label_value = YANGDynClass(base=[RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['16..1048575']}),RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'IPV4_EXPLICIT_NULL': {'value': 0}, 'ROUTER_ALERT': {'value': 1}, 'IPV6_EXPLICIT_NULL': {'value': 2}, 'IMPLICIT_NULL': {'value': 3}, 'ENTROPY_LABEL_INDICATOR': {'value': 7}, 'NO_LABEL': {}},),], is_leaf=True, yang_name="end-label-value", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-mpls:mpls-label', is_config=False)


  def _get_ttl_value(self):
    """
    Getter method for ttl_value, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/mpls/state/ttl_value (uint8)

    YANG Description: Time-to-live MPLS packet value match.
    """
    return self.__ttl_value
      
  def _set_ttl_value(self, v, load=False):
    """
    Setter method for ttl_value, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/mpls/state/ttl_value (uint8)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_ttl_value is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_ttl_value() directly.

    YANG Description: Time-to-live MPLS packet value match.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="ttl-value", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='uint8', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """ttl_value must be of a type compatible with uint8""",
          'defined-type': "uint8",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="ttl-value", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='uint8', is_config=False)""",
        })

    self.__ttl_value = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_ttl_value(self):
    self.__ttl_value = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="ttl-value", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='uint8', is_config=False)

  traffic_class = __builtin__.property(_get_traffic_class)
  start_label_value = __builtin__.property(_get_start_label_value)
  end_label_value = __builtin__.property(_get_end_label_value)
  ttl_value = __builtin__.property(_get_ttl_value)


  _pyangbind_elements = OrderedDict([('traffic_class', traffic_class), ('start_label_value', start_label_value), ('end_label_value', end_label_value), ('ttl_value', ttl_value), ])


class yc_mpls_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_mpls(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-acl - based on the path /acl/acl-sets/acl-set/acl-entries/acl-entry/mpls. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: MPLS header fields
  """
  __slots__ = ('_path_helper', '_extmethods', '__config','__state',)

  _yang_name = 'mpls'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__config = YANGDynClass(base=yc_config_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_mpls_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_mpls_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['acl', 'acl-sets', 'acl-set', 'acl-entries', 'acl-entry', 'mpls']

  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/mpls/config (container)

    YANG Description: Configuration parameters relating to fields within
the MPLS header.
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/mpls/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration parameters relating to fields within
the MPLS header.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_mpls_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_mpls_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_mpls_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/mpls/state (container)

    YANG Description: Operational state parameters relating to fields
within the MPLS header
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/mpls/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state parameters relating to fields
within the MPLS header
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_mpls_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_mpls_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_mpls_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)

  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)


  _pyangbind_elements = OrderedDict([('config', config), ('state', state), ])


class yc_config_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_ipv6_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-acl - based on the path /acl/acl-sets/acl-set/acl-entries/acl-entry/ipv6/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration data for IPv6 match fields
  """
  __slots__ = ('_path_helper', '_extmethods', '__source_address','__source_flow_label','__destination_address','__destination_flow_label','__dscp','__dscp_set','__protocol','__hop_limit',)

  _yang_name = 'config'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__source_address = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))/(12[0-8]|1[0-1][0-9]|[1-9][0-9]|[0-9])'}), is_leaf=True, yang_name="source-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:ipv6-prefix', is_config=True)
    self.__source_flow_label = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['0..1048575']}), is_leaf=True, yang_name="source-flow-label", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:ipv6-flow-label', is_config=True)
    self.__destination_address = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))/(12[0-8]|1[0-1][0-9]|[1-9][0-9]|[0-9])'}), is_leaf=True, yang_name="destination-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:ipv6-prefix', is_config=True)
    self.__destination_flow_label = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['0..1048575']}), is_leaf=True, yang_name="destination-flow-label", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:ipv6-flow-label', is_config=True)
    self.__dscp = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']}), is_leaf=True, yang_name="dscp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:dscp', is_config=True)
    self.__dscp_set = YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']})), is_leaf=False, yang_name="dscp-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:dscp', is_config=True)
    self.__protocol = YANGDynClass(base=[RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..254']}),RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'IP_TCP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_TCP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_UDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_UDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_ICMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_ICMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_IGMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_IGMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_PIM': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_PIM': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_RSVP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_RSVP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_GRE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_GRE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_AUTH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_AUTH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_L2TP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_L2TP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_IN_IP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_IN_IP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}},),], is_leaf=True, yang_name="protocol", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-pkt-match-types:ip-protocol-type', is_config=True)
    self.__hop_limit = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..255']}), is_leaf=True, yang_name="hop-limit", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='uint8', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['acl', 'acl-sets', 'acl-set', 'acl-entries', 'acl-entry', 'ipv6', 'config']

  def _get_source_address(self):
    """
    Getter method for source_address, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv6/config/source_address (oc-inet:ipv6-prefix)

    YANG Description: Source IPv6 address prefix.
    """
    return self.__source_address
      
  def _set_source_address(self, v, load=False):
    """
    Setter method for source_address, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv6/config/source_address (oc-inet:ipv6-prefix)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_source_address is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_source_address() directly.

    YANG Description: Source IPv6 address prefix.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))/(12[0-8]|1[0-1][0-9]|[1-9][0-9]|[0-9])'}), is_leaf=True, yang_name="source-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:ipv6-prefix', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """source_address must be of a type compatible with oc-inet:ipv6-prefix""",
          'defined-type': "oc-inet:ipv6-prefix",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))/(12[0-8]|1[0-1][0-9]|[1-9][0-9]|[0-9])'}), is_leaf=True, yang_name="source-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:ipv6-prefix', is_config=True)""",
        })

    self.__source_address = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_source_address(self):
    self.__source_address = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))/(12[0-8]|1[0-1][0-9]|[1-9][0-9]|[0-9])'}), is_leaf=True, yang_name="source-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:ipv6-prefix', is_config=True)


  def _get_source_flow_label(self):
    """
    Getter method for source_flow_label, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv6/config/source_flow_label (oc-inet:ipv6-flow-label)

    YANG Description: Source IPv6 Flow label.
    """
    return self.__source_flow_label
      
  def _set_source_flow_label(self, v, load=False):
    """
    Setter method for source_flow_label, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv6/config/source_flow_label (oc-inet:ipv6-flow-label)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_source_flow_label is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_source_flow_label() directly.

    YANG Description: Source IPv6 Flow label.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['0..1048575']}), is_leaf=True, yang_name="source-flow-label", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:ipv6-flow-label', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """source_flow_label must be of a type compatible with oc-inet:ipv6-flow-label""",
          'defined-type': "oc-inet:ipv6-flow-label",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['0..1048575']}), is_leaf=True, yang_name="source-flow-label", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:ipv6-flow-label', is_config=True)""",
        })

    self.__source_flow_label = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_source_flow_label(self):
    self.__source_flow_label = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['0..1048575']}), is_leaf=True, yang_name="source-flow-label", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:ipv6-flow-label', is_config=True)


  def _get_destination_address(self):
    """
    Getter method for destination_address, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv6/config/destination_address (oc-inet:ipv6-prefix)

    YANG Description: Destination IPv6 address prefix.
    """
    return self.__destination_address
      
  def _set_destination_address(self, v, load=False):
    """
    Setter method for destination_address, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv6/config/destination_address (oc-inet:ipv6-prefix)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_destination_address is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_destination_address() directly.

    YANG Description: Destination IPv6 address prefix.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))/(12[0-8]|1[0-1][0-9]|[1-9][0-9]|[0-9])'}), is_leaf=True, yang_name="destination-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:ipv6-prefix', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """destination_address must be of a type compatible with oc-inet:ipv6-prefix""",
          'defined-type': "oc-inet:ipv6-prefix",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))/(12[0-8]|1[0-1][0-9]|[1-9][0-9]|[0-9])'}), is_leaf=True, yang_name="destination-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:ipv6-prefix', is_config=True)""",
        })

    self.__destination_address = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_destination_address(self):
    self.__destination_address = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))/(12[0-8]|1[0-1][0-9]|[1-9][0-9]|[0-9])'}), is_leaf=True, yang_name="destination-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:ipv6-prefix', is_config=True)


  def _get_destination_flow_label(self):
    """
    Getter method for destination_flow_label, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv6/config/destination_flow_label (oc-inet:ipv6-flow-label)

    YANG Description: Destination IPv6 Flow label.
    """
    return self.__destination_flow_label
      
  def _set_destination_flow_label(self, v, load=False):
    """
    Setter method for destination_flow_label, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv6/config/destination_flow_label (oc-inet:ipv6-flow-label)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_destination_flow_label is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_destination_flow_label() directly.

    YANG Description: Destination IPv6 Flow label.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['0..1048575']}), is_leaf=True, yang_name="destination-flow-label", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:ipv6-flow-label', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """destination_flow_label must be of a type compatible with oc-inet:ipv6-flow-label""",
          'defined-type': "oc-inet:ipv6-flow-label",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['0..1048575']}), is_leaf=True, yang_name="destination-flow-label", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:ipv6-flow-label', is_config=True)""",
        })

    self.__destination_flow_label = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_destination_flow_label(self):
    self.__destination_flow_label = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['0..1048575']}), is_leaf=True, yang_name="destination-flow-label", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:ipv6-flow-label', is_config=True)


  def _get_dscp(self):
    """
    Getter method for dscp, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv6/config/dscp (oc-inet:dscp)

    YANG Description: Value of diffserv codepoint.
    """
    return self.__dscp
      
  def _set_dscp(self, v, load=False):
    """
    Setter method for dscp, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv6/config/dscp (oc-inet:dscp)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_dscp is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_dscp() directly.

    YANG Description: Value of diffserv codepoint.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']}), is_leaf=True, yang_name="dscp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:dscp', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """dscp must be of a type compatible with oc-inet:dscp""",
          'defined-type': "oc-inet:dscp",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']}), is_leaf=True, yang_name="dscp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:dscp', is_config=True)""",
        })

    self.__dscp = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_dscp(self):
    self.__dscp = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']}), is_leaf=True, yang_name="dscp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:dscp', is_config=True)


  def _get_dscp_set(self):
    """
    Getter method for dscp_set, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv6/config/dscp_set (oc-inet:dscp)

    YANG Description: A list of DSCP values to be matched for incoming packets. AN OR match should
be performed, such that a packet must match one of the values defined in this
list. If the field is left empty then any DSCP value matches unless the 'dscp'
leaf is specified. It is not valid to specify both 'dscp' and 'dscp-set together.'
    """
    return self.__dscp_set
      
  def _set_dscp_set(self, v, load=False):
    """
    Setter method for dscp_set, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv6/config/dscp_set (oc-inet:dscp)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_dscp_set is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_dscp_set() directly.

    YANG Description: A list of DSCP values to be matched for incoming packets. AN OR match should
be performed, such that a packet must match one of the values defined in this
list. If the field is left empty then any DSCP value matches unless the 'dscp'
leaf is specified. It is not valid to specify both 'dscp' and 'dscp-set together.'
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']})), is_leaf=False, yang_name="dscp-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:dscp', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """dscp_set must be of a type compatible with oc-inet:dscp""",
          'defined-type': "oc-inet:dscp",
          'generated-type': """YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']})), is_leaf=False, yang_name="dscp-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:dscp', is_config=True)""",
        })

    self.__dscp_set = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_dscp_set(self):
    self.__dscp_set = YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']})), is_leaf=False, yang_name="dscp-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:dscp', is_config=True)


  def _get_protocol(self):
    """
    Getter method for protocol, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv6/config/protocol (oc-pkt-match-types:ip-protocol-type)

    YANG Description: The protocol carried in the IP packet, expressed either
as its IP protocol number, or by a defined identity.
    """
    return self.__protocol
      
  def _set_protocol(self, v, load=False):
    """
    Setter method for protocol, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv6/config/protocol (oc-pkt-match-types:ip-protocol-type)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_protocol is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_protocol() directly.

    YANG Description: The protocol carried in the IP packet, expressed either
as its IP protocol number, or by a defined identity.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=[RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..254']}),RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'IP_TCP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_TCP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_UDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_UDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_ICMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_ICMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_IGMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_IGMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_PIM': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_PIM': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_RSVP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_RSVP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_GRE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_GRE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_AUTH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_AUTH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_L2TP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_L2TP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_IN_IP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_IN_IP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}},),], is_leaf=True, yang_name="protocol", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-pkt-match-types:ip-protocol-type', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """protocol must be of a type compatible with oc-pkt-match-types:ip-protocol-type""",
          'defined-type': "oc-pkt-match-types:ip-protocol-type",
          'generated-type': """YANGDynClass(base=[RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..254']}),RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'IP_TCP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_TCP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_UDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_UDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_ICMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_ICMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_IGMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_IGMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_PIM': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_PIM': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_RSVP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_RSVP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_GRE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_GRE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_AUTH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_AUTH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_L2TP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_L2TP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_IN_IP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_IN_IP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}},),], is_leaf=True, yang_name="protocol", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-pkt-match-types:ip-protocol-type', is_config=True)""",
        })

    self.__protocol = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_protocol(self):
    self.__protocol = YANGDynClass(base=[RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..254']}),RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'IP_TCP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_TCP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_UDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_UDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_ICMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_ICMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_IGMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_IGMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_PIM': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_PIM': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_RSVP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_RSVP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_GRE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_GRE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_AUTH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_AUTH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_L2TP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_L2TP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_IN_IP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_IN_IP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}},),], is_leaf=True, yang_name="protocol", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-pkt-match-types:ip-protocol-type', is_config=True)


  def _get_hop_limit(self):
    """
    Getter method for hop_limit, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv6/config/hop_limit (uint8)

    YANG Description: The IP packet's hop limit -- known as TTL (in hops) in
IPv4 packets, and hop limit in IPv6
    """
    return self.__hop_limit
      
  def _set_hop_limit(self, v, load=False):
    """
    Setter method for hop_limit, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv6/config/hop_limit (uint8)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_hop_limit is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_hop_limit() directly.

    YANG Description: The IP packet's hop limit -- known as TTL (in hops) in
IPv4 packets, and hop limit in IPv6
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..255']}), is_leaf=True, yang_name="hop-limit", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='uint8', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """hop_limit must be of a type compatible with uint8""",
          'defined-type': "uint8",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..255']}), is_leaf=True, yang_name="hop-limit", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='uint8', is_config=True)""",
        })

    self.__hop_limit = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_hop_limit(self):
    self.__hop_limit = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..255']}), is_leaf=True, yang_name="hop-limit", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='uint8', is_config=True)

  source_address = __builtin__.property(_get_source_address, _set_source_address)
  source_flow_label = __builtin__.property(_get_source_flow_label, _set_source_flow_label)
  destination_address = __builtin__.property(_get_destination_address, _set_destination_address)
  destination_flow_label = __builtin__.property(_get_destination_flow_label, _set_destination_flow_label)
  dscp = __builtin__.property(_get_dscp, _set_dscp)
  dscp_set = __builtin__.property(_get_dscp_set, _set_dscp_set)
  protocol = __builtin__.property(_get_protocol, _set_protocol)
  hop_limit = __builtin__.property(_get_hop_limit, _set_hop_limit)


  _pyangbind_elements = OrderedDict([('source_address', source_address), ('source_flow_label', source_flow_label), ('destination_address', destination_address), ('destination_flow_label', destination_flow_label), ('dscp', dscp), ('dscp_set', dscp_set), ('protocol', protocol), ('hop_limit', hop_limit), ])


class yc_state_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_ipv6_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-acl - based on the path /acl/acl-sets/acl-set/acl-entries/acl-entry/ipv6/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state data for IPv6 match fields
  """
  __slots__ = ('_path_helper', '_extmethods', '__source_address','__source_flow_label','__destination_address','__destination_flow_label','__dscp','__dscp_set','__protocol','__hop_limit',)

  _yang_name = 'state'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__source_address = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))/(12[0-8]|1[0-1][0-9]|[1-9][0-9]|[0-9])'}), is_leaf=True, yang_name="source-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:ipv6-prefix', is_config=False)
    self.__source_flow_label = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['0..1048575']}), is_leaf=True, yang_name="source-flow-label", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:ipv6-flow-label', is_config=False)
    self.__destination_address = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))/(12[0-8]|1[0-1][0-9]|[1-9][0-9]|[0-9])'}), is_leaf=True, yang_name="destination-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:ipv6-prefix', is_config=False)
    self.__destination_flow_label = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['0..1048575']}), is_leaf=True, yang_name="destination-flow-label", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:ipv6-flow-label', is_config=False)
    self.__dscp = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']}), is_leaf=True, yang_name="dscp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:dscp', is_config=False)
    self.__dscp_set = YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']})), is_leaf=False, yang_name="dscp-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:dscp', is_config=False)
    self.__protocol = YANGDynClass(base=[RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..254']}),RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'IP_TCP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_TCP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_UDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_UDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_ICMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_ICMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_IGMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_IGMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_PIM': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_PIM': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_RSVP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_RSVP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_GRE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_GRE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_AUTH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_AUTH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_L2TP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_L2TP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_IN_IP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_IN_IP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}},),], is_leaf=True, yang_name="protocol", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-pkt-match-types:ip-protocol-type', is_config=False)
    self.__hop_limit = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..255']}), is_leaf=True, yang_name="hop-limit", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='uint8', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['acl', 'acl-sets', 'acl-set', 'acl-entries', 'acl-entry', 'ipv6', 'state']

  def _get_source_address(self):
    """
    Getter method for source_address, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv6/state/source_address (oc-inet:ipv6-prefix)

    YANG Description: Source IPv6 address prefix.
    """
    return self.__source_address
      
  def _set_source_address(self, v, load=False):
    """
    Setter method for source_address, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv6/state/source_address (oc-inet:ipv6-prefix)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_source_address is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_source_address() directly.

    YANG Description: Source IPv6 address prefix.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))/(12[0-8]|1[0-1][0-9]|[1-9][0-9]|[0-9])'}), is_leaf=True, yang_name="source-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:ipv6-prefix', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """source_address must be of a type compatible with oc-inet:ipv6-prefix""",
          'defined-type': "oc-inet:ipv6-prefix",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))/(12[0-8]|1[0-1][0-9]|[1-9][0-9]|[0-9])'}), is_leaf=True, yang_name="source-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:ipv6-prefix', is_config=False)""",
        })

    self.__source_address = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_source_address(self):
    self.__source_address = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))/(12[0-8]|1[0-1][0-9]|[1-9][0-9]|[0-9])'}), is_leaf=True, yang_name="source-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:ipv6-prefix', is_config=False)


  def _get_source_flow_label(self):
    """
    Getter method for source_flow_label, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv6/state/source_flow_label (oc-inet:ipv6-flow-label)

    YANG Description: Source IPv6 Flow label.
    """
    return self.__source_flow_label
      
  def _set_source_flow_label(self, v, load=False):
    """
    Setter method for source_flow_label, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv6/state/source_flow_label (oc-inet:ipv6-flow-label)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_source_flow_label is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_source_flow_label() directly.

    YANG Description: Source IPv6 Flow label.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['0..1048575']}), is_leaf=True, yang_name="source-flow-label", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:ipv6-flow-label', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """source_flow_label must be of a type compatible with oc-inet:ipv6-flow-label""",
          'defined-type': "oc-inet:ipv6-flow-label",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['0..1048575']}), is_leaf=True, yang_name="source-flow-label", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:ipv6-flow-label', is_config=False)""",
        })

    self.__source_flow_label = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_source_flow_label(self):
    self.__source_flow_label = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['0..1048575']}), is_leaf=True, yang_name="source-flow-label", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:ipv6-flow-label', is_config=False)


  def _get_destination_address(self):
    """
    Getter method for destination_address, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv6/state/destination_address (oc-inet:ipv6-prefix)

    YANG Description: Destination IPv6 address prefix.
    """
    return self.__destination_address
      
  def _set_destination_address(self, v, load=False):
    """
    Setter method for destination_address, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv6/state/destination_address (oc-inet:ipv6-prefix)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_destination_address is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_destination_address() directly.

    YANG Description: Destination IPv6 address prefix.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))/(12[0-8]|1[0-1][0-9]|[1-9][0-9]|[0-9])'}), is_leaf=True, yang_name="destination-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:ipv6-prefix', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """destination_address must be of a type compatible with oc-inet:ipv6-prefix""",
          'defined-type': "oc-inet:ipv6-prefix",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))/(12[0-8]|1[0-1][0-9]|[1-9][0-9]|[0-9])'}), is_leaf=True, yang_name="destination-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:ipv6-prefix', is_config=False)""",
        })

    self.__destination_address = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_destination_address(self):
    self.__destination_address = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))/(12[0-8]|1[0-1][0-9]|[1-9][0-9]|[0-9])'}), is_leaf=True, yang_name="destination-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:ipv6-prefix', is_config=False)


  def _get_destination_flow_label(self):
    """
    Getter method for destination_flow_label, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv6/state/destination_flow_label (oc-inet:ipv6-flow-label)

    YANG Description: Destination IPv6 Flow label.
    """
    return self.__destination_flow_label
      
  def _set_destination_flow_label(self, v, load=False):
    """
    Setter method for destination_flow_label, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv6/state/destination_flow_label (oc-inet:ipv6-flow-label)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_destination_flow_label is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_destination_flow_label() directly.

    YANG Description: Destination IPv6 Flow label.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['0..1048575']}), is_leaf=True, yang_name="destination-flow-label", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:ipv6-flow-label', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """destination_flow_label must be of a type compatible with oc-inet:ipv6-flow-label""",
          'defined-type': "oc-inet:ipv6-flow-label",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['0..1048575']}), is_leaf=True, yang_name="destination-flow-label", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:ipv6-flow-label', is_config=False)""",
        })

    self.__destination_flow_label = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_destination_flow_label(self):
    self.__destination_flow_label = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['0..1048575']}), is_leaf=True, yang_name="destination-flow-label", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:ipv6-flow-label', is_config=False)


  def _get_dscp(self):
    """
    Getter method for dscp, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv6/state/dscp (oc-inet:dscp)

    YANG Description: Value of diffserv codepoint.
    """
    return self.__dscp
      
  def _set_dscp(self, v, load=False):
    """
    Setter method for dscp, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv6/state/dscp (oc-inet:dscp)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_dscp is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_dscp() directly.

    YANG Description: Value of diffserv codepoint.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']}), is_leaf=True, yang_name="dscp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:dscp', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """dscp must be of a type compatible with oc-inet:dscp""",
          'defined-type': "oc-inet:dscp",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']}), is_leaf=True, yang_name="dscp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:dscp', is_config=False)""",
        })

    self.__dscp = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_dscp(self):
    self.__dscp = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']}), is_leaf=True, yang_name="dscp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:dscp', is_config=False)


  def _get_dscp_set(self):
    """
    Getter method for dscp_set, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv6/state/dscp_set (oc-inet:dscp)

    YANG Description: A list of DSCP values to be matched for incoming packets. AN OR match should
be performed, such that a packet must match one of the values defined in this
list. If the field is left empty then any DSCP value matches unless the 'dscp'
leaf is specified. It is not valid to specify both 'dscp' and 'dscp-set together.'
    """
    return self.__dscp_set
      
  def _set_dscp_set(self, v, load=False):
    """
    Setter method for dscp_set, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv6/state/dscp_set (oc-inet:dscp)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_dscp_set is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_dscp_set() directly.

    YANG Description: A list of DSCP values to be matched for incoming packets. AN OR match should
be performed, such that a packet must match one of the values defined in this
list. If the field is left empty then any DSCP value matches unless the 'dscp'
leaf is specified. It is not valid to specify both 'dscp' and 'dscp-set together.'
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']})), is_leaf=False, yang_name="dscp-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:dscp', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """dscp_set must be of a type compatible with oc-inet:dscp""",
          'defined-type': "oc-inet:dscp",
          'generated-type': """YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']})), is_leaf=False, yang_name="dscp-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:dscp', is_config=False)""",
        })

    self.__dscp_set = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_dscp_set(self):
    self.__dscp_set = YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']})), is_leaf=False, yang_name="dscp-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:dscp', is_config=False)


  def _get_protocol(self):
    """
    Getter method for protocol, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv6/state/protocol (oc-pkt-match-types:ip-protocol-type)

    YANG Description: The protocol carried in the IP packet, expressed either
as its IP protocol number, or by a defined identity.
    """
    return self.__protocol
      
  def _set_protocol(self, v, load=False):
    """
    Setter method for protocol, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv6/state/protocol (oc-pkt-match-types:ip-protocol-type)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_protocol is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_protocol() directly.

    YANG Description: The protocol carried in the IP packet, expressed either
as its IP protocol number, or by a defined identity.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=[RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..254']}),RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'IP_TCP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_TCP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_UDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_UDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_ICMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_ICMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_IGMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_IGMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_PIM': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_PIM': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_RSVP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_RSVP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_GRE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_GRE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_AUTH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_AUTH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_L2TP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_L2TP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_IN_IP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_IN_IP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}},),], is_leaf=True, yang_name="protocol", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-pkt-match-types:ip-protocol-type', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """protocol must be of a type compatible with oc-pkt-match-types:ip-protocol-type""",
          'defined-type': "oc-pkt-match-types:ip-protocol-type",
          'generated-type': """YANGDynClass(base=[RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..254']}),RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'IP_TCP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_TCP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_UDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_UDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_ICMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_ICMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_IGMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_IGMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_PIM': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_PIM': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_RSVP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_RSVP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_GRE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_GRE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_AUTH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_AUTH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_L2TP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_L2TP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_IN_IP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_IN_IP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}},),], is_leaf=True, yang_name="protocol", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-pkt-match-types:ip-protocol-type', is_config=False)""",
        })

    self.__protocol = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_protocol(self):
    self.__protocol = YANGDynClass(base=[RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..254']}),RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'IP_TCP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_TCP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_UDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_UDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_ICMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_ICMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_IGMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_IGMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_PIM': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_PIM': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_RSVP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_RSVP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_GRE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_GRE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_AUTH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_AUTH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_L2TP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_L2TP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_IN_IP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_IN_IP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}},),], is_leaf=True, yang_name="protocol", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-pkt-match-types:ip-protocol-type', is_config=False)


  def _get_hop_limit(self):
    """
    Getter method for hop_limit, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv6/state/hop_limit (uint8)

    YANG Description: The IP packet's hop limit -- known as TTL (in hops) in
IPv4 packets, and hop limit in IPv6
    """
    return self.__hop_limit
      
  def _set_hop_limit(self, v, load=False):
    """
    Setter method for hop_limit, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv6/state/hop_limit (uint8)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_hop_limit is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_hop_limit() directly.

    YANG Description: The IP packet's hop limit -- known as TTL (in hops) in
IPv4 packets, and hop limit in IPv6
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..255']}), is_leaf=True, yang_name="hop-limit", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='uint8', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """hop_limit must be of a type compatible with uint8""",
          'defined-type': "uint8",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..255']}), is_leaf=True, yang_name="hop-limit", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='uint8', is_config=False)""",
        })

    self.__hop_limit = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_hop_limit(self):
    self.__hop_limit = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..255']}), is_leaf=True, yang_name="hop-limit", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='uint8', is_config=False)

  source_address = __builtin__.property(_get_source_address)
  source_flow_label = __builtin__.property(_get_source_flow_label)
  destination_address = __builtin__.property(_get_destination_address)
  destination_flow_label = __builtin__.property(_get_destination_flow_label)
  dscp = __builtin__.property(_get_dscp)
  dscp_set = __builtin__.property(_get_dscp_set)
  protocol = __builtin__.property(_get_protocol)
  hop_limit = __builtin__.property(_get_hop_limit)


  _pyangbind_elements = OrderedDict([('source_address', source_address), ('source_flow_label', source_flow_label), ('destination_address', destination_address), ('destination_flow_label', destination_flow_label), ('dscp', dscp), ('dscp_set', dscp_set), ('protocol', protocol), ('hop_limit', hop_limit), ])


class yc_ipv6_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_ipv6(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-acl - based on the path /acl/acl-sets/acl-set/acl-entries/acl-entry/ipv6. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Top-level container for IPv6 match field data
  """
  __slots__ = ('_path_helper', '_extmethods', '__config','__state',)

  _yang_name = 'ipv6'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__config = YANGDynClass(base=yc_config_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_ipv6_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_ipv6_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['acl', 'acl-sets', 'acl-set', 'acl-entries', 'acl-entry', 'ipv6']

  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv6/config (container)

    YANG Description: Configuration data for IPv6 match fields
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv6/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration data for IPv6 match fields
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_ipv6_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_ipv6_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_ipv6_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv6/state (container)

    YANG Description: Operational state data for IPv6 match fields
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv6/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state data for IPv6 match fields
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_ipv6_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_ipv6_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_ipv6_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)

  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)


  _pyangbind_elements = OrderedDict([('config', config), ('state', state), ])


class yc_config_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_transport_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-acl - based on the path /acl/acl-sets/acl-set/acl-entries/acl-entry/transport/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration data
  """
  __slots__ = ('_path_helper', '_extmethods', '__source_port','__destination_port','__tcp_flags',)

  _yang_name = 'config'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__source_port = YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(0{0,4}[0-9]|0{0,3}[1-9][0-9]|0{0,2}[1-9][0-9]{2}|0?[1-9][0-9]{3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])\\.\\.(0{0,4}[0-9]|0{0,3}[1-9][0-9]|0{0,2}[1-9][0-9]{2}|0?[1-9][0-9]{3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])'}),RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16),RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'ANY': {}},),], is_leaf=True, yang_name="source-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-pkt-match-types:port-num-range', is_config=True)
    self.__destination_port = YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(0{0,4}[0-9]|0{0,3}[1-9][0-9]|0{0,2}[1-9][0-9]{2}|0?[1-9][0-9]{3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])\\.\\.(0{0,4}[0-9]|0{0,3}[1-9][0-9]|0{0,2}[1-9][0-9]{2}|0?[1-9][0-9]{3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])'}),RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16),RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'ANY': {}},),], is_leaf=True, yang_name="destination-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-pkt-match-types:port-num-range', is_config=True)
    self.__tcp_flags = YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'TCP_SYN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_SYN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_FIN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_FIN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_RST': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_RST': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_PSH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_PSH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_ACK': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_ACK': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_URG': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_URG': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_ECE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_ECE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_CWR': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_CWR': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}},)), is_leaf=False, yang_name="tcp-flags", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='identityref', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['acl', 'acl-sets', 'acl-set', 'acl-entries', 'acl-entry', 'transport', 'config']

  def _get_source_port(self):
    """
    Getter method for source_port, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/transport/config/source_port (oc-pkt-match-types:port-num-range)

    YANG Description: Source port or range
    """
    return self.__source_port
      
  def _set_source_port(self, v, load=False):
    """
    Setter method for source_port, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/transport/config/source_port (oc-pkt-match-types:port-num-range)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_source_port is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_source_port() directly.

    YANG Description: Source port or range
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(0{0,4}[0-9]|0{0,3}[1-9][0-9]|0{0,2}[1-9][0-9]{2}|0?[1-9][0-9]{3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])\\.\\.(0{0,4}[0-9]|0{0,3}[1-9][0-9]|0{0,2}[1-9][0-9]{2}|0?[1-9][0-9]{3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])'}),RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16),RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'ANY': {}},),], is_leaf=True, yang_name="source-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-pkt-match-types:port-num-range', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """source_port must be of a type compatible with oc-pkt-match-types:port-num-range""",
          'defined-type': "oc-pkt-match-types:port-num-range",
          'generated-type': """YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(0{0,4}[0-9]|0{0,3}[1-9][0-9]|0{0,2}[1-9][0-9]{2}|0?[1-9][0-9]{3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])\\.\\.(0{0,4}[0-9]|0{0,3}[1-9][0-9]|0{0,2}[1-9][0-9]{2}|0?[1-9][0-9]{3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])'}),RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16),RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'ANY': {}},),], is_leaf=True, yang_name="source-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-pkt-match-types:port-num-range', is_config=True)""",
        })

    self.__source_port = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_source_port(self):
    self.__source_port = YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(0{0,4}[0-9]|0{0,3}[1-9][0-9]|0{0,2}[1-9][0-9]{2}|0?[1-9][0-9]{3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])\\.\\.(0{0,4}[0-9]|0{0,3}[1-9][0-9]|0{0,2}[1-9][0-9]{2}|0?[1-9][0-9]{3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])'}),RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16),RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'ANY': {}},),], is_leaf=True, yang_name="source-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-pkt-match-types:port-num-range', is_config=True)


  def _get_destination_port(self):
    """
    Getter method for destination_port, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/transport/config/destination_port (oc-pkt-match-types:port-num-range)

    YANG Description: Destination port or range
    """
    return self.__destination_port
      
  def _set_destination_port(self, v, load=False):
    """
    Setter method for destination_port, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/transport/config/destination_port (oc-pkt-match-types:port-num-range)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_destination_port is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_destination_port() directly.

    YANG Description: Destination port or range
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(0{0,4}[0-9]|0{0,3}[1-9][0-9]|0{0,2}[1-9][0-9]{2}|0?[1-9][0-9]{3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])\\.\\.(0{0,4}[0-9]|0{0,3}[1-9][0-9]|0{0,2}[1-9][0-9]{2}|0?[1-9][0-9]{3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])'}),RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16),RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'ANY': {}},),], is_leaf=True, yang_name="destination-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-pkt-match-types:port-num-range', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """destination_port must be of a type compatible with oc-pkt-match-types:port-num-range""",
          'defined-type': "oc-pkt-match-types:port-num-range",
          'generated-type': """YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(0{0,4}[0-9]|0{0,3}[1-9][0-9]|0{0,2}[1-9][0-9]{2}|0?[1-9][0-9]{3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])\\.\\.(0{0,4}[0-9]|0{0,3}[1-9][0-9]|0{0,2}[1-9][0-9]{2}|0?[1-9][0-9]{3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])'}),RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16),RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'ANY': {}},),], is_leaf=True, yang_name="destination-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-pkt-match-types:port-num-range', is_config=True)""",
        })

    self.__destination_port = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_destination_port(self):
    self.__destination_port = YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(0{0,4}[0-9]|0{0,3}[1-9][0-9]|0{0,2}[1-9][0-9]{2}|0?[1-9][0-9]{3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])\\.\\.(0{0,4}[0-9]|0{0,3}[1-9][0-9]|0{0,2}[1-9][0-9]{2}|0?[1-9][0-9]{3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])'}),RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16),RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'ANY': {}},),], is_leaf=True, yang_name="destination-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-pkt-match-types:port-num-range', is_config=True)


  def _get_tcp_flags(self):
    """
    Getter method for tcp_flags, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/transport/config/tcp_flags (identityref)

    YANG Description: List of TCP flags to match
    """
    return self.__tcp_flags
      
  def _set_tcp_flags(self, v, load=False):
    """
    Setter method for tcp_flags, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/transport/config/tcp_flags (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_tcp_flags is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_tcp_flags() directly.

    YANG Description: List of TCP flags to match
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'TCP_SYN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_SYN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_FIN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_FIN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_RST': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_RST': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_PSH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_PSH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_ACK': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_ACK': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_URG': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_URG': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_ECE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_ECE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_CWR': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_CWR': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}},)), is_leaf=False, yang_name="tcp-flags", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='identityref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """tcp_flags must be of a type compatible with identityref""",
          'defined-type': "openconfig-acl:identityref",
          'generated-type': """YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'TCP_SYN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_SYN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_FIN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_FIN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_RST': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_RST': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_PSH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_PSH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_ACK': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_ACK': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_URG': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_URG': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_ECE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_ECE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_CWR': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_CWR': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}},)), is_leaf=False, yang_name="tcp-flags", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='identityref', is_config=True)""",
        })

    self.__tcp_flags = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_tcp_flags(self):
    self.__tcp_flags = YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'TCP_SYN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_SYN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_FIN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_FIN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_RST': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_RST': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_PSH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_PSH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_ACK': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_ACK': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_URG': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_URG': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_ECE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_ECE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_CWR': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_CWR': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}},)), is_leaf=False, yang_name="tcp-flags", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='identityref', is_config=True)

  source_port = __builtin__.property(_get_source_port, _set_source_port)
  destination_port = __builtin__.property(_get_destination_port, _set_destination_port)
  tcp_flags = __builtin__.property(_get_tcp_flags, _set_tcp_flags)


  _pyangbind_elements = OrderedDict([('source_port', source_port), ('destination_port', destination_port), ('tcp_flags', tcp_flags), ])


class yc_state_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_transport_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-acl - based on the path /acl/acl-sets/acl-set/acl-entries/acl-entry/transport/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: State data
  """
  __slots__ = ('_path_helper', '_extmethods', '__source_port','__destination_port','__tcp_flags',)

  _yang_name = 'state'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__source_port = YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(0{0,4}[0-9]|0{0,3}[1-9][0-9]|0{0,2}[1-9][0-9]{2}|0?[1-9][0-9]{3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])\\.\\.(0{0,4}[0-9]|0{0,3}[1-9][0-9]|0{0,2}[1-9][0-9]{2}|0?[1-9][0-9]{3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])'}),RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16),RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'ANY': {}},),], is_leaf=True, yang_name="source-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-pkt-match-types:port-num-range', is_config=False)
    self.__destination_port = YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(0{0,4}[0-9]|0{0,3}[1-9][0-9]|0{0,2}[1-9][0-9]{2}|0?[1-9][0-9]{3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])\\.\\.(0{0,4}[0-9]|0{0,3}[1-9][0-9]|0{0,2}[1-9][0-9]{2}|0?[1-9][0-9]{3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])'}),RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16),RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'ANY': {}},),], is_leaf=True, yang_name="destination-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-pkt-match-types:port-num-range', is_config=False)
    self.__tcp_flags = YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'TCP_SYN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_SYN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_FIN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_FIN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_RST': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_RST': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_PSH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_PSH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_ACK': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_ACK': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_URG': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_URG': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_ECE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_ECE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_CWR': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_CWR': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}},)), is_leaf=False, yang_name="tcp-flags", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='identityref', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['acl', 'acl-sets', 'acl-set', 'acl-entries', 'acl-entry', 'transport', 'state']

  def _get_source_port(self):
    """
    Getter method for source_port, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/transport/state/source_port (oc-pkt-match-types:port-num-range)

    YANG Description: Source port or range
    """
    return self.__source_port
      
  def _set_source_port(self, v, load=False):
    """
    Setter method for source_port, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/transport/state/source_port (oc-pkt-match-types:port-num-range)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_source_port is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_source_port() directly.

    YANG Description: Source port or range
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(0{0,4}[0-9]|0{0,3}[1-9][0-9]|0{0,2}[1-9][0-9]{2}|0?[1-9][0-9]{3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])\\.\\.(0{0,4}[0-9]|0{0,3}[1-9][0-9]|0{0,2}[1-9][0-9]{2}|0?[1-9][0-9]{3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])'}),RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16),RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'ANY': {}},),], is_leaf=True, yang_name="source-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-pkt-match-types:port-num-range', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """source_port must be of a type compatible with oc-pkt-match-types:port-num-range""",
          'defined-type': "oc-pkt-match-types:port-num-range",
          'generated-type': """YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(0{0,4}[0-9]|0{0,3}[1-9][0-9]|0{0,2}[1-9][0-9]{2}|0?[1-9][0-9]{3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])\\.\\.(0{0,4}[0-9]|0{0,3}[1-9][0-9]|0{0,2}[1-9][0-9]{2}|0?[1-9][0-9]{3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])'}),RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16),RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'ANY': {}},),], is_leaf=True, yang_name="source-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-pkt-match-types:port-num-range', is_config=False)""",
        })

    self.__source_port = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_source_port(self):
    self.__source_port = YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(0{0,4}[0-9]|0{0,3}[1-9][0-9]|0{0,2}[1-9][0-9]{2}|0?[1-9][0-9]{3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])\\.\\.(0{0,4}[0-9]|0{0,3}[1-9][0-9]|0{0,2}[1-9][0-9]{2}|0?[1-9][0-9]{3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])'}),RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16),RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'ANY': {}},),], is_leaf=True, yang_name="source-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-pkt-match-types:port-num-range', is_config=False)


  def _get_destination_port(self):
    """
    Getter method for destination_port, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/transport/state/destination_port (oc-pkt-match-types:port-num-range)

    YANG Description: Destination port or range
    """
    return self.__destination_port
      
  def _set_destination_port(self, v, load=False):
    """
    Setter method for destination_port, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/transport/state/destination_port (oc-pkt-match-types:port-num-range)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_destination_port is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_destination_port() directly.

    YANG Description: Destination port or range
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(0{0,4}[0-9]|0{0,3}[1-9][0-9]|0{0,2}[1-9][0-9]{2}|0?[1-9][0-9]{3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])\\.\\.(0{0,4}[0-9]|0{0,3}[1-9][0-9]|0{0,2}[1-9][0-9]{2}|0?[1-9][0-9]{3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])'}),RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16),RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'ANY': {}},),], is_leaf=True, yang_name="destination-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-pkt-match-types:port-num-range', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """destination_port must be of a type compatible with oc-pkt-match-types:port-num-range""",
          'defined-type': "oc-pkt-match-types:port-num-range",
          'generated-type': """YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(0{0,4}[0-9]|0{0,3}[1-9][0-9]|0{0,2}[1-9][0-9]{2}|0?[1-9][0-9]{3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])\\.\\.(0{0,4}[0-9]|0{0,3}[1-9][0-9]|0{0,2}[1-9][0-9]{2}|0?[1-9][0-9]{3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])'}),RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16),RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'ANY': {}},),], is_leaf=True, yang_name="destination-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-pkt-match-types:port-num-range', is_config=False)""",
        })

    self.__destination_port = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_destination_port(self):
    self.__destination_port = YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(0{0,4}[0-9]|0{0,3}[1-9][0-9]|0{0,2}[1-9][0-9]{2}|0?[1-9][0-9]{3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])\\.\\.(0{0,4}[0-9]|0{0,3}[1-9][0-9]|0{0,2}[1-9][0-9]{2}|0?[1-9][0-9]{3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])'}),RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16),RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'ANY': {}},),], is_leaf=True, yang_name="destination-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-pkt-match-types:port-num-range', is_config=False)


  def _get_tcp_flags(self):
    """
    Getter method for tcp_flags, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/transport/state/tcp_flags (identityref)

    YANG Description: List of TCP flags to match
    """
    return self.__tcp_flags
      
  def _set_tcp_flags(self, v, load=False):
    """
    Setter method for tcp_flags, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/transport/state/tcp_flags (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_tcp_flags is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_tcp_flags() directly.

    YANG Description: List of TCP flags to match
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'TCP_SYN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_SYN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_FIN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_FIN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_RST': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_RST': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_PSH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_PSH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_ACK': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_ACK': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_URG': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_URG': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_ECE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_ECE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_CWR': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_CWR': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}},)), is_leaf=False, yang_name="tcp-flags", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='identityref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """tcp_flags must be of a type compatible with identityref""",
          'defined-type': "openconfig-acl:identityref",
          'generated-type': """YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'TCP_SYN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_SYN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_FIN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_FIN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_RST': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_RST': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_PSH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_PSH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_ACK': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_ACK': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_URG': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_URG': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_ECE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_ECE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_CWR': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_CWR': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}},)), is_leaf=False, yang_name="tcp-flags", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='identityref', is_config=False)""",
        })

    self.__tcp_flags = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_tcp_flags(self):
    self.__tcp_flags = YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'TCP_SYN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_SYN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_FIN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_FIN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_RST': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_RST': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_PSH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_PSH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_ACK': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_ACK': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_URG': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_URG': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_ECE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_ECE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_CWR': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_CWR': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}},)), is_leaf=False, yang_name="tcp-flags", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='identityref', is_config=False)

  source_port = __builtin__.property(_get_source_port)
  destination_port = __builtin__.property(_get_destination_port)
  tcp_flags = __builtin__.property(_get_tcp_flags)


  _pyangbind_elements = OrderedDict([('source_port', source_port), ('destination_port', destination_port), ('tcp_flags', tcp_flags), ])


class yc_transport_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_transport(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-acl - based on the path /acl/acl-sets/acl-set/acl-entries/acl-entry/transport. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Transport fields container
  """
  __slots__ = ('_path_helper', '_extmethods', '__config','__state',)

  _yang_name = 'transport'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__config = YANGDynClass(base=yc_config_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_transport_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_transport_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['acl', 'acl-sets', 'acl-set', 'acl-entries', 'acl-entry', 'transport']

  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/transport/config (container)

    YANG Description: Configuration data
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/transport/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration data
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_transport_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_transport_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_transport_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/transport/state (container)

    YANG Description: State data
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/transport/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: State data
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_transport_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_transport_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_transport_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)

  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)


  _pyangbind_elements = OrderedDict([('config', config), ('state', state), ])


class yc_config_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_input_interface_interface_ref_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-acl - based on the path /acl/acl-sets/acl-set/acl-entries/acl-entry/input-interface/interface-ref/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configured reference to interface / subinterface
  """
  __slots__ = ('_path_helper', '_extmethods', '__interface','__subinterface',)

  _yang_name = 'config'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__interface = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=True)
    self.__subinterface = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="subinterface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['acl', 'acl-sets', 'acl-set', 'acl-entries', 'acl-entry', 'input-interface', 'interface-ref', 'config']

  def _get_interface(self):
    """
    Getter method for interface, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/input_interface/interface_ref/config/interface (leafref)

    YANG Description: Reference to a base interface.  If a reference to a
subinterface is required, this leaf must be specified
to indicate the base interface.
    """
    return self.__interface
      
  def _set_interface(self, v, load=False):
    """
    Setter method for interface, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/input_interface/interface_ref/config/interface (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_interface is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_interface() directly.

    YANG Description: Reference to a base interface.  If a reference to a
subinterface is required, this leaf must be specified
to indicate the base interface.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """interface must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=True)""",
        })

    self.__interface = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_interface(self):
    self.__interface = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=True)


  def _get_subinterface(self):
    """
    Getter method for subinterface, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/input_interface/interface_ref/config/subinterface (leafref)

    YANG Description: Reference to a subinterface -- this requires the base
interface to be specified using the interface leaf in
this container.  If only a reference to a base interface
is requuired, this leaf should not be set.
    """
    return self.__subinterface
      
  def _set_subinterface(self, v, load=False):
    """
    Setter method for subinterface, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/input_interface/interface_ref/config/subinterface (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_subinterface is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_subinterface() directly.

    YANG Description: Reference to a subinterface -- this requires the base
interface to be specified using the interface leaf in
this container.  If only a reference to a base interface
is requuired, this leaf should not be set.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="subinterface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """subinterface must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="subinterface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=True)""",
        })

    self.__subinterface = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_subinterface(self):
    self.__subinterface = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="subinterface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=True)

  interface = __builtin__.property(_get_interface, _set_interface)
  subinterface = __builtin__.property(_get_subinterface, _set_subinterface)


  _pyangbind_elements = OrderedDict([('interface', interface), ('subinterface', subinterface), ])


class yc_state_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_input_interface_interface_ref_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-acl - based on the path /acl/acl-sets/acl-set/acl-entries/acl-entry/input-interface/interface-ref/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state for interface-ref
  """
  __slots__ = ('_path_helper', '_extmethods', '__interface','__subinterface',)

  _yang_name = 'state'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__interface = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=False)
    self.__subinterface = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="subinterface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['acl', 'acl-sets', 'acl-set', 'acl-entries', 'acl-entry', 'input-interface', 'interface-ref', 'state']

  def _get_interface(self):
    """
    Getter method for interface, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/input_interface/interface_ref/state/interface (leafref)

    YANG Description: Reference to a base interface.  If a reference to a
subinterface is required, this leaf must be specified
to indicate the base interface.
    """
    return self.__interface
      
  def _set_interface(self, v, load=False):
    """
    Setter method for interface, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/input_interface/interface_ref/state/interface (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_interface is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_interface() directly.

    YANG Description: Reference to a base interface.  If a reference to a
subinterface is required, this leaf must be specified
to indicate the base interface.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """interface must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=False)""",
        })

    self.__interface = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_interface(self):
    self.__interface = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=False)


  def _get_subinterface(self):
    """
    Getter method for subinterface, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/input_interface/interface_ref/state/subinterface (leafref)

    YANG Description: Reference to a subinterface -- this requires the base
interface to be specified using the interface leaf in
this container.  If only a reference to a base interface
is requuired, this leaf should not be set.
    """
    return self.__subinterface
      
  def _set_subinterface(self, v, load=False):
    """
    Setter method for subinterface, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/input_interface/interface_ref/state/subinterface (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_subinterface is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_subinterface() directly.

    YANG Description: Reference to a subinterface -- this requires the base
interface to be specified using the interface leaf in
this container.  If only a reference to a base interface
is requuired, this leaf should not be set.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="subinterface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """subinterface must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="subinterface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=False)""",
        })

    self.__subinterface = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_subinterface(self):
    self.__subinterface = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="subinterface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=False)

  interface = __builtin__.property(_get_interface)
  subinterface = __builtin__.property(_get_subinterface)


  _pyangbind_elements = OrderedDict([('interface', interface), ('subinterface', subinterface), ])


class yc_interface_ref_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_input_interface_interface_ref(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-acl - based on the path /acl/acl-sets/acl-set/acl-entries/acl-entry/input-interface/interface-ref. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Reference to an interface or subinterface
  """
  __slots__ = ('_path_helper', '_extmethods', '__config','__state',)

  _yang_name = 'interface-ref'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__config = YANGDynClass(base=yc_config_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_input_interface_interface_ref_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_input_interface_interface_ref_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['acl', 'acl-sets', 'acl-set', 'acl-entries', 'acl-entry', 'input-interface', 'interface-ref']

  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/input_interface/interface_ref/config (container)

    YANG Description: Configured reference to interface / subinterface
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/input_interface/interface_ref/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configured reference to interface / subinterface
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_input_interface_interface_ref_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_input_interface_interface_ref_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_input_interface_interface_ref_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/input_interface/interface_ref/state (container)

    YANG Description: Operational state for interface-ref
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/input_interface/interface_ref/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state for interface-ref
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_input_interface_interface_ref_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_input_interface_interface_ref_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_input_interface_interface_ref_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)

  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)


  _pyangbind_elements = OrderedDict([('config', config), ('state', state), ])


class yc_input_interface_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_input_interface(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-acl - based on the path /acl/acl-sets/acl-set/acl-entries/acl-entry/input-interface. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Input interface container
  """
  __slots__ = ('_path_helper', '_extmethods', '__interface_ref',)

  _yang_name = 'input-interface'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__interface_ref = YANGDynClass(base=yc_interface_ref_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_input_interface_interface_ref, is_container='container', yang_name="interface-ref", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['acl', 'acl-sets', 'acl-set', 'acl-entries', 'acl-entry', 'input-interface']

  def _get_interface_ref(self):
    """
    Getter method for interface_ref, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/input_interface/interface_ref (container)

    YANG Description: Reference to an interface or subinterface
    """
    return self.__interface_ref
      
  def _set_interface_ref(self, v, load=False):
    """
    Setter method for interface_ref, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/input_interface/interface_ref (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_interface_ref is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_interface_ref() directly.

    YANG Description: Reference to an interface or subinterface
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_interface_ref_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_input_interface_interface_ref, is_container='container', yang_name="interface-ref", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """interface_ref must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_interface_ref_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_input_interface_interface_ref, is_container='container', yang_name="interface-ref", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)""",
        })

    self.__interface_ref = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_interface_ref(self):
    self.__interface_ref = YANGDynClass(base=yc_interface_ref_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_input_interface_interface_ref, is_container='container', yang_name="interface-ref", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)

  interface_ref = __builtin__.property(_get_interface_ref, _set_interface_ref)


  _pyangbind_elements = OrderedDict([('interface_ref', interface_ref), ])


class yc_config_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_actions_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-acl - based on the path /acl/acl-sets/acl-set/acl-entries/acl-entry/actions/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Config data for ACL actions
  """
  __slots__ = ('_path_helper', '_extmethods', '__forwarding_action','__log_action',)

  _yang_name = 'config'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__forwarding_action = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ACCEPT': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:ACCEPT': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'DROP': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:DROP': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'REJECT': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:REJECT': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}},), is_leaf=True, yang_name="forwarding-action", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='identityref', is_config=True)
    self.__log_action = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'LOG_SYSLOG': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:LOG_SYSLOG': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'LOG_NONE': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:LOG_NONE': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}},), default=six.text_type("LOG_NONE"), is_leaf=True, yang_name="log-action", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='identityref', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['acl', 'acl-sets', 'acl-set', 'acl-entries', 'acl-entry', 'actions', 'config']

  def _get_forwarding_action(self):
    """
    Getter method for forwarding_action, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/actions/config/forwarding_action (identityref)

    YANG Description: Specifies the forwarding action.  One forwarding action
must be specified for each ACL entry
    """
    return self.__forwarding_action
      
  def _set_forwarding_action(self, v, load=False):
    """
    Setter method for forwarding_action, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/actions/config/forwarding_action (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_forwarding_action is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_forwarding_action() directly.

    YANG Description: Specifies the forwarding action.  One forwarding action
must be specified for each ACL entry
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ACCEPT': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:ACCEPT': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'DROP': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:DROP': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'REJECT': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:REJECT': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}},), is_leaf=True, yang_name="forwarding-action", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='identityref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """forwarding_action must be of a type compatible with identityref""",
          'defined-type': "openconfig-acl:identityref",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ACCEPT': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:ACCEPT': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'DROP': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:DROP': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'REJECT': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:REJECT': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}},), is_leaf=True, yang_name="forwarding-action", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='identityref', is_config=True)""",
        })

    self.__forwarding_action = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_forwarding_action(self):
    self.__forwarding_action = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ACCEPT': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:ACCEPT': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'DROP': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:DROP': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'REJECT': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:REJECT': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}},), is_leaf=True, yang_name="forwarding-action", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='identityref', is_config=True)


  def _get_log_action(self):
    """
    Getter method for log_action, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/actions/config/log_action (identityref)

    YANG Description: Specifies the log action and destination for
matched packets.  The default is not to log the
packet.
    """
    return self.__log_action
      
  def _set_log_action(self, v, load=False):
    """
    Setter method for log_action, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/actions/config/log_action (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_log_action is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_log_action() directly.

    YANG Description: Specifies the log action and destination for
matched packets.  The default is not to log the
packet.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'LOG_SYSLOG': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:LOG_SYSLOG': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'LOG_NONE': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:LOG_NONE': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}},), default=six.text_type("LOG_NONE"), is_leaf=True, yang_name="log-action", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='identityref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """log_action must be of a type compatible with identityref""",
          'defined-type': "openconfig-acl:identityref",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'LOG_SYSLOG': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:LOG_SYSLOG': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'LOG_NONE': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:LOG_NONE': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}},), default=six.text_type("LOG_NONE"), is_leaf=True, yang_name="log-action", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='identityref', is_config=True)""",
        })

    self.__log_action = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_log_action(self):
    self.__log_action = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'LOG_SYSLOG': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:LOG_SYSLOG': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'LOG_NONE': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:LOG_NONE': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}},), default=six.text_type("LOG_NONE"), is_leaf=True, yang_name="log-action", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='identityref', is_config=True)

  forwarding_action = __builtin__.property(_get_forwarding_action, _set_forwarding_action)
  log_action = __builtin__.property(_get_log_action, _set_log_action)


  _pyangbind_elements = OrderedDict([('forwarding_action', forwarding_action), ('log_action', log_action), ])


class yc_state_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_actions_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-acl - based on the path /acl/acl-sets/acl-set/acl-entries/acl-entry/actions/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: State information for ACL actions
  """
  __slots__ = ('_path_helper', '_extmethods', '__forwarding_action','__log_action',)

  _yang_name = 'state'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__forwarding_action = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ACCEPT': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:ACCEPT': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'DROP': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:DROP': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'REJECT': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:REJECT': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}},), is_leaf=True, yang_name="forwarding-action", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='identityref', is_config=False)
    self.__log_action = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'LOG_SYSLOG': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:LOG_SYSLOG': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'LOG_NONE': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:LOG_NONE': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}},), default=six.text_type("LOG_NONE"), is_leaf=True, yang_name="log-action", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='identityref', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['acl', 'acl-sets', 'acl-set', 'acl-entries', 'acl-entry', 'actions', 'state']

  def _get_forwarding_action(self):
    """
    Getter method for forwarding_action, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/actions/state/forwarding_action (identityref)

    YANG Description: Specifies the forwarding action.  One forwarding action
must be specified for each ACL entry
    """
    return self.__forwarding_action
      
  def _set_forwarding_action(self, v, load=False):
    """
    Setter method for forwarding_action, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/actions/state/forwarding_action (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_forwarding_action is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_forwarding_action() directly.

    YANG Description: Specifies the forwarding action.  One forwarding action
must be specified for each ACL entry
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ACCEPT': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:ACCEPT': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'DROP': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:DROP': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'REJECT': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:REJECT': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}},), is_leaf=True, yang_name="forwarding-action", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='identityref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """forwarding_action must be of a type compatible with identityref""",
          'defined-type': "openconfig-acl:identityref",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ACCEPT': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:ACCEPT': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'DROP': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:DROP': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'REJECT': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:REJECT': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}},), is_leaf=True, yang_name="forwarding-action", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='identityref', is_config=False)""",
        })

    self.__forwarding_action = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_forwarding_action(self):
    self.__forwarding_action = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ACCEPT': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:ACCEPT': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'DROP': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:DROP': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'REJECT': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:REJECT': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}},), is_leaf=True, yang_name="forwarding-action", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='identityref', is_config=False)


  def _get_log_action(self):
    """
    Getter method for log_action, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/actions/state/log_action (identityref)

    YANG Description: Specifies the log action and destination for
matched packets.  The default is not to log the
packet.
    """
    return self.__log_action
      
  def _set_log_action(self, v, load=False):
    """
    Setter method for log_action, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/actions/state/log_action (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_log_action is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_log_action() directly.

    YANG Description: Specifies the log action and destination for
matched packets.  The default is not to log the
packet.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'LOG_SYSLOG': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:LOG_SYSLOG': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'LOG_NONE': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:LOG_NONE': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}},), default=six.text_type("LOG_NONE"), is_leaf=True, yang_name="log-action", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='identityref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """log_action must be of a type compatible with identityref""",
          'defined-type': "openconfig-acl:identityref",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'LOG_SYSLOG': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:LOG_SYSLOG': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'LOG_NONE': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:LOG_NONE': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}},), default=six.text_type("LOG_NONE"), is_leaf=True, yang_name="log-action", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='identityref', is_config=False)""",
        })

    self.__log_action = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_log_action(self):
    self.__log_action = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'LOG_SYSLOG': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:LOG_SYSLOG': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'LOG_NONE': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:LOG_NONE': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}},), default=six.text_type("LOG_NONE"), is_leaf=True, yang_name="log-action", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='identityref', is_config=False)

  forwarding_action = __builtin__.property(_get_forwarding_action)
  log_action = __builtin__.property(_get_log_action)


  _pyangbind_elements = OrderedDict([('forwarding_action', forwarding_action), ('log_action', log_action), ])


class yc_actions_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_actions(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-acl - based on the path /acl/acl-sets/acl-set/acl-entries/acl-entry/actions. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Enclosing container for list of ACL actions associated
with an entry
  """
  __slots__ = ('_path_helper', '_extmethods', '__config','__state',)

  _yang_name = 'actions'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__config = YANGDynClass(base=yc_config_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_actions_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_actions_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['acl', 'acl-sets', 'acl-set', 'acl-entries', 'acl-entry', 'actions']

  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/actions/config (container)

    YANG Description: Config data for ACL actions
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/actions/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Config data for ACL actions
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_actions_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_actions_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_actions_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/actions/state (container)

    YANG Description: State information for ACL actions
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/actions/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: State information for ACL actions
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_actions_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_actions_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_actions_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)

  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)


  _pyangbind_elements = OrderedDict([('config', config), ('state', state), ])


class yc_acl_entry_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-acl - based on the path /acl/acl-sets/acl-set/acl-entries/acl-entry. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: List of ACL entries comprising an ACL set
  """
  __slots__ = ('_path_helper', '_extmethods', '__sequence_id','__config','__state','__l2','__ipv4','__mpls','__ipv6','__transport','__input_interface','__actions',)

  _yang_name = 'acl-entry'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__sequence_id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="sequence-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=True)
    self.__config = YANGDynClass(base=yc_config_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)
    self.__l2 = YANGDynClass(base=yc_l2_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_l2, is_container='container', yang_name="l2", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)
    self.__ipv4 = YANGDynClass(base=yc_ipv4_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_ipv4, is_container='container', yang_name="ipv4", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)
    self.__mpls = YANGDynClass(base=yc_mpls_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_mpls, is_container='container', yang_name="mpls", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)
    self.__ipv6 = YANGDynClass(base=yc_ipv6_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_ipv6, is_container='container', yang_name="ipv6", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)
    self.__transport = YANGDynClass(base=yc_transport_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_transport, is_container='container', yang_name="transport", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)
    self.__input_interface = YANGDynClass(base=yc_input_interface_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_input_interface, is_container='container', yang_name="input-interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)
    self.__actions = YANGDynClass(base=yc_actions_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_actions, is_container='container', yang_name="actions", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['acl', 'acl-sets', 'acl-set', 'acl-entries', 'acl-entry']

  def _get_sequence_id(self):
    """
    Getter method for sequence_id, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/sequence_id (leafref)

    YANG Description: references the list key
    """
    return self.__sequence_id
      
  def _set_sequence_id(self, v, load=False):
    """
    Setter method for sequence_id, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/sequence_id (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_sequence_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_sequence_id() directly.

    YANG Description: references the list key
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="sequence-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """sequence_id must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="sequence-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=True)""",
        })

    self.__sequence_id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_sequence_id(self):
    self.__sequence_id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="sequence-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=True)


  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/config (container)

    YANG Description: Access list entries config
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Access list entries config
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/state (container)

    YANG Description: State information for ACL entries
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: State information for ACL entries
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)


  def _get_l2(self):
    """
    Getter method for l2, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/l2 (container)

    YANG Description: Ethernet header fields
    """
    return self.__l2
      
  def _set_l2(self, v, load=False):
    """
    Setter method for l2, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/l2 (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_l2 is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_l2() directly.

    YANG Description: Ethernet header fields
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_l2_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_l2, is_container='container', yang_name="l2", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """l2 must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_l2_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_l2, is_container='container', yang_name="l2", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)""",
        })

    self.__l2 = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_l2(self):
    self.__l2 = YANGDynClass(base=yc_l2_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_l2, is_container='container', yang_name="l2", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)


  def _get_ipv4(self):
    """
    Getter method for ipv4, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv4 (container)

    YANG Description: Top level container for IPv4 match field data
    """
    return self.__ipv4
      
  def _set_ipv4(self, v, load=False):
    """
    Setter method for ipv4, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv4 (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_ipv4 is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_ipv4() directly.

    YANG Description: Top level container for IPv4 match field data
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_ipv4_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_ipv4, is_container='container', yang_name="ipv4", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """ipv4 must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_ipv4_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_ipv4, is_container='container', yang_name="ipv4", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)""",
        })

    self.__ipv4 = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_ipv4(self):
    self.__ipv4 = YANGDynClass(base=yc_ipv4_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_ipv4, is_container='container', yang_name="ipv4", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)


  def _get_mpls(self):
    """
    Getter method for mpls, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/mpls (container)

    YANG Description: MPLS header fields
    """
    return self.__mpls
      
  def _set_mpls(self, v, load=False):
    """
    Setter method for mpls, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/mpls (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_mpls is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_mpls() directly.

    YANG Description: MPLS header fields
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_mpls_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_mpls, is_container='container', yang_name="mpls", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """mpls must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_mpls_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_mpls, is_container='container', yang_name="mpls", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)""",
        })

    self.__mpls = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_mpls(self):
    self.__mpls = YANGDynClass(base=yc_mpls_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_mpls, is_container='container', yang_name="mpls", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)


  def _get_ipv6(self):
    """
    Getter method for ipv6, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv6 (container)

    YANG Description: Top-level container for IPv6 match field data
    """
    return self.__ipv6
      
  def _set_ipv6(self, v, load=False):
    """
    Setter method for ipv6, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv6 (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_ipv6 is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_ipv6() directly.

    YANG Description: Top-level container for IPv6 match field data
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_ipv6_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_ipv6, is_container='container', yang_name="ipv6", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """ipv6 must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_ipv6_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_ipv6, is_container='container', yang_name="ipv6", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)""",
        })

    self.__ipv6 = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_ipv6(self):
    self.__ipv6 = YANGDynClass(base=yc_ipv6_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_ipv6, is_container='container', yang_name="ipv6", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)


  def _get_transport(self):
    """
    Getter method for transport, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/transport (container)

    YANG Description: Transport fields container
    """
    return self.__transport
      
  def _set_transport(self, v, load=False):
    """
    Setter method for transport, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/transport (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_transport is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_transport() directly.

    YANG Description: Transport fields container
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_transport_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_transport, is_container='container', yang_name="transport", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """transport must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_transport_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_transport, is_container='container', yang_name="transport", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)""",
        })

    self.__transport = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_transport(self):
    self.__transport = YANGDynClass(base=yc_transport_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_transport, is_container='container', yang_name="transport", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)


  def _get_input_interface(self):
    """
    Getter method for input_interface, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/input_interface (container)

    YANG Description: Input interface container
    """
    return self.__input_interface
      
  def _set_input_interface(self, v, load=False):
    """
    Setter method for input_interface, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/input_interface (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_input_interface is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_input_interface() directly.

    YANG Description: Input interface container
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_input_interface_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_input_interface, is_container='container', yang_name="input-interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """input_interface must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_input_interface_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_input_interface, is_container='container', yang_name="input-interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)""",
        })

    self.__input_interface = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_input_interface(self):
    self.__input_interface = YANGDynClass(base=yc_input_interface_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_input_interface, is_container='container', yang_name="input-interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)


  def _get_actions(self):
    """
    Getter method for actions, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/actions (container)

    YANG Description: Enclosing container for list of ACL actions associated
with an entry
    """
    return self.__actions
      
  def _set_actions(self, v, load=False):
    """
    Setter method for actions, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/actions (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_actions is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_actions() directly.

    YANG Description: Enclosing container for list of ACL actions associated
with an entry
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_actions_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_actions, is_container='container', yang_name="actions", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """actions must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_actions_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_actions, is_container='container', yang_name="actions", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)""",
        })

    self.__actions = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_actions(self):
    self.__actions = YANGDynClass(base=yc_actions_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_actions, is_container='container', yang_name="actions", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)

  sequence_id = __builtin__.property(_get_sequence_id, _set_sequence_id)
  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)
  l2 = __builtin__.property(_get_l2, _set_l2)
  ipv4 = __builtin__.property(_get_ipv4, _set_ipv4)
  mpls = __builtin__.property(_get_mpls, _set_mpls)
  ipv6 = __builtin__.property(_get_ipv6, _set_ipv6)
  transport = __builtin__.property(_get_transport, _set_transport)
  input_interface = __builtin__.property(_get_input_interface, _set_input_interface)
  actions = __builtin__.property(_get_actions, _set_actions)


  _pyangbind_elements = OrderedDict([('sequence_id', sequence_id), ('config', config), ('state', state), ('l2', l2), ('ipv4', ipv4), ('mpls', mpls), ('ipv6', ipv6), ('transport', transport), ('input_interface', input_interface), ('actions', actions), ])


class yc_acl_entries_openconfig_acl__acl_acl_sets_acl_set_acl_entries(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-acl - based on the path /acl/acl-sets/acl-set/acl-entries. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Access list entries container
  """
  __slots__ = ('_path_helper', '_extmethods', '__acl_entry',)

  _yang_name = 'acl-entries'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__acl_entry = YANGDynClass(base=YANGListType("sequence_id",yc_acl_entry_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry, yang_name="acl-entry", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='sequence-id', extensions=None), is_container='list', yang_name="acl-entry", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='list', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['acl', 'acl-sets', 'acl-set', 'acl-entries']

  def _get_acl_entry(self):
    """
    Getter method for acl_entry, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry (list)

    YANG Description: List of ACL entries comprising an ACL set
    """
    return self.__acl_entry
      
  def _set_acl_entry(self, v, load=False):
    """
    Setter method for acl_entry, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_acl_entry is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_acl_entry() directly.

    YANG Description: List of ACL entries comprising an ACL set
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("sequence_id",yc_acl_entry_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry, yang_name="acl-entry", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='sequence-id', extensions=None), is_container='list', yang_name="acl-entry", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='list', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """acl_entry must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("sequence_id",yc_acl_entry_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry, yang_name="acl-entry", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='sequence-id', extensions=None), is_container='list', yang_name="acl-entry", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='list', is_config=True)""",
        })

    self.__acl_entry = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_acl_entry(self):
    self.__acl_entry = YANGDynClass(base=YANGListType("sequence_id",yc_acl_entry_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry, yang_name="acl-entry", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='sequence-id', extensions=None), is_container='list', yang_name="acl-entry", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='list', is_config=True)

  acl_entry = __builtin__.property(_get_acl_entry, _set_acl_entry)


  _pyangbind_elements = OrderedDict([('acl_entry', acl_entry), ])


class yc_acl_set_openconfig_acl__acl_acl_sets_acl_set(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-acl - based on the path /acl/acl-sets/acl-set. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: List of ACL sets, each comprising of a list of ACL
entries
  """
  __slots__ = ('_path_helper', '_extmethods', '__name','__type','__config','__state','__acl_entries',)

  _yang_name = 'acl-set'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=True)
    self.__type = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=True)
    self.__config = YANGDynClass(base=yc_config_openconfig_acl__acl_acl_sets_acl_set_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_acl__acl_acl_sets_acl_set_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)
    self.__acl_entries = YANGDynClass(base=yc_acl_entries_openconfig_acl__acl_acl_sets_acl_set_acl_entries, is_container='container', yang_name="acl-entries", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['acl', 'acl-sets', 'acl-set']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /acl/acl_sets/acl_set/name (leafref)

    YANG Description: Reference to the name list key
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /acl/acl_sets/acl_set/name (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: Reference to the name list key
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=True)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=True)


  def _get_type(self):
    """
    Getter method for type, mapped from YANG variable /acl/acl_sets/acl_set/type (leafref)

    YANG Description: Reference to the type list key
    """
    return self.__type
      
  def _set_type(self, v, load=False):
    """
    Setter method for type, mapped from YANG variable /acl/acl_sets/acl_set/type (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_type is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_type() directly.

    YANG Description: Reference to the type list key
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """type must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=True)""",
        })

    self.__type = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_type(self):
    self.__type = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=True)


  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /acl/acl_sets/acl_set/config (container)

    YANG Description: Access list config
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /acl/acl_sets/acl_set/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Access list config
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_acl__acl_acl_sets_acl_set_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_acl__acl_acl_sets_acl_set_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_acl__acl_acl_sets_acl_set_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /acl/acl_sets/acl_set/state (container)

    YANG Description: Access list state information
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /acl/acl_sets/acl_set/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Access list state information
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_acl__acl_acl_sets_acl_set_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_acl__acl_acl_sets_acl_set_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_acl__acl_acl_sets_acl_set_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)


  def _get_acl_entries(self):
    """
    Getter method for acl_entries, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries (container)

    YANG Description: Access list entries container
    """
    return self.__acl_entries
      
  def _set_acl_entries(self, v, load=False):
    """
    Setter method for acl_entries, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_acl_entries is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_acl_entries() directly.

    YANG Description: Access list entries container
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_acl_entries_openconfig_acl__acl_acl_sets_acl_set_acl_entries, is_container='container', yang_name="acl-entries", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """acl_entries must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_acl_entries_openconfig_acl__acl_acl_sets_acl_set_acl_entries, is_container='container', yang_name="acl-entries", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)""",
        })

    self.__acl_entries = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_acl_entries(self):
    self.__acl_entries = YANGDynClass(base=yc_acl_entries_openconfig_acl__acl_acl_sets_acl_set_acl_entries, is_container='container', yang_name="acl-entries", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)

  name = __builtin__.property(_get_name, _set_name)
  type = __builtin__.property(_get_type, _set_type)
  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)
  acl_entries = __builtin__.property(_get_acl_entries, _set_acl_entries)


  _pyangbind_elements = OrderedDict([('name', name), ('type', type), ('config', config), ('state', state), ('acl_entries', acl_entries), ])


class yc_acl_sets_openconfig_acl__acl_acl_sets(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-acl - based on the path /acl/acl-sets. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Access list entries variables enclosing container
  """
  __slots__ = ('_path_helper', '_extmethods', '__acl_set',)

  _yang_name = 'acl-sets'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__acl_set = YANGDynClass(base=YANGListType("name type",yc_acl_set_openconfig_acl__acl_acl_sets_acl_set, yang_name="acl-set", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name type', extensions=None), is_container='list', yang_name="acl-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='list', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['acl', 'acl-sets']

  def _get_acl_set(self):
    """
    Getter method for acl_set, mapped from YANG variable /acl/acl_sets/acl_set (list)

    YANG Description: List of ACL sets, each comprising of a list of ACL
entries
    """
    return self.__acl_set
      
  def _set_acl_set(self, v, load=False):
    """
    Setter method for acl_set, mapped from YANG variable /acl/acl_sets/acl_set (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_acl_set is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_acl_set() directly.

    YANG Description: List of ACL sets, each comprising of a list of ACL
entries
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("name type",yc_acl_set_openconfig_acl__acl_acl_sets_acl_set, yang_name="acl-set", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name type', extensions=None), is_container='list', yang_name="acl-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='list', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """acl_set must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("name type",yc_acl_set_openconfig_acl__acl_acl_sets_acl_set, yang_name="acl-set", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name type', extensions=None), is_container='list', yang_name="acl-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='list', is_config=True)""",
        })

    self.__acl_set = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_acl_set(self):
    self.__acl_set = YANGDynClass(base=YANGListType("name type",yc_acl_set_openconfig_acl__acl_acl_sets_acl_set, yang_name="acl-set", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name type', extensions=None), is_container='list', yang_name="acl-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='list', is_config=True)

  acl_set = __builtin__.property(_get_acl_set, _set_acl_set)


  _pyangbind_elements = OrderedDict([('acl_set', acl_set), ])


class yc_config_openconfig_acl__acl_interfaces_interface_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-acl - based on the path /acl/interfaces/interface/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration for ACL per-interface data
  """
  __slots__ = ('_path_helper', '_extmethods', '__id',)

  _yang_name = 'config'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-if:interface-id', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['acl', 'interfaces', 'interface', 'config']

  def _get_id(self):
    """
    Getter method for id, mapped from YANG variable /acl/interfaces/interface/config/id (oc-if:interface-id)

    YANG Description: User-defined identifier for the interface -- a common
convention could be '<if name>.<subif index>'
    """
    return self.__id
      
  def _set_id(self, v, load=False):
    """
    Setter method for id, mapped from YANG variable /acl/interfaces/interface/config/id (oc-if:interface-id)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_id() directly.

    YANG Description: User-defined identifier for the interface -- a common
convention could be '<if name>.<subif index>'
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-if:interface-id', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """id must be of a type compatible with oc-if:interface-id""",
          'defined-type': "oc-if:interface-id",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-if:interface-id', is_config=True)""",
        })

    self.__id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_id(self):
    self.__id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-if:interface-id', is_config=True)

  id = __builtin__.property(_get_id, _set_id)


  _pyangbind_elements = OrderedDict([('id', id), ])


class yc_state_openconfig_acl__acl_interfaces_interface_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-acl - based on the path /acl/interfaces/interface/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state for ACL per-interface data
  """
  __slots__ = ('_path_helper', '_extmethods', '__id',)

  _yang_name = 'state'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-if:interface-id', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['acl', 'interfaces', 'interface', 'state']

  def _get_id(self):
    """
    Getter method for id, mapped from YANG variable /acl/interfaces/interface/state/id (oc-if:interface-id)

    YANG Description: User-defined identifier for the interface -- a common
convention could be '<if name>.<subif index>'
    """
    return self.__id
      
  def _set_id(self, v, load=False):
    """
    Setter method for id, mapped from YANG variable /acl/interfaces/interface/state/id (oc-if:interface-id)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_id() directly.

    YANG Description: User-defined identifier for the interface -- a common
convention could be '<if name>.<subif index>'
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-if:interface-id', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """id must be of a type compatible with oc-if:interface-id""",
          'defined-type': "oc-if:interface-id",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-if:interface-id', is_config=False)""",
        })

    self.__id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_id(self):
    self.__id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-if:interface-id', is_config=False)

  id = __builtin__.property(_get_id)


  _pyangbind_elements = OrderedDict([('id', id), ])


class yc_config_openconfig_acl__acl_interfaces_interface_interface_ref_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-acl - based on the path /acl/interfaces/interface/interface-ref/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configured reference to interface / subinterface
  """
  __slots__ = ('_path_helper', '_extmethods', '__interface','__subinterface',)

  _yang_name = 'config'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__interface = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=True)
    self.__subinterface = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="subinterface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['acl', 'interfaces', 'interface', 'interface-ref', 'config']

  def _get_interface(self):
    """
    Getter method for interface, mapped from YANG variable /acl/interfaces/interface/interface_ref/config/interface (leafref)

    YANG Description: Reference to a base interface.  If a reference to a
subinterface is required, this leaf must be specified
to indicate the base interface.
    """
    return self.__interface
      
  def _set_interface(self, v, load=False):
    """
    Setter method for interface, mapped from YANG variable /acl/interfaces/interface/interface_ref/config/interface (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_interface is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_interface() directly.

    YANG Description: Reference to a base interface.  If a reference to a
subinterface is required, this leaf must be specified
to indicate the base interface.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """interface must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=True)""",
        })

    self.__interface = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_interface(self):
    self.__interface = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=True)


  def _get_subinterface(self):
    """
    Getter method for subinterface, mapped from YANG variable /acl/interfaces/interface/interface_ref/config/subinterface (leafref)

    YANG Description: Reference to a subinterface -- this requires the base
interface to be specified using the interface leaf in
this container.  If only a reference to a base interface
is requuired, this leaf should not be set.
    """
    return self.__subinterface
      
  def _set_subinterface(self, v, load=False):
    """
    Setter method for subinterface, mapped from YANG variable /acl/interfaces/interface/interface_ref/config/subinterface (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_subinterface is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_subinterface() directly.

    YANG Description: Reference to a subinterface -- this requires the base
interface to be specified using the interface leaf in
this container.  If only a reference to a base interface
is requuired, this leaf should not be set.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="subinterface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """subinterface must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="subinterface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=True)""",
        })

    self.__subinterface = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_subinterface(self):
    self.__subinterface = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="subinterface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=True)

  interface = __builtin__.property(_get_interface, _set_interface)
  subinterface = __builtin__.property(_get_subinterface, _set_subinterface)


  _pyangbind_elements = OrderedDict([('interface', interface), ('subinterface', subinterface), ])


class yc_state_openconfig_acl__acl_interfaces_interface_interface_ref_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-acl - based on the path /acl/interfaces/interface/interface-ref/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state for interface-ref
  """
  __slots__ = ('_path_helper', '_extmethods', '__interface','__subinterface',)

  _yang_name = 'state'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__interface = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=False)
    self.__subinterface = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="subinterface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['acl', 'interfaces', 'interface', 'interface-ref', 'state']

  def _get_interface(self):
    """
    Getter method for interface, mapped from YANG variable /acl/interfaces/interface/interface_ref/state/interface (leafref)

    YANG Description: Reference to a base interface.  If a reference to a
subinterface is required, this leaf must be specified
to indicate the base interface.
    """
    return self.__interface
      
  def _set_interface(self, v, load=False):
    """
    Setter method for interface, mapped from YANG variable /acl/interfaces/interface/interface_ref/state/interface (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_interface is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_interface() directly.

    YANG Description: Reference to a base interface.  If a reference to a
subinterface is required, this leaf must be specified
to indicate the base interface.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """interface must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=False)""",
        })

    self.__interface = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_interface(self):
    self.__interface = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=False)


  def _get_subinterface(self):
    """
    Getter method for subinterface, mapped from YANG variable /acl/interfaces/interface/interface_ref/state/subinterface (leafref)

    YANG Description: Reference to a subinterface -- this requires the base
interface to be specified using the interface leaf in
this container.  If only a reference to a base interface
is requuired, this leaf should not be set.
    """
    return self.__subinterface
      
  def _set_subinterface(self, v, load=False):
    """
    Setter method for subinterface, mapped from YANG variable /acl/interfaces/interface/interface_ref/state/subinterface (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_subinterface is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_subinterface() directly.

    YANG Description: Reference to a subinterface -- this requires the base
interface to be specified using the interface leaf in
this container.  If only a reference to a base interface
is requuired, this leaf should not be set.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="subinterface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """subinterface must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="subinterface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=False)""",
        })

    self.__subinterface = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_subinterface(self):
    self.__subinterface = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="subinterface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=False)

  interface = __builtin__.property(_get_interface)
  subinterface = __builtin__.property(_get_subinterface)


  _pyangbind_elements = OrderedDict([('interface', interface), ('subinterface', subinterface), ])


class yc_interface_ref_openconfig_acl__acl_interfaces_interface_interface_ref(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-acl - based on the path /acl/interfaces/interface/interface-ref. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Reference to an interface or subinterface
  """
  __slots__ = ('_path_helper', '_extmethods', '__config','__state',)

  _yang_name = 'interface-ref'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__config = YANGDynClass(base=yc_config_openconfig_acl__acl_interfaces_interface_interface_ref_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_acl__acl_interfaces_interface_interface_ref_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['acl', 'interfaces', 'interface', 'interface-ref']

  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /acl/interfaces/interface/interface_ref/config (container)

    YANG Description: Configured reference to interface / subinterface
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /acl/interfaces/interface/interface_ref/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configured reference to interface / subinterface
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_acl__acl_interfaces_interface_interface_ref_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_acl__acl_interfaces_interface_interface_ref_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_acl__acl_interfaces_interface_interface_ref_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /acl/interfaces/interface/interface_ref/state (container)

    YANG Description: Operational state for interface-ref
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /acl/interfaces/interface/interface_ref/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state for interface-ref
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_acl__acl_interfaces_interface_interface_ref_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_acl__acl_interfaces_interface_interface_ref_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_acl__acl_interfaces_interface_interface_ref_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)

  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)


  _pyangbind_elements = OrderedDict([('config', config), ('state', state), ])


class yc_config_openconfig_acl__acl_interfaces_interface_ingress_acl_sets_ingress_acl_set_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-acl - based on the path /acl/interfaces/interface/ingress-acl-sets/ingress-acl-set/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration data 
  """
  __slots__ = ('_path_helper', '_extmethods', '__set_name','__type',)

  _yang_name = 'config'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__set_name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="set-name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=True)
    self.__type = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['acl', 'interfaces', 'interface', 'ingress-acl-sets', 'ingress-acl-set', 'config']

  def _get_set_name(self):
    """
    Getter method for set_name, mapped from YANG variable /acl/interfaces/interface/ingress_acl_sets/ingress_acl_set/config/set_name (leafref)

    YANG Description: Reference to the ACL set name applied on ingress
    """
    return self.__set_name
      
  def _set_set_name(self, v, load=False):
    """
    Setter method for set_name, mapped from YANG variable /acl/interfaces/interface/ingress_acl_sets/ingress_acl_set/config/set_name (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_set_name() directly.

    YANG Description: Reference to the ACL set name applied on ingress
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="set-name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """set_name must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="set-name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=True)""",
        })

    self.__set_name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_set_name(self):
    self.__set_name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="set-name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=True)


  def _get_type(self):
    """
    Getter method for type, mapped from YANG variable /acl/interfaces/interface/ingress_acl_sets/ingress_acl_set/config/type (leafref)

    YANG Description: Reference to the ACL set type applied on ingress
    """
    return self.__type
      
  def _set_type(self, v, load=False):
    """
    Setter method for type, mapped from YANG variable /acl/interfaces/interface/ingress_acl_sets/ingress_acl_set/config/type (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_type is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_type() directly.

    YANG Description: Reference to the ACL set type applied on ingress
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """type must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=True)""",
        })

    self.__type = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_type(self):
    self.__type = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=True)

  set_name = __builtin__.property(_get_set_name, _set_set_name)
  type = __builtin__.property(_get_type, _set_type)


  _pyangbind_elements = OrderedDict([('set_name', set_name), ('type', type), ])


class yc_state_openconfig_acl__acl_interfaces_interface_ingress_acl_sets_ingress_acl_set_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-acl - based on the path /acl/interfaces/interface/ingress-acl-sets/ingress-acl-set/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state data for interface ingress ACLs
  """
  __slots__ = ('_path_helper', '_extmethods', '__set_name','__type',)

  _yang_name = 'state'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__set_name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="set-name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=False)
    self.__type = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['acl', 'interfaces', 'interface', 'ingress-acl-sets', 'ingress-acl-set', 'state']

  def _get_set_name(self):
    """
    Getter method for set_name, mapped from YANG variable /acl/interfaces/interface/ingress_acl_sets/ingress_acl_set/state/set_name (leafref)

    YANG Description: Reference to the ACL set name applied on ingress
    """
    return self.__set_name
      
  def _set_set_name(self, v, load=False):
    """
    Setter method for set_name, mapped from YANG variable /acl/interfaces/interface/ingress_acl_sets/ingress_acl_set/state/set_name (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_set_name() directly.

    YANG Description: Reference to the ACL set name applied on ingress
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="set-name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """set_name must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="set-name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=False)""",
        })

    self.__set_name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_set_name(self):
    self.__set_name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="set-name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=False)


  def _get_type(self):
    """
    Getter method for type, mapped from YANG variable /acl/interfaces/interface/ingress_acl_sets/ingress_acl_set/state/type (leafref)

    YANG Description: Reference to the ACL set type applied on ingress
    """
    return self.__type
      
  def _set_type(self, v, load=False):
    """
    Setter method for type, mapped from YANG variable /acl/interfaces/interface/ingress_acl_sets/ingress_acl_set/state/type (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_type is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_type() directly.

    YANG Description: Reference to the ACL set type applied on ingress
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """type must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=False)""",
        })

    self.__type = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_type(self):
    self.__type = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=False)

  set_name = __builtin__.property(_get_set_name)
  type = __builtin__.property(_get_type)


  _pyangbind_elements = OrderedDict([('set_name', set_name), ('type', type), ])


class yc_state_openconfig_acl__acl_interfaces_interface_ingress_acl_sets_ingress_acl_set_acl_entries_acl_entry_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-acl - based on the path /acl/interfaces/interface/ingress-acl-sets/ingress-acl-set/acl-entries/acl-entry/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state data for per-interface ACL entries
  """
  __slots__ = ('_path_helper', '_extmethods', '__sequence_id','__matched_packets','__matched_octets',)

  _yang_name = 'state'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__sequence_id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="sequence-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=False)
    self.__matched_packets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="matched-packets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-yang:counter64', is_config=False)
    self.__matched_octets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="matched-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-yang:counter64', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['acl', 'interfaces', 'interface', 'ingress-acl-sets', 'ingress-acl-set', 'acl-entries', 'acl-entry', 'state']

  def _get_sequence_id(self):
    """
    Getter method for sequence_id, mapped from YANG variable /acl/interfaces/interface/ingress_acl_sets/ingress_acl_set/acl_entries/acl_entry/state/sequence_id (leafref)

    YANG Description: Reference to an entry in the ACL set applied to an
interface
    """
    return self.__sequence_id
      
  def _set_sequence_id(self, v, load=False):
    """
    Setter method for sequence_id, mapped from YANG variable /acl/interfaces/interface/ingress_acl_sets/ingress_acl_set/acl_entries/acl_entry/state/sequence_id (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_sequence_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_sequence_id() directly.

    YANG Description: Reference to an entry in the ACL set applied to an
interface
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="sequence-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """sequence_id must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="sequence-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=False)""",
        })

    self.__sequence_id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_sequence_id(self):
    self.__sequence_id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="sequence-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=False)


  def _get_matched_packets(self):
    """
    Getter method for matched_packets, mapped from YANG variable /acl/interfaces/interface/ingress_acl_sets/ingress_acl_set/acl_entries/acl_entry/state/matched_packets (oc-yang:counter64)

    YANG Description: Count of the number of packets matching the current ACL
entry.

An implementation should provide this counter on a
per-interface per-ACL-entry if possible.

If an implementation only supports ACL counters per entry
(i.e., not broken out per interface), then the value
should be equal to the aggregate count across all interfaces.

An implementation that provides counters per entry per
interface is not required to also provide an aggregate count,
e.g., per entry -- the user is expected to be able implement
the required aggregation if such a count is needed.
    """
    return self.__matched_packets
      
  def _set_matched_packets(self, v, load=False):
    """
    Setter method for matched_packets, mapped from YANG variable /acl/interfaces/interface/ingress_acl_sets/ingress_acl_set/acl_entries/acl_entry/state/matched_packets (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_matched_packets is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_matched_packets() directly.

    YANG Description: Count of the number of packets matching the current ACL
entry.

An implementation should provide this counter on a
per-interface per-ACL-entry if possible.

If an implementation only supports ACL counters per entry
(i.e., not broken out per interface), then the value
should be equal to the aggregate count across all interfaces.

An implementation that provides counters per entry per
interface is not required to also provide an aggregate count,
e.g., per entry -- the user is expected to be able implement
the required aggregation if such a count is needed.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="matched-packets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """matched_packets must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="matched-packets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__matched_packets = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_matched_packets(self):
    self.__matched_packets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="matched-packets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-yang:counter64', is_config=False)


  def _get_matched_octets(self):
    """
    Getter method for matched_octets, mapped from YANG variable /acl/interfaces/interface/ingress_acl_sets/ingress_acl_set/acl_entries/acl_entry/state/matched_octets (oc-yang:counter64)

    YANG Description: Count of the number of octets (bytes) matching the current
ACL entry.

An implementation should provide this counter on a
per-interface per-ACL-entry if possible.

If an implementation only supports ACL counters per entry
(i.e., not broken out per interface), then the value
should be equal to the aggregate count across all interfaces.

An implementation that provides counters per entry per
interface is not required to also provide an aggregate count,
e.g., per entry -- the user is expected to be able implement
the required aggregation if such a count is needed.
    """
    return self.__matched_octets
      
  def _set_matched_octets(self, v, load=False):
    """
    Setter method for matched_octets, mapped from YANG variable /acl/interfaces/interface/ingress_acl_sets/ingress_acl_set/acl_entries/acl_entry/state/matched_octets (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_matched_octets is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_matched_octets() directly.

    YANG Description: Count of the number of octets (bytes) matching the current
ACL entry.

An implementation should provide this counter on a
per-interface per-ACL-entry if possible.

If an implementation only supports ACL counters per entry
(i.e., not broken out per interface), then the value
should be equal to the aggregate count across all interfaces.

An implementation that provides counters per entry per
interface is not required to also provide an aggregate count,
e.g., per entry -- the user is expected to be able implement
the required aggregation if such a count is needed.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="matched-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """matched_octets must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="matched-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__matched_octets = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_matched_octets(self):
    self.__matched_octets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="matched-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-yang:counter64', is_config=False)

  sequence_id = __builtin__.property(_get_sequence_id)
  matched_packets = __builtin__.property(_get_matched_packets)
  matched_octets = __builtin__.property(_get_matched_octets)


  _pyangbind_elements = OrderedDict([('sequence_id', sequence_id), ('matched_packets', matched_packets), ('matched_octets', matched_octets), ])


class yc_acl_entry_openconfig_acl__acl_interfaces_interface_ingress_acl_sets_ingress_acl_set_acl_entries_acl_entry(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-acl - based on the path /acl/interfaces/interface/ingress-acl-sets/ingress-acl-set/acl-entries/acl-entry. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: List of ACL entries assigned to an interface
  """
  __slots__ = ('_path_helper', '_extmethods', '__sequence_id','__state',)

  _yang_name = 'acl-entry'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__sequence_id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="sequence-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=False)
    self.__state = YANGDynClass(base=yc_state_openconfig_acl__acl_interfaces_interface_ingress_acl_sets_ingress_acl_set_acl_entries_acl_entry_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['acl', 'interfaces', 'interface', 'ingress-acl-sets', 'ingress-acl-set', 'acl-entries', 'acl-entry']

  def _get_sequence_id(self):
    """
    Getter method for sequence_id, mapped from YANG variable /acl/interfaces/interface/ingress_acl_sets/ingress_acl_set/acl_entries/acl_entry/sequence_id (leafref)

    YANG Description: Reference to per-interface acl entry key
    """
    return self.__sequence_id
      
  def _set_sequence_id(self, v, load=False):
    """
    Setter method for sequence_id, mapped from YANG variable /acl/interfaces/interface/ingress_acl_sets/ingress_acl_set/acl_entries/acl_entry/sequence_id (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_sequence_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_sequence_id() directly.

    YANG Description: Reference to per-interface acl entry key
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="sequence-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """sequence_id must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="sequence-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=False)""",
        })

    self.__sequence_id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_sequence_id(self):
    self.__sequence_id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="sequence-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=False)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /acl/interfaces/interface/ingress_acl_sets/ingress_acl_set/acl_entries/acl_entry/state (container)

    YANG Description: Operational state data for per-interface ACL entries
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /acl/interfaces/interface/ingress_acl_sets/ingress_acl_set/acl_entries/acl_entry/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state data for per-interface ACL entries
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_acl__acl_interfaces_interface_ingress_acl_sets_ingress_acl_set_acl_entries_acl_entry_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_acl__acl_interfaces_interface_ingress_acl_sets_ingress_acl_set_acl_entries_acl_entry_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=False)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_acl__acl_interfaces_interface_ingress_acl_sets_ingress_acl_set_acl_entries_acl_entry_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=False)

  sequence_id = __builtin__.property(_get_sequence_id)
  state = __builtin__.property(_get_state)


  _pyangbind_elements = OrderedDict([('sequence_id', sequence_id), ('state', state), ])


class yc_acl_entries_openconfig_acl__acl_interfaces_interface_ingress_acl_sets_ingress_acl_set_acl_entries(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-acl - based on the path /acl/interfaces/interface/ingress-acl-sets/ingress-acl-set/acl-entries. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Enclosing container for list of references to ACLs
  """
  __slots__ = ('_path_helper', '_extmethods', '__acl_entry',)

  _yang_name = 'acl-entries'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__acl_entry = YANGDynClass(base=YANGListType("sequence_id",yc_acl_entry_openconfig_acl__acl_interfaces_interface_ingress_acl_sets_ingress_acl_set_acl_entries_acl_entry, yang_name="acl-entry", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='sequence-id', extensions=None), is_container='list', yang_name="acl-entry", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='list', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['acl', 'interfaces', 'interface', 'ingress-acl-sets', 'ingress-acl-set', 'acl-entries']

  def _get_acl_entry(self):
    """
    Getter method for acl_entry, mapped from YANG variable /acl/interfaces/interface/ingress_acl_sets/ingress_acl_set/acl_entries/acl_entry (list)

    YANG Description: List of ACL entries assigned to an interface
    """
    return self.__acl_entry
      
  def _set_acl_entry(self, v, load=False):
    """
    Setter method for acl_entry, mapped from YANG variable /acl/interfaces/interface/ingress_acl_sets/ingress_acl_set/acl_entries/acl_entry (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_acl_entry is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_acl_entry() directly.

    YANG Description: List of ACL entries assigned to an interface
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("sequence_id",yc_acl_entry_openconfig_acl__acl_interfaces_interface_ingress_acl_sets_ingress_acl_set_acl_entries_acl_entry, yang_name="acl-entry", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='sequence-id', extensions=None), is_container='list', yang_name="acl-entry", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='list', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """acl_entry must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("sequence_id",yc_acl_entry_openconfig_acl__acl_interfaces_interface_ingress_acl_sets_ingress_acl_set_acl_entries_acl_entry, yang_name="acl-entry", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='sequence-id', extensions=None), is_container='list', yang_name="acl-entry", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='list', is_config=False)""",
        })

    self.__acl_entry = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_acl_entry(self):
    self.__acl_entry = YANGDynClass(base=YANGListType("sequence_id",yc_acl_entry_openconfig_acl__acl_interfaces_interface_ingress_acl_sets_ingress_acl_set_acl_entries_acl_entry, yang_name="acl-entry", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='sequence-id', extensions=None), is_container='list', yang_name="acl-entry", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='list', is_config=False)

  acl_entry = __builtin__.property(_get_acl_entry)


  _pyangbind_elements = OrderedDict([('acl_entry', acl_entry), ])


class yc_ingress_acl_set_openconfig_acl__acl_interfaces_interface_ingress_acl_sets_ingress_acl_set(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-acl - based on the path /acl/interfaces/interface/ingress-acl-sets/ingress-acl-set. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: List of ingress ACLs on the interface
  """
  __slots__ = ('_path_helper', '_extmethods', '__set_name','__type','__config','__state','__acl_entries',)

  _yang_name = 'ingress-acl-set'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__set_name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="set-name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=True)
    self.__type = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=True)
    self.__config = YANGDynClass(base=yc_config_openconfig_acl__acl_interfaces_interface_ingress_acl_sets_ingress_acl_set_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_acl__acl_interfaces_interface_ingress_acl_sets_ingress_acl_set_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)
    self.__acl_entries = YANGDynClass(base=yc_acl_entries_openconfig_acl__acl_interfaces_interface_ingress_acl_sets_ingress_acl_set_acl_entries, is_container='container', yang_name="acl-entries", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['acl', 'interfaces', 'interface', 'ingress-acl-sets', 'ingress-acl-set']

  def _get_set_name(self):
    """
    Getter method for set_name, mapped from YANG variable /acl/interfaces/interface/ingress_acl_sets/ingress_acl_set/set_name (leafref)

    YANG Description: Reference to set name list key
    """
    return self.__set_name
      
  def _set_set_name(self, v, load=False):
    """
    Setter method for set_name, mapped from YANG variable /acl/interfaces/interface/ingress_acl_sets/ingress_acl_set/set_name (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_set_name() directly.

    YANG Description: Reference to set name list key
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="set-name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """set_name must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="set-name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=True)""",
        })

    self.__set_name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_set_name(self):
    self.__set_name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="set-name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=True)


  def _get_type(self):
    """
    Getter method for type, mapped from YANG variable /acl/interfaces/interface/ingress_acl_sets/ingress_acl_set/type (leafref)

    YANG Description: Reference to type list key
    """
    return self.__type
      
  def _set_type(self, v, load=False):
    """
    Setter method for type, mapped from YANG variable /acl/interfaces/interface/ingress_acl_sets/ingress_acl_set/type (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_type is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_type() directly.

    YANG Description: Reference to type list key
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """type must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=True)""",
        })

    self.__type = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_type(self):
    self.__type = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=True)


  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /acl/interfaces/interface/ingress_acl_sets/ingress_acl_set/config (container)

    YANG Description: Configuration data 
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /acl/interfaces/interface/ingress_acl_sets/ingress_acl_set/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration data 
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_acl__acl_interfaces_interface_ingress_acl_sets_ingress_acl_set_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_acl__acl_interfaces_interface_ingress_acl_sets_ingress_acl_set_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_acl__acl_interfaces_interface_ingress_acl_sets_ingress_acl_set_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /acl/interfaces/interface/ingress_acl_sets/ingress_acl_set/state (container)

    YANG Description: Operational state data for interface ingress ACLs
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /acl/interfaces/interface/ingress_acl_sets/ingress_acl_set/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state data for interface ingress ACLs
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_acl__acl_interfaces_interface_ingress_acl_sets_ingress_acl_set_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_acl__acl_interfaces_interface_ingress_acl_sets_ingress_acl_set_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_acl__acl_interfaces_interface_ingress_acl_sets_ingress_acl_set_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)


  def _get_acl_entries(self):
    """
    Getter method for acl_entries, mapped from YANG variable /acl/interfaces/interface/ingress_acl_sets/ingress_acl_set/acl_entries (container)

    YANG Description: Enclosing container for list of references to ACLs
    """
    return self.__acl_entries
      
  def _set_acl_entries(self, v, load=False):
    """
    Setter method for acl_entries, mapped from YANG variable /acl/interfaces/interface/ingress_acl_sets/ingress_acl_set/acl_entries (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_acl_entries is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_acl_entries() directly.

    YANG Description: Enclosing container for list of references to ACLs
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_acl_entries_openconfig_acl__acl_interfaces_interface_ingress_acl_sets_ingress_acl_set_acl_entries, is_container='container', yang_name="acl-entries", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """acl_entries must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_acl_entries_openconfig_acl__acl_interfaces_interface_ingress_acl_sets_ingress_acl_set_acl_entries, is_container='container', yang_name="acl-entries", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)""",
        })

    self.__acl_entries = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_acl_entries(self):
    self.__acl_entries = YANGDynClass(base=yc_acl_entries_openconfig_acl__acl_interfaces_interface_ingress_acl_sets_ingress_acl_set_acl_entries, is_container='container', yang_name="acl-entries", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)

  set_name = __builtin__.property(_get_set_name, _set_set_name)
  type = __builtin__.property(_get_type, _set_type)
  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)
  acl_entries = __builtin__.property(_get_acl_entries, _set_acl_entries)


  _pyangbind_elements = OrderedDict([('set_name', set_name), ('type', type), ('config', config), ('state', state), ('acl_entries', acl_entries), ])


class yc_ingress_acl_sets_openconfig_acl__acl_interfaces_interface_ingress_acl_sets(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-acl - based on the path /acl/interfaces/interface/ingress-acl-sets. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Enclosing container the list of ingress ACLs on the
interface
  """
  __slots__ = ('_path_helper', '_extmethods', '__ingress_acl_set',)

  _yang_name = 'ingress-acl-sets'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__ingress_acl_set = YANGDynClass(base=YANGListType("set_name type",yc_ingress_acl_set_openconfig_acl__acl_interfaces_interface_ingress_acl_sets_ingress_acl_set, yang_name="ingress-acl-set", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='set-name type', extensions=None), is_container='list', yang_name="ingress-acl-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='list', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['acl', 'interfaces', 'interface', 'ingress-acl-sets']

  def _get_ingress_acl_set(self):
    """
    Getter method for ingress_acl_set, mapped from YANG variable /acl/interfaces/interface/ingress_acl_sets/ingress_acl_set (list)

    YANG Description: List of ingress ACLs on the interface
    """
    return self.__ingress_acl_set
      
  def _set_ingress_acl_set(self, v, load=False):
    """
    Setter method for ingress_acl_set, mapped from YANG variable /acl/interfaces/interface/ingress_acl_sets/ingress_acl_set (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_ingress_acl_set is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_ingress_acl_set() directly.

    YANG Description: List of ingress ACLs on the interface
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("set_name type",yc_ingress_acl_set_openconfig_acl__acl_interfaces_interface_ingress_acl_sets_ingress_acl_set, yang_name="ingress-acl-set", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='set-name type', extensions=None), is_container='list', yang_name="ingress-acl-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='list', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """ingress_acl_set must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("set_name type",yc_ingress_acl_set_openconfig_acl__acl_interfaces_interface_ingress_acl_sets_ingress_acl_set, yang_name="ingress-acl-set", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='set-name type', extensions=None), is_container='list', yang_name="ingress-acl-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='list', is_config=True)""",
        })

    self.__ingress_acl_set = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_ingress_acl_set(self):
    self.__ingress_acl_set = YANGDynClass(base=YANGListType("set_name type",yc_ingress_acl_set_openconfig_acl__acl_interfaces_interface_ingress_acl_sets_ingress_acl_set, yang_name="ingress-acl-set", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='set-name type', extensions=None), is_container='list', yang_name="ingress-acl-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='list', is_config=True)

  ingress_acl_set = __builtin__.property(_get_ingress_acl_set, _set_ingress_acl_set)


  _pyangbind_elements = OrderedDict([('ingress_acl_set', ingress_acl_set), ])


class yc_config_openconfig_acl__acl_interfaces_interface_egress_acl_sets_egress_acl_set_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-acl - based on the path /acl/interfaces/interface/egress-acl-sets/egress-acl-set/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration data 
  """
  __slots__ = ('_path_helper', '_extmethods', '__set_name','__type',)

  _yang_name = 'config'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__set_name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="set-name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=True)
    self.__type = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['acl', 'interfaces', 'interface', 'egress-acl-sets', 'egress-acl-set', 'config']

  def _get_set_name(self):
    """
    Getter method for set_name, mapped from YANG variable /acl/interfaces/interface/egress_acl_sets/egress_acl_set/config/set_name (leafref)

    YANG Description: Reference to the ACL set name applied on egress
    """
    return self.__set_name
      
  def _set_set_name(self, v, load=False):
    """
    Setter method for set_name, mapped from YANG variable /acl/interfaces/interface/egress_acl_sets/egress_acl_set/config/set_name (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_set_name() directly.

    YANG Description: Reference to the ACL set name applied on egress
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="set-name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """set_name must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="set-name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=True)""",
        })

    self.__set_name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_set_name(self):
    self.__set_name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="set-name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=True)


  def _get_type(self):
    """
    Getter method for type, mapped from YANG variable /acl/interfaces/interface/egress_acl_sets/egress_acl_set/config/type (leafref)

    YANG Description: Reference to the ACL set type applied on egress.
    """
    return self.__type
      
  def _set_type(self, v, load=False):
    """
    Setter method for type, mapped from YANG variable /acl/interfaces/interface/egress_acl_sets/egress_acl_set/config/type (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_type is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_type() directly.

    YANG Description: Reference to the ACL set type applied on egress.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """type must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=True)""",
        })

    self.__type = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_type(self):
    self.__type = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=True)

  set_name = __builtin__.property(_get_set_name, _set_set_name)
  type = __builtin__.property(_get_type, _set_type)


  _pyangbind_elements = OrderedDict([('set_name', set_name), ('type', type), ])


class yc_state_openconfig_acl__acl_interfaces_interface_egress_acl_sets_egress_acl_set_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-acl - based on the path /acl/interfaces/interface/egress-acl-sets/egress-acl-set/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state data for interface egress ACLs
  """
  __slots__ = ('_path_helper', '_extmethods', '__set_name','__type',)

  _yang_name = 'state'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__set_name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="set-name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=False)
    self.__type = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['acl', 'interfaces', 'interface', 'egress-acl-sets', 'egress-acl-set', 'state']

  def _get_set_name(self):
    """
    Getter method for set_name, mapped from YANG variable /acl/interfaces/interface/egress_acl_sets/egress_acl_set/state/set_name (leafref)

    YANG Description: Reference to the ACL set name applied on egress
    """
    return self.__set_name
      
  def _set_set_name(self, v, load=False):
    """
    Setter method for set_name, mapped from YANG variable /acl/interfaces/interface/egress_acl_sets/egress_acl_set/state/set_name (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_set_name() directly.

    YANG Description: Reference to the ACL set name applied on egress
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="set-name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """set_name must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="set-name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=False)""",
        })

    self.__set_name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_set_name(self):
    self.__set_name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="set-name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=False)


  def _get_type(self):
    """
    Getter method for type, mapped from YANG variable /acl/interfaces/interface/egress_acl_sets/egress_acl_set/state/type (leafref)

    YANG Description: Reference to the ACL set type applied on egress.
    """
    return self.__type
      
  def _set_type(self, v, load=False):
    """
    Setter method for type, mapped from YANG variable /acl/interfaces/interface/egress_acl_sets/egress_acl_set/state/type (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_type is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_type() directly.

    YANG Description: Reference to the ACL set type applied on egress.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """type must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=False)""",
        })

    self.__type = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_type(self):
    self.__type = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=False)

  set_name = __builtin__.property(_get_set_name)
  type = __builtin__.property(_get_type)


  _pyangbind_elements = OrderedDict([('set_name', set_name), ('type', type), ])


class yc_state_openconfig_acl__acl_interfaces_interface_egress_acl_sets_egress_acl_set_acl_entries_acl_entry_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-acl - based on the path /acl/interfaces/interface/egress-acl-sets/egress-acl-set/acl-entries/acl-entry/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state data for per-interface ACL entries
  """
  __slots__ = ('_path_helper', '_extmethods', '__sequence_id','__matched_packets','__matched_octets',)

  _yang_name = 'state'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__sequence_id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="sequence-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=False)
    self.__matched_packets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="matched-packets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-yang:counter64', is_config=False)
    self.__matched_octets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="matched-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-yang:counter64', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['acl', 'interfaces', 'interface', 'egress-acl-sets', 'egress-acl-set', 'acl-entries', 'acl-entry', 'state']

  def _get_sequence_id(self):
    """
    Getter method for sequence_id, mapped from YANG variable /acl/interfaces/interface/egress_acl_sets/egress_acl_set/acl_entries/acl_entry/state/sequence_id (leafref)

    YANG Description: Reference to an entry in the ACL set applied to an
interface
    """
    return self.__sequence_id
      
  def _set_sequence_id(self, v, load=False):
    """
    Setter method for sequence_id, mapped from YANG variable /acl/interfaces/interface/egress_acl_sets/egress_acl_set/acl_entries/acl_entry/state/sequence_id (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_sequence_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_sequence_id() directly.

    YANG Description: Reference to an entry in the ACL set applied to an
interface
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="sequence-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """sequence_id must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="sequence-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=False)""",
        })

    self.__sequence_id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_sequence_id(self):
    self.__sequence_id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="sequence-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=False)


  def _get_matched_packets(self):
    """
    Getter method for matched_packets, mapped from YANG variable /acl/interfaces/interface/egress_acl_sets/egress_acl_set/acl_entries/acl_entry/state/matched_packets (oc-yang:counter64)

    YANG Description: Count of the number of packets matching the current ACL
entry.

An implementation should provide this counter on a
per-interface per-ACL-entry if possible.

If an implementation only supports ACL counters per entry
(i.e., not broken out per interface), then the value
should be equal to the aggregate count across all interfaces.

An implementation that provides counters per entry per
interface is not required to also provide an aggregate count,
e.g., per entry -- the user is expected to be able implement
the required aggregation if such a count is needed.
    """
    return self.__matched_packets
      
  def _set_matched_packets(self, v, load=False):
    """
    Setter method for matched_packets, mapped from YANG variable /acl/interfaces/interface/egress_acl_sets/egress_acl_set/acl_entries/acl_entry/state/matched_packets (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_matched_packets is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_matched_packets() directly.

    YANG Description: Count of the number of packets matching the current ACL
entry.

An implementation should provide this counter on a
per-interface per-ACL-entry if possible.

If an implementation only supports ACL counters per entry
(i.e., not broken out per interface), then the value
should be equal to the aggregate count across all interfaces.

An implementation that provides counters per entry per
interface is not required to also provide an aggregate count,
e.g., per entry -- the user is expected to be able implement
the required aggregation if such a count is needed.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="matched-packets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """matched_packets must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="matched-packets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__matched_packets = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_matched_packets(self):
    self.__matched_packets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="matched-packets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-yang:counter64', is_config=False)


  def _get_matched_octets(self):
    """
    Getter method for matched_octets, mapped from YANG variable /acl/interfaces/interface/egress_acl_sets/egress_acl_set/acl_entries/acl_entry/state/matched_octets (oc-yang:counter64)

    YANG Description: Count of the number of octets (bytes) matching the current
ACL entry.

An implementation should provide this counter on a
per-interface per-ACL-entry if possible.

If an implementation only supports ACL counters per entry
(i.e., not broken out per interface), then the value
should be equal to the aggregate count across all interfaces.

An implementation that provides counters per entry per
interface is not required to also provide an aggregate count,
e.g., per entry -- the user is expected to be able implement
the required aggregation if such a count is needed.
    """
    return self.__matched_octets
      
  def _set_matched_octets(self, v, load=False):
    """
    Setter method for matched_octets, mapped from YANG variable /acl/interfaces/interface/egress_acl_sets/egress_acl_set/acl_entries/acl_entry/state/matched_octets (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_matched_octets is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_matched_octets() directly.

    YANG Description: Count of the number of octets (bytes) matching the current
ACL entry.

An implementation should provide this counter on a
per-interface per-ACL-entry if possible.

If an implementation only supports ACL counters per entry
(i.e., not broken out per interface), then the value
should be equal to the aggregate count across all interfaces.

An implementation that provides counters per entry per
interface is not required to also provide an aggregate count,
e.g., per entry -- the user is expected to be able implement
the required aggregation if such a count is needed.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="matched-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """matched_octets must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="matched-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__matched_octets = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_matched_octets(self):
    self.__matched_octets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="matched-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-yang:counter64', is_config=False)

  sequence_id = __builtin__.property(_get_sequence_id)
  matched_packets = __builtin__.property(_get_matched_packets)
  matched_octets = __builtin__.property(_get_matched_octets)


  _pyangbind_elements = OrderedDict([('sequence_id', sequence_id), ('matched_packets', matched_packets), ('matched_octets', matched_octets), ])


class yc_acl_entry_openconfig_acl__acl_interfaces_interface_egress_acl_sets_egress_acl_set_acl_entries_acl_entry(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-acl - based on the path /acl/interfaces/interface/egress-acl-sets/egress-acl-set/acl-entries/acl-entry. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: List of ACL entries assigned to an interface
  """
  __slots__ = ('_path_helper', '_extmethods', '__sequence_id','__state',)

  _yang_name = 'acl-entry'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__sequence_id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="sequence-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=False)
    self.__state = YANGDynClass(base=yc_state_openconfig_acl__acl_interfaces_interface_egress_acl_sets_egress_acl_set_acl_entries_acl_entry_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['acl', 'interfaces', 'interface', 'egress-acl-sets', 'egress-acl-set', 'acl-entries', 'acl-entry']

  def _get_sequence_id(self):
    """
    Getter method for sequence_id, mapped from YANG variable /acl/interfaces/interface/egress_acl_sets/egress_acl_set/acl_entries/acl_entry/sequence_id (leafref)

    YANG Description: Reference to per-interface acl entry key
    """
    return self.__sequence_id
      
  def _set_sequence_id(self, v, load=False):
    """
    Setter method for sequence_id, mapped from YANG variable /acl/interfaces/interface/egress_acl_sets/egress_acl_set/acl_entries/acl_entry/sequence_id (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_sequence_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_sequence_id() directly.

    YANG Description: Reference to per-interface acl entry key
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="sequence-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """sequence_id must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="sequence-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=False)""",
        })

    self.__sequence_id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_sequence_id(self):
    self.__sequence_id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="sequence-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=False)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /acl/interfaces/interface/egress_acl_sets/egress_acl_set/acl_entries/acl_entry/state (container)

    YANG Description: Operational state data for per-interface ACL entries
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /acl/interfaces/interface/egress_acl_sets/egress_acl_set/acl_entries/acl_entry/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state data for per-interface ACL entries
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_acl__acl_interfaces_interface_egress_acl_sets_egress_acl_set_acl_entries_acl_entry_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_acl__acl_interfaces_interface_egress_acl_sets_egress_acl_set_acl_entries_acl_entry_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=False)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_acl__acl_interfaces_interface_egress_acl_sets_egress_acl_set_acl_entries_acl_entry_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=False)

  sequence_id = __builtin__.property(_get_sequence_id)
  state = __builtin__.property(_get_state)


  _pyangbind_elements = OrderedDict([('sequence_id', sequence_id), ('state', state), ])


class yc_acl_entries_openconfig_acl__acl_interfaces_interface_egress_acl_sets_egress_acl_set_acl_entries(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-acl - based on the path /acl/interfaces/interface/egress-acl-sets/egress-acl-set/acl-entries. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Enclosing container for list of references to ACLs
  """
  __slots__ = ('_path_helper', '_extmethods', '__acl_entry',)

  _yang_name = 'acl-entries'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__acl_entry = YANGDynClass(base=YANGListType("sequence_id",yc_acl_entry_openconfig_acl__acl_interfaces_interface_egress_acl_sets_egress_acl_set_acl_entries_acl_entry, yang_name="acl-entry", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='sequence-id', extensions=None), is_container='list', yang_name="acl-entry", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='list', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['acl', 'interfaces', 'interface', 'egress-acl-sets', 'egress-acl-set', 'acl-entries']

  def _get_acl_entry(self):
    """
    Getter method for acl_entry, mapped from YANG variable /acl/interfaces/interface/egress_acl_sets/egress_acl_set/acl_entries/acl_entry (list)

    YANG Description: List of ACL entries assigned to an interface
    """
    return self.__acl_entry
      
  def _set_acl_entry(self, v, load=False):
    """
    Setter method for acl_entry, mapped from YANG variable /acl/interfaces/interface/egress_acl_sets/egress_acl_set/acl_entries/acl_entry (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_acl_entry is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_acl_entry() directly.

    YANG Description: List of ACL entries assigned to an interface
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("sequence_id",yc_acl_entry_openconfig_acl__acl_interfaces_interface_egress_acl_sets_egress_acl_set_acl_entries_acl_entry, yang_name="acl-entry", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='sequence-id', extensions=None), is_container='list', yang_name="acl-entry", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='list', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """acl_entry must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("sequence_id",yc_acl_entry_openconfig_acl__acl_interfaces_interface_egress_acl_sets_egress_acl_set_acl_entries_acl_entry, yang_name="acl-entry", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='sequence-id', extensions=None), is_container='list', yang_name="acl-entry", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='list', is_config=False)""",
        })

    self.__acl_entry = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_acl_entry(self):
    self.__acl_entry = YANGDynClass(base=YANGListType("sequence_id",yc_acl_entry_openconfig_acl__acl_interfaces_interface_egress_acl_sets_egress_acl_set_acl_entries_acl_entry, yang_name="acl-entry", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='sequence-id', extensions=None), is_container='list', yang_name="acl-entry", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='list', is_config=False)

  acl_entry = __builtin__.property(_get_acl_entry)


  _pyangbind_elements = OrderedDict([('acl_entry', acl_entry), ])


class yc_egress_acl_set_openconfig_acl__acl_interfaces_interface_egress_acl_sets_egress_acl_set(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-acl - based on the path /acl/interfaces/interface/egress-acl-sets/egress-acl-set. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: List of egress ACLs on the interface
  """
  __slots__ = ('_path_helper', '_extmethods', '__set_name','__type','__config','__state','__acl_entries',)

  _yang_name = 'egress-acl-set'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__set_name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="set-name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=True)
    self.__type = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=True)
    self.__config = YANGDynClass(base=yc_config_openconfig_acl__acl_interfaces_interface_egress_acl_sets_egress_acl_set_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_acl__acl_interfaces_interface_egress_acl_sets_egress_acl_set_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)
    self.__acl_entries = YANGDynClass(base=yc_acl_entries_openconfig_acl__acl_interfaces_interface_egress_acl_sets_egress_acl_set_acl_entries, is_container='container', yang_name="acl-entries", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['acl', 'interfaces', 'interface', 'egress-acl-sets', 'egress-acl-set']

  def _get_set_name(self):
    """
    Getter method for set_name, mapped from YANG variable /acl/interfaces/interface/egress_acl_sets/egress_acl_set/set_name (leafref)

    YANG Description: Reference to set name list key
    """
    return self.__set_name
      
  def _set_set_name(self, v, load=False):
    """
    Setter method for set_name, mapped from YANG variable /acl/interfaces/interface/egress_acl_sets/egress_acl_set/set_name (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_set_name() directly.

    YANG Description: Reference to set name list key
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="set-name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """set_name must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="set-name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=True)""",
        })

    self.__set_name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_set_name(self):
    self.__set_name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="set-name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=True)


  def _get_type(self):
    """
    Getter method for type, mapped from YANG variable /acl/interfaces/interface/egress_acl_sets/egress_acl_set/type (leafref)

    YANG Description: Reference to type list key
    """
    return self.__type
      
  def _set_type(self, v, load=False):
    """
    Setter method for type, mapped from YANG variable /acl/interfaces/interface/egress_acl_sets/egress_acl_set/type (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_type is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_type() directly.

    YANG Description: Reference to type list key
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """type must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=True)""",
        })

    self.__type = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_type(self):
    self.__type = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=True)


  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /acl/interfaces/interface/egress_acl_sets/egress_acl_set/config (container)

    YANG Description: Configuration data 
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /acl/interfaces/interface/egress_acl_sets/egress_acl_set/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration data 
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_acl__acl_interfaces_interface_egress_acl_sets_egress_acl_set_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_acl__acl_interfaces_interface_egress_acl_sets_egress_acl_set_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_acl__acl_interfaces_interface_egress_acl_sets_egress_acl_set_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /acl/interfaces/interface/egress_acl_sets/egress_acl_set/state (container)

    YANG Description: Operational state data for interface egress ACLs
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /acl/interfaces/interface/egress_acl_sets/egress_acl_set/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state data for interface egress ACLs
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_acl__acl_interfaces_interface_egress_acl_sets_egress_acl_set_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_acl__acl_interfaces_interface_egress_acl_sets_egress_acl_set_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_acl__acl_interfaces_interface_egress_acl_sets_egress_acl_set_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)


  def _get_acl_entries(self):
    """
    Getter method for acl_entries, mapped from YANG variable /acl/interfaces/interface/egress_acl_sets/egress_acl_set/acl_entries (container)

    YANG Description: Enclosing container for list of references to ACLs
    """
    return self.__acl_entries
      
  def _set_acl_entries(self, v, load=False):
    """
    Setter method for acl_entries, mapped from YANG variable /acl/interfaces/interface/egress_acl_sets/egress_acl_set/acl_entries (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_acl_entries is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_acl_entries() directly.

    YANG Description: Enclosing container for list of references to ACLs
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_acl_entries_openconfig_acl__acl_interfaces_interface_egress_acl_sets_egress_acl_set_acl_entries, is_container='container', yang_name="acl-entries", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """acl_entries must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_acl_entries_openconfig_acl__acl_interfaces_interface_egress_acl_sets_egress_acl_set_acl_entries, is_container='container', yang_name="acl-entries", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)""",
        })

    self.__acl_entries = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_acl_entries(self):
    self.__acl_entries = YANGDynClass(base=yc_acl_entries_openconfig_acl__acl_interfaces_interface_egress_acl_sets_egress_acl_set_acl_entries, is_container='container', yang_name="acl-entries", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)

  set_name = __builtin__.property(_get_set_name, _set_set_name)
  type = __builtin__.property(_get_type, _set_type)
  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)
  acl_entries = __builtin__.property(_get_acl_entries, _set_acl_entries)


  _pyangbind_elements = OrderedDict([('set_name', set_name), ('type', type), ('config', config), ('state', state), ('acl_entries', acl_entries), ])


class yc_egress_acl_sets_openconfig_acl__acl_interfaces_interface_egress_acl_sets(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-acl - based on the path /acl/interfaces/interface/egress-acl-sets. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Enclosing container the list of egress ACLs on the
interface
  """
  __slots__ = ('_path_helper', '_extmethods', '__egress_acl_set',)

  _yang_name = 'egress-acl-sets'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__egress_acl_set = YANGDynClass(base=YANGListType("set_name type",yc_egress_acl_set_openconfig_acl__acl_interfaces_interface_egress_acl_sets_egress_acl_set, yang_name="egress-acl-set", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='set-name type', extensions=None), is_container='list', yang_name="egress-acl-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='list', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['acl', 'interfaces', 'interface', 'egress-acl-sets']

  def _get_egress_acl_set(self):
    """
    Getter method for egress_acl_set, mapped from YANG variable /acl/interfaces/interface/egress_acl_sets/egress_acl_set (list)

    YANG Description: List of egress ACLs on the interface
    """
    return self.__egress_acl_set
      
  def _set_egress_acl_set(self, v, load=False):
    """
    Setter method for egress_acl_set, mapped from YANG variable /acl/interfaces/interface/egress_acl_sets/egress_acl_set (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_egress_acl_set is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_egress_acl_set() directly.

    YANG Description: List of egress ACLs on the interface
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("set_name type",yc_egress_acl_set_openconfig_acl__acl_interfaces_interface_egress_acl_sets_egress_acl_set, yang_name="egress-acl-set", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='set-name type', extensions=None), is_container='list', yang_name="egress-acl-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='list', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """egress_acl_set must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("set_name type",yc_egress_acl_set_openconfig_acl__acl_interfaces_interface_egress_acl_sets_egress_acl_set, yang_name="egress-acl-set", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='set-name type', extensions=None), is_container='list', yang_name="egress-acl-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='list', is_config=True)""",
        })

    self.__egress_acl_set = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_egress_acl_set(self):
    self.__egress_acl_set = YANGDynClass(base=YANGListType("set_name type",yc_egress_acl_set_openconfig_acl__acl_interfaces_interface_egress_acl_sets_egress_acl_set, yang_name="egress-acl-set", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='set-name type', extensions=None), is_container='list', yang_name="egress-acl-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='list', is_config=True)

  egress_acl_set = __builtin__.property(_get_egress_acl_set, _set_egress_acl_set)


  _pyangbind_elements = OrderedDict([('egress_acl_set', egress_acl_set), ])


class yc_interface_openconfig_acl__acl_interfaces_interface(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-acl - based on the path /acl/interfaces/interface. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: List of interfaces on which ACLs are set
  """
  __slots__ = ('_path_helper', '_extmethods', '__id','__config','__state','__interface_ref','__ingress_acl_sets','__egress_acl_sets',)

  _yang_name = 'interface'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=True)
    self.__config = YANGDynClass(base=yc_config_openconfig_acl__acl_interfaces_interface_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_acl__acl_interfaces_interface_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)
    self.__interface_ref = YANGDynClass(base=yc_interface_ref_openconfig_acl__acl_interfaces_interface_interface_ref, is_container='container', yang_name="interface-ref", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)
    self.__ingress_acl_sets = YANGDynClass(base=yc_ingress_acl_sets_openconfig_acl__acl_interfaces_interface_ingress_acl_sets, is_container='container', yang_name="ingress-acl-sets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)
    self.__egress_acl_sets = YANGDynClass(base=yc_egress_acl_sets_openconfig_acl__acl_interfaces_interface_egress_acl_sets, is_container='container', yang_name="egress-acl-sets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['acl', 'interfaces', 'interface']

  def _get_id(self):
    """
    Getter method for id, mapped from YANG variable /acl/interfaces/interface/id (leafref)

    YANG Description: Reference to the interface id list key
    """
    return self.__id
      
  def _set_id(self, v, load=False):
    """
    Setter method for id, mapped from YANG variable /acl/interfaces/interface/id (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_id() directly.

    YANG Description: Reference to the interface id list key
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """id must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=True)""",
        })

    self.__id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_id(self):
    self.__id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=True)


  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /acl/interfaces/interface/config (container)

    YANG Description: Configuration for ACL per-interface data
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /acl/interfaces/interface/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration for ACL per-interface data
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_acl__acl_interfaces_interface_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_acl__acl_interfaces_interface_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_acl__acl_interfaces_interface_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /acl/interfaces/interface/state (container)

    YANG Description: Operational state for ACL per-interface data
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /acl/interfaces/interface/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state for ACL per-interface data
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_acl__acl_interfaces_interface_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_acl__acl_interfaces_interface_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_acl__acl_interfaces_interface_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)


  def _get_interface_ref(self):
    """
    Getter method for interface_ref, mapped from YANG variable /acl/interfaces/interface/interface_ref (container)

    YANG Description: Reference to an interface or subinterface
    """
    return self.__interface_ref
      
  def _set_interface_ref(self, v, load=False):
    """
    Setter method for interface_ref, mapped from YANG variable /acl/interfaces/interface/interface_ref (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_interface_ref is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_interface_ref() directly.

    YANG Description: Reference to an interface or subinterface
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_interface_ref_openconfig_acl__acl_interfaces_interface_interface_ref, is_container='container', yang_name="interface-ref", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """interface_ref must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_interface_ref_openconfig_acl__acl_interfaces_interface_interface_ref, is_container='container', yang_name="interface-ref", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)""",
        })

    self.__interface_ref = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_interface_ref(self):
    self.__interface_ref = YANGDynClass(base=yc_interface_ref_openconfig_acl__acl_interfaces_interface_interface_ref, is_container='container', yang_name="interface-ref", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)


  def _get_ingress_acl_sets(self):
    """
    Getter method for ingress_acl_sets, mapped from YANG variable /acl/interfaces/interface/ingress_acl_sets (container)

    YANG Description: Enclosing container the list of ingress ACLs on the
interface
    """
    return self.__ingress_acl_sets
      
  def _set_ingress_acl_sets(self, v, load=False):
    """
    Setter method for ingress_acl_sets, mapped from YANG variable /acl/interfaces/interface/ingress_acl_sets (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_ingress_acl_sets is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_ingress_acl_sets() directly.

    YANG Description: Enclosing container the list of ingress ACLs on the
interface
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_ingress_acl_sets_openconfig_acl__acl_interfaces_interface_ingress_acl_sets, is_container='container', yang_name="ingress-acl-sets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """ingress_acl_sets must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_ingress_acl_sets_openconfig_acl__acl_interfaces_interface_ingress_acl_sets, is_container='container', yang_name="ingress-acl-sets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)""",
        })

    self.__ingress_acl_sets = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_ingress_acl_sets(self):
    self.__ingress_acl_sets = YANGDynClass(base=yc_ingress_acl_sets_openconfig_acl__acl_interfaces_interface_ingress_acl_sets, is_container='container', yang_name="ingress-acl-sets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)


  def _get_egress_acl_sets(self):
    """
    Getter method for egress_acl_sets, mapped from YANG variable /acl/interfaces/interface/egress_acl_sets (container)

    YANG Description: Enclosing container the list of egress ACLs on the
interface
    """
    return self.__egress_acl_sets
      
  def _set_egress_acl_sets(self, v, load=False):
    """
    Setter method for egress_acl_sets, mapped from YANG variable /acl/interfaces/interface/egress_acl_sets (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_egress_acl_sets is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_egress_acl_sets() directly.

    YANG Description: Enclosing container the list of egress ACLs on the
interface
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_egress_acl_sets_openconfig_acl__acl_interfaces_interface_egress_acl_sets, is_container='container', yang_name="egress-acl-sets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """egress_acl_sets must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_egress_acl_sets_openconfig_acl__acl_interfaces_interface_egress_acl_sets, is_container='container', yang_name="egress-acl-sets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)""",
        })

    self.__egress_acl_sets = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_egress_acl_sets(self):
    self.__egress_acl_sets = YANGDynClass(base=yc_egress_acl_sets_openconfig_acl__acl_interfaces_interface_egress_acl_sets, is_container='container', yang_name="egress-acl-sets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)

  id = __builtin__.property(_get_id, _set_id)
  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)
  interface_ref = __builtin__.property(_get_interface_ref, _set_interface_ref)
  ingress_acl_sets = __builtin__.property(_get_ingress_acl_sets, _set_ingress_acl_sets)
  egress_acl_sets = __builtin__.property(_get_egress_acl_sets, _set_egress_acl_sets)


  _pyangbind_elements = OrderedDict([('id', id), ('config', config), ('state', state), ('interface_ref', interface_ref), ('ingress_acl_sets', ingress_acl_sets), ('egress_acl_sets', egress_acl_sets), ])


class yc_interfaces_openconfig_acl__acl_interfaces(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-acl - based on the path /acl/interfaces. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Enclosing container for the list of interfaces on which
ACLs are set
  """
  __slots__ = ('_path_helper', '_extmethods', '__interface',)

  _yang_name = 'interfaces'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__interface = YANGDynClass(base=YANGListType("id",yc_interface_openconfig_acl__acl_interfaces_interface, yang_name="interface", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='id', extensions=None), is_container='list', yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='list', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['acl', 'interfaces']

  def _get_interface(self):
    """
    Getter method for interface, mapped from YANG variable /acl/interfaces/interface (list)

    YANG Description: List of interfaces on which ACLs are set
    """
    return self.__interface
      
  def _set_interface(self, v, load=False):
    """
    Setter method for interface, mapped from YANG variable /acl/interfaces/interface (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_interface is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_interface() directly.

    YANG Description: List of interfaces on which ACLs are set
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("id",yc_interface_openconfig_acl__acl_interfaces_interface, yang_name="interface", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='id', extensions=None), is_container='list', yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='list', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """interface must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("id",yc_interface_openconfig_acl__acl_interfaces_interface, yang_name="interface", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='id', extensions=None), is_container='list', yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='list', is_config=True)""",
        })

    self.__interface = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_interface(self):
    self.__interface = YANGDynClass(base=YANGListType("id",yc_interface_openconfig_acl__acl_interfaces_interface, yang_name="interface", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='id', extensions=None), is_container='list', yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='list', is_config=True)

  interface = __builtin__.property(_get_interface, _set_interface)


  _pyangbind_elements = OrderedDict([('interface', interface), ])


class yc_acl_openconfig_acl__acl(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-acl - based on the path /acl. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Top level enclosing container for ACL model config
and operational state data
  """
  __slots__ = ('_path_helper', '_extmethods', '__state','__acl_sets','__interfaces',)

  _yang_name = 'acl'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__state = YANGDynClass(base=yc_state_openconfig_acl__acl_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)
    self.__acl_sets = YANGDynClass(base=yc_acl_sets_openconfig_acl__acl_acl_sets, is_container='container', yang_name="acl-sets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)
    self.__interfaces = YANGDynClass(base=yc_interfaces_openconfig_acl__acl_interfaces, is_container='container', yang_name="interfaces", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['acl']

  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /acl/state (container)

    YANG Description: Global operational state data for ACLs
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /acl/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Global operational state data for ACLs
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_acl__acl_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_acl__acl_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_acl__acl_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)


  def _get_acl_sets(self):
    """
    Getter method for acl_sets, mapped from YANG variable /acl/acl_sets (container)

    YANG Description: Access list entries variables enclosing container
    """
    return self.__acl_sets
      
  def _set_acl_sets(self, v, load=False):
    """
    Setter method for acl_sets, mapped from YANG variable /acl/acl_sets (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_acl_sets is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_acl_sets() directly.

    YANG Description: Access list entries variables enclosing container
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_acl_sets_openconfig_acl__acl_acl_sets, is_container='container', yang_name="acl-sets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """acl_sets must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_acl_sets_openconfig_acl__acl_acl_sets, is_container='container', yang_name="acl-sets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)""",
        })

    self.__acl_sets = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_acl_sets(self):
    self.__acl_sets = YANGDynClass(base=yc_acl_sets_openconfig_acl__acl_acl_sets, is_container='container', yang_name="acl-sets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)


  def _get_interfaces(self):
    """
    Getter method for interfaces, mapped from YANG variable /acl/interfaces (container)

    YANG Description: Enclosing container for the list of interfaces on which
ACLs are set
    """
    return self.__interfaces
      
  def _set_interfaces(self, v, load=False):
    """
    Setter method for interfaces, mapped from YANG variable /acl/interfaces (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_interfaces is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_interfaces() directly.

    YANG Description: Enclosing container for the list of interfaces on which
ACLs are set
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_interfaces_openconfig_acl__acl_interfaces, is_container='container', yang_name="interfaces", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """interfaces must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_interfaces_openconfig_acl__acl_interfaces, is_container='container', yang_name="interfaces", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)""",
        })

    self.__interfaces = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_interfaces(self):
    self.__interfaces = YANGDynClass(base=yc_interfaces_openconfig_acl__acl_interfaces, is_container='container', yang_name="interfaces", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)

  state = __builtin__.property(_get_state, _set_state)
  acl_sets = __builtin__.property(_get_acl_sets, _set_acl_sets)
  interfaces = __builtin__.property(_get_interfaces, _set_interfaces)


  _pyangbind_elements = OrderedDict([('state', state), ('acl_sets', acl_sets), ('interfaces', interfaces), ])


class openconfig_acl(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-acl - based on the path /openconfig-acl. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: This module defines configuration and operational state
data for network access control lists (i.e., filters, rules,
etc.).  ACLs are organized into ACL sets, with each set
containing one or more ACL entries.  ACL sets are identified
by a unique name, while each entry within a set is assigned
a sequence-id that determines the order in which the ACL
rules are applied to a packet.  Note that ACLs are evaluated
in ascending order based on the sequence-id (low to high).

Individual ACL rules specify match criteria based on fields in
the packet, along with an action that defines how matching
packets should be handled. Entries have a type that indicates
the type of match criteria, e.g., MAC layer, IPv4, IPv6, etc.
  """
  __slots__ = ('_path_helper', '_extmethods', '__acl',)

  _yang_name = 'openconfig-acl'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__acl = YANGDynClass(base=yc_acl_openconfig_acl__acl, is_container='container', yang_name="acl", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return []

  def _get_acl(self):
    """
    Getter method for acl, mapped from YANG variable /acl (container)

    YANG Description: Top level enclosing container for ACL model config
and operational state data
    """
    return self.__acl
      
  def _set_acl(self, v, load=False):
    """
    Setter method for acl, mapped from YANG variable /acl (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_acl is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_acl() directly.

    YANG Description: Top level enclosing container for ACL model config
and operational state data
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_acl_openconfig_acl__acl, is_container='container', yang_name="acl", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """acl must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_acl_openconfig_acl__acl, is_container='container', yang_name="acl", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)""",
        })

    self.__acl = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_acl(self):
    self.__acl = YANGDynClass(base=yc_acl_openconfig_acl__acl, is_container='container', yang_name="acl", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)

  acl = __builtin__.property(_get_acl, _set_acl)


  _pyangbind_elements = OrderedDict([('acl', acl), ])


