package vpcpeer

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListVpcPeerConnections invokes the vpcpeer.ListVpcPeerConnections API synchronously
func (client *Client) ListVpcPeerConnections(request *ListVpcPeerConnectionsRequest) (response *ListVpcPeerConnectionsResponse, err error) {
	response = CreateListVpcPeerConnectionsResponse()
	err = client.DoAction(request, response)
	return
}

// ListVpcPeerConnectionsWithChan invokes the vpcpeer.ListVpcPeerConnections API asynchronously
func (client *Client) ListVpcPeerConnectionsWithChan(request *ListVpcPeerConnectionsRequest) (<-chan *ListVpcPeerConnectionsResponse, <-chan error) {
	responseChan := make(chan *ListVpcPeerConnectionsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListVpcPeerConnections(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListVpcPeerConnectionsWithCallback invokes the vpcpeer.ListVpcPeerConnections API asynchronously
func (client *Client) ListVpcPeerConnectionsWithCallback(request *ListVpcPeerConnectionsRequest, callback func(response *ListVpcPeerConnectionsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListVpcPeerConnectionsResponse
		var err error
		defer close(result)
		response, err = client.ListVpcPeerConnections(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListVpcPeerConnectionsRequest is the request struct for api ListVpcPeerConnections
type ListVpcPeerConnectionsRequest struct {
	*requests.RpcRequest
	Channel    string                        `position:"Body" name:"Channel"`
	NextToken  string                        `position:"Body" name:"NextToken"`
	Tags       *[]ListVpcPeerConnectionsTags `position:"Query" name:"Tags"  type:"Repeated"`
	InstanceId string                        `position:"Body" name:"InstanceId"`
	VpcId      *[]string                     `position:"Body" name:"VpcId"  type:"Repeated"`
	Name       string                        `position:"Body" name:"Name"`
	MaxResults requests.Integer              `position:"Body" name:"MaxResults"`
}

// ListVpcPeerConnectionsTags is a repeated param struct in ListVpcPeerConnectionsRequest
type ListVpcPeerConnectionsTags struct {
	Key   string `name:"Key"`
	Value string `name:"Value"`
}

// ListVpcPeerConnectionsResponse is the response struct for api ListVpcPeerConnections
type ListVpcPeerConnectionsResponse struct {
	*responses.BaseResponse
	RequestId       string                `json:"RequestId" xml:"RequestId"`
	TotalCount      int                   `json:"TotalCount" xml:"TotalCount"`
	MaxResults      int                   `json:"MaxResults" xml:"MaxResults"`
	NextToken       string                `json:"NextToken" xml:"NextToken"`
	VpcPeerConnects []VpcPeerConnectsItem `json:"VpcPeerConnects" xml:"VpcPeerConnects"`
}

// CreateListVpcPeerConnectionsRequest creates a request to invoke ListVpcPeerConnections API
func CreateListVpcPeerConnectionsRequest() (request *ListVpcPeerConnectionsRequest) {
	request = &ListVpcPeerConnectionsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("VpcPeer", "2022-01-01", "ListVpcPeerConnections", "vpcpeer", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListVpcPeerConnectionsResponse creates a response to parse from ListVpcPeerConnections response
func CreateListVpcPeerConnectionsResponse() (response *ListVpcPeerConnectionsResponse) {
	response = &ListVpcPeerConnectionsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
