package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeVpnConnections invokes the vpc.DescribeVpnConnections API synchronously
func (client *Client) DescribeVpnConnections(request *DescribeVpnConnectionsRequest) (response *DescribeVpnConnectionsResponse, err error) {
	response = CreateDescribeVpnConnectionsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeVpnConnectionsWithChan invokes the vpc.DescribeVpnConnections API asynchronously
func (client *Client) DescribeVpnConnectionsWithChan(request *DescribeVpnConnectionsRequest) (<-chan *DescribeVpnConnectionsResponse, <-chan error) {
	responseChan := make(chan *DescribeVpnConnectionsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeVpnConnections(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeVpnConnectionsWithCallback invokes the vpc.DescribeVpnConnections API asynchronously
func (client *Client) DescribeVpnConnectionsWithCallback(request *DescribeVpnConnectionsRequest, callback func(response *DescribeVpnConnectionsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeVpnConnectionsResponse
		var err error
		defer close(result)
		response, err = client.DescribeVpnConnections(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeVpnConnectionsRequest is the request struct for api DescribeVpnConnections
type DescribeVpnConnectionsRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer             `position:"Query" name:"ResourceOwnerId"`
	CustomerGatewayId    string                       `position:"Query" name:"CustomerGatewayId"`
	PageNumber           requests.Integer             `position:"Query" name:"PageNumber"`
	PageSize             requests.Integer             `position:"Query" name:"PageSize"`
	Tag                  *[]DescribeVpnConnectionsTag `position:"Query" name:"Tag"  type:"Repeated"`
	ResourceOwnerAccount string                       `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string                       `position:"Query" name:"OwnerAccount"`
	VpnGatewayId         string                       `position:"Query" name:"VpnGatewayId"`
	OwnerId              requests.Integer             `position:"Query" name:"OwnerId"`
	VpnConnectionId      string                       `position:"Query" name:"VpnConnectionId"`
}

// DescribeVpnConnectionsTag is a repeated param struct in DescribeVpnConnectionsRequest
type DescribeVpnConnectionsTag struct {
	Value string `name:"Value"`
	Key   string `name:"Key"`
}

// DescribeVpnConnectionsResponse is the response struct for api DescribeVpnConnections
type DescribeVpnConnectionsResponse struct {
	*responses.BaseResponse
	PageSize       int            `json:"PageSize" xml:"PageSize"`
	RequestId      string         `json:"RequestId" xml:"RequestId"`
	PageNumber     int            `json:"PageNumber" xml:"PageNumber"`
	TotalCount     int            `json:"TotalCount" xml:"TotalCount"`
	VpnConnections VpnConnections `json:"VpnConnections" xml:"VpnConnections"`
}

// CreateDescribeVpnConnectionsRequest creates a request to invoke DescribeVpnConnections API
func CreateDescribeVpnConnectionsRequest() (request *DescribeVpnConnectionsRequest) {
	request = &DescribeVpnConnectionsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "DescribeVpnConnections", "vpc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeVpnConnectionsResponse creates a response to parse from DescribeVpnConnections response
func CreateDescribeVpnConnectionsResponse() (response *DescribeVpnConnectionsResponse) {
	response = &DescribeVpnConnectionsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
