package trademark

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SubmitSupplement invokes the trademark.SubmitSupplement API synchronously
// api document: https://help.aliyun.com/api/trademark/submitsupplement.html
func (client *Client) SubmitSupplement(request *SubmitSupplementRequest) (response *SubmitSupplementResponse, err error) {
	response = CreateSubmitSupplementResponse()
	err = client.DoAction(request, response)
	return
}

// SubmitSupplementWithChan invokes the trademark.SubmitSupplement API asynchronously
// api document: https://help.aliyun.com/api/trademark/submitsupplement.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SubmitSupplementWithChan(request *SubmitSupplementRequest) (<-chan *SubmitSupplementResponse, <-chan error) {
	responseChan := make(chan *SubmitSupplementResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SubmitSupplement(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SubmitSupplementWithCallback invokes the trademark.SubmitSupplement API asynchronously
// api document: https://help.aliyun.com/api/trademark/submitsupplement.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SubmitSupplementWithCallback(request *SubmitSupplementRequest, callback func(response *SubmitSupplementResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SubmitSupplementResponse
		var err error
		defer close(result)
		response, err = client.SubmitSupplement(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SubmitSupplementRequest is the request struct for api SubmitSupplement
type SubmitSupplementRequest struct {
	*requests.RpcRequest
	UploadOssKeyList string           `position:"Query" name:"UploadOssKeyList"`
	Id               requests.Integer `position:"Query" name:"Id"`
	Content          string           `position:"Query" name:"Content"`
}

// SubmitSupplementResponse is the response struct for api SubmitSupplement
type SubmitSupplementResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	ErrorMsg  string `json:"ErrorMsg" xml:"ErrorMsg"`
	ErrorCode string `json:"ErrorCode" xml:"ErrorCode"`
}

// CreateSubmitSupplementRequest creates a request to invoke SubmitSupplement API
func CreateSubmitSupplementRequest() (request *SubmitSupplementRequest) {
	request = &SubmitSupplementRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Trademark", "2018-07-24", "SubmitSupplement", "trademark", "openAPI")
	return
}

// CreateSubmitSupplementResponse creates a response to parse from SubmitSupplement response
func CreateSubmitSupplementResponse() (response *SubmitSupplementResponse) {
	response = &SubmitSupplementResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
