package tag

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetPolicyEnableStatus invokes the tag.GetPolicyEnableStatus API synchronously
func (client *Client) GetPolicyEnableStatus(request *GetPolicyEnableStatusRequest) (response *GetPolicyEnableStatusResponse, err error) {
	response = CreateGetPolicyEnableStatusResponse()
	err = client.DoAction(request, response)
	return
}

// GetPolicyEnableStatusWithChan invokes the tag.GetPolicyEnableStatus API asynchronously
func (client *Client) GetPolicyEnableStatusWithChan(request *GetPolicyEnableStatusRequest) (<-chan *GetPolicyEnableStatusResponse, <-chan error) {
	responseChan := make(chan *GetPolicyEnableStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetPolicyEnableStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetPolicyEnableStatusWithCallback invokes the tag.GetPolicyEnableStatus API asynchronously
func (client *Client) GetPolicyEnableStatusWithCallback(request *GetPolicyEnableStatusRequest, callback func(response *GetPolicyEnableStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetPolicyEnableStatusResponse
		var err error
		defer close(result)
		response, err = client.GetPolicyEnableStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetPolicyEnableStatusRequest is the request struct for api GetPolicyEnableStatus
type GetPolicyEnableStatusRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      string           `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	UserType             string           `position:"Query" name:"UserType"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// GetPolicyEnableStatusResponse is the response struct for api GetPolicyEnableStatus
type GetPolicyEnableStatusResponse struct {
	*responses.BaseResponse
	RequestId    string             `json:"RequestId" xml:"RequestId"`
	StatusModels []StatusModelsItem `json:"StatusModels" xml:"StatusModels"`
}

// CreateGetPolicyEnableStatusRequest creates a request to invoke GetPolicyEnableStatus API
func CreateGetPolicyEnableStatusRequest() (request *GetPolicyEnableStatusRequest) {
	request = &GetPolicyEnableStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Tag", "2018-08-28", "GetPolicyEnableStatus", "tag", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetPolicyEnableStatusResponse creates a response to parse from GetPolicyEnableStatus response
func CreateGetPolicyEnableStatusResponse() (response *GetPolicyEnableStatusResponse) {
	response = &GetPolicyEnableStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
