package smartsales

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateCall invokes the smartsales.UpdateCall API synchronously
func (client *Client) UpdateCall(request *UpdateCallRequest) (response *UpdateCallResponse, err error) {
	response = CreateUpdateCallResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateCallWithChan invokes the smartsales.UpdateCall API asynchronously
func (client *Client) UpdateCallWithChan(request *UpdateCallRequest) (<-chan *UpdateCallResponse, <-chan error) {
	responseChan := make(chan *UpdateCallResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateCall(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateCallWithCallback invokes the smartsales.UpdateCall API asynchronously
func (client *Client) UpdateCallWithCallback(request *UpdateCallRequest, callback func(response *UpdateCallResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateCallResponse
		var err error
		defer close(result)
		response, err = client.UpdateCall(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateCallRequest is the request struct for api UpdateCall
type UpdateCallRequest struct {
	*requests.RpcRequest
	CallId           requests.Integer `position:"Query" name:"CallId"`
	ClueStatusRemark string           `position:"Query" name:"ClueStatusRemark"`
	AgentKey         string           `position:"Query" name:"AgentKey"`
	BusinessResult   requests.Integer `position:"Query" name:"BusinessResult"`
	CustomCallId     string           `position:"Query" name:"CustomCallId"`
}

// UpdateCallResponse is the response struct for api UpdateCall
type UpdateCallResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   string `json:"Success" xml:"Success"`
}

// CreateUpdateCallRequest creates a request to invoke UpdateCall API
func CreateUpdateCallRequest() (request *UpdateCallRequest) {
	request = &UpdateCallRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("SmartSales", "2022-08-18", "UpdateCall", "", "")
	request.Method = requests.POST
	return
}

// CreateUpdateCallResponse creates a response to parse from UpdateCall response
func CreateUpdateCallResponse() (response *UpdateCallResponse) {
	response = &UpdateCallResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
