package scdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeScdnCertificateDetail invokes the scdn.DescribeScdnCertificateDetail API synchronously
func (client *Client) DescribeScdnCertificateDetail(request *DescribeScdnCertificateDetailRequest) (response *DescribeScdnCertificateDetailResponse, err error) {
	response = CreateDescribeScdnCertificateDetailResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeScdnCertificateDetailWithChan invokes the scdn.DescribeScdnCertificateDetail API asynchronously
func (client *Client) DescribeScdnCertificateDetailWithChan(request *DescribeScdnCertificateDetailRequest) (<-chan *DescribeScdnCertificateDetailResponse, <-chan error) {
	responseChan := make(chan *DescribeScdnCertificateDetailResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeScdnCertificateDetail(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeScdnCertificateDetailWithCallback invokes the scdn.DescribeScdnCertificateDetail API asynchronously
func (client *Client) DescribeScdnCertificateDetailWithCallback(request *DescribeScdnCertificateDetailRequest, callback func(response *DescribeScdnCertificateDetailResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeScdnCertificateDetailResponse
		var err error
		defer close(result)
		response, err = client.DescribeScdnCertificateDetail(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeScdnCertificateDetailRequest is the request struct for api DescribeScdnCertificateDetail
type DescribeScdnCertificateDetailRequest struct {
	*requests.RpcRequest
	SecurityToken string           `position:"Query" name:"SecurityToken"`
	CertName      string           `position:"Query" name:"CertName"`
	OwnerId       requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribeScdnCertificateDetailResponse is the response struct for api DescribeScdnCertificateDetail
type DescribeScdnCertificateDetailResponse struct {
	*responses.BaseResponse
	CertName  string `json:"CertName" xml:"CertName"`
	Key       string `json:"Key" xml:"Key"`
	Cert      string `json:"Cert" xml:"Cert"`
	CertId    int64  `json:"CertId" xml:"CertId"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDescribeScdnCertificateDetailRequest creates a request to invoke DescribeScdnCertificateDetail API
func CreateDescribeScdnCertificateDetailRequest() (request *DescribeScdnCertificateDetailRequest) {
	request = &DescribeScdnCertificateDetailRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("scdn", "2017-11-15", "DescribeScdnCertificateDetail", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeScdnCertificateDetailResponse creates a response to parse from DescribeScdnCertificateDetail response
func CreateDescribeScdnCertificateDetailResponse() (response *DescribeScdnCertificateDetailResponse) {
	response = &DescribeScdnCertificateDetailResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
