package rtc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeAppKey invokes the rtc.DescribeAppKey API synchronously
func (client *Client) DescribeAppKey(request *DescribeAppKeyRequest) (response *DescribeAppKeyResponse, err error) {
	response = CreateDescribeAppKeyResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeAppKeyWithChan invokes the rtc.DescribeAppKey API asynchronously
func (client *Client) DescribeAppKeyWithChan(request *DescribeAppKeyRequest) (<-chan *DescribeAppKeyResponse, <-chan error) {
	responseChan := make(chan *DescribeAppKeyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeAppKey(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeAppKeyWithCallback invokes the rtc.DescribeAppKey API asynchronously
func (client *Client) DescribeAppKeyWithCallback(request *DescribeAppKeyRequest, callback func(response *DescribeAppKeyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeAppKeyResponse
		var err error
		defer close(result)
		response, err = client.DescribeAppKey(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeAppKeyRequest is the request struct for api DescribeAppKey
type DescribeAppKeyRequest struct {
	*requests.RpcRequest
	ShowLog    string           `position:"Query" name:"ShowLog"`
	QueryAppId string           `position:"Query" name:"QueryAppId"`
	OwnerId    requests.Integer `position:"Query" name:"OwnerId"`
	AppId      string           `position:"Query" name:"AppId"`
}

// DescribeAppKeyResponse is the response struct for api DescribeAppKey
type DescribeAppKeyResponse struct {
	*responses.BaseResponse
	BizId     string `json:"BizId" xml:"BizId"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	AppKey    string `json:"AppKey" xml:"AppKey"`
}

// CreateDescribeAppKeyRequest creates a request to invoke DescribeAppKey API
func CreateDescribeAppKeyRequest() (request *DescribeAppKeyRequest) {
	request = &DescribeAppKeyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("rtc", "2018-01-11", "DescribeAppKey", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeAppKeyResponse creates a response to parse from DescribeAppKey response
func CreateDescribeAppKeyResponse() (response *DescribeAppKeyResponse) {
	response = &DescribeAppKeyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
