package retailadvqa_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AudiencePushStatus invokes the retailadvqa_public.AudiencePushStatus API synchronously
func (client *Client) AudiencePushStatus(request *AudiencePushStatusRequest) (response *AudiencePushStatusResponse, err error) {
	response = CreateAudiencePushStatusResponse()
	err = client.DoAction(request, response)
	return
}

// AudiencePushStatusWithChan invokes the retailadvqa_public.AudiencePushStatus API asynchronously
func (client *Client) AudiencePushStatusWithChan(request *AudiencePushStatusRequest) (<-chan *AudiencePushStatusResponse, <-chan error) {
	responseChan := make(chan *AudiencePushStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AudiencePushStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AudiencePushStatusWithCallback invokes the retailadvqa_public.AudiencePushStatus API asynchronously
func (client *Client) AudiencePushStatusWithCallback(request *AudiencePushStatusRequest, callback func(response *AudiencePushStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AudiencePushStatusResponse
		var err error
		defer close(result)
		response, err = client.AudiencePushStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AudiencePushStatusRequest is the request struct for api AudiencePushStatus
type AudiencePushStatusRequest struct {
	*requests.RpcRequest
	AccessId    string `position:"Query" name:"AccessId"`
	AudienceId  string `position:"Query" name:"AudienceId"`
	WorkspaceId string `position:"Query" name:"WorkspaceId"`
}

// AudiencePushStatusResponse is the response struct for api AudiencePushStatus
type AudiencePushStatusResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	ErrorDesc string `json:"ErrorDesc" xml:"ErrorDesc"`
	TraceId   string `json:"TraceId" xml:"TraceId"`
	ErrorCode string `json:"ErrorCode" xml:"ErrorCode"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      string `json:"Data" xml:"Data"`
}

// CreateAudiencePushStatusRequest creates a request to invoke AudiencePushStatus API
func CreateAudiencePushStatusRequest() (request *AudiencePushStatusRequest) {
	request = &AudiencePushStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("retailadvqa-public", "2020-05-15", "AudiencePushStatus", "", "")
	request.Method = requests.POST
	return
}

// CreateAudiencePushStatusResponse creates a response to parse from AudiencePushStatus response
func CreateAudiencePushStatusResponse() (response *AudiencePushStatusResponse) {
	response = &AudiencePushStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
