package opensearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RemoveQueryProcessor invokes the opensearch.RemoveQueryProcessor API synchronously
func (client *Client) RemoveQueryProcessor(request *RemoveQueryProcessorRequest) (response *RemoveQueryProcessorResponse, err error) {
	response = CreateRemoveQueryProcessorResponse()
	err = client.DoAction(request, response)
	return
}

// RemoveQueryProcessorWithChan invokes the opensearch.RemoveQueryProcessor API asynchronously
func (client *Client) RemoveQueryProcessorWithChan(request *RemoveQueryProcessorRequest) (<-chan *RemoveQueryProcessorResponse, <-chan error) {
	responseChan := make(chan *RemoveQueryProcessorResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RemoveQueryProcessor(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RemoveQueryProcessorWithCallback invokes the opensearch.RemoveQueryProcessor API asynchronously
func (client *Client) RemoveQueryProcessorWithCallback(request *RemoveQueryProcessorRequest, callback func(response *RemoveQueryProcessorResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RemoveQueryProcessorResponse
		var err error
		defer close(result)
		response, err = client.RemoveQueryProcessor(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RemoveQueryProcessorRequest is the request struct for api RemoveQueryProcessor
type RemoveQueryProcessorRequest struct {
	*requests.RoaRequest
	AppId            requests.Integer `position:"Path" name:"appId"`
	Name             string           `position:"Path" name:"name"`
	AppGroupIdentity string           `position:"Path" name:"appGroupIdentity"`
}

// RemoveQueryProcessorResponse is the response struct for api RemoveQueryProcessor
type RemoveQueryProcessorResponse struct {
	*responses.BaseResponse
	Result    string `json:"result" xml:"result"`
	RequestId string `json:"requestId" xml:"requestId"`
}

// CreateRemoveQueryProcessorRequest creates a request to invoke RemoveQueryProcessor API
func CreateRemoveQueryProcessorRequest() (request *RemoveQueryProcessorRequest) {
	request = &RemoveQueryProcessorRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("OpenSearch", "2017-12-25", "RemoveQueryProcessor", "/v4/openapi/app-groups/[appGroupIdentity]/apps/[appId]/query-processors/[name]", "", "")
	request.Method = requests.DELETE
	return
}

// CreateRemoveQueryProcessorResponse creates a response to parse from RemoveQueryProcessor response
func CreateRemoveQueryProcessorResponse() (response *RemoveQueryProcessorResponse) {
	response = &RemoveQueryProcessorResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
