package opensearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateSearchStrategy invokes the opensearch.CreateSearchStrategy API synchronously
func (client *Client) CreateSearchStrategy(request *CreateSearchStrategyRequest) (response *CreateSearchStrategyResponse, err error) {
	response = CreateCreateSearchStrategyResponse()
	err = client.DoAction(request, response)
	return
}

// CreateSearchStrategyWithChan invokes the opensearch.CreateSearchStrategy API asynchronously
func (client *Client) CreateSearchStrategyWithChan(request *CreateSearchStrategyRequest) (<-chan *CreateSearchStrategyResponse, <-chan error) {
	responseChan := make(chan *CreateSearchStrategyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateSearchStrategy(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateSearchStrategyWithCallback invokes the opensearch.CreateSearchStrategy API asynchronously
func (client *Client) CreateSearchStrategyWithCallback(request *CreateSearchStrategyRequest, callback func(response *CreateSearchStrategyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateSearchStrategyResponse
		var err error
		defer close(result)
		response, err = client.CreateSearchStrategy(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateSearchStrategyRequest is the request struct for api CreateSearchStrategy
type CreateSearchStrategyRequest struct {
	*requests.RoaRequest
	AppId            string `position:"Path" name:"appId"`
	AppGroupIdentity string `position:"Path" name:"appGroupIdentity"`
}

// CreateSearchStrategyResponse is the response struct for api CreateSearchStrategy
type CreateSearchStrategyResponse struct {
	*responses.BaseResponse
	RequestId string `json:"requestId" xml:"requestId"`
}

// CreateCreateSearchStrategyRequest creates a request to invoke CreateSearchStrategy API
func CreateCreateSearchStrategyRequest() (request *CreateSearchStrategyRequest) {
	request = &CreateSearchStrategyRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("OpenSearch", "2017-12-25", "CreateSearchStrategy", "/v4/openapi/app-groups/[appGroupIdentity]/apps/[appId]/search-strategies", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateSearchStrategyResponse creates a response to parse from CreateSearchStrategy response
func CreateCreateSearchStrategyResponse() (response *CreateSearchStrategyResponse) {
	response = &CreateSearchStrategyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
