package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// InitializeAutoShowListTask invokes the live.InitializeAutoShowListTask API synchronously
func (client *Client) InitializeAutoShowListTask(request *InitializeAutoShowListTaskRequest) (response *InitializeAutoShowListTaskResponse, err error) {
	response = CreateInitializeAutoShowListTaskResponse()
	err = client.DoAction(request, response)
	return
}

// InitializeAutoShowListTaskWithChan invokes the live.InitializeAutoShowListTask API asynchronously
func (client *Client) InitializeAutoShowListTaskWithChan(request *InitializeAutoShowListTaskRequest) (<-chan *InitializeAutoShowListTaskResponse, <-chan error) {
	responseChan := make(chan *InitializeAutoShowListTaskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.InitializeAutoShowListTask(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// InitializeAutoShowListTaskWithCallback invokes the live.InitializeAutoShowListTask API asynchronously
func (client *Client) InitializeAutoShowListTaskWithCallback(request *InitializeAutoShowListTaskRequest, callback func(response *InitializeAutoShowListTaskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *InitializeAutoShowListTaskResponse
		var err error
		defer close(result)
		response, err = client.InitializeAutoShowListTask(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// InitializeAutoShowListTaskRequest is the request struct for api InitializeAutoShowListTask
type InitializeAutoShowListTaskRequest struct {
	*requests.RpcRequest
	StartTime    requests.Integer `position:"Query" name:"StartTime"`
	CasterConfig string           `position:"Query" name:"CasterConfig"`
	DomainName   string           `position:"Query" name:"DomainName"`
	EndTime      requests.Integer `position:"Query" name:"EndTime"`
	OwnerId      requests.Integer `position:"Query" name:"OwnerId"`
	CallBackUrl  string           `position:"Query" name:"CallBackUrl"`
	ResourceIds  string           `position:"Query" name:"ResourceIds"`
}

// InitializeAutoShowListTaskResponse is the response struct for api InitializeAutoShowListTask
type InitializeAutoShowListTaskResponse struct {
	*responses.BaseResponse
	StreamList string `json:"StreamList" xml:"StreamList"`
	RequestId  string `json:"RequestId" xml:"RequestId"`
	CasterId   string `json:"CasterId" xml:"CasterId"`
}

// CreateInitializeAutoShowListTaskRequest creates a request to invoke InitializeAutoShowListTask API
func CreateInitializeAutoShowListTaskRequest() (request *InitializeAutoShowListTaskRequest) {
	request = &InitializeAutoShowListTaskRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "InitializeAutoShowListTask", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateInitializeAutoShowListTaskResponse creates a response to parse from InitializeAutoShowListTask response
func CreateInitializeAutoShowListTaskResponse() (response *InitializeAutoShowListTaskResponse) {
	response = &InitializeAutoShowListTaskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
