package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeMixStreamList invokes the live.DescribeMixStreamList API synchronously
func (client *Client) DescribeMixStreamList(request *DescribeMixStreamListRequest) (response *DescribeMixStreamListResponse, err error) {
	response = CreateDescribeMixStreamListResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeMixStreamListWithChan invokes the live.DescribeMixStreamList API asynchronously
func (client *Client) DescribeMixStreamListWithChan(request *DescribeMixStreamListRequest) (<-chan *DescribeMixStreamListResponse, <-chan error) {
	responseChan := make(chan *DescribeMixStreamListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeMixStreamList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeMixStreamListWithCallback invokes the live.DescribeMixStreamList API asynchronously
func (client *Client) DescribeMixStreamListWithCallback(request *DescribeMixStreamListRequest, callback func(response *DescribeMixStreamListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeMixStreamListResponse
		var err error
		defer close(result)
		response, err = client.DescribeMixStreamList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeMixStreamListRequest is the request struct for api DescribeMixStreamList
type DescribeMixStreamListRequest struct {
	*requests.RpcRequest
	StartTime   string           `position:"Query" name:"StartTime"`
	AppName     string           `position:"Query" name:"AppName"`
	PageSize    requests.Integer `position:"Query" name:"PageSize"`
	StreamName  string           `position:"Query" name:"StreamName"`
	MixStreamId string           `position:"Query" name:"MixStreamId"`
	DomainName  string           `position:"Query" name:"DomainName"`
	EndTime     string           `position:"Query" name:"EndTime"`
	OwnerId     requests.Integer `position:"Query" name:"OwnerId"`
	PageNo      requests.Integer `position:"Query" name:"PageNo"`
}

// DescribeMixStreamListResponse is the response struct for api DescribeMixStreamList
type DescribeMixStreamListResponse struct {
	*responses.BaseResponse
	Total         int             `json:"Total" xml:"Total"`
	RequestId     string          `json:"RequestId" xml:"RequestId"`
	MixStreamList []MixStreamInfo `json:"MixStreamList" xml:"MixStreamList"`
}

// CreateDescribeMixStreamListRequest creates a request to invoke DescribeMixStreamList API
func CreateDescribeMixStreamListRequest() (request *DescribeMixStreamListRequest) {
	request = &DescribeMixStreamListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "DescribeMixStreamList", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeMixStreamListResponse creates a response to parse from DescribeMixStreamList response
func CreateDescribeMixStreamListResponse() (response *DescribeMixStreamListResponse) {
	response = &DescribeMixStreamListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
