package eventbridge

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListAliyunOfficialEventSources invokes the eventbridge.ListAliyunOfficialEventSources API synchronously
func (client *Client) ListAliyunOfficialEventSources(request *ListAliyunOfficialEventSourcesRequest) (response *ListAliyunOfficialEventSourcesResponse, err error) {
	response = CreateListAliyunOfficialEventSourcesResponse()
	err = client.DoAction(request, response)
	return
}

// ListAliyunOfficialEventSourcesWithChan invokes the eventbridge.ListAliyunOfficialEventSources API asynchronously
func (client *Client) ListAliyunOfficialEventSourcesWithChan(request *ListAliyunOfficialEventSourcesRequest) (<-chan *ListAliyunOfficialEventSourcesResponse, <-chan error) {
	responseChan := make(chan *ListAliyunOfficialEventSourcesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListAliyunOfficialEventSources(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListAliyunOfficialEventSourcesWithCallback invokes the eventbridge.ListAliyunOfficialEventSources API asynchronously
func (client *Client) ListAliyunOfficialEventSourcesWithCallback(request *ListAliyunOfficialEventSourcesRequest, callback func(response *ListAliyunOfficialEventSourcesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListAliyunOfficialEventSourcesResponse
		var err error
		defer close(result)
		response, err = client.ListAliyunOfficialEventSources(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListAliyunOfficialEventSourcesRequest is the request struct for api ListAliyunOfficialEventSources
type ListAliyunOfficialEventSourcesRequest struct {
	*requests.RpcRequest
	Type       string           `position:"Query" name:"Type"`
	NextToken  string           `position:"Query" name:"NextToken"`
	Limit      requests.Integer `position:"Query" name:"Limit"`
	NamePrefix string           `position:"Query" name:"NamePrefix"`
}

// ListAliyunOfficialEventSourcesResponse is the response struct for api ListAliyunOfficialEventSources
type ListAliyunOfficialEventSourcesResponse struct {
	*responses.BaseResponse
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateListAliyunOfficialEventSourcesRequest creates a request to invoke ListAliyunOfficialEventSources API
func CreateListAliyunOfficialEventSourcesRequest() (request *ListAliyunOfficialEventSourcesRequest) {
	request = &ListAliyunOfficialEventSourcesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("eventbridge", "2020-04-01", "ListAliyunOfficialEventSources", "", "")
	request.Method = requests.POST
	return
}

// CreateListAliyunOfficialEventSourcesResponse creates a response to parse from ListAliyunOfficialEventSources response
func CreateListAliyunOfficialEventSourcesResponse() (response *ListAliyunOfficialEventSourcesResponse) {
	response = &ListAliyunOfficialEventSourcesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
