package ehpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListAvailableEcsTypes invokes the ehpc.ListAvailableEcsTypes API synchronously
func (client *Client) ListAvailableEcsTypes(request *ListAvailableEcsTypesRequest) (response *ListAvailableEcsTypesResponse, err error) {
	response = CreateListAvailableEcsTypesResponse()
	err = client.DoAction(request, response)
	return
}

// ListAvailableEcsTypesWithChan invokes the ehpc.ListAvailableEcsTypes API asynchronously
func (client *Client) ListAvailableEcsTypesWithChan(request *ListAvailableEcsTypesRequest) (<-chan *ListAvailableEcsTypesResponse, <-chan error) {
	responseChan := make(chan *ListAvailableEcsTypesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListAvailableEcsTypes(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListAvailableEcsTypesWithCallback invokes the ehpc.ListAvailableEcsTypes API asynchronously
func (client *Client) ListAvailableEcsTypesWithCallback(request *ListAvailableEcsTypesRequest, callback func(response *ListAvailableEcsTypesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListAvailableEcsTypesResponse
		var err error
		defer close(result)
		response, err = client.ListAvailableEcsTypes(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListAvailableEcsTypesRequest is the request struct for api ListAvailableEcsTypes
type ListAvailableEcsTypesRequest struct {
	*requests.RpcRequest
	SpotStrategy       string           `position:"Query" name:"SpotStrategy"`
	ZoneId             string           `position:"Query" name:"ZoneId"`
	ShowSoldOut        requests.Boolean `position:"Query" name:"ShowSoldOut"`
	InstanceChargeType string           `position:"Query" name:"InstanceChargeType"`
}

// ListAvailableEcsTypesResponse is the response struct for api ListAvailableEcsTypes
type ListAvailableEcsTypesResponse struct {
	*responses.BaseResponse
	SupportSpotInstance  bool                 `json:"SupportSpotInstance" xml:"SupportSpotInstance"`
	RequestId            string               `json:"RequestId" xml:"RequestId"`
	InstanceTypeFamilies InstanceTypeFamilies `json:"InstanceTypeFamilies" xml:"InstanceTypeFamilies"`
}

// CreateListAvailableEcsTypesRequest creates a request to invoke ListAvailableEcsTypes API
func CreateListAvailableEcsTypesRequest() (request *ListAvailableEcsTypesRequest) {
	request = &ListAvailableEcsTypesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("EHPC", "2018-04-12", "ListAvailableEcsTypes", "", "")
	request.Method = requests.GET
	return
}

// CreateListAvailableEcsTypesResponse creates a response to parse from ListAvailableEcsTypes response
func CreateListAvailableEcsTypesResponse() (response *ListAvailableEcsTypesResponse) {
	response = &ListAvailableEcsTypesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
