package ehpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetVisualServiceStatus invokes the ehpc.GetVisualServiceStatus API synchronously
func (client *Client) GetVisualServiceStatus(request *GetVisualServiceStatusRequest) (response *GetVisualServiceStatusResponse, err error) {
	response = CreateGetVisualServiceStatusResponse()
	err = client.DoAction(request, response)
	return
}

// GetVisualServiceStatusWithChan invokes the ehpc.GetVisualServiceStatus API asynchronously
func (client *Client) GetVisualServiceStatusWithChan(request *GetVisualServiceStatusRequest) (<-chan *GetVisualServiceStatusResponse, <-chan error) {
	responseChan := make(chan *GetVisualServiceStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetVisualServiceStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetVisualServiceStatusWithCallback invokes the ehpc.GetVisualServiceStatus API asynchronously
func (client *Client) GetVisualServiceStatusWithCallback(request *GetVisualServiceStatusRequest, callback func(response *GetVisualServiceStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetVisualServiceStatusResponse
		var err error
		defer close(result)
		response, err = client.GetVisualServiceStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetVisualServiceStatusRequest is the request struct for api GetVisualServiceStatus
type GetVisualServiceStatusRequest struct {
	*requests.RpcRequest
	ClusterId string `position:"Query" name:"ClusterId"`
}

// GetVisualServiceStatusResponse is the response struct for api GetVisualServiceStatus
type GetVisualServiceStatusResponse struct {
	*responses.BaseResponse
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateGetVisualServiceStatusRequest creates a request to invoke GetVisualServiceStatus API
func CreateGetVisualServiceStatusRequest() (request *GetVisualServiceStatusRequest) {
	request = &GetVisualServiceStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("EHPC", "2018-04-12", "GetVisualServiceStatus", "", "")
	request.Method = requests.GET
	return
}

// CreateGetVisualServiceStatusResponse creates a response to parse from GetVisualServiceStatus response
func CreateGetVisualServiceStatusResponse() (response *GetVisualServiceStatusResponse) {
	response = &GetVisualServiceStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
