package eflo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateVpd invokes the eflo.UpdateVpd API synchronously
func (client *Client) UpdateVpd(request *UpdateVpdRequest) (response *UpdateVpdResponse, err error) {
	response = CreateUpdateVpdResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateVpdWithChan invokes the eflo.UpdateVpd API asynchronously
func (client *Client) UpdateVpdWithChan(request *UpdateVpdRequest) (<-chan *UpdateVpdResponse, <-chan error) {
	responseChan := make(chan *UpdateVpdResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateVpd(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateVpdWithCallback invokes the eflo.UpdateVpd API asynchronously
func (client *Client) UpdateVpdWithCallback(request *UpdateVpdRequest, callback func(response *UpdateVpdResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateVpdResponse
		var err error
		defer close(result)
		response, err = client.UpdateVpd(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateVpdRequest is the request struct for api UpdateVpd
type UpdateVpdRequest struct {
	*requests.RpcRequest
	Description string `position:"Body" name:"Description"`
	VpdId       string `position:"Body" name:"VpdId"`
	Name        string `position:"Body" name:"Name"`
}

// UpdateVpdResponse is the response struct for api UpdateVpd
type UpdateVpdResponse struct {
	*responses.BaseResponse
	Code      int     `json:"Code" xml:"Code"`
	Message   string  `json:"Message" xml:"Message"`
	RequestId string  `json:"RequestId" xml:"RequestId"`
	Content   Content `json:"Content" xml:"Content"`
}

// CreateUpdateVpdRequest creates a request to invoke UpdateVpd API
func CreateUpdateVpdRequest() (request *UpdateVpdRequest) {
	request = &UpdateVpdRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("eflo", "2022-05-30", "UpdateVpd", "eflo", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateVpdResponse creates a response to parse from UpdateVpd response
func CreateUpdateVpdResponse() (response *UpdateVpdResponse) {
	response = &UpdateVpdResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
