package config

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteConfigDeliveryChannel invokes the config.DeleteConfigDeliveryChannel API synchronously
func (client *Client) DeleteConfigDeliveryChannel(request *DeleteConfigDeliveryChannelRequest) (response *DeleteConfigDeliveryChannelResponse, err error) {
	response = CreateDeleteConfigDeliveryChannelResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteConfigDeliveryChannelWithChan invokes the config.DeleteConfigDeliveryChannel API asynchronously
func (client *Client) DeleteConfigDeliveryChannelWithChan(request *DeleteConfigDeliveryChannelRequest) (<-chan *DeleteConfigDeliveryChannelResponse, <-chan error) {
	responseChan := make(chan *DeleteConfigDeliveryChannelResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteConfigDeliveryChannel(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteConfigDeliveryChannelWithCallback invokes the config.DeleteConfigDeliveryChannel API asynchronously
func (client *Client) DeleteConfigDeliveryChannelWithCallback(request *DeleteConfigDeliveryChannelRequest, callback func(response *DeleteConfigDeliveryChannelResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteConfigDeliveryChannelResponse
		var err error
		defer close(result)
		response, err = client.DeleteConfigDeliveryChannel(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteConfigDeliveryChannelRequest is the request struct for api DeleteConfigDeliveryChannel
type DeleteConfigDeliveryChannelRequest struct {
	*requests.RpcRequest
	DeliveryChannelId string `position:"Query" name:"DeliveryChannelId"`
}

// DeleteConfigDeliveryChannelResponse is the response struct for api DeleteConfigDeliveryChannel
type DeleteConfigDeliveryChannelResponse struct {
	*responses.BaseResponse
	RequestId         string `json:"RequestId" xml:"RequestId"`
	DeliveryChannelId string `json:"DeliveryChannelId" xml:"DeliveryChannelId"`
}

// CreateDeleteConfigDeliveryChannelRequest creates a request to invoke DeleteConfigDeliveryChannel API
func CreateDeleteConfigDeliveryChannelRequest() (request *DeleteConfigDeliveryChannelRequest) {
	request = &DeleteConfigDeliveryChannelRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Config", "2020-09-07", "DeleteConfigDeliveryChannel", "", "")
	request.Method = requests.POST
	return
}

// CreateDeleteConfigDeliveryChannelResponse creates a response to parse from DeleteConfigDeliveryChannel response
func CreateDeleteConfigDeliveryChannelResponse() (response *DeleteConfigDeliveryChannelResponse) {
	response = &DeleteConfigDeliveryChannelResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
