package cloudwf

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetOssServerSign invokes the cloudwf.GetOssServerSign API synchronously
// api document: https://help.aliyun.com/api/cloudwf/getossserversign.html
func (client *Client) GetOssServerSign(request *GetOssServerSignRequest) (response *GetOssServerSignResponse, err error) {
	response = CreateGetOssServerSignResponse()
	err = client.DoAction(request, response)
	return
}

// GetOssServerSignWithChan invokes the cloudwf.GetOssServerSign API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/getossserversign.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetOssServerSignWithChan(request *GetOssServerSignRequest) (<-chan *GetOssServerSignResponse, <-chan error) {
	responseChan := make(chan *GetOssServerSignResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetOssServerSign(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetOssServerSignWithCallback invokes the cloudwf.GetOssServerSign API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/getossserversign.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetOssServerSignWithCallback(request *GetOssServerSignRequest, callback func(response *GetOssServerSignResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetOssServerSignResponse
		var err error
		defer close(result)
		response, err = client.GetOssServerSign(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetOssServerSignRequest is the request struct for api GetOssServerSign
type GetOssServerSignRequest struct {
	*requests.RpcRequest
	DirType requests.Integer `position:"Query" name:"DirType"`
}

// GetOssServerSignResponse is the response struct for api GetOssServerSign
type GetOssServerSignResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Message   string `json:"Message" xml:"Message"`
	Data      string `json:"Data" xml:"Data"`
	ErrorCode int    `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg  string `json:"ErrorMsg" xml:"ErrorMsg"`
}

// CreateGetOssServerSignRequest creates a request to invoke GetOssServerSign API
func CreateGetOssServerSignRequest() (request *GetOssServerSignRequest) {
	request = &GetOssServerSignRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudwf", "2017-03-28", "GetOssServerSign", "cloudwf", "openAPI")
	return
}

// CreateGetOssServerSignResponse creates a response to parse from GetOssServerSign response
func CreateGetOssServerSignResponse() (response *GetOssServerSignResponse) {
	response = &GetOssServerSignResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
