package cloudapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyInstanceSpec invokes the cloudapi.ModifyInstanceSpec API synchronously
func (client *Client) ModifyInstanceSpec(request *ModifyInstanceSpecRequest) (response *ModifyInstanceSpecResponse, err error) {
	response = CreateModifyInstanceSpecResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyInstanceSpecWithChan invokes the cloudapi.ModifyInstanceSpec API asynchronously
func (client *Client) ModifyInstanceSpecWithChan(request *ModifyInstanceSpecRequest) (<-chan *ModifyInstanceSpecResponse, <-chan error) {
	responseChan := make(chan *ModifyInstanceSpecResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyInstanceSpec(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyInstanceSpecWithCallback invokes the cloudapi.ModifyInstanceSpec API asynchronously
func (client *Client) ModifyInstanceSpecWithCallback(request *ModifyInstanceSpecRequest, callback func(response *ModifyInstanceSpecResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyInstanceSpecResponse
		var err error
		defer close(result)
		response, err = client.ModifyInstanceSpec(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyInstanceSpecRequest is the request struct for api ModifyInstanceSpec
type ModifyInstanceSpecRequest struct {
	*requests.RpcRequest
	AutoPay        requests.Boolean `position:"Query" name:"AutoPay"`
	SkipWaitSwitch requests.Boolean `position:"Query" name:"SkipWaitSwitch"`
	InstanceSpec   string           `position:"Query" name:"InstanceSpec"`
	Token          string           `position:"Query" name:"Token"`
	InstanceId     string           `position:"Query" name:"InstanceId"`
	ModifyAction   string           `position:"Query" name:"ModifyAction"`
}

// ModifyInstanceSpecResponse is the response struct for api ModifyInstanceSpec
type ModifyInstanceSpecResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyInstanceSpecRequest creates a request to invoke ModifyInstanceSpec API
func CreateModifyInstanceSpecRequest() (request *ModifyInstanceSpecRequest) {
	request = &ModifyInstanceSpecRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudAPI", "2016-07-14", "ModifyInstanceSpec", "apigateway", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyInstanceSpecResponse creates a response to parse from ModifyInstanceSpec response
func CreateModifyInstanceSpecResponse() (response *ModifyInstanceSpecResponse) {
	response = &ModifyInstanceSpecResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
