package cloudapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DryRunSwagger invokes the cloudapi.DryRunSwagger API synchronously
func (client *Client) DryRunSwagger(request *DryRunSwaggerRequest) (response *DryRunSwaggerResponse, err error) {
	response = CreateDryRunSwaggerResponse()
	err = client.DoAction(request, response)
	return
}

// DryRunSwaggerWithChan invokes the cloudapi.DryRunSwagger API asynchronously
func (client *Client) DryRunSwaggerWithChan(request *DryRunSwaggerRequest) (<-chan *DryRunSwaggerResponse, <-chan error) {
	responseChan := make(chan *DryRunSwaggerResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DryRunSwagger(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DryRunSwaggerWithCallback invokes the cloudapi.DryRunSwagger API asynchronously
func (client *Client) DryRunSwaggerWithCallback(request *DryRunSwaggerRequest, callback func(response *DryRunSwaggerResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DryRunSwaggerResponse
		var err error
		defer close(result)
		response, err = client.DryRunSwagger(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DryRunSwaggerRequest is the request struct for api DryRunSwagger
type DryRunSwaggerRequest struct {
	*requests.RpcRequest
	DataFormat      string           `position:"Query" name:"DataFormat"`
	Data            string           `position:"Body" name:"Data"`
	GroupId         string           `position:"Query" name:"GroupId"`
	GlobalCondition string           `position:"Query" name:"GlobalCondition"`
	SecurityToken   string           `position:"Query" name:"SecurityToken"`
	Overwrite       requests.Boolean `position:"Query" name:"Overwrite"`
}

// DryRunSwaggerResponse is the response struct for api DryRunSwagger
type DryRunSwaggerResponse struct {
	*responses.BaseResponse
	GlobalCondition string                      `json:"GlobalCondition" xml:"GlobalCondition"`
	RequestId       string                      `json:"RequestId" xml:"RequestId"`
	Success         SuccessInDryRunSwagger      `json:"Success" xml:"Success"`
	Failed          FailedInDryRunSwagger       `json:"Failed" xml:"Failed"`
	ModelFailed     ModelFailedInDryRunSwagger  `json:"ModelFailed" xml:"ModelFailed"`
	ModelSuccess    ModelSuccessInDryRunSwagger `json:"ModelSuccess" xml:"ModelSuccess"`
}

// CreateDryRunSwaggerRequest creates a request to invoke DryRunSwagger API
func CreateDryRunSwaggerRequest() (request *DryRunSwaggerRequest) {
	request = &DryRunSwaggerRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudAPI", "2016-07-14", "DryRunSwagger", "apigateway", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDryRunSwaggerResponse creates a response to parse from DryRunSwagger response
func CreateDryRunSwaggerResponse() (response *DryRunSwaggerResponse) {
	response = &DryRunSwaggerResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
