package clickhouse

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeRDSschemas invokes the clickhouse.DescribeRDSschemas API synchronously
func (client *Client) DescribeRDSschemas(request *DescribeRDSschemasRequest) (response *DescribeRDSschemasResponse, err error) {
	response = CreateDescribeRDSschemasResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeRDSschemasWithChan invokes the clickhouse.DescribeRDSschemas API asynchronously
func (client *Client) DescribeRDSschemasWithChan(request *DescribeRDSschemasRequest) (<-chan *DescribeRDSschemasResponse, <-chan error) {
	responseChan := make(chan *DescribeRDSschemasResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeRDSschemas(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeRDSschemasWithCallback invokes the clickhouse.DescribeRDSschemas API asynchronously
func (client *Client) DescribeRDSschemasWithCallback(request *DescribeRDSschemasRequest, callback func(response *DescribeRDSschemasResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeRDSschemasResponse
		var err error
		defer close(result)
		response, err = client.DescribeRDSschemas(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeRDSschemasRequest is the request struct for api DescribeRDSschemas
type DescribeRDSschemasRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	RdsPassword          string           `position:"Query" name:"RdsPassword"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	DbClusterId          string           `position:"Query" name:"DbClusterId"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	RdsId                string           `position:"Query" name:"RdsId"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	RdsPort              requests.Integer `position:"Query" name:"RdsPort"`
	RdsVpcUrl            string           `position:"Query" name:"RdsVpcUrl"`
	RdsUserName          string           `position:"Query" name:"RdsUserName"`
}

// DescribeRDSschemasResponse is the response struct for api DescribeRDSschemas
type DescribeRDSschemasResponse struct {
	*responses.BaseResponse
	RequestId string   `json:"RequestId" xml:"RequestId"`
	Schemas   []string `json:"Schemas" xml:"Schemas"`
}

// CreateDescribeRDSschemasRequest creates a request to invoke DescribeRDSschemas API
func CreateDescribeRDSschemasRequest() (request *DescribeRDSschemasRequest) {
	request = &DescribeRDSschemasRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("clickhouse", "2019-11-11", "DescribeRDSschemas", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeRDSschemasResponse creates a response to parse from DescribeRDSschemas response
func CreateDescribeRDSschemasResponse() (response *DescribeRDSschemasResponse) {
	response = &DescribeRDSschemasResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
