package ccc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RemoveSkillGroupsFromUser invokes the ccc.RemoveSkillGroupsFromUser API synchronously
func (client *Client) RemoveSkillGroupsFromUser(request *RemoveSkillGroupsFromUserRequest) (response *RemoveSkillGroupsFromUserResponse, err error) {
	response = CreateRemoveSkillGroupsFromUserResponse()
	err = client.DoAction(request, response)
	return
}

// RemoveSkillGroupsFromUserWithChan invokes the ccc.RemoveSkillGroupsFromUser API asynchronously
func (client *Client) RemoveSkillGroupsFromUserWithChan(request *RemoveSkillGroupsFromUserRequest) (<-chan *RemoveSkillGroupsFromUserResponse, <-chan error) {
	responseChan := make(chan *RemoveSkillGroupsFromUserResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RemoveSkillGroupsFromUser(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RemoveSkillGroupsFromUserWithCallback invokes the ccc.RemoveSkillGroupsFromUser API asynchronously
func (client *Client) RemoveSkillGroupsFromUserWithCallback(request *RemoveSkillGroupsFromUserRequest, callback func(response *RemoveSkillGroupsFromUserResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RemoveSkillGroupsFromUserResponse
		var err error
		defer close(result)
		response, err = client.RemoveSkillGroupsFromUser(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RemoveSkillGroupsFromUserRequest is the request struct for api RemoveSkillGroupsFromUser
type RemoveSkillGroupsFromUserRequest struct {
	*requests.RpcRequest
	UserId           string `position:"Query" name:"UserId"`
	InstanceId       string `position:"Query" name:"InstanceId"`
	SkillGroupIdList string `position:"Query" name:"SkillGroupIdList"`
}

// RemoveSkillGroupsFromUserResponse is the response struct for api RemoveSkillGroupsFromUser
type RemoveSkillGroupsFromUserResponse struct {
	*responses.BaseResponse
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	Data           string `json:"Data" xml:"Data"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
}

// CreateRemoveSkillGroupsFromUserRequest creates a request to invoke RemoveSkillGroupsFromUser API
func CreateRemoveSkillGroupsFromUserRequest() (request *RemoveSkillGroupsFromUserRequest) {
	request = &RemoveSkillGroupsFromUserRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CCC", "2020-07-01", "RemoveSkillGroupsFromUser", "", "")
	request.Method = requests.POST
	return
}

// CreateRemoveSkillGroupsFromUserResponse creates a response to parse from RemoveSkillGroupsFromUser response
func CreateRemoveSkillGroupsFromUserResponse() (response *RemoveSkillGroupsFromUserResponse) {
	response = &RemoveSkillGroupsFromUserResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
