package apds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteMigrationGroup invokes the apds.DeleteMigrationGroup API synchronously
func (client *Client) DeleteMigrationGroup(request *DeleteMigrationGroupRequest) (response *DeleteMigrationGroupResponse, err error) {
	response = CreateDeleteMigrationGroupResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteMigrationGroupWithChan invokes the apds.DeleteMigrationGroup API asynchronously
func (client *Client) DeleteMigrationGroupWithChan(request *DeleteMigrationGroupRequest) (<-chan *DeleteMigrationGroupResponse, <-chan error) {
	responseChan := make(chan *DeleteMigrationGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteMigrationGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteMigrationGroupWithCallback invokes the apds.DeleteMigrationGroup API asynchronously
func (client *Client) DeleteMigrationGroupWithCallback(request *DeleteMigrationGroupRequest, callback func(response *DeleteMigrationGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteMigrationGroupResponse
		var err error
		defer close(result)
		response, err = client.DeleteMigrationGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteMigrationGroupRequest is the request struct for api DeleteMigrationGroup
type DeleteMigrationGroupRequest struct {
	*requests.RoaRequest
	Id string `position:"Query" name:"id"`
}

// DeleteMigrationGroupResponse is the response struct for api DeleteMigrationGroup
type DeleteMigrationGroupResponse struct {
	*responses.BaseResponse
	Code    string `json:"Code" xml:"Code"`
	Error   string `json:"error" xml:"error"`
	Success bool   `json:"Success" xml:"Success"`
	Data    string `json:"Data" xml:"Data"`
}

// CreateDeleteMigrationGroupRequest creates a request to invoke DeleteMigrationGroup API
func CreateDeleteMigrationGroupRequest() (request *DeleteMigrationGroupRequest) {
	request = &DeleteMigrationGroupRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("apds", "2022-03-31", "DeleteMigrationGroup", "/okss-services/migration-group/remove-migration-group", "", "")
	request.Method = requests.POST
	return
}

// CreateDeleteMigrationGroupResponse creates a response to parse from DeleteMigrationGroup response
func CreateDeleteMigrationGroupResponse() (response *DeleteMigrationGroupResponse) {
	response = &DeleteMigrationGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
