package ahas_openapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetMetricsOfApp invokes the ahas_openapi.GetMetricsOfApp API synchronously
func (client *Client) GetMetricsOfApp(request *GetMetricsOfAppRequest) (response *GetMetricsOfAppResponse, err error) {
	response = CreateGetMetricsOfAppResponse()
	err = client.DoAction(request, response)
	return
}

// GetMetricsOfAppWithChan invokes the ahas_openapi.GetMetricsOfApp API asynchronously
func (client *Client) GetMetricsOfAppWithChan(request *GetMetricsOfAppRequest) (<-chan *GetMetricsOfAppResponse, <-chan error) {
	responseChan := make(chan *GetMetricsOfAppResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetMetricsOfApp(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetMetricsOfAppWithCallback invokes the ahas_openapi.GetMetricsOfApp API asynchronously
func (client *Client) GetMetricsOfAppWithCallback(request *GetMetricsOfAppRequest, callback func(response *GetMetricsOfAppResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetMetricsOfAppResponse
		var err error
		defer close(result)
		response, err = client.GetMetricsOfApp(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetMetricsOfAppRequest is the request struct for api GetMetricsOfApp
type GetMetricsOfAppRequest struct {
	*requests.RpcRequest
	EndTime      requests.Integer `position:"Query" name:"EndTime"`
	StartTime    requests.Integer `position:"Query" name:"StartTime"`
	AhasRegionId string           `position:"Query" name:"AhasRegionId"`
	AppName      string           `position:"Query" name:"AppName"`
	Namespace    string           `position:"Query" name:"Namespace"`
}

// GetMetricsOfAppResponse is the response struct for api GetMetricsOfApp
type GetMetricsOfAppResponse struct {
	*responses.BaseResponse
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateGetMetricsOfAppRequest creates a request to invoke GetMetricsOfApp API
func CreateGetMetricsOfAppRequest() (request *GetMetricsOfAppRequest) {
	request = &GetMetricsOfAppRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ahas-openapi", "2019-09-01", "GetMetricsOfApp", "ahas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetMetricsOfAppResponse creates a response to parse from GetMetricsOfApp response
func CreateGetMetricsOfAppResponse() (response *GetMetricsOfAppResponse) {
	response = &GetMetricsOfAppResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
