package adb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeTableAccessCount invokes the adb.DescribeTableAccessCount API synchronously
func (client *Client) DescribeTableAccessCount(request *DescribeTableAccessCountRequest) (response *DescribeTableAccessCountResponse, err error) {
	response = CreateDescribeTableAccessCountResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeTableAccessCountWithChan invokes the adb.DescribeTableAccessCount API asynchronously
func (client *Client) DescribeTableAccessCountWithChan(request *DescribeTableAccessCountRequest) (<-chan *DescribeTableAccessCountResponse, <-chan error) {
	responseChan := make(chan *DescribeTableAccessCountResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeTableAccessCount(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeTableAccessCountWithCallback invokes the adb.DescribeTableAccessCount API asynchronously
func (client *Client) DescribeTableAccessCountWithCallback(request *DescribeTableAccessCountRequest, callback func(response *DescribeTableAccessCountResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeTableAccessCountResponse
		var err error
		defer close(result)
		response, err = client.DescribeTableAccessCount(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeTableAccessCountRequest is the request struct for api DescribeTableAccessCount
type DescribeTableAccessCountRequest struct {
	*requests.RpcRequest
	DBClusterId string           `position:"Query" name:"DBClusterId"`
	StartTime   string           `position:"Query" name:"StartTime"`
	PageNumber  requests.Integer `position:"Query" name:"PageNumber"`
	PageSize    requests.Integer `position:"Query" name:"PageSize"`
	TableName   string           `position:"Query" name:"TableName"`
	Order       string           `position:"Query" name:"Order"`
}

// DescribeTableAccessCountResponse is the response struct for api DescribeTableAccessCount
type DescribeTableAccessCountResponse struct {
	*responses.BaseResponse
	RequestId  string      `json:"RequestId" xml:"RequestId"`
	PageNumber int         `json:"PageNumber" xml:"PageNumber"`
	PageSize   int         `json:"PageSize" xml:"PageSize"`
	TotalCount int         `json:"TotalCount" xml:"TotalCount"`
	Items      []ItemsItem `json:"Items" xml:"Items"`
}

// CreateDescribeTableAccessCountRequest creates a request to invoke DescribeTableAccessCount API
func CreateDescribeTableAccessCountRequest() (request *DescribeTableAccessCountRequest) {
	request = &DescribeTableAccessCountRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("adb", "2019-03-15", "DescribeTableAccessCount", "ads", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeTableAccessCountResponse creates a response to parse from DescribeTableAccessCount response
func CreateDescribeTableAccessCountResponse() (response *DescribeTableAccessCountResponse) {
	response = &DescribeTableAccessCountResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
