package main

import (
	"flag"
	"html/template"
	"log"
	"os"
	"strings"
)

const tmpl = `
// DANGER! This code was autogenerated from template by clickhouse-go/lib/codegen/nullable_appender.
// You shouldn't change it manually.
// For more info check clickhouse-go/lib/codegen/nullable_appender/main.go

package {{.Package}}

import (
	"fmt"
	"net"
	"reflect"
	"time"
)

var nullableAppender = map[string]func(v interface{}, slice reflect.Value) (reflect.Value, error){
{{ range .Types }}
	"*{{.}}": func(v interface{}, slice reflect.Value) (reflect.Value, error) {
		if v != nil {
			v, ok := v.({{.}})
			if !ok {
				return slice, fmt.Errorf("cannot assert to type {{.}}")
			}
			return reflect.Append(slice, reflect.ValueOf(&v)), nil
		}
		var vNil *{{.}}
		return reflect.Append(slice, reflect.ValueOf(vNil)), nil
	},
{{ end }}
}
`

type values struct {
	Package string
	Types   []string
}

func main() {
	settings := values{
		Types: []string{
			// add new types here that can be null and used with Array(Nullable(T))
			"int8",
			"int16",
			"int32",
			"int64",
			"uint8",
			"uint16",
			"uint32",
			"uint64",
			"float32",
			"float64",
			"string",
			"time.Time",
			"net.IP",
		},
		Package: "column",
	}
	flag.StringVar(&settings.Package, "package", "column", "Package name")
	out := flag.String("file", "nullable_appender.go", "Output file")
	flag.Parse()
	file, err := os.Create(*out)
	if err == nil {
		defer file.Close()
		err = template.Must(
			template.New("nullableAppender").Funcs(map[string]interface{}{"toLower": strings.ToLower}).Parse(tmpl),
		).Execute(file, &settings)
	}
	if err != nil {
		log.Panic(err)
	}
	log.Printf("Nullable appender generated for package %s in file %s", settings.Package, *out)
}
