// Copyright The OpenTelemetry Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by "pdata/internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package pmetric

import (
	"testing"

	"github.com/stretchr/testify/assert"
)

func TestSummaryDataPointValueAtQuantile_MoveTo(t *testing.T) {
	ms := generateTestSummaryDataPointValueAtQuantile()
	dest := NewSummaryDataPointValueAtQuantile()
	ms.MoveTo(dest)
	assert.Equal(t, NewSummaryDataPointValueAtQuantile(), ms)
	assert.Equal(t, generateTestSummaryDataPointValueAtQuantile(), dest)
}

func TestSummaryDataPointValueAtQuantile_CopyTo(t *testing.T) {
	ms := NewSummaryDataPointValueAtQuantile()
	orig := NewSummaryDataPointValueAtQuantile()
	orig.CopyTo(ms)
	assert.Equal(t, orig, ms)
	orig = generateTestSummaryDataPointValueAtQuantile()
	orig.CopyTo(ms)
	assert.Equal(t, orig, ms)
}

func TestSummaryDataPointValueAtQuantile_Quantile(t *testing.T) {
	ms := NewSummaryDataPointValueAtQuantile()
	assert.Equal(t, float64(0.0), ms.Quantile())
	ms.SetQuantile(float64(17.13))
	assert.Equal(t, float64(17.13), ms.Quantile())
}

func TestSummaryDataPointValueAtQuantile_Value(t *testing.T) {
	ms := NewSummaryDataPointValueAtQuantile()
	assert.Equal(t, float64(0.0), ms.Value())
	ms.SetValue(float64(17.13))
	assert.Equal(t, float64(17.13), ms.Value())
}

func generateTestSummaryDataPointValueAtQuantile() SummaryDataPointValueAtQuantile {
	tv := NewSummaryDataPointValueAtQuantile()
	fillTestSummaryDataPointValueAtQuantile(tv)
	return tv
}

func fillTestSummaryDataPointValueAtQuantile(tv SummaryDataPointValueAtQuantile) {
	tv.orig.Quantile = float64(17.13)
	tv.orig.Value = float64(17.13)
}
