package yundun_dbaudit

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeEventLogs invokes the yundun_dbaudit.DescribeEventLogs API synchronously
// api document: https://help.aliyun.com/api/yundun-dbaudit/describeeventlogs.html
func (client *Client) DescribeEventLogs(request *DescribeEventLogsRequest) (response *DescribeEventLogsResponse, err error) {
	response = CreateDescribeEventLogsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeEventLogsWithChan invokes the yundun_dbaudit.DescribeEventLogs API asynchronously
// api document: https://help.aliyun.com/api/yundun-dbaudit/describeeventlogs.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeEventLogsWithChan(request *DescribeEventLogsRequest) (<-chan *DescribeEventLogsResponse, <-chan error) {
	responseChan := make(chan *DescribeEventLogsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeEventLogs(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeEventLogsWithCallback invokes the yundun_dbaudit.DescribeEventLogs API asynchronously
// api document: https://help.aliyun.com/api/yundun-dbaudit/describeeventlogs.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeEventLogsWithCallback(request *DescribeEventLogsRequest, callback func(response *DescribeEventLogsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeEventLogsResponse
		var err error
		defer close(result)
		response, err = client.DescribeEventLogs(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeEventLogsRequest is the request struct for api DescribeEventLogs
type DescribeEventLogsRequest struct {
	*requests.RpcRequest
	Dip          string           `position:"Query" name:"Dip"`
	StartTime    string           `position:"Query" name:"StartTime"`
	Sessionid    string           `position:"Query" name:"Sessionid"`
	Dir          string           `position:"Query" name:"Dir"`
	HostName     string           `position:"Query" name:"HostName"`
	SourceIp     string           `position:"Query" name:"SourceIp"`
	Payload      string           `position:"Query" name:"Payload"`
	LoginUser    string           `position:"Query" name:"LoginUser"`
	QueryString  string           `position:"Query" name:"QueryString"`
	Sort         string           `position:"Query" name:"Sort"`
	SqlLen       string           `position:"Query" name:"SqlLen"`
	InstanceId   string           `position:"Query" name:"InstanceId"`
	DbName       string           `position:"Query" name:"DbName"`
	DbId         string           `position:"Query" name:"DbId"`
	Dmac         string           `position:"Query" name:"Dmac"`
	Smac         string           `position:"Query" name:"Smac"`
	EventName    string           `position:"Query" name:"EventName"`
	Dport        string           `position:"Query" name:"Dport"`
	Result       string           `position:"Query" name:"Result"`
	OpType       string           `position:"Query" name:"OpType"`
	ClientUser   string           `position:"Query" name:"ClientUser"`
	PageSize     requests.Integer `position:"Query" name:"PageSize"`
	Sip          string           `position:"Query" name:"Sip"`
	EffectRow    string           `position:"Query" name:"EffectRow"`
	ResultDesc   string           `position:"Query" name:"ResultDesc"`
	Sqlid        string           `position:"Query" name:"Sqlid"`
	Cost         string           `position:"Query" name:"Cost"`
	DepartmentId string           `position:"Query" name:"DepartmentId"`
	EndTime      string           `position:"Query" name:"EndTime"`
	CurrentPage  requests.Integer `position:"Query" name:"CurrentPage"`
	Accessid     string           `position:"Query" name:"Accessid"`
	EventLevel   string           `position:"Query" name:"EventLevel"`
	DbType       string           `position:"Query" name:"DbType"`
	ClientPrg    string           `position:"Query" name:"ClientPrg"`
	Sport        string           `position:"Query" name:"Sport"`
	DataSet      string           `position:"Query" name:"DataSet"`
}

// DescribeEventLogsResponse is the response struct for api DescribeEventLogs
type DescribeEventLogsResponse struct {
	*responses.BaseResponse
	RequestId  string                    `json:"RequestId" xml:"RequestId"`
	TotalCount int                       `json:"TotalCount" xml:"TotalCount"`
	EventLogs  []ItemInDescribeEventLogs `json:"EventLogs" xml:"EventLogs"`
}

// CreateDescribeEventLogsRequest creates a request to invoke DescribeEventLogs API
func CreateDescribeEventLogsRequest() (request *DescribeEventLogsRequest) {
	request = &DescribeEventLogsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Yundun-dbaudit", "2018-10-29", "DescribeEventLogs", "dbaudit", "openAPI")
	return
}

// CreateDescribeEventLogsResponse creates a response to parse from DescribeEventLogs response
func CreateDescribeEventLogsResponse() (response *DescribeEventLogsResponse) {
	response = &DescribeEventLogsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
