package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeVpnAttachments invokes the vpc.DescribeVpnAttachments API synchronously
func (client *Client) DescribeVpnAttachments(request *DescribeVpnAttachmentsRequest) (response *DescribeVpnAttachmentsResponse, err error) {
	response = CreateDescribeVpnAttachmentsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeVpnAttachmentsWithChan invokes the vpc.DescribeVpnAttachments API asynchronously
func (client *Client) DescribeVpnAttachmentsWithChan(request *DescribeVpnAttachmentsRequest) (<-chan *DescribeVpnAttachmentsResponse, <-chan error) {
	responseChan := make(chan *DescribeVpnAttachmentsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeVpnAttachments(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeVpnAttachmentsWithCallback invokes the vpc.DescribeVpnAttachments API asynchronously
func (client *Client) DescribeVpnAttachmentsWithCallback(request *DescribeVpnAttachmentsRequest, callback func(response *DescribeVpnAttachmentsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeVpnAttachmentsResponse
		var err error
		defer close(result)
		response, err = client.DescribeVpnAttachments(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeVpnAttachmentsRequest is the request struct for api DescribeVpnAttachments
type DescribeVpnAttachmentsRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer             `position:"Query" name:"ResourceOwnerId"`
	AttachType           string                       `position:"Query" name:"AttachType"`
	PageNumber           requests.Integer             `position:"Query" name:"PageNumber"`
	PageSize             requests.Integer             `position:"Query" name:"PageSize"`
	Tag                  *[]DescribeVpnAttachmentsTag `position:"Query" name:"Tag"  type:"Repeated"`
	ResourceOwnerAccount string                       `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string                       `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer             `position:"Query" name:"OwnerId"`
	VpnConnectionId      string                       `position:"Query" name:"VpnConnectionId"`
}

// DescribeVpnAttachmentsTag is a repeated param struct in DescribeVpnAttachmentsRequest
type DescribeVpnAttachmentsTag struct {
	Value string `name:"Value"`
	Key   string `name:"Key"`
}

// DescribeVpnAttachmentsResponse is the response struct for api DescribeVpnAttachments
type DescribeVpnAttachmentsResponse struct {
	*responses.BaseResponse
	RequestId      string          `json:"RequestId" xml:"RequestId"`
	PageSize       int             `json:"PageSize" xml:"PageSize"`
	PageNumber     int             `json:"PageNumber" xml:"PageNumber"`
	TotalCount     int             `json:"TotalCount" xml:"TotalCount"`
	VpnAttachments []VpnAttachment `json:"VpnAttachments" xml:"VpnAttachments"`
}

// CreateDescribeVpnAttachmentsRequest creates a request to invoke DescribeVpnAttachments API
func CreateDescribeVpnAttachmentsRequest() (request *DescribeVpnAttachmentsRequest) {
	request = &DescribeVpnAttachmentsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "DescribeVpnAttachments", "vpc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeVpnAttachmentsResponse creates a response to parse from DescribeVpnAttachments response
func CreateDescribeVpnAttachmentsResponse() (response *DescribeVpnAttachmentsResponse) {
	response = &DescribeVpnAttachmentsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
