package vod

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DecryptKMSDataKey invokes the vod.DecryptKMSDataKey API synchronously
func (client *Client) DecryptKMSDataKey(request *DecryptKMSDataKeyRequest) (response *DecryptKMSDataKeyResponse, err error) {
	response = CreateDecryptKMSDataKeyResponse()
	err = client.DoAction(request, response)
	return
}

// DecryptKMSDataKeyWithChan invokes the vod.DecryptKMSDataKey API asynchronously
func (client *Client) DecryptKMSDataKeyWithChan(request *DecryptKMSDataKeyRequest) (<-chan *DecryptKMSDataKeyResponse, <-chan error) {
	responseChan := make(chan *DecryptKMSDataKeyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DecryptKMSDataKey(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DecryptKMSDataKeyWithCallback invokes the vod.DecryptKMSDataKey API asynchronously
func (client *Client) DecryptKMSDataKeyWithCallback(request *DecryptKMSDataKeyRequest, callback func(response *DecryptKMSDataKeyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DecryptKMSDataKeyResponse
		var err error
		defer close(result)
		response, err = client.DecryptKMSDataKey(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DecryptKMSDataKeyRequest is the request struct for api DecryptKMSDataKey
type DecryptKMSDataKeyRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      string           `position:"Query" name:"ResourceOwnerId"`
	ResourceRealOwnerId  requests.Integer `position:"Query" name:"ResourceRealOwnerId"`
	KmsRegionId          string           `position:"Query" name:"KmsRegionId"`
	CipherText           string           `position:"Query" name:"CipherText"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              string           `position:"Query" name:"OwnerId"`
}

// DecryptKMSDataKeyResponse is the response struct for api DecryptKMSDataKey
type DecryptKMSDataKeyResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	KeyId     string `json:"KeyId" xml:"KeyId"`
	Plaintext string `json:"Plaintext" xml:"Plaintext"`
}

// CreateDecryptKMSDataKeyRequest creates a request to invoke DecryptKMSDataKey API
func CreateDecryptKMSDataKeyRequest() (request *DecryptKMSDataKeyRequest) {
	request = &DecryptKMSDataKeyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vod", "2017-03-21", "DecryptKMSDataKey", "vod", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDecryptKMSDataKeyResponse creates a response to parse from DecryptKMSDataKey response
func CreateDecryptKMSDataKeyResponse() (response *DecryptKMSDataKeyResponse) {
	response = &DecryptKMSDataKeyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
