package videoseg

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SegmentVideoBody invokes the videoseg.SegmentVideoBody API synchronously
func (client *Client) SegmentVideoBody(request *SegmentVideoBodyRequest) (response *SegmentVideoBodyResponse, err error) {
	response = CreateSegmentVideoBodyResponse()
	err = client.DoAction(request, response)
	return
}

// SegmentVideoBodyWithChan invokes the videoseg.SegmentVideoBody API asynchronously
func (client *Client) SegmentVideoBodyWithChan(request *SegmentVideoBodyRequest) (<-chan *SegmentVideoBodyResponse, <-chan error) {
	responseChan := make(chan *SegmentVideoBodyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SegmentVideoBody(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SegmentVideoBodyWithCallback invokes the videoseg.SegmentVideoBody API asynchronously
func (client *Client) SegmentVideoBodyWithCallback(request *SegmentVideoBodyRequest, callback func(response *SegmentVideoBodyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SegmentVideoBodyResponse
		var err error
		defer close(result)
		response, err = client.SegmentVideoBody(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SegmentVideoBodyRequest is the request struct for api SegmentVideoBody
type SegmentVideoBodyRequest struct {
	*requests.RpcRequest
	Async    requests.Boolean `position:"Body" name:"Async"`
	VideoUrl string           `position:"Body" name:"VideoUrl"`
}

// SegmentVideoBodyResponse is the response struct for api SegmentVideoBody
type SegmentVideoBodyResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateSegmentVideoBodyRequest creates a request to invoke SegmentVideoBody API
func CreateSegmentVideoBodyRequest() (request *SegmentVideoBodyRequest) {
	request = &SegmentVideoBodyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("videoseg", "2020-03-20", "SegmentVideoBody", "", "")
	request.Method = requests.POST
	return
}

// CreateSegmentVideoBodyResponse creates a response to parse from SegmentVideoBody response
func CreateSegmentVideoBodyResponse() (response *SegmentVideoBodyResponse) {
	response = &SegmentVideoBodyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
