package viapi_regen

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetLabelDetail invokes the viapi_regen.GetLabelDetail API synchronously
func (client *Client) GetLabelDetail(request *GetLabelDetailRequest) (response *GetLabelDetailResponse, err error) {
	response = CreateGetLabelDetailResponse()
	err = client.DoAction(request, response)
	return
}

// GetLabelDetailWithChan invokes the viapi_regen.GetLabelDetail API asynchronously
func (client *Client) GetLabelDetailWithChan(request *GetLabelDetailRequest) (<-chan *GetLabelDetailResponse, <-chan error) {
	responseChan := make(chan *GetLabelDetailResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetLabelDetail(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetLabelDetailWithCallback invokes the viapi_regen.GetLabelDetail API asynchronously
func (client *Client) GetLabelDetailWithCallback(request *GetLabelDetailRequest, callback func(response *GetLabelDetailResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetLabelDetailResponse
		var err error
		defer close(result)
		response, err = client.GetLabelDetail(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetLabelDetailRequest is the request struct for api GetLabelDetail
type GetLabelDetailRequest struct {
	*requests.RpcRequest
	Id requests.Integer `position:"Body" name:"Id"`
}

// GetLabelDetailResponse is the response struct for api GetLabelDetail
type GetLabelDetailResponse struct {
	*responses.BaseResponse
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateGetLabelDetailRequest creates a request to invoke GetLabelDetail API
func CreateGetLabelDetailRequest() (request *GetLabelDetailRequest) {
	request = &GetLabelDetailRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("viapi-regen", "2021-11-19", "GetLabelDetail", "selflearning", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetLabelDetailResponse creates a response to parse from GetLabelDetail response
func CreateGetLabelDetailResponse() (response *GetLabelDetailResponse) {
	response = &GetLabelDetailResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
