package sas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RebootMachine invokes the sas.RebootMachine API synchronously
func (client *Client) RebootMachine(request *RebootMachineRequest) (response *RebootMachineResponse, err error) {
	response = CreateRebootMachineResponse()
	err = client.DoAction(request, response)
	return
}

// RebootMachineWithChan invokes the sas.RebootMachine API asynchronously
func (client *Client) RebootMachineWithChan(request *RebootMachineRequest) (<-chan *RebootMachineResponse, <-chan error) {
	responseChan := make(chan *RebootMachineResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RebootMachine(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RebootMachineWithCallback invokes the sas.RebootMachine API asynchronously
func (client *Client) RebootMachineWithCallback(request *RebootMachineRequest, callback func(response *RebootMachineResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RebootMachineResponse
		var err error
		defer close(result)
		response, err = client.RebootMachine(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RebootMachineRequest is the request struct for api RebootMachine
type RebootMachineRequest struct {
	*requests.RpcRequest
	Uuid     string `position:"Query" name:"Uuid"`
	SourceIp string `position:"Query" name:"SourceIp"`
}

// RebootMachineResponse is the response struct for api RebootMachine
type RebootMachineResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateRebootMachineRequest creates a request to invoke RebootMachine API
func CreateRebootMachineRequest() (request *RebootMachineRequest) {
	request = &RebootMachineRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Sas", "2018-12-03", "RebootMachine", "sas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateRebootMachineResponse creates a response to parse from RebootMachine response
func CreateRebootMachineResponse() (response *RebootMachineResponse) {
	response = &RebootMachineResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
