package sas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDomainCount invokes the sas.DescribeDomainCount API synchronously
func (client *Client) DescribeDomainCount(request *DescribeDomainCountRequest) (response *DescribeDomainCountResponse, err error) {
	response = CreateDescribeDomainCountResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDomainCountWithChan invokes the sas.DescribeDomainCount API asynchronously
func (client *Client) DescribeDomainCountWithChan(request *DescribeDomainCountRequest) (<-chan *DescribeDomainCountResponse, <-chan error) {
	responseChan := make(chan *DescribeDomainCountResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDomainCount(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDomainCountWithCallback invokes the sas.DescribeDomainCount API asynchronously
func (client *Client) DescribeDomainCountWithCallback(request *DescribeDomainCountRequest, callback func(response *DescribeDomainCountResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDomainCountResponse
		var err error
		defer close(result)
		response, err = client.DescribeDomainCount(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDomainCountRequest is the request struct for api DescribeDomainCount
type DescribeDomainCountRequest struct {
	*requests.RpcRequest
	SourceIp string `position:"Query" name:"SourceIp"`
}

// DescribeDomainCountResponse is the response struct for api DescribeDomainCount
type DescribeDomainCountResponse struct {
	*responses.BaseResponse
	RootDomainsCount  int    `json:"RootDomainsCount" xml:"RootDomainsCount"`
	RequestId         string `json:"RequestId" xml:"RequestId"`
	SubDomainsCount   int    `json:"SubDomainsCount" xml:"SubDomainsCount"`
	TotalDomainsCount int    `json:"TotalDomainsCount" xml:"TotalDomainsCount"`
}

// CreateDescribeDomainCountRequest creates a request to invoke DescribeDomainCount API
func CreateDescribeDomainCountRequest() (request *DescribeDomainCountRequest) {
	request = &DescribeDomainCountRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Sas", "2018-12-03", "DescribeDomainCount", "sas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeDomainCountResponse creates a response to parse from DescribeDomainCount response
func CreateDescribeDomainCountResponse() (response *DescribeDomainCountResponse) {
	response = &DescribeDomainCountResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
